/**
 * Created by Dmitry Shaporenko on 04.08.14.
 */


//key = "trnsl.1.1.20140804T113929Z.8dbdbd61f200046a.9818c697da2cfc83c0882aa5984a39a3d3a216ca";
key = "dict.1.1.20140806T092804Z.e29a361c95e1c382.649ceac6e0bb0f49c9121132cbc29624639c47d5";
//apiurl = "https://translate.yandex.net/api/v1.5/tr.json/";
apiurl = "https://dictionary.yandex.net/api/v1/dicservice.json/";


var badthings = {
    401: "Wrong API key",
    402: "Blocked API key",
    403: "Daily request limit over",
    404: "Daily text limit over",
    412: "Unable to translate",
    413: "Text is too long",
    501: "Translation direction is not supported"

};


function requestJSON(url) {
    request = new XMLHttpRequest({ mozSystem: true});
    request.open('get', url, true);
    request.responseType = 'json';
    request.addEventListener('load', onRequestLoad);
    request.send();
}


function translate(text, from, to) {
    checkinternet();
    if (text !== '') {
        baseurl = apiurl + "lookup?";
        url = baseurl + "key=" + key + "&text=" + text + "&lang=" + from + "-" + to;
        console.log(url);
        savelastsearch(text);
        return requestJSON(url)
    } else {
        showresults("Translation goes here...")
    }
}


function onRequestLoad() {

    console.log("RESPONSE CODE: " + request.status);

    if (request.status == 200) {
        showresults(getword(request.response));
    } else {
        alert(badthings[request.response.code]);
    }
}

function uiCall() {
    $('.dynamic').show();
    managedonatebutton();
    $('.uk-button').blur();
    $('#t').blur();

    if (waslastsearch($('#t').val())) {
        return;
    } else {
    translate($('#t').val(), $('#from').val(), $('#to').val());
    }

}

window.addEventListener('DOMContentLoaded', function () {

    onstart();

    $("#t").focusin(function () {

        $('.dynamic').hide();
    });

    $("#t").keypress(function (e) {
        if (e.which == 13) {
            uiCall()
        }
    });

});

window.addEventListener("deviceorientation", fixheight, true);
//http://runawaydev.wordpress.com/2013/07/06/easy-guide-to-localize-a-firefoxos-apps-html-interface/
//албанский	sq
//английский	en
//армянский	hy
//азербайджанский	az
//белорусский	be
//болгарский	bg
//венгерский	hu
//голландский	nl
//греческий	el
//датский	da
//итальянский	it
//испанский	es
//каталанский	ca
//латышский	lv
//литовский	lt
//македонский	mk
//немецкий	de
//норвежский	no
//польский	pl
//португальский	pt
//румынский	ro
//русский	ru
//сербский	sr
//словацкий	sk
//словенский	sl
//турецкий	tr
//украинский	uk
//финский	fi
//французский	fr
//хорватский	hr
//чешский	cs
//шведский	sv
//эстонский	et