function Easter(Y) {
    var C = Math.floor(Y/100);
    var N = Y - 19*Math.floor(Y/19);
    var K = Math.floor((C - 17)/25);
    var I = C - Math.floor(C/4) - Math.floor((C - K)/3) + 19*N + 15;
    I = I - 30*Math.floor((I/30));
    I = I - Math.floor(I/28)*(1 - Math.floor(I/28)*Math.floor(29/(I + 1))*Math.floor((21 - N)/11));
    var J = Y + Math.floor(Y/4) + I + 2 - C + Math.floor(C/4);
    J = J - 7*Math.floor(J/7);
    var L = I - J;
    var M = 3 + Math.floor((L + 40)/44);
    var D = L + 28 - 31*Math.floor(M/4);

    return M + '.' + D;
}

function padout(number) { 
	return (number < 10) ? '0' + number : number;
}

var	dateManager = function() {
		
        var today = new Date(Date.now());
        today.setHours(0,0,0,0);
        var temp = new Date(Date.now());
  
        var holidays;
        var holidayNames;
  
        this.updateHolidays = function() {
          var easter = Easter(temp.getFullYear()).split('.');
          var easterM = parseInt(easter[0]);
          var easterD = parseInt(easter[1]);
          
          holidays = [
            new Date(temp.getFullYear(), 0, 1),
            new Date(temp.getFullYear(), 2, 15),
            new Date(temp.getFullYear(), easterM-1, easterD+1),
            new Date(temp.getFullYear(), 4, 1),
            new Date(temp.getFullYear(), easterM-1, easterD+1),
            new Date(temp.getFullYear(), 7, 20),
            new Date(temp.getFullYear(), 9, 23),
            new Date(temp.getFullYear(), 10, 1),
            new Date(temp.getFullYear(), 11, 25),
            new Date(temp.getFullYear(), 11, 26),
          ];
          
          holidayNames = [
            "jv",
            "1848-as forradalom",
            "Hsvt htf",
            "A munka nnepe",
            "Pnksd htf",
            "llamalapts nnepe",
            "1956-os forradalom",
            "Mindenszentek",
            "Karcsony",
            "Karcsony"
          ];
          
          holidays[4].setDate(holidays[4].getDate() + 49);
          
          
        };
  
		this.prevYear = function() {
				temp.setFullYear(temp.getFullYear() - 1);
                this.updateHolidays();
			};

		this.nextYear = function() {
				temp.setFullYear(temp.getFullYear() + 1);
                this.updateHolidays();
			};

		this.getActualYear = function() {
				return temp.getFullYear();
			};
  
        this.getDATEToday = function() {
				return today;
			};
  
        this.getDATEHoliday = function(x) {
				return holidays[x];
			};
  
        this.getDateToday = function() {
				return today.getFullYear() + '.' + padout(today.getMonth()+1) + '.' + padout(today.getDate()) + '.';
			};
  
        this.getHoliday = function(x) {
				return holidays[x].getFullYear() + '.' + padout(holidays[x].getMonth()+1) + '.' + padout(holidays[x].getDate()) + '.';
			};
  
        this.getHolidayDay = function(x) {
				return holidays[x].getDay();
			};
  
        this.getHolidayName = function(x) {
				return holidayNames[x];
			};
	};

var dateManager = new dateManager();
var $year;
var $today;

function show() {
	$year = document.getElementById('year');
    $today = document.getElementById('today');
	update();
}

function update() {
    dateManager.updateHolidays();
	$year.innerHTML = dateManager.getActualYear();
    $today.innerHTML = dateManager.getDateToday();
    document.getElementById("0").innerHTML = dateManager.getHoliday(0);
    document.getElementById("1").innerHTML = dateManager.getHoliday(1);
    document.getElementById("2").innerHTML = dateManager.getHoliday(2);
    document.getElementById("3").innerHTML = dateManager.getHoliday(3);
    document.getElementById("4").innerHTML = dateManager.getHoliday(4);
    document.getElementById("5").innerHTML = dateManager.getHoliday(5);
    document.getElementById("6").innerHTML = dateManager.getHoliday(6);
    document.getElementById("7").innerHTML = dateManager.getHoliday(7);
    document.getElementById("8").innerHTML = dateManager.getHoliday(8);
    document.getElementById("9").innerHTML = dateManager.getHoliday(9);
  
  document.getElementById("s0").innerHTML = dateManager.getHolidayName(0);
    document.getElementById("s1").innerHTML = dateManager.getHolidayName(1);
    document.getElementById("s2").innerHTML = dateManager.getHolidayName(2);
    document.getElementById("s3").innerHTML = dateManager.getHolidayName(3);
    document.getElementById("s4").innerHTML = dateManager.getHolidayName(4);
    document.getElementById("s5").innerHTML = dateManager.getHolidayName(5);
    document.getElementById("s6").innerHTML = dateManager.getHolidayName(6);
    document.getElementById("s7").innerHTML = dateManager.getHolidayName(7);
    document.getElementById("s8").innerHTML = dateManager.getHolidayName(8);
    document.getElementById("s9").innerHTML = dateManager.getHolidayName(9);
}

function prev() {
	dateManager.prevYear();
    update();
}

function next() {
	dateManager.nextYear();
    update();
}

function showDetails(id)
{

  var background = document.getElementById(id).style.background;

  if(background == "rgb(255,145,0)")
  {
  document.getElementById(id).innerHTML = "rgb(26,255,0)";
  }
  if(background == "rgb(26,255,0)")
  {
    document.getElementById(id).style.background = "rgb(255,145,0)";
  }

}

function daydiff(first, second) {
    return Math.round((second-first)/(1000*60*60*24));
}

var weekdays = ["Vasrnap", "Htf", "Kedd", "Szerda", "Cstrtk", "Pntek", "Szombat"];

var tempSpanString;

function change(spanDateID, spanStringID){
  
  var spanDate = document.getElementById(spanDateID);
  var spanString = document.getElementById(spanStringID);

  var dateState1 = dateManager.getHoliday(spanDateID);
  var dateState2 = weekdays[dateManager.getHolidayDay(spanDateID)];
  
  var stringState1 = dateManager.getHolidayName(spanDateID);
  var stringState2 = days_between(dateManager.getDATEToday(),  dateManager.getDATEHoliday(spanDateID));
  
  if (stringState2 < 0)
    stringState2 = Math.abs(stringState2) + " napja";
  else
    stringState2 = stringState2 + " nap mlva";
  
  if ( spanDate.innerHTML == dateState1 ) {
    spanDate.innerHTML = dateState2;
    spanString.innerHTML = stringState2;
  }
    else if ( spanDate.innerHTML == dateState2 ) {
      spanDate.innerHTML = dateState1;
      spanString.innerHTML = stringState1;
    }         
}

function days_between(date1, date2) {
    var oneDay = 1000 * 60 * 60 * 24;
    return Math.round((date2.getTime() - date1.getTime())/(oneDay));
}

function exit() {
	window.close();
}