﻿/// <reference path="bootstrap.min.js" />
/// <reference path="jquery-1.11.3.min.js" />
/// <reference path="PrayTimes.js" />

$(document).ready(function () {
    check();
    //lat = lattitude, long = longtitiude, tz = timezone
    function moazen(lat, long, tz) {
        var months = ["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسيمبر"];
        var date = new Date();

        var times = prayTimes.getTimes(new Date(), [lat, long], tz);
        var fajr = times.fajr;
        var sunrise = times.sunrise;
        var dhuhr = times.dhuhr;
        var asr = times.asr;
        var maghrib = times.maghrib;
        var isha = times.isha;

        var prayTime = [fajr, sunrise, dhuhr, asr, maghrib, isha];
        var prayName = ['fajr', 'sunrise', 'dhuhr', 'asr', 'maghrib', 'isha'];

        highlight();

        $('#fajr .caption').html(fajr);
        $('#sunrise .caption').html(sunrise);
        $('#dhuhr .caption').html(dhuhr);
        $('#asr .caption').html(asr);
        $('#maghrib .caption').html(maghrib);
        $('#isha .caption').html(isha);

        $('#day').html(date.getDate());
        $('#month').html(months[date.getMonth()]);
        $('#year').html(date.getFullYear());


        setInterval(function () {
            highlight();
            checkPray();
        }, 60000);


        function highlight() {
            var now = new Date();
            var nowTime = now.getHours() + ':' + now.getMinutes();
            if (nowTime.length <= 4) {
                nowTime = '0' + nowTime;
            }
            for (var i = 0; i < prayName.length; i++) {
                if (nowTime < prayTime[i]) {
                    console.log('in if ' + nowTime);
                    if ($('#' + prayName[i]).hasClass('highlight')) {
                        return;
                    } else {
                        $('.pray-time').removeClass('highlight');
                        $('#' + prayName[i]).addClass('highlight');
                        return;
                    }
                } else {
                    $('.pray-time').removeClass('highlight');
                    $('#' + prayName[0]).addClass('highlight');
                }
            }
        }

        //notification
        function notify(msg) {
            var options = {
                body: msg,
                sound: 'audio/alarm.mp3'
            }

            var n = new Notification('Moa`zen', options);
            n.sound;
        }
        function checkPray() {
            var checkNow = new Date();
			var NowHours = checkNow.getHours();
			if(NowHours < '10')
			{
				NowHours='0'+NowHours;
				}
				
			var NowMinutes = checkNow.getMinutes();	
			if(NowMinutes < '10')
			{
				NowHours='0'+NowMinutes;
				}
				
				
            var checkNowTime = NowHours + ':' + NowMinutes ;
            for (var i = 0; i < prayName.length; i++) {
				
			console.log('checkNowTime'+checkNowTime+' --- pary time'+prayTime[i]);
                if (checkNowTime === prayTime[i]) {
                    console.log('pary time');
                    notify(prayName[i]);
                }
            }
        }
    }
    //some style fixes
    $('.time-bg img').load(function () {
        $('#time').css('height', $('.time-bg img').outerHeight() + 'px');
        $('.time-container').css('top', ($('.time-bg img').outerHeight() * 0.2) + 'px');
        $('.pray-time .title, .pray-time .caption').css('font-size', ($('.time-bg img').outerHeight() / 20) + 'px');
    });
    $(window).resize(function () {
        $('#time').css('height', $('.time-bg img').outerHeight() + 'px');
        $('.time-container').css('top', ($('.time-bg img').outerHeight() * 0.2) + 'px');
        $('.pray-time .title, .pray-time .caption').css('font-size', ($('.time-bg img').outerHeight() / 20) + 'px');
    })
    //search
    $.widget("custom.catcomplete", $.ui.autocomplete, {
        _renderMenu: function (ul, items) {
            var that = this,
              currentCategory = "";
            $.each(items, function (index, item) {
                if (item.category != currentCategory) {
                    ul.append("<li class='ui-autocomplete-category'>" + item.category + "</li>");
                    currentCategory = item.category;
                }
                that._renderItemData(ul, item);
            });
        }
    });

    var xhr;
    $("#position-search").catcomplete({
        delay: 0,
        source: function (request, response) {
            var regex = new RegExp(request.term, 'i');
            if (xhr) {
                xhr.abort();
            }
            xhr = $.ajax({
                url: "data/CitiesData.json",
                dataType: "json",
                cache: false,
                success: function (data) {
                    response($.map(data.geoname, function (item) {
                        if (regex.test(item.alternatenames)) {
                            return {
                                label: item.name,
                                desc: item.desc
                            };
                        }
                    }));
                }
            });
        },
        minlength: 0
    });
    //check if there is a position in pos.json
    //if yes run moazen() with the saved pos.josn
    //else run submit() to make a pos.json and start moazen()
    //Ajax
    function creatXHR() {
        if (typeof XMLHttpRequest !== 'undefined') {
            return new XMLHttpRequest();
        } else {
            var versions = ['MSXML2.XmlHttp.6.0', 'MSXL2.XmlHttp.3.0'];
            for (var i = 0; i < versions.lenght; i++) {
                try {
                    var xhr = ActiveXObject(versions[i]);
                    return xhr;
                } catch (error) {
                    //do nothing
                }
            }
        }
        alert('Your Browser Dose not Support XmlHttp');
        return null;
    }

    function makeGetRequest(url, callback) {
        var xhr = new creatXHR();
        xhr.open('GET', url);

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                var status = xhr.status;
                if (status >= 200 && status < 300 || status === 304) {
                    callback(xhr.responseText);
                } else {
                    console.log('an error occured');
                }
            }
        }

        xhr.send(null);
    }

    
    function check() {
        var obj = JSON.parse(localStorage.getItem('city'));
        if (obj === null) {
            console.log('init');
            init();
        } else {
            processPosJSON(obj);
        }
        
    }
    function processPosJSON(data) {
        console.log(data);
        $('#position .position').html(data.name);
        moazen(parseFloat(data.latitude), parseFloat(data.longitude), parseFloat(data.GMT_offset));
    }

    function init() {
        $('#popup').fadeIn();
        submit();
    }

    //submit
    var searchFlag = false;
    function submit() {
        $('#submit').click(function () {
            var searchVal = $('#position-search').val();
            
            if (searchVal != '') {
                makeGetRequest('data/CitiesData.json', checkSearch);
            } else {
                alert('من فضلك اختار مدينة');
            }
        });
    }

    function checkSearch(data) {
        var cities = jQuery.parseJSON('' + data);
        console.log(getObjects(cities, 'name', $('#position-search').val()).length);
        if (getObjects(cities, 'name', $('#position-search').val()).length > 0) {
            $('#position .position').html($('#position-search').val());
            makeGetRequest('data/CitiesData.json', processCitiesJSON);
            $('#popup').fadeOut(0);
        } else {
            alert('من فضلك اختار مدينة');
            return;
        }
    }
    function processCitiesJSON(data) {
        var cities = jQuery.parseJSON('' + data);
        console.log(getObjects(cities, 'name', $('#position-search').val()));
        var cityInfo = getObjects(cities, 'name', $('#position-search').val());
        console.log(cityInfo[0].latitude);
        moazen(parseFloat(cityInfo[0].latitude), parseFloat(cityInfo[0].longitude), parseFloat(cityInfo[0].GMT_offset));
        saveToJSON(cityInfo[0]);
    }

    function getObjects(obj, key, val) {
        var objects = [];
        for (var i in obj) {
            if (!obj.hasOwnProperty(i)) continue;
            if (typeof obj[i] == 'object') {
                objects = objects.concat(getObjects(obj[i], key, val));
            } else if (i == key && obj[key] == val) {
                objects.push(obj);
            }
        }
        return objects;
    }
    
    function saveToJSON(data) {
        localStorage.setItem('city', JSON.stringify(data));
    }

    //change position
    $('.position').click(function () {
        $('#popup').fadeIn();
        $('#submit').click(submit());
    })
});