"use strict";



var NASButtonViewEventNone				= 0;
var NASButtonViewEventTouchDown			= 1;
var NASButtonViewEventTouchUp			= 2;
var NASButtonViewEventTouchUpInside		= 3;
var NASButtonViewEventTouchUpOutside	= 4;
var NASButtonViewEventTouchMoveInside	= 5;
var NASButtonViewEventTouchMoveOutside	= 6;
var NASButtonViewEventTouchCancelled	= 7;

var NASButtonViewItemBackground = 100;



var NASButtonView = NASView.extend({
	m_delegate					: null,
	m_isTouchDown				: false,
	m_isTouchInside				: false,
	m_isTouchEnable				: true,
	m_isTouchDownEffectEnable	: true,
	m_prioryty					: 0,
	
	m_pImageData				: null,
	m_nImageDataWidth			: 0,
	m_nImageDataHeight			: 0,



    init:function () {
        this._super();

        return true;
    },

	onEnter:function(){
		this._super();
	},

	onExit:function(){
		var pSprite = this.getChildByTag(NASButtonViewItemBackground);
		if(pSprite){
			if(this.m_isTouchDownEffectEnable){
//				pSprite.setColor(cc.WHITE);
				pSprite.setScale(1.0);
			}
		}
		
		this._super();
	},



	setBackgroundWithNode:function(node, contentSize)
	{
		if (this.getChildByTag(NASButtonViewItemBackground))
		{
			this.removeChildByTag(NASButtonViewItemBackground, true);
		}
		
        node.ignoreAnchorPointForPosition(true);
        
		this.setContentSize(contentSize);
		this.addChild(node, 0, NASButtonViewItemBackground);
	},
	
	
	setBackgroundWithSprite:function(pSprite)
	{
		this.setBackgroundWithNode(pSprite, pSprite.getContentSize());
	},
	
	
	setBackgroundWithFile:function(pStrFileName)
	{
        var sprite = cc.Sprite.create(pStrFileName);
        
		this.setBackgroundWithSprite(sprite);
	},
	
	
	setDelegate:function(pDelegate)
	{
		this.m_delegate = pDelegate;
	},
	
	
	setTouchEnable:function(enable)
	{
		this.m_isTouchEnable = enable;
	},
	
	
	setTouchDownEffectEnable:function(enable)
	{
		this.m_isTouchDownEffectEnable = enable;
	},
	
	
	containsTouchLocation:function(pTouch)
	{
		var rect = this.rect();
		var point = this.convertTouchToNodeSpace(pTouch);
        
        var ret = (rect.origin.x <= point.x && point.x <= rect.origin.x + rect.size.width &&
                    rect.origin.y <= point.y && point.y <= rect.origin.y + rect.size.height);
        
        if(this.m_pImageData == null)
        {
            return ret;
        }
        else if(!ret)
        {
            return ret;
        }
        
		return this.containsTouchLocationWithAlpha(pTouch);
	},
	
    containsTouchLocationWithAlpha:function(pTouch)
    {
		var rect = this.rect();
		var point = this.convertTouchToNodeSpaceAR(pTouch);
        
        var x = point.x - rect.origin.x;
        var y = rect.origin.y + rect.size.height - point.y;
        
        return (0 != this.m_pImageData[(y*this.m_nImageDataWidth+x)*4*(this.m_nImageDataWidth/this.getContentSize().width+0.5) + 3]);
    },
	
	rect:function()
	{
		var size = this.getContentSize();
		
		// for HTML5 (because image loaded async.)
		if(size.width==0 && size.height==0){
			var sprite = this.getSprite();
			if(sprite){
				this.setContentSize(sprite.getContentSize());
			}
		}
		//--
		
//		return cc.RectMake(-size.width*this.getAnchorPoint().x, -size.height*this.getAnchorPoint().y, size.width, size.height);
		return cc.RectMake(0, 0, size.width, size.height);
	},
	
	
	viewTouchBegan:function(pTouch, pEvent)
	{
        
		if (!this.m_isTouchEnable)
		{
			return false;
		}
		
		if (!this.containsTouchLocation(pTouch))
		{
			return false;
		}
		
		this.m_isTouchDown = true;
		this.m_isTouchInside = true;
		var pSprite = this.getChildByTag(NASButtonViewItemBackground);
		if (pSprite != null)
		{
			if (this.m_isTouchDownEffectEnable)
			{
//				pSprite.setColor(cc.GRAY);
				pSprite.setScale(1.15);
			}
		}
		
		if (this.m_delegate != null)
		{
			this.m_delegate.buttonEvent(this, NASButtonViewEventTouchDown, pTouch);
		}
		
        return true;
	},
	
	viewTouchMoved:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventNone;
			if (!this.containsTouchLocation(pTouch))
			{
//				if (m_isTouchInside)
				{
					event = NASButtonViewEventTouchMoveOutside;
					var pSprite = this.getChildByTag(NASButtonViewItemBackground);
					if (pSprite != null)
					{
						if (this.m_isTouchDownEffectEnable)
						{
//							pSprite.setColor(cc.WHITE);
							pSprite.setScale(1.0);
						}
					}
					this.m_isTouchInside = false;
				}
			}
			else
			{
//				if (!m_isTouchInside)
				{
					event = NASButtonViewEventTouchMoveInside;
					var pSprite = this.getChildByTag(NASButtonViewItemBackground);
					if (pSprite != null)
					{
						if (this.m_isTouchDownEffectEnable)
						{
//							pSprite.setColor(cc.GRAY);
							pSprite.setScale(1.15);
						}
					}
					this.m_isTouchInside = true;
				}
			}
			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
		
	},
	
	viewTouchEnded:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventNone;
			if (!this.m_isTouchInside)
			{
				event = NASButtonViewEventTouchUpOutside;
			}
			else
			{
				event = NASButtonViewEventTouchUpInside;
			}
			
			this.m_isTouchDown = false;
			var pSprite = this.getChildByTag(NASButtonViewItemBackground);
			if (pSprite != null)
			{
				if (this.m_isTouchDownEffectEnable)
				{
//					pSprite.setColor(cc.WHITE);
					pSprite.setScale(1.0);
				}
			}
			
			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
		
	},
	
	viewTouchCancelled:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventTouchCancelled;
			
			this.m_isTouchDown = false;
			var pSprite = this.getChildByTag(NASButtonViewItemBackground);
			if (pSprite != null)
			{
				if (this.m_isTouchDownEffectEnable)
				{
//					pSprite.setColor(cc.WHITE);
					pSprite.setScale(1.0);
				}
			}
			
			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
	},
	
	touchDelegateRetain:function()
	{
		//none NASView::retain();
	},
	
	touchDelegateRelease:function()
	{
		//none NASView::release();
	},
	
	/*
	// Will not port this function now.
    setCCImageData:function(pFileName)
    {
        
        var imgButton = new cc.Image();
        imgButton.initWithImageFile(pFileName, cc.Image.kFmtPng);
        var size = imgButton.getWidth()*imgButton.getHeight()*4;
        this.m_pImageData = null;//### (unsigned char*)calloc(size, sizeof(unsigned char));
        if(this.m_pImageData != null)
        {
            this.m_nImageDataWidth = imgButton->getWidth();
            this.m_nImageDataHeight = imgButton->getHeight();
            //### memcpy(m_pImageData, imgButton->getData(), size);
        }
        
        //### delete imgButton;
    },
    */
    
    setColor:function(color)
    {
        var pSprite = this.getChildByTag(NASButtonViewItemBackground);
        if (pSprite != null)
        {
            pSprite.setColor(color);
        }
    },

    setOpacity:function(opacity)
    {
        var pSprite = this.getChildByTag(NASButtonViewItemBackground);
        if (pSprite != null)
        {
            pSprite.setOpacity(opacity);
        }
    },
    
    setSpriteWithTexture:function(pTexture)
    {
        var pSprite = this.getChildByTag(NASButtonViewItemBackground);
        if(pSprite != null)
        {
            pSprite.setTexture(pTexture);
        }
    },
    
    setPrioryty:function(priority)
    {
        this.m_prioryty = priority;
    },
    
    getSprite:function()
    {
        return this.getChildByTag(NASButtonViewItemBackground);
    },

});



NASButtonView.create = function(){
	var view = new NASButtonView();
	
	return (view.init()) ? view : null;
};

NASButtonView.buttonWithFile = function(sFileName, pDelegate, nPriority){
	var sprite = cc.Sprite.create(sFileName);
	
	return NASButtonView.buttonWithSprite(sprite, pDelegate, nPriority);
}

NASButtonView.buttonWithSprite = function(pSprite, pDelegate, nPriority){
	return NASButtonView.buttonWithNode(pSprite, pDelegate, pSprite.getContentSize(), nPriority);
}

NASButtonView.buttonWithNode = function(pNode, pDelegate, pSize, nPriority){
	var view = NASButtonView.create();
	if(view){
		view.setBackgroundWithNode(pNode, pSize);
		view.setDelegate(pDelegate);
		view.m_prioryty = nPriority;
	}
	
	return view;
}


