"use strict";

//*************************************************************************************
//
// YMAmagoGameScene
//
//*************************************************************************************

var YMAmagoGameSceneViewTag = 0;
var YMAmagoGameSceneViewTagBackGround		 = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagShichirin		     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagYakiko	     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagYakikoFukidashi	     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagYakikoMessage	     = YMAmagoGameSceneViewTag++;


var YMAmagoGameSceneViewTagDishNamaMochiGet		     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagBtnDishNamaMochi		     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagDishBakedSet		     = YMAmagoGameSceneViewTag++;

var YMAmagoGameSceneViewTagMoveNamaAmago		     = YMAmagoGameSceneViewTag++;

var YMAmagoGameSceneViewTagScoreTemp		     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagScoreLabel		     = YMAmagoGameSceneViewTag++;

var YMAmagoGameSceneViewTagCountDownTimer		     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagTimeLabel		     = YMAmagoGameSceneViewTag++;

var YMAmagoGameSceneViewTagCountDownLabel	     = YMAmagoGameSceneViewTag++;
var YMAmagoGameSceneViewTagBlockButton	     = YMAmagoGameSceneViewTag++;

var YMAmagoGameSceneViewTagBakingMochi	     = YMAmagoGameSceneViewTag++;



//Multiple

var YMAmagoGameLayer = NASView.extend({

	m_numMochi : 0,
	m_numMochiMax : 10,
	m_score : 0,
	m_gameTimerMax : 60 + 5, //CountDown included
	m_gameTimerCurrent : 60 + 5, //CountDown included,
	// 	m_gameTimerMax : 5,
	// m_gameTimerCurrent : 5,

	init:function()
	{
		if (!this._super())
		{
			return false;
		}

		var backGround = cc.Sprite.create("res/ym_r_amago_bg.png");
		backGround.setPosition(g_YMScreenCenter);
		this.addChild(backGround,
			YMAmagoGameSceneViewTagBackGround,
			YMAmagoGameSceneViewTagBackGround);

		var dishNamamochi = cc.Sprite.create("res/ym_r_amago_base_nama.png");
		dishNamamochi.setPosition(cc.p(125 / 2,125 / 2));
		this.addChild(dishNamamochi,
			YMAmagoGameSceneViewTagDishNamaMochiGet,
			YMAmagoGameSceneViewTagDishNamaMochiGet);

		var shiChirin = cc.Sprite.create("res/ym_r_base_yaki.png");
		shiChirin.setPosition(g_YMScreenCenter);
		this.addChild(shiChirin,
			YMAmagoGameSceneViewTagShichirin,
			YMAmagoGameSceneViewTagShichirin);

	   	// var dishBaked = cc.Sprite.create("res/ym_btn_start.png");
	    // dishBaked.setPosition(cc.p(428,281));
	    // this.addChild(dishBaked);

	    var yakiko = cc.Sprite.create("res/ym_r_amago_yakiko1.png");
	    yakiko.setPosition(cc.p(400,66));
	    this.addChild(yakiko,
	    	YMAmagoGameSceneViewTagYakiko,
	    	YMAmagoGameSceneViewTagYakiko);

	    var buttonNamamochi = NASButtonView.buttonWithNode(cc.Node.create(),this,cc.size(90,90));
	    buttonNamamochi.setContentSize(dishNamamochi.getContentSize());
	    buttonNamamochi.setTouchDownEffectEnable(false);
	    buttonNamamochi.setPosition(cc.p(dishNamamochi.getPosition().x - dishNamamochi.getContentSize().width / 2,
	    	dishNamamochi.getPosition().y - dishNamamochi.getContentSize().height / 2));
	    buttonNamamochi.setTag(YMAmagoGameSceneViewTagBtnDishNamaMochi);
	    this.addChild(buttonNamamochi,
	    	YMAmagoGameSceneViewTagBtnDishNamaMochi,
	    	YMAmagoGameSceneViewTagBtnDishNamaMochi);

	    var atlasScore = cc.LabelAtlas.create("0", "res/ym_r_amago_num1.png", 15, 20, '+');
	    atlasScore.setAnchorPoint(cc.p(1, 0.5));
	    atlasScore.setPosition(cc.p(852/2,594/2));
	    this.addChild(atlasScore,
	    	YMAmagoGameSceneViewTagScoreLabel,
	    	YMAmagoGameSceneViewTagScoreLabel);

	    var scoreTemp = cc.Sprite.create("res/ym_r_amago_score.png");
	    scoreTemp.setPosition(cc.p(765/2,594/2));
	    this.addChild(scoreTemp,
	    	YMAmagoGameSceneViewTagScoreTemp,
	    	YMAmagoGameSceneViewTagScoreTemp);

	    var timerSprite = cc.Sprite.create("res/ym_r_amago_time.png");
	    timerSprite.setPosition(cc.p(126/2,496/2));
	    this.addChild(timerSprite,
	    	YMAmagoGameSceneViewTagCountDownTimer,
	    	YMAmagoGameSceneViewTagCountDownTimer);	

	    var yakikoFukidashi = cc.Sprite.create("res/ym_r_amago_hkds_base.png");
	    yakikoFukidashi.setAnchorPoint(cc.p(0,0));
	    yakikoFukidashi.setPosition(cc.p(752/2 - 5,270/2 - 10));
	    this.addChild(yakikoFukidashi,
	    	YMAmagoGameSceneViewTagYakikoFukidashi,
	    	YMAmagoGameSceneViewTagYakikoFukidashi);

	    var yakikoMessage = cc.Sprite.create("res/ym_r_amago_hkds_text1.png");
	    yakikoMessage.setAnchorPoint(cc.p(0,0));
	    yakikoMessage.setPosition(cc.p(759/2 - 5,383/2 - 10));
	    this.addChild(yakikoMessage,
	    	YMAmagoGameSceneViewTagYakikoMessage,
	    	YMAmagoGameSceneViewTagYakikoMessage);

	    var strNum = String(this.m_gameTimerCurrent);

	    var atlasTime = cc.LabelAtlas.create(60, "res/ym_r_amago_num1.png", 15, 20, '+');
	    // atlasTime.setAnchorPoint(cc.p(1, 0.5));
	    // atlasTime.setScale(1.4);
	    atlasTime.setPosition( cc.p(127/2 - 21 , 484 /2 + 10));
	    this.addChild(atlasTime,
	    	YMAmagoGameSceneViewTagTimeLabel,
	    	YMAmagoGameSceneViewTagTimeLabel);

	    var blockButton = NASButtonView.buttonWithNode(cc.Node.create(),this,g_YMScreenSize);
	    blockButton.setPosition(cc.p(0,0));
	    this.addChild(blockButton,
	    	YMAmagoGameSceneViewTagBlockButton,
	    	YMAmagoGameSceneViewTagBlockButton);
	    
	    return true;

	},

	getTimerMax:function()
	{
		return this.m_gameTimerMax;
	},

	setTimerNum:function(time)
	{
		var updated = parseInt(time);
		if(this.m_gameTimerCurrent != updated)
		{	

			if(updated <= 60)
			{

				var spCountDownOld = this.getChildByTag(YMAmagoGameSceneViewTagCountDownLabel);
				if(spCountDownOld)
				{
					spCountDownOld.removeFromParent();
				}

				var blockButton = this.getChildByTag(YMAmagoGameSceneViewTagBlockButton);
				if(blockButton)
				{
					blockButton.removeFromParent();
				}

				this.m_gameTimerCurrent = updated;
				//cc.log("Timer : " + this.m_gameTimerCurrent);
				var atlasTime = this.getChildByTag(YMAmagoGameSceneViewTagTimeLabel);
				var strNum = String(updated);
				atlasTime.setString(strNum);
			}

			else if(updated < 65)
			{ 
				var spCountDownOld = this.getChildByTag(YMAmagoGameSceneViewTagCountDownLabel);
				if(spCountDownOld)
				{
					spCountDownOld.removeFromParent();
				}

				if(updated == 61)
				{
					var spCountDown = cc.Sprite.create("res/ym_r_count_start.png");
					spCountDown.setPosition(g_YMScreenCenter);

					this.addChild(spCountDown,
						YMAmagoGameSceneViewTagCountDownLabel,
						YMAmagoGameSceneViewTagCountDownLabel);
				}
				else
				{
					var nNumForFilename = (updated - 61);
					var strFilename = "res/ym_r_count_" + nNumForFilename + ".png";
					var spCountDown = cc.Sprite.create(strFilename);
					spCountDown.setPosition(g_YMScreenCenter);

					this.addChild(spCountDown,
						YMAmagoGameSceneViewTagCountDownLabel,
						YMAmagoGameSceneViewTagCountDownLabel);
				}

			}

		}
	},

	gameStart:function()
	{

		// var actions = new Array();
  //   actions.push(cc.DelayTime.create(delay));
  //   actions.push(cc.EaseIn.create(cc.Spawn.create(cc.ScaleTo.create(0.15, 1.1),
  //                                                 cc.MoveTo.create(0.15, nextPoint),
  //                                                 null), 5.0));
  //   actions.push(cc.Spawn.create(cc.ScaleTo.create(0.1, 1.0),
  //                                cc.MoveTo.create(0.1, basePoint),
  //                                null));
  //   if(callfunc && callTarget)
  //   {
  //   	//cc.log("[Popup] callfunc && callTarget is exist!!")
  //       actions.push(cc.CallFunc.create(callfunc, callTarget, target));
  //   }

  //   target.runAction(cc.Sequence.create(actions));]


  var actions = new Array();
  actions.push(ym.GameTimer.create(this.getTimerMax()));
  actions.push(cc.CallFunc.create(this.gameEnd, this));

  this.runAction(cc.Sequence.create(actions));
},

gameEnd:function(target)
{
	var scene = new YMAmagoResultScene();
	scene.initWithScore(target.m_score);
	var tran = cc.TransitionFade.create(0.3, scene);
	cc.Director.getInstance().replaceScene(tran);
},

addScore:function(score)
{
	this.m_score += score;

	if(this.m_score < 0)
	{
		this.m_score = 0;
	}

	var strScore = String(this.m_score);
	var atlasScore = this.getChildByTag(YMAmagoGameSceneViewTagScoreLabel);
	atlasScore.setString(strScore);

},

	// yakikoTextureSetSad1Second:function()
	// {
	// 	var sp = this.getChildByTag(YMAmagoGameSceneViewTagYakiko);
	// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_amago_yakiko2.png"));
	// },

	yakikoTextureSetSad:function(target)
	{
		var sp = target.getChildByTag(YMAmagoGameSceneViewTagYakiko);
		sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_amago_yakiko2.png"));

		var yakikoMessage = target.getChildByTag(YMAmagoGameSceneViewTagYakikoMessage);
		yakikoMessage.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_amago_hkds_text2.png"));

	},

	yakikoTextureSetNormal:function(target)
	{
		var sp = target.getChildByTag(YMAmagoGameSceneViewTagYakiko);
		sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_amago_yakiko1.png"));

		var yakikoMessage = target.getChildByTag(YMAmagoGameSceneViewTagYakikoMessage);
		yakikoMessage.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_amago_hkds_text1.png"));
	},

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var tag = button.getTag();

		if (tag == YMAmagoGameSceneViewTagBtnDishNamaMochi)
		{
			if(event == NASButtonViewEventTouchDown)
			{

				var moveNamaAmago = cc.Sprite.create("res/ym_r_amago_amago1_m.png");
				var pos = this.convertTouchToNodeSpace(touch);
				moveNamaAmago.setPosition(pos);
				this.addChild(moveNamaAmago,
					YMAmagoGameSceneViewTagMoveNamaAmago,
					YMAmagoGameSceneViewTagMoveNamaAmago);
			}

			else if(event == NASButtonViewEventTouchMoveInside || event == NASButtonViewEventTouchMoveOutside)
			{

				var moveNamaMochi = this.getChildByTag(YMAmagoGameSceneViewTagMoveNamaAmago);
				if(moveNamaMochi) 
				{
					var pos = this.convertTouchToNodeSpace(touch);
					moveNamaMochi.setPosition(pos);
				}

			}
			else if(event == NASButtonViewEventTouchUp || event == NASButtonViewEventTouchUpInside || event == NASButtonViewEventTouchUpOutside)
			{

				var moveNamaMochi = this.getChildByTag(YMAmagoGameSceneViewTagMoveNamaAmago);
				if(moveNamaMochi) 
				{

					

					var pos = this.convertTouchToNodeSpace(touch);
					var distance = cc.pDistance(pos,g_YMScreenCenter);
					if( (distance < 120) && (this.m_numMochi < this.m_numMochiMax) )
					{

						moveNamaMochi.removeFromParent(true);

						var bakeMochi = YMAmago.create(this);

						var pos = this.convertTouchToNodeSpace(touch);
						bakeMochi.setPosition(cc.p(pos.x - bakeMochi.getContentSize().width / 2,
							pos.y - bakeMochi.getContentSize().height / 2));

						this.addChild(bakeMochi,
							YMAmagoGameSceneViewTagBakingMochi + this.m_numMochi,
							YMAmagoGameSceneViewTagBakingMochi + this.m_numMochi);
						this.m_numMochi++;

						//cc.log("Added. Now baking mochi num : " + this.m_numMochi);

						bakeMochi.runAction(ym.Bake.create(bakeMochi.getTimeMax()));
					}
					else 
					{

						var actions = new Array();
						actions.push(cc.MoveTo.create(0.1,cc.p(30,30)));
						actions.push(ym.RemoveSelf.create());

						moveNamaMochi.runAction(cc.Sequence.create(actions));
					}

				}
			}
		}

		if(tag >= YMAmagoGameSceneViewTagBakingMochi)
		{
			if(event == NASButtonViewEventTouchDown)
			{
				// button.stopAllActions();
				button.pauseSchedulerAndActions();
				var buttonPos = button.getPosition();
				button.setPosBeforeMove(buttonPos);
			}

			else if(event == NASButtonViewEventTouchMoveInside || event == NASButtonViewEventTouchMoveOutside)
			{

				var pos = this.convertTouchToNodeSpace(touch);
				button.setPosition(cc.p(pos.x - button.getContentSize().width / 2,
					pos.y - button.getContentSize().height / 2));

			}
			else if(event == NASButtonViewEventTouchUp || event == NASButtonViewEventTouchUpInside || event == NASButtonViewEventTouchUpOutside)
			{

				// var moveNamaMochi = this.getChildByTag(YMAmagoGameSceneViewTagMoveNamaAmago);
				// if(moveNamaMochi) 
				// {

					// moveNamaMochi.removeFromParent(true);

					var posYakiko = cc.p(820/2,60/2);

					var pos = this.convertTouchToNodeSpace(touch);
					var distance = cc.pDistance(pos,posYakiko);

					if( (distance < 35) )
					{

						var bakeState = button.getBakeState();
						if(bakeState == YMMochiBakedStateTagTooMuchBaked)
						{

							var actions = new Array();
							actions.push(cc.CallFunc.create(this.yakikoTextureSetSad,this));
							actions.push(cc.DelayTime.create(2));
							actions.push(cc.CallFunc.create(this.yakikoTextureSetNormal,this));

							this.runAction(cc.Sequence.create(actions));

						}
						else 
						{
							this.yakikoTextureSetNormal(this);
						}

						this.addScore(button.getScore());

						button.removeFromParent();
						this.m_numMochi--;

					}
					else 
					{
						var posBeforeMove = button.getPosBeforeMove();
						button.runAction(cc.MoveTo.create(0.1,posBeforeMove));
						// button.setPosition(posBeforeMove);
						button.resumeSchedulerAndActions();
					}

				}



			}
		}
	});

var YMAmagoGameScene = cc.Scene.extend({
	onEnter:function () {
		this._super();
		var layer = new YMAmagoGameLayer();
		layer.init();
		this.addChild(layer);
		layer.gameStart();
    // layer.runAction(ym.GameTimer.create(layer.getTimerMax()));
    //TEST
}
});


