"use strict";


//*************************************************************************************
//
// YMMochi
//
//*************************************************************************************

var YMMochiTag = 0;
var YMMochiTagNone			= YMMochiTag++;
var YMMochiTagSpMochi			= YMMochiTag++;
// var YMMochiTagImage			= YMMochiTag++;
// var YMMochiTagName			= YMMochiTag++;
// var YMMochiTagDescription	= YMMochiTag++;
// var YMMochiTagPrice			= YMMochiTag++;
// var YMMochiTagNew			= YMMochiTag++;

var YMMochiBakedStateTag = 0;
var YMMochiBakedStateTagRare			= YMMochiBakedStateTag++;
var YMMochiBakedStateTagMidRare			= YMMochiBakedStateTag++;
var YMMochiBakedStateTagPerfect			= YMMochiBakedStateTag++;
var YMMochiBakedStateTagWellDone			= YMMochiBakedStateTag++;
var YMMochiBakedStateTagTooMuchBaked			= YMMochiBakedStateTag++;


var YMMochiTypeTag = 0;
var YMMochiTypeTagNeko = YMMochiTypeTag++;
var YMMochiTypeTagChamagon = YMMochiTypeTag++;
var YMMochiTypeTagChiken = YMMochiTypeTag++;
var YMMochiTypeTagHeart = YMMochiTypeTag++;
var YMMochiTypeTagTurtle = YMMochiTypeTag++;
var YMMochiTypeTagStar = YMMochiTypeTag++;

var YMMochi = NASButtonView.extend ({
	
    // m_nItemIndex:0,
    // m_isEmpty:false,
    // m_isQuestion:false,
    // m_isMini:false,
    // m_data:null,

    m_timeMax : 15,
    m_time : 0.0,
    m_bakeState : 0,
    m_posBoforeMove : cc.p(0,0),
    m_type : 0,

    init:function(delegate) {
    	if (!this._super())
    	{
    		return false;
    	}

    	this.m_delegate = delegate;

    	this.setTimeNum(this.m_timeMax);

    	var random = Math.random();
    	cc.log("random" + random);

    	var threshold = 1.0/6.0;

    	if(random < threshold*1)
    	{
    		this.m_type = YMMochiTypeTagNeko;
    		this.m_timeMax = 15;
    	}
    	else if(random < threshold*2)
    	{
    		this.m_type = YMMochiTypeTagChamagon;
    		this.m_timeMax = 20;
    	}
    	else if(random < threshold*3)
    	{
    		this.m_type = YMMochiTypeTagChiken;
    		this.m_timeMax = 25;
    	}
    	else if(random < threshold*4)
    	{
    		this.m_type = YMMochiTypeTagHeart;
    		this.m_timeMax = 15;
    	}
    	else if(random < threshold*5)
    	{
    		this.m_type = YMMochiTypeTagTurtle;
    		this.m_timeMax = 40;
    	}
    	else if(random < threshold*6)
    	{
    		this.m_type = YMMochiTypeTagStar;
    		this.m_timeMax = 10;
    	}


    	var mochi = cc.Sprite.create("res/ym_r_mochi1.png");
    	this.setContentSize(mochi.getContentSize());

    	mochi.setTag(YMMochiTagSpMochi);

    	mochi.setPosition( cc.p(mochi.getContentSize().width /2 , mochi.getContentSize().height /2) );
    	this.addChild(mochi);

    	return true;
    },

    setTimeNum:function(num)
    {
    	this.m_time = num;
		// cc.log("num" + this.m_time);

		if(13 < this.m_time)
		{
			this.setBakeState(YMMochiBakedStateTagRare);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi1.png"));
			// }
		}
		else if(10 < this.m_time)
		{
			this.setBakeState(YMMochiBakedStateTagMidRare);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi2.png"));
			// }
		}
		else if(6 < this.m_time)
		{
			this.setBakeState(YMMochiBakedStateTagPerfect);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_chamagon.png"));
			// }
		}
		else if(3 < this.m_time)
		{
			this.setBakeState(YMMochiBakedStateTagWellDone);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi4.png"));
			// }
		}
		else 
		{
			this.setBakeState(YMMochiBakedStateTagTooMuchBaked);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi5.png"));
			// }
		}

	},

	getTimeNum:function()
	{
		return this.m_time;
	},

	getTimeMax:function()
	{
		return this.m_timeMax;
	},

	getScore:function()
	{
		
		var bakeState = this.getBakeState();
		if(bakeState == YMMochiBakedStateTagRare)
		{
			// this.addScore(1);
			var retScore = 10 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMMochiBakedStateTagMidRare)
		{
			// this.addScore(2);
			var retScore = 20 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMMochiBakedStateTagPerfect)
		{
			// this.addScore(10);
			var retScore = 100 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMMochiBakedStateTagWellDone)
		{
			// this.addScore(2);
			var retScore = 20 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMMochiBakedStateTagTooMuchBaked)
		{
			var retScore = -10 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}

	},

	setBakeState:function(bakeState)
	{

		if(this.m_bakeState != bakeState)
		{
			
			this.m_bakeState = bakeState;

			if(this.m_bakeState == YMMochiBakedStateTagRare)
			{
				var sp = this.getSprite();
				if(sp)
				{
					sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi1.png"));
				}
			}
			else if(this.m_bakeState == YMMochiBakedStateTagMidRare)
			{
				var sp = this.getSprite();
				if(sp)
				{
					sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi2.png"));
				}
			}
			else if(this.m_bakeState == YMMochiBakedStateTagPerfect)
			{
				var sp = this.getSprite();
				if(sp)
				{
					if(this.m_type == YMMochiTypeTagNeko)
					{
						sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_neko.png"));
					}
					else if(this.m_type == YMMochiTypeTagChamagon)
					{
						sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_chamagon.png"));
					}
					else if(this.m_type == YMMochiTypeTagChiken)
					{
						sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_chicken.png"));
					}
					else if(this.m_type == YMMochiTypeTagHeart)
					{
						sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_heart.png"));
					}
					else if(this.m_type == YMMochiTypeTagTurtle)
					{
						sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_turtle.png"));
					}
					else if(this.m_type == YMMochiTypeTagStar)
					{
						sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_star.png"));
					}
				}
			}
			else if(this.m_bakeState == YMMochiBakedStateTagWellDone)
			{
				var sp = this.getSprite();
				if(sp)
				{
					sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi4.png"));
				}
			}
			else if(this.m_bakeState == YMMochiBakedStateTagTooMuchBaked)
			{
				var sp = this.getSprite();
				if(sp)
				{
					sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi5.png"));
				}
			}
			// var sp = this.getSprite();
			// sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_btn_start.png"));

			cc.log("bakestate : " + this.m_bakeState);
			if(this.m_bakeState == YMMochiBakedStateTagTooMuchBaked)
			{
				cc.log("toomuch baked");
			}

		}
		
	},

	getBakeState:function()
	{
		return this.m_bakeState;
	},

	setPosBeforeMove:function(pos)
	{
		this.m_posBoforeMove = pos;
	},

	getPosBeforeMove:function()
	{
		return this.m_posBoforeMove;
	},

	setOpacity:function(o)
	{
		var sp = this.getChildByTag(YMMochiTagSpMochi);
		if(sp) sp.setOpacity(o);

	    // var sp2 = this.getChildByTag(YMMochiTagNew);
	    // if(sp2) sp2.setOpacity(o);
	    
	},
	
	getSprite:function()
	{
		return this.getChildByTag(YMMochiTagSpMochi);
	},

	changeColor:function(b)
	{

		var sp = this.getChildByTag(YMMochiTagSpMochi);
		if(sp)
		{
			if(b) sp.setColor(cc.GRAY);
			else sp.setColor(cc.WHITE);
		}

	    // var sp2 = this.getChildByTag(YMMochiTagNew);
	    // if(sp2)
	    // {
	    //     if(b) sp2.setColor(cc.GRAY);
	    //     else sp2.setColor(cc.WHITE);
	    // }
	},

	viewTouchBegan:function(pTouch, pEvent)
	{
		if (!this.m_isTouchEnable)
		{
			return false;
		}

		if (!this.containsTouchLocation(pTouch))
		{
			return false;
		}

		this.m_isTouchDown = true;
		this.m_isTouchInside = true;
		var pSprite = this.getChildByTag(NASButtonViewItemBackground);
		if (pSprite != null)
		{
			if (this.m_isTouchDownEffectEnable)
			{
				this.changeColor(true);
			}
		}

		if (this.m_delegate != null)
		{
			this.m_delegate.buttonEvent(this, NASButtonViewEventTouchDown, pTouch);
		}

		return true;
	},
	
	viewTouchMoved:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventNone;
			if (!this.containsTouchLocation(pTouch))
			{
				event = NASButtonViewEventTouchMoveOutside;
				if (this.m_isTouchDownEffectEnable)
				{
					this.changeColor(false);
				}

				this.m_isTouchInside = false;
			}
			else
			{
				event = NASButtonViewEventTouchMoveInside;
				if (this.m_isTouchDownEffectEnable)
				{
					this.changeColor(true);
				}

				this.m_isTouchInside = true;
			}
			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
	},
	
	viewTouchEnded:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventNone;
			if (!this.m_isTouchInside)
			{
				event = NASButtonViewEventTouchUpOutside;
			}
			else
			{
				event = NASButtonViewEventTouchUpInside;
			}

			this.m_isTouchDown = false;
			if (this.m_isTouchDownEffectEnable)
			{
				this.changeColor(false);
			}

			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
	},
	
	viewTouchCancelled:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventTouchCancelled;

			this.m_isTouchDown = false;
			if (this.m_isTouchDownEffectEnable)
			{
				this.changeColor(false);
			}

			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
	},

});

YMMochi.create = function(delegate){
	var view = new YMMochi();
	
	return (view.init(delegate)) ? view : null;
};
