"use strict";

//*************************************************************************************
//
// YMRankingScene
//
//*************************************************************************************

var YMRankingSceneViewTag = 0;
// var YMTitleSceneViewTagBackGround		 = YMRankingSceneViewTag++;
var YMTitleSceneViewTagToTopButton		 = YMRankingSceneViewTag++;
var YMTitleSceneViewTagToAmagoRank		 = YMRankingSceneViewTag++;
var YMTitleSceneViewTagScroll		 = YMRankingSceneViewTag++;
// var YMTitleSceneViewTagRankingButton		 = YMRankingSceneViewTag++;

var YMTitleSceneViewTagTsuusinBoard		 = 10000;
var YMTitleSceneViewTagTsuusinMessageBoard		 = 10000 + 1;
var YMTitleSceneViewTagTsuusinMessage		 = 10000 + 2;
var YMTitleSceneViewTagErrorToTopButton		 = 10000 + 3;

var YMRankingLayer = NASView.extend({

	m_ranking : null,

	init:function()
	{
		if (!this._super())
		{
			return false;
		}

		var backGround = cc.Sprite.create("res/ym_r_rank_bg.png");
		backGround.setPosition(g_YMScreenCenter);
		this.addChild(backGround);

		//ym_r_rank_title.png

		var titleWord = cc.Sprite.create("res/ym_r_rank_title.png");
		titleWord.setPosition(cc.p(g_YMScreenCenter.x, 560/2));
		this.addChild(titleWord);

		

		var tsuusinBoardBg = cc.Sprite.create("res/ym_r_connect_bg.png");
		tsuusinBoardBg.setPosition(g_YMScreenCenter);
		this.addChild(tsuusinBoardBg,
			YMTitleSceneViewTagTsuusinBoard,
			YMTitleSceneViewTagTsuusinBoard);

		var tsuusinBoard = cc.Sprite.create("res/ym_r_connect_base.png");
		tsuusinBoard.setPosition(g_YMScreenCenter);
		tsuusinBoardBg.addChild(tsuusinBoard,
			YMTitleSceneViewTagTsuusinMessageBoard,
			YMTitleSceneViewTagTsuusinMessageBoard);

		var tsuusinBoardMessage = cc.Sprite.create("res/ym_r_connect_text_load.png");
		tsuusinBoardMessage.setPosition(cc.p(tsuusinBoard.getContentSize().width/2,
											 tsuusinBoard.getContentSize().height/2));
		tsuusinBoard.addChild(tsuusinBoardMessage,
			YMTitleSceneViewTagTsuusinMessage,
			YMTitleSceneViewTagTsuusinMessage);

		this.getRanking();

		return true;
	},

	getRanking:function()
	{
		var that = this;
		ym_api_score_list(function(error, text) {
			var obj = JSON.parse(text);

			if (obj != null) {
				var nStatus = obj["status"];
				if (nStatus == 0) {

					var ranking = obj["score_list"];
					that.m_ranking = ranking;

					that.runAction(cc.CallFunc.create(that.showRanking, that));
					

				} else {
					// error
					that.runAction(cc.CallFunc.create(that.showError, that));
				}
			} else {
				// error
				if (error != null) {
				}
			}
		});
	},

	showError:function(target)
	{
		var tsuusinBoardBg = target.getChildByTag(YMTitleSceneViewTagTsuusinBoard);
		if(tsuusinBoardBg)
		{
			var tsuusinBoard = tsuusinBoardBg.getChildByTag(YMTitleSceneViewTagTsuusinMessageBoard);
			var tsuusinBoardMessageOld = tsuusinBoard.getChildByTag(YMTitleSceneViewTagTsuusinMessage);
			if(tsuusinBoardMessageOld) tsuusinBoardMessageOld.removeFromParent();

			var tsuusinBoardMessage = cc.Sprite.create("res/ym_r_connect_text_error.png");
			tsuusinBoardMessage.setPosition(cc.p(tsuusinBoard.getContentSize().width/2,
				tsuusinBoard.getContentSize().height/2));
			tsuusinBoard.addChild(tsuusinBoardMessage,
				YMTitleSceneViewTagTsuusinMessage,
				YMTitleSceneViewTagTsuusinMessage);

			var buttonToTop = NASButtonView.buttonWithFile("res/ym_r_rank_btn_top.png", this);
			buttonToTop.setPosition(cc.p(g_YMScreenCenter.x - buttonToTop.getContentSize().width/2
									,50));
			// buttonToTop.setTag(YMTitleSceneViewTagToTopButton);
			target.addChild(buttonToTop,YMTitleSceneViewTagErrorToTopButton,YMTitleSceneViewTagErrorToTopButton);

		}
	},

	showRanking:function(target)
	{

		var tsuusinBoardBg = target.getChildByTag(YMTitleSceneViewTagTsuusinBoard);
		if(tsuusinBoardBg) tsuusinBoardBg.removeFromParent();

		var scrollView = NASScrollView.create();
		scrollView.m_bClip = true;
		scrollView.m_bPaging = false;
		scrollView.m_bBounceX = false;
		scrollView.m_bBounceY = true;

		var sizeContent = cc.SizeMake(816/2,349/2);
		var sizeView = cc.SizeMake(816/2,349);

		scrollView.setViewSize(sizeView);
		scrollView.setContentSize(sizeContent);


    	var posTopLeft = cc.p(0,sizeView.height);
    	cc.log("posTopLeft" + sizeView.height);

		for (var i = 0; i < this.m_ranking.length; i++)
		{

			var obj = this.m_ranking[i];
			var rank = obj["rank"];
			var playername = obj["playerName"];
			var score = obj["score"];

			var viewCell = NASView.create();

			var strFilename = "res/ym_r_rank_num_" + String(i+1) +".png";

			var spCellBack = cc.Sprite.create(strFilename);
			spCellBack.setPosition(cc.p( spCellBack.getContentSize().width /2 ,
				spCellBack.getContentSize().height /2));

			viewCell.addChild(spCellBack);
			viewCell.setContentSize(spCellBack.getContentSize());

			var labelName = cc.LabelTTF.create(playername, "Helvetica", 18);
			// labelName.setColor(cc.BLACK);
			labelName.setAnchorPoint(cc.p(0.5, 0.5));
			labelName.setPosition(cc.p(150, + spCellBack.getContentSize().height/2));
			labelName.setHorizontalAlignment(cc.TEXT_ALIGNMENT_CENTER);
			viewCell.addChild(labelName);

			// var labelScore = cc.LabelTTF.create(score, "Helvetica", 18);
			var atlasScore = cc.LabelAtlas.create(score, "res/ym_r_num2.png", 19, 25, '+');
			// labelName.setColor(cc.BLACK);
			atlasScore.setAnchorPoint(cc.p(1, 0.5));
			atlasScore.setPosition(cc.p(692/2, spCellBack.getContentSize().height/2));
			// atlasScore.setHorizontalAlignment(cc.TEXT_ALIGNMENT_RIGHT);
			viewCell.addChild(atlasScore);

			var spPoint = cc.Sprite.create("res/ym_r_rank_text_score.png");
			spPoint.setAnchorPoint(cc.p(0,0.5));
			spPoint.setPosition(cc.p(350, spCellBack.getContentSize().height/2));
			viewCell.addChild(spPoint);

			var strFilenameLine = "";
			if(i < 3)
			{
				strFilenameLine = "res/ym_r_rank_line_" + String(i+1) + ".png";
			}

			if( strFilenameLine != "")
			{
				var spLine = cc.Sprite.create(strFilenameLine);
				spLine.setAnchorPoint(cc.p(0,0));
				viewCell.addChild(spLine);
			}

			var spCellPos = cc.p(10 , posTopLeft.y - (spCellBack.getContentSize().height) * (i + 1));

			viewCell.setPosition(spCellPos);
			scrollView.addView(viewCell);

			// display

			// cc.log(rank);
			// cc.log(playername);
		}

		var posTop = cc.p(0,-(scrollView.getViewSize().height - scrollView.getContentSize().height));
		scrollView.setViewOffset(posTop);

		scrollView.setPosition(cc.p(70/2,100/2));

		target.addChild(scrollView,
			YMTitleSceneViewTagScroll,
			YMTitleSceneViewTagScroll);

		var buttonToTop = NASButtonView.buttonWithFile("res/ym_r_rank_btn_top.png", this);
		buttonToTop.setPosition(cc.p(824/2,
									 511/2));
	    buttonToTop.setTag(YMTitleSceneViewTagToTopButton);
		target.addChild(buttonToTop);

		var buttonToAmagoRank = NASButtonView.buttonWithFile("res/ym_r_rank_btn_amago.png", this);
		buttonToAmagoRank.setPosition(cc.p(0 ,g_YMScreenSize.height - buttonToAmagoRank.getContentSize().height));
		buttonToAmagoRank.setTag(YMTitleSceneViewTagToAmagoRank);
		target.addChild(buttonToAmagoRank);

//		var vMain = this.getChildByTag(JGRankingLayerTagMain);
//		var vScroll = vMain.getChildByTag(JGRankingLayerMainTagScroll);

//		var scroll = this.makeScroll();
//		scroll.setTag(JGRankingLayerScrollTagScroll);
//		scroll.setPosition(cc.p(30, 35));
//		vScroll.addChild(scroll);
	},

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{

		var tag = button.getTag();
		if(event == NASButtonViewEventTouchUpInside)
		{
			if (tag == YMTitleSceneViewTagToTopButton || tag == YMTitleSceneViewTagErrorToTopButton)
			{

				var scene = new YMTitleScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);

			}

			else if(tag == YMTitleSceneViewTagToAmagoRank)
			{

				var scene = new YMAmagoRankingScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);

			}
			// else if(tag == YMTitleSceneViewTagRankingButton)
			// {
			// 	var scene = new YMRankingScene();
			// 	var tran = cc.TransitionFade.create(0.3, scene);
			// 	cc.Director.getInstance().replaceScene(tran);
			// }
		}

	}
});

var YMRankingScene = cc.Scene.extend({
	onEnter:function () {
		this._super();
		var layer = new YMRankingLayer();
		layer.init();
		this.addChild(layer);
	}
});


