"use strict";

//*************************************************************************************
//
// YMResultScene
//
//*************************************************************************************

var YMResultSceneButtonTag = 100;
var YMResultSceneButtonTagNone			= YMResultSceneButtonTag++;
var YMResultSceneButtonTagNameOK			= YMResultSceneButtonTag++;

var YMResultSceneEditBoxTag = 0;
var YMResultSceneEditBoxTagPlayerName		= YMResultSceneEditBoxTag++;


var YMResultSceneResultLevel = 0;
var YMResultSceneResultLevelHigh = 1;
var YMResultSceneResultLevelMid = 2;
var YMResultSceneResultLevelLow = 3;


var YMResultSceneViewTagTsuusinBoard		 = 10000;
var YMResultSceneViewTagTsuusinMessageBoard		 = 10000 + 1;
var YMResultSceneViewTagTsuusinMessage		 = 10000 + 2;
var YMResultSceneViewTagErrorToTopButton		 = 10000 + 3;

var YMResultLayer = NASView.extend ({

	m_nScoreID:0,
	m_nRank:0,
	m_sPlayerName:"名無しさん",
	m_resultLevel : 0,
	m_score : 0,

	init:function(score)
	{
		if (!this._super())
		{
			return false;
		}

		this.m_score = score;

		var backGround = cc.Sprite.create("res/ym_r_result_bg.png");
		backGround.setPosition(g_YMScreenCenter);
		this.addChild(backGround);

		if(600 < score)
		{
			this.m_resultLevel = YMResultSceneResultLevelHigh;
		}
		else if(200 < score)
		{
			this.m_resultLevel = YMResultSceneResultLevelMid;
		}
		else
		{
			this.m_resultLevel = YMResultSceneResultLevelLow;
		}


		var tsuusinBoardBg = cc.Sprite.create("res/ym_r_connect_bg.png");
		tsuusinBoardBg.setPosition(g_YMScreenCenter);
		this.addChild(tsuusinBoardBg,
			YMResultSceneViewTagTsuusinBoard,
			YMResultSceneViewTagTsuusinBoard);

		var tsuusinBoard = cc.Sprite.create("res/ym_r_connect_base.png");
		tsuusinBoard.setPosition(g_YMScreenCenter);
		tsuusinBoardBg.addChild(tsuusinBoard,
			YMResultSceneViewTagTsuusinMessageBoard,
			YMResultSceneViewTagTsuusinMessageBoard);

		var tsuusinBoardMessage = cc.Sprite.create("res/ym_r_connect_text_load.png");
		tsuusinBoardMessage.setPosition(cc.p(tsuusinBoard.getContentSize().width/2,
											 tsuusinBoard.getContentSize().height/2));
		tsuusinBoard.addChild(tsuusinBoardMessage,
			YMResultSceneViewTagTsuusinMessage,
			YMResultSceneViewTagTsuusinMessage);

		//★ registScore
		this.registScore(score);

	    return true;
	},

	registScore:function(score)
	{
		var that = this;
		ym_api_regist_score(score, function(error, text) {
			var obj = JSON.parse(text);

			if (obj != null) {
				var nStatus = obj["status"];
				if (nStatus == 0) {

					that.m_nScoreID = obj["score_id"];
					that.m_nRank = obj["rank"];

					cc.log("rank:" + that.m_nRank);

					that.runAction(cc.CallFunc.create(that.showResult, that));

				} else {
					//★ error
					that.runAction(cc.CallFunc.create(that.showError, that));
				}
			} else {
				//★ error
				if (error != null) {
				}
			}
		});
	},

	showError:function(target)
	{
		var tsuusinBoardBg = target.getChildByTag(YMResultSceneViewTagTsuusinBoard);
		if(tsuusinBoardBg)
		{
			var tsuusinBoard = tsuusinBoardBg.getChildByTag(YMResultSceneViewTagTsuusinMessageBoard);
			var tsuusinBoardMessageOld = tsuusinBoard.getChildByTag(YMResultSceneViewTagTsuusinMessage);
			if(tsuusinBoardMessageOld) tsuusinBoardMessageOld.removeFromParent();

			var tsuusinBoardMessage = cc.Sprite.create("res/ym_r_connect_text_error.png");
			tsuusinBoardMessage.setPosition(cc.p(tsuusinBoard.getContentSize().width/2,
				tsuusinBoard.getContentSize().height/2));
			tsuusinBoard.addChild(tsuusinBoardMessage,
				YMResultSceneViewTagTsuusinMessage,
				YMResultSceneViewTagTsuusinMessage);

			var buttonToTop = NASButtonView.buttonWithFile("res/ym_r_rank_btn_top.png", this);
			buttonToTop.setPosition(cc.p(g_YMScreenCenter.x - buttonToTop.getContentSize().width/2
									,50));
			// buttonToTop.setTag(YMResultSceneViewTagToTopButton);
			target.addChild(buttonToTop,YMResultSceneViewTagErrorToTopButton,YMResultSceneViewTagErrorToTopButton);

		}
	},

	showResult:function(target)
	{

		var tsuusinBoardBg = target.getChildByTag(YMResultSceneViewTagTsuusinBoard);
		if(tsuusinBoardBg) tsuusinBoardBg.removeFromParent();

		var spTitleFilename = "res/ym_r_result_type" + target.m_resultLevel +"_title.png";
		
		var spResultTitle = cc.Sprite.create(spTitleFilename);

		spResultTitle.setPosition(cc.p(g_YMScreenCenter.x, 560/2));
		target.addChild(spResultTitle);

		var spTextFilename = "res/ym_r_result_type" + target.m_resultLevel +"_text.png";

		var spriteComment = cc.Sprite.create(spTextFilename);
		spriteComment.setPosition(cc.p(g_YMScreenCenter.x, 423/2));
		target.addChild(spriteComment);

		var spEditBoxBack = cc.Sprite.create("res/ym_r_result_textbox.png");
		spEditBoxBack.setAnchorPoint(cc.p(0,0));
		spEditBoxBack.setPosition(cc.p(118/2,276/2));
		target.addChild(spEditBoxBack);

		var sizeEdit = cc.SizeMake(spEditBoxBack.getContentSize().width*cc.canvas.width/480, 
								spEditBoxBack.getContentSize().height*cc.canvas.height/360);
		var editPlayerName = cc.EditBox.create(sizeEdit, cc.Scale9Sprite.create("res/ym_r_result_textbox.png"));

		editPlayerName.setFontSize(14*cc.canvas.height/360);
		var posEdit = cc.PointMake(cc.canvas.width/2 - editPlayerName.getContentSize().width/2, cc.canvas.height/2-10-editPlayerName.getContentSize().height/2)
		editPlayerName.setAnchorPoint(cc.p(0,0));
// mod dojo 2014.01.27 vvvv
//		editPlayerName.setPosition(spEditBoxBack.getPosition());
		var editBoxScale = cc.Director.getInstance().getContentScaleFactor();
		editPlayerName.setPosition(cc.p(spEditBoxBack.getPosition().x*editBoxScale, spEditBoxBack.getPosition().y*editBoxScale));
// mod dojo 2014.01.27 ^^^^
		editPlayerName.setBorderWidth(0);

		var spNamae = cc.Sprite.create("res/ym_r_result_text_name.png");
		spNamae.setAnchorPoint(cc.p(0,0));
		spNamae.setPosition(cc.p(114/2,337/2));
		target.addChild(spNamae);

		var spAnatawa = cc.Sprite.create("res/ym_r_result_text_rank.png");
		spAnatawa.setAnchorPoint(cc.p(0,1));
		spAnatawa.setPosition(cc.p(114/2,246/2));
		target.addChild(spAnatawa);

		var atlasRank = cc.LabelAtlas.create(target.m_nRank, "res/ym_r_num2.png", 19, 25, '+');
		// labelName.setColor(cc.BLACK);
		atlasRank.setAnchorPoint(cc.p(1, 0));
		atlasRank.setPosition(cc.p(297/2,165/2 - 10));
		// atlasScore.setHorizontalAlignment(cc.TEXT_ALIGNMENT_RIGHT);
		target.addChild(atlasRank);

		//539 323

		var spScoreFrame = cc.Sprite.create("res/ym_r_result_text_score.png");
		spScoreFrame.setAnchorPoint(cc.p(0,1));
		spScoreFrame.setPosition(cc.p(539/2,370/2));
		target.addChild(spScoreFrame);


		var atlasScore = cc.LabelAtlas.create(target.m_score, "res/ym_r_num2.png", 19, 25, '+');
		// labelName.setColor(cc.BLACK);
		atlasScore.setAnchorPoint(cc.p(1, 0));
		atlasScore.setPosition(cc.p(753/2,335/2 - 30));
		// atlasScore.setHorizontalAlignment(cc.TEXT_ALIGNMENT_RIGHT);
		target.addChild(atlasScore);


		var spYakikoFilename = "res/ym_r_result_type" + target.m_resultLevel +"_yakiko.png";

		var spYakiko = cc.Sprite.create(spYakikoFilename);
		spYakiko.setAnchorPoint(cc.p(0,1));
		spYakiko.setPosition(cc.p(350/2,310/2 - 10));
		target.addChild(spYakiko);


		window.addEventListener("resize", function (event) {
			editPlayerName.setFontSize(14*cc.canvas.height/360);
			sizeEdit = cc.SizeMake(spriteComment.getContentSize().width/480 * cc.canvas.width, 25/360 * cc.canvas.height);
			editPlayerName.setContentSize(sizeEdit);
			posEdit = cc.PointMake(cc.canvas.width/2 - editPlayerName.getContentSize().width/2, cc.canvas.height/2-10-editPlayerName.getContentSize().height/2)
   			editPlayerName.setPosition(posEdit);
    	});

		editPlayerName.setFontColor(cc.BLACK);
        // editPlayerName.setText(this.m_sPlayerName);
		editPlayerName.setPlaceHolder("名無しさん");
		editPlayerName.setMaxLength(10);
		editPlayerName.setReturnType(cc.KEYBOARD_RETURNTYPE_DONE);
		editPlayerName.setTag(YMResultSceneEditBoxTagPlayerName);
		editPlayerName.setDelegate(this);
		target.addChild(editPlayerName);

		var buttonOK = NASButtonView.buttonWithFile("res/ym_r_result_btn.png", this);
		buttonOK.setPosition(cc.p(829/2,518/2));
		buttonOK.setTag(YMResultSceneButtonTagNameOK);
		target.addChild(buttonOK);
//		JGAvatarAnim.animBlowPopUp(buttonOK, 0.0, null, null);

	},

	registName:function(nScoreID, sPlayerName)
	{
		var childEditBox = this.getChildByTag(YMResultSceneEditBoxTagPlayerName);
		// childEditBox.setEditBoxVisible(false);

		var tsuusinBoardBg = cc.Sprite.create("res/ym_r_connect_bg.png");
		tsuusinBoardBg.setPosition(g_YMScreenCenter);
		this.addChild(tsuusinBoardBg,
			YMResultSceneViewTagTsuusinBoard,
			YMResultSceneViewTagTsuusinBoard);

		var tsuusinBoard = cc.Sprite.create("res/ym_r_connect_base.png");
		tsuusinBoard.setPosition(g_YMScreenCenter);
		tsuusinBoardBg.addChild(tsuusinBoard,
			YMResultSceneViewTagTsuusinMessageBoard,
			YMResultSceneViewTagTsuusinMessageBoard);

		var tsuusinBoardMessage = cc.Sprite.create("res/ym_r_connect_text_load.png");
		tsuusinBoardMessage.setPosition(cc.p(tsuusinBoard.getContentSize().width/2,
											 tsuusinBoard.getContentSize().height/2));
		tsuusinBoard.addChild(tsuusinBoardMessage,
			YMResultSceneViewTagTsuusinMessage,
			YMResultSceneViewTagTsuusinMessage);

		var that = this;
		ym_api_regist_name(nScoreID, sPlayerName, function(error, text) {
			var obj = JSON.parse(text);

			if (obj != null) {
				var nStatus = obj["status"];
				if (nStatus == 0) {

//					that.runAction(cc.CallFunc.create(that.closeName, that));
					cc.log("OK");

					that.runAction(cc.CallFunc.create(that.toRanking, that));

				} else {
					//★ error
					that.runAction(cc.CallFunc.create(that.showError, that));
				}
			} else {
				//★ error
				if (error != null)
				{
				}
			}
		});

	},

	toRanking:function()
	{
		var scene = new YMRankingScene();
		var tran = cc.TransitionFade.create(0.3, scene);
		cc.Director.getInstance().replaceScene(tran);
	},

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		if(event == NASButtonViewEventTouchUpInside)
		{
			var tag = button.getTag();

			if (tag == YMResultSceneButtonTagNameOK)
			{
				if (this.m_sPlayerName != "")
				{
					//★ registName
					this.registName(this.m_nScoreID, this.m_sPlayerName);
				}
		    }
		    else if(tag == YMResultSceneViewTagErrorToTopButton)
		    {
		    	var scene = new YMTitleScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);
		    }
		}
	},

	//************************************************************
	// CCEditBoxDelegate
	//************************************************************
	editBoxEditingDidBegin:function(editBox)
	{
	    cc.log("editBox DidBegin !");
	},

	editBoxEditingDidEnd:function(editBox)
	{
	    cc.log("editBox DidEnd !");
	},

	editBoxTextChanged:function(editBox, text)
	{
	    cc.log("editBox TextChanged, text: " + text);
	},

	editBoxReturn:function(editBox)
	{
	    cc.log("editBox was returned !");

		this.m_sPlayerName = editBox.getText();
	}

});

var YMResultScene = cc.Scene.extend({
	
	onEnter:function () {
		this._super();
	},

	initWithScore : function(score)
	{
		cc.log("score  " + score);
		var layer = new YMResultLayer();
		layer.init(score);
		this.addChild(layer);
	}
});

