"use strict";

var ym = ym = ym || {};

ym.Bake = cc.ActionInterval.extend(/** @lends cc.Bake# */{
    initWithDuration:function (duration) { //function overload here
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
            this._endNum = 0;
            return true;
        }
        return false;
    },

    startWithTarget:function (target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startNum = target.getTimeNum();
        this._delta = this._endNum - this._startNum;
    },

    update:function (time) {
        // cc.log("ym.Bake update time" + time);
        if (this._target)
        {
            this._target.setTimeNum(this._startNum + this._delta * time);
        }
    },

    _endNum : 0,
    _startNum : 0,
    _delta : 0,
    _previousNum : 0

});

ym.Bake.create = function (duration){ //function overload
    var bake = new ym.Bake();
    bake.initWithDuration(duration);

    return bake;
};

ym.GameTimer = cc.ActionInterval.extend(/** @lends cc.Bake# */{
    initWithDuration:function (duration) { //function overload here
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
            this._endNum = 0;
            return true;
        }
        return false;
    },

    startWithTarget:function (target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startNum = target.getTimerMax();
        this._delta = this._endNum - this._startNum;
    },

    update:function (time) {
        // cc.log("ym.Bake update time" + time);
        if (this._target)
        {
            this._target.setTimerNum(this._startNum + this._delta * time);
        }
    },

    _endNum : 0,
    _startNum : 0,
    _delta : 0,
    _previousNum : 0

});


ym.GameTimer.create = function (duration){ //function overload
    var timer = new ym.GameTimer();
    timer.initWithDuration(duration);

    return timer;
};

ym.RemoveSelf = cc.ActionInstant.extend({
     _isNeedCleanUp:true,
    ctor:function(){
        // cc.FiniteTimeAction.prototype.ctor.call(this);
        this._isNeedCleanUp = true;
    },

    update:function(time){
        this._target.removeFromParent(this._isNeedCleanUp);
    },

    init:function(isNeedCleanUp){
        this._isNeedCleanUp = isNeedCleanUp;
        return true;
    },

    reverse:function(){
        return new cc.RemoveSelf(this._isNeedCleanUp);
    },

    clone:function(){
        return new cc.RemoveSelf(this._isNeedCleanUp);
    }
});

ym.RemoveSelf.create = function(isNeedCleanUp){
    if(isNeedCleanUp == null)
        isNeedCleanUp = true;
    var removeSelf = new ym.RemoveSelf();
    if(removeSelf)
        removeSelf.init(isNeedCleanUp);
    return removeSelf;
};
