"use strict";


//*************************************************************************************
//
// YMAmago
//
//*************************************************************************************

var YMAmagoTag = 0;
var YMAmagoTagNone			= YMAmagoTag++;
var YMAmagoTagSpMochi			= YMAmagoTag++;
// var YMAmagoTagImage			= YMAmagoTag++;
// var YMAmagoTagName			= YMAmagoTag++;
// var YMAmagoTagDescription	= YMAmagoTag++;
// var YMAmagoTagPrice			= YMAmagoTag++;
// var YMAmagoTagNew			= YMAmagoTag++;

var YMAmagoBakedStateTag = 0;
var YMAmagoBakedStateTagRare			= YMAmagoBakedStateTag++;
var YMAmagoBakedStateTagMidRare			= YMAmagoBakedStateTag++;
var YMAmagoBakedStateTagPerfect			= YMAmagoBakedStateTag++;
var YMAmagoBakedStateTagWellDone			= YMAmagoBakedStateTag++;
var YMAmagoBakedStateTagTooMuchBaked			= YMAmagoBakedStateTag++;


var YMAmagoTypeTag = 0;
var YMAmagoTypeTagSmall = YMAmagoTypeTag++;
var YMAmagoTypeTagMiddle = YMAmagoTypeTag++;
var YMAmagoTypeTagLarge = YMAmagoTypeTag++;

var YMAmago = NASButtonView.extend ({
	
    // m_nItemIndex:0,
    // m_isEmpty:false,
    // m_isQuestion:false,
    // m_isMini:false,
    // m_data:null,

    m_timeMax : 15,
    m_time : 0.0,
    m_bakeState : 0,
    m_posBoforeMove : cc.p(0,0),
    m_type : 0,
    m_typeSuffix : "",

    init:function(delegate) {
    	if (!this._super())
    	{
    		return false;
    	}

    	this.m_delegate = delegate;

    	this.setTimeNum(this.m_timeMax);

    	var random = Math.random();
    	cc.log("random" + random);

    	var patternNum = 3.0;
    	var threshold = 1.0 / patternNum;

    	var filename = "";

    	if(random < threshold*1)
    	{
    		this.m_type = YMAmagoTypeTagSmall;
    		this.m_typeSuffix = "s";
    		this.m_timeMax = 15;
    		filename = "res/ym_r_amago_amago1_s.png";
    	}
    	else if(random < threshold*2)
    	{
    		this.m_type = YMAmagoTypeTagMiddle;
    		this.m_typeSuffix = "m";
    		this.m_timeMax = 20;
    		filename = "res/ym_r_amago_amago1_m.png";
    	}
    	else if(random < threshold*3)
    	{
    		this.m_type = YMAmagoTypeTagLarge;
    		this.m_typeSuffix = "l";
    		this.m_timeMax = 25;
    		filename = "res/ym_r_amago_amago1_l.png";
		}


    	var amago = cc.Sprite.create(filename);
    	this.setContentSize(amago.getContentSize());

    	amago.setTag(YMAmagoTagSpMochi);

    	amago.setPosition( cc.p(amago.getContentSize().width /2 , amago.getContentSize().height /2) );
    	this.addChild(amago);

    	return true;
    },

    setTimeNum:function(num)
    {
    	this.m_time = num;
		// cc.log("num" + this.m_time);

		if(13 < this.m_time)
		{
			this.setBakeState(YMAmagoBakedStateTagRare);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi1.png"));
			// }
		}
		else if(10 < this.m_time)
		{
			this.setBakeState(YMAmagoBakedStateTagMidRare);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi2.png"));
			// }
		}
		else if(6 < this.m_time)
		{
			this.setBakeState(YMAmagoBakedStateTagPerfect);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi3_chamagon.png"));
			// }
		}
		else if(3 < this.m_time)
		{
			this.setBakeState(YMAmagoBakedStateTagWellDone);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi4.png"));
			// }
		}
		else 
		{
			this.setBakeState(YMAmagoBakedStateTagTooMuchBaked);
			// var sp = this.getSprite();
			// if(sp)
			// {
			// 	sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_r_mochi5.png"));
			// }
		}

	},

	getTimeNum:function()
	{
		return this.m_time;
	},

	getTimeMax:function()
	{
		return this.m_timeMax;
	},

	getScore:function()
	{
		
		var bakeState = this.getBakeState();
		if(bakeState == YMAmagoBakedStateTagRare)
		{
			// this.addScore(1);
			var retScore = -20 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMAmagoBakedStateTagMidRare)
		{
			// this.addScore(2);
			var retScore = -20 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMAmagoBakedStateTagPerfect)
		{
			// this.addScore(10);
			var retScore = 100 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMAmagoBakedStateTagWellDone)
		{
			// this.addScore(2);
			var retScore = 60 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}
		else if(bakeState == YMAmagoBakedStateTagTooMuchBaked)
		{
			var retScore = -10 * (this.m_timeMax/10.0);

			return parseInt(retScore);
		}

	},

	setBakeState:function(bakeState)
	{

		if(this.m_bakeState != bakeState)
		{
			
			this.m_bakeState = bakeState;

			if(this.m_bakeState == YMAmagoBakedStateTagRare)
			{
				var sp = this.getSprite();
				if(sp)
				{
					var filename = "res/ym_r_amago_amago1_" + this.m_typeSuffix + ".png";
					sp.setTexture(cc.TextureCache.getInstance().addImage(filename));
				}
			}
			else if(this.m_bakeState == YMAmagoBakedStateTagMidRare)
			{
				var sp = this.getSprite();
				if(sp)
				{
					var filename = "res/ym_r_amago_amago2_" + this.m_typeSuffix + ".png";
					sp.setTexture(cc.TextureCache.getInstance().addImage(filename));
				}
			}
			else if(this.m_bakeState == YMAmagoBakedStateTagPerfect)
			{
				var sp = this.getSprite();
				if(sp)
				{
					var filename = "res/ym_r_amago_amago3_" + this.m_typeSuffix + ".png";
					sp.setTexture(cc.TextureCache.getInstance().addImage(filename));
				}
			}
			else if(this.m_bakeState == YMAmagoBakedStateTagWellDone)
			{
				var sp = this.getSprite();
				if(sp)
				{	
					var filename = "res/ym_r_amago_amago4_" + this.m_typeSuffix + ".png";
					sp.setTexture(cc.TextureCache.getInstance().addImage(filename));
				}
			}
			else if(this.m_bakeState == YMAmagoBakedStateTagTooMuchBaked)
			{
				var sp = this.getSprite();
				if(sp)
				{	
					var filename = "res/ym_r_amago_amago5_" + this.m_typeSuffix + ".png";
					sp.setTexture(cc.TextureCache.getInstance().addImage(filename));
				}
			}
			// var sp = this.getSprite();
			// sp.setTexture(cc.TextureCache.getInstance().addImage("res/ym_btn_start.png"));

			cc.log("bakestate : " + this.m_bakeState);
			if(this.m_bakeState == YMAmagoBakedStateTagTooMuchBaked)
			{
				cc.log("toomuch baked");
			}

		}
		
	},

	getBakeState:function()
	{
		return this.m_bakeState;
	},

	setPosBeforeMove:function(pos)
	{
		this.m_posBoforeMove = pos;
	},

	getPosBeforeMove:function()
	{
		return this.m_posBoforeMove;
	},

	setOpacity:function(o)
	{
		var sp = this.getChildByTag(YMAmagoTagSpMochi);
		if(sp) sp.setOpacity(o);

	    // var sp2 = this.getChildByTag(YMAmagoTagNew);
	    // if(sp2) sp2.setOpacity(o);
	    
	},
	
	getSprite:function()
	{
		return this.getChildByTag(YMAmagoTagSpMochi);
	},

	changeColor:function(b)
	{

		var sp = this.getChildByTag(YMAmagoTagSpMochi);
		if(sp)
		{
			if(b) sp.setColor(cc.GRAY);
			else sp.setColor(cc.WHITE);
		}

	    // var sp2 = this.getChildByTag(YMAmagoTagNew);
	    // if(sp2)
	    // {
	    //     if(b) sp2.setColor(cc.GRAY);
	    //     else sp2.setColor(cc.WHITE);
	    // }
	},

	viewTouchBegan:function(pTouch, pEvent)
	{
		if (!this.m_isTouchEnable)
		{
			return false;
		}

		if (!this.containsTouchLocation(pTouch))
		{
			return false;
		}

		this.m_isTouchDown = true;
		this.m_isTouchInside = true;
		var pSprite = this.getChildByTag(NASButtonViewItemBackground);
		if (pSprite != null)
		{
			if (this.m_isTouchDownEffectEnable)
			{
				this.changeColor(true);
			}
		}

		if (this.m_delegate != null)
		{
			this.m_delegate.buttonEvent(this, NASButtonViewEventTouchDown, pTouch);
		}

		return true;
	},
	
	viewTouchMoved:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventNone;
			if (!this.containsTouchLocation(pTouch))
			{
				event = NASButtonViewEventTouchMoveOutside;
				if (this.m_isTouchDownEffectEnable)
				{
					this.changeColor(false);
				}

				this.m_isTouchInside = false;
			}
			else
			{
				event = NASButtonViewEventTouchMoveInside;
				if (this.m_isTouchDownEffectEnable)
				{
					this.changeColor(true);
				}

				this.m_isTouchInside = true;
			}
			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
	},
	
	viewTouchEnded:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventNone;
			if (!this.m_isTouchInside)
			{
				event = NASButtonViewEventTouchUpOutside;
			}
			else
			{
				event = NASButtonViewEventTouchUpInside;
			}

			this.m_isTouchDown = false;
			if (this.m_isTouchDownEffectEnable)
			{
				this.changeColor(false);
			}

			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
	},
	
	viewTouchCancelled:function(pTouch, pEvent)
	{
		if (this.m_isTouchDown)
		{
			var event = NASButtonViewEventTouchCancelled;

			this.m_isTouchDown = false;
			if (this.m_isTouchDownEffectEnable)
			{
				this.changeColor(false);
			}

			if (this.m_delegate != null && event != NASButtonViewEventNone)
			{
				this.m_delegate.buttonEvent(this, event, pTouch);
			}
		}
	},

});

YMAmago.create = function(delegate){
	var view = new YMAmago();
	
	return (view.init(delegate)) ? view : null;
};
