"use strict";

//*************************************************************************************
//
// YMTitleScene
//
//*************************************************************************************

var YMTitleSceneViewTag = 0;
var YMTitleSceneViewTagBackGround		 = YMTitleSceneViewTag++;
var YMTitleSceneViewTagStartButton		 = YMTitleSceneViewTag++;
var YMTitleSceneViewTagRankingButton		 = YMTitleSceneViewTag++;
var YMTitleSceneViewTagAmagoButton		 = YMTitleSceneViewTag++;
var YMTitleSceneViewTagManualButton		 = YMTitleSceneViewTag++;

var YMTitleLayer = NASView.extend({

	init:function()
	{
		if (!this._super())
		{
			return false;
		}

		var backGround = cc.Sprite.create("res/ym_title_back.png");
	    backGround.setPosition(g_YMScreenCenter);
	    this.addChild(backGround);

		var buttonStart = NASButtonView.buttonWithFile("res/ym_r_index_btn_start.png", this);
		// buttonStart.setPosition(cc.p(g_YMScreenCenter.x - buttonStart.getContentSize().width / 2 + 95 - 50,
		// 							 g_YMScreenCenter.y - buttonStart.getContentSize().height / 2 - 40));
		buttonStart.setPosition(cc.p(g_YMScreenCenter.x - buttonStart.getContentSize().width / 2 - 150 ,
									 g_YMScreenCenter.y - buttonStart.getContentSize().height / 2));
		// buttonStart.setPosition(cc.p(203,275));
	    buttonStart.setTouchDownEffectEnable(false);
	    buttonStart.setTag(YMTitleSceneViewTagStartButton);
		this.addChild(buttonStart);

		var buttonRanking = NASButtonView.buttonWithFile("res/ym_r_index_btn_ranking.png", this);
		// buttonRanking.setPosition(cc.p(g_YMScreenCenter.x - buttonRanking.getContentSize().width / 2 - 95 - 50,
		// 							 g_YMScreenCenter.y - buttonRanking.getContentSize().height / 2 - 40));
		buttonRanking.setScale(0.7);
		buttonRanking.setPosition(cc.p(g_YMScreenSize.width - buttonRanking.getContentSize().width*buttonRanking.getScale() - 20,
									   20));
		// buttonRanking.setPosition(cc.p(585,275));
		//585/283
	    buttonRanking.setTouchDownEffectEnable(false);
	    buttonRanking.setTag(YMTitleSceneViewTagRankingButton);
		this.addChild(buttonRanking);

		var buttonAmago = NASButtonView.buttonWithFile("res/ym_r_index_btn_amago.png", this);
		buttonAmago.setPosition(cc.p(g_YMScreenCenter.x - buttonRanking.getContentSize().width / 2,
									 g_YMScreenCenter.y - buttonRanking.getContentSize().height / 2));
	    buttonAmago.setTouchDownEffectEnable(false);
	    buttonAmago.setTag(YMTitleSceneViewTagAmagoButton);
		this.addChild(buttonAmago);

		var buttonManual = NASButtonView.buttonWithFile("res/ym_r_index_btn_help.png", this);
		// buttonRanking.setPosition(cc.p(g_YMScreenCenter.x - buttonRanking.getContentSize().width / 2 - 95 - 50,
		// 							 g_YMScreenCenter.y - buttonRanking.getContentSize().height / 2 - 40));
		buttonManual.setPosition(cc.p(g_YMScreenCenter.x - buttonManual.getContentSize().width / 2 + 150,
									 g_YMScreenCenter.y - buttonManual.getContentSize().height / 2));
		// buttonRanking.setPosition(cc.p(585,275));
		//585/283
	    buttonManual.setTouchDownEffectEnable(false);
	    buttonManual.setTag(YMTitleSceneViewTagManualButton);
		this.addChild(buttonManual);
		
// add dojo 2014.01.27 vvvv
		// adjust window
		var selfPointer = this;
		this.adjustSizeForWindow();
		window.addEventListener("resize", function (event) {
			selfPointer.adjustSizeForWindow();
		});
// add dojo 2014.01.27 ^^^^


		return true;

	},

// add dojo 2014.01.27 vvvv
	adjustSizeForWindow:function ()
	{
		var xScale = 0.0;
		var yScale = 0.0;
		var query = location.search;
	    if (typeof query !== undefined && query !== "") {
			this.m_bFrame = true;
	        var array = query.split("&");
	        for (var i = 0; i < array.length; i++) {
	            if (array[i].indexOf("w") > -1) {
					xScale = array[i].split("=")[1] / cc.originalCanvasSize.width;
	            }
	            if (array[i].indexOf("h") > -1) {
					yScale = array[i].split("=")[1] / cc.originalCanvasSize.height;
	            }
	        }
	    }

        var margin = document.documentElement.clientWidth - document.body.clientWidth;
        cc.canvas.width = document.documentElement.clientWidth - margin;
        cc.canvas.height = document.documentElement.clientHeight - margin;

		if (xScale == 0)
		{
	        var xScale = cc.canvas.width / cc.originalCanvasSize.width;
	    }
	    if (yScale == 0)
	    {
	        var yScale = cc.canvas.height / cc.originalCanvasSize.height;
	    }

        if (xScale > yScale) {
            xScale = yScale;
        }
        cc.canvas.width = cc.originalCanvasSize.width * xScale;
        cc.canvas.height = cc.originalCanvasSize.height * xScale;
        var parentDiv = document.getElementById("Cocos2dGameContainer");
        if (parentDiv) {
            parentDiv.style.width = cc.canvas.width + "px";
            parentDiv.style.height = cc.canvas.height + "px";
        }

        cc.renderContext.translate(0, cc.canvas.height);
        cc.renderContext.scale(xScale, xScale);
        cc.Director.getInstance().setContentScaleFactor(xScale);
    },
// add dojo 2014.01.27 ^^^^

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var tag = button.getTag();
		if(event == NASButtonViewEventTouchUpInside)
		{
			if (tag == YMTitleSceneViewTagStartButton)
			{

				var scene = new YMGameScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);

			}
			else if(tag == YMTitleSceneViewTagAmagoButton)
			{

				var scene = new YMAmagoGameScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);

			}
			else if(tag == YMTitleSceneViewTagRankingButton)
			{
				var scene = new YMRankingScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);
			}
			else if(tag== YMTitleSceneViewTagManualButton)
			{
				var scene = new YMHelpScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);
			}
		}
	   //  else if (tag == JGTitleSceneButtonMaintenanceReload && event == NASButtonViewEventTouchUpInside)
	   //  {
	   //      var view = this.getChildByTag(tagJGMaintenanceLayer);
	   //      view.runAction(cc.CallFunc.create(this.remove, this));

	   //      var type = button.getUserObject();
	   //      if (type == JGMaintenanceTypeMaintenance)
	   //      {
	   //          this.getMaintenance();
	   //      }
	   //      else if (type == JGMaintenanceTypeEntranceLimit)
	   //      {
    //         	var sLoginKey = JGAPI.getInstance().getKey();
    //         	cc.log("[1-1]loginkey : " + sLoginKey);
				// this.getEntranceLimit(sLoginKey);
	   //      }
	   //  }
	}
});

var YMTitleScene = cc.Scene.extend({
	onEnter:function () {
		this._super();
		var layer = new YMTitleLayer();
		layer.init();
		this.addChild(layer);
	}
});


