"use strict";

//	Initial define
var stdio = new Stdio();

//"System Volume Information"

// initial trigger
window.addEventListener("load", function(event){
	init();
});
function init(){
	stdio.tabList.open();
}

function Stdio(){
	var stdio = this;
	this.sdcard = navigator.getDeviceStorage('sdcard');
	
	this.html = {};
	this.currentDir = ["sdcard"];
	this.allDir = {};
	this.callBack = {};
	
	//	Function
	this.save = function( address, content, callBack = function(){} ){
		var file = new Blob( [ content ], { type: "text/plain" } );
		stdio._delete( address, function(){
			stdio._save( address, file, function(){
				console.log( "[Success] stdio.save;", address, content );
				callBack();
			}, function(){
				console.log( "[Failure] stdio.save;", address, content );
			} );
		} );
	}
	this.read = function( address, callBack ){
		stdio._get( address, function( blob ){
			stdio._read( blob, function( result ){
				console.log( "[Success] stdio.read;", result );
				callBack( result );
			} );
		}, function( result ){
			console.log("[Failure] stdio.read");
		} );
	}
	this.rename = function( from, to, callBack = function(){} ){
		stdio._get( from, function( blob ){
			stdio._save( to, blob, function( blob ){
				stdio._delete( from, function(){
					console.log( "[Success] stdio.rename;"+from+"; to ;"+to );
					callBack();
				} );
			} );
		} );
	};
	this.remove = function( address ){
		stdio._delete( address, function(){
			console.log( "[Success] stdio.remove;" );
		}, function(){
			console.log( "[Failure] stdio.remove;" );
		} );
	}
	//	Internal
	this._get = function( address, callBackS, callBackF = function(){} ){
		var request = stdio.sdcard.getEditable( address );
		request.onsuccess = function () {	callBackS( this.result );	}
		request.onerror = function () {	callBackF( this.error );	}
	};
	this._read = function( blob, callBack ){
		var reader = new FileReader();
		reader.addEventListener( "loadend", function() {
			callBack( reader.result );
		});
		reader.readAsText( blob );
	};
	this._save = function( address, file, callBackS = function(){}, callBackF = function(){} ){
		var request = stdio.sdcard.addNamed( file, address );
		request.onsuccess = function () {	callBackS( this.result );	}
		request.onerror = function () {	callBackF( this.error );	}
	}
	this._delete = function( address, callBackS = function(){}, callBackF = function(){} ){
		var request = stdio.sdcard.delete( address );
		request.onsuccess = function () {	callBackS();	}
		request.onerror = function () {	callBackF( this.error );	}
	}
	// omake
	this.dom = function( keyword ){
		switch( keyword[0] ){
			case "#":console.log( keyword.slice( 1, keyword.length ) );return document.getElementById( keyword.slice( 1, keyword.length ) );
			case ".":return document.getElementsByClassName( keyword.slice( 1, keyword.length ) );
			default :return document.getElementsByTagName( keyword.slice( 0, keyword.length ) );
		}
	}
	this.elm = function( tagName, tagOption, text ){
		var elm;
		elm = document.createElement( tagName );
		if ( tagOption ) {
			tagOption.split(" ").forEach( function( opt ){
				switch( opt[0] ){
					case "#":elm.id = opt.slice( 1, opt.length );break;
					case ".":elm.classList.add( opt.slice( 1, opt.length ) );break;
				}
			} );
		}
		if ( text ) {
			elm.innerHTML = text;
		}
		return elm;
	}
	//	File Manager
	this.fileManager = new function(){
		var fileManager = this;
		this.activated = undefined;
		this.callBack = undefined
		this.currentDir = [""];
		this.unitList = [];
		
		this.html = {};
		this.html["main"] = stdio.elm( "div", "#fileManager" );
		this.html["header"] = stdio.elm( "header", "#fileManagerHeader", "File Manager" );
		this.html["address"] = stdio.elm( "div", "#fileManagerAddress", "/" );
		this.html["menu"] = stdio.elm( "div", "#fileManagerMenu" );
		this.html["body"] = stdio.elm( "div", "#fileManagerBody" );
		this.html["footer"] = stdio.elm( "footer", "#fileManagerFooter" );
		this.html["main"].appendChild( this.html["header"] );
		this.html["main"].appendChild( this.html["address"] );
		this.html["main"].appendChild( this.html["menu"] );
		this.html["main"].appendChild( this.html["body"] );
		this.html["main"].appendChild( this.html["footer"] );
		this.html["cancelButton"] = stdio.elm( "div", "#fileManagerCancel", "×" );
		this.html["cancelButton"].addEventListener( "click", function(){
				fileManager.callBack();
				fileManager.hide();
		} );
		this.html["newButton"] = stdio.elm( "button", "#fileManagerNew", "+File" );
		this.html["newButton"].addEventListener( "click", function(){
			fileManager.new();
		} );
		this.html["newDirButton"] = stdio.elm( "button", "#fileManagerNewDir", "+Dir" );
		this.html["newDirButton"].addEventListener( "click", function(){
			fileManager.newDir();
		} );
		this.html["upButton"] = stdio.elm( "button", "#fileManagerUp", "↑" );
		this.html["upButton"].addEventListener( "click", function(){
			fileManager.up();
		} );
		this.html["renameButton"] = stdio.elm( "button", "#fileManagerRename", "rename" );
		this.html["renameButton"].addEventListener( "click", function(){
			fileManager.rename();
		} );
		this.html["deleteButton"] = stdio.elm( "button", "#fileManagerDelete", "delete" );
		this.html["deleteButton"].addEventListener( "click", function(){
			fileManager.delete();
		} );
		this.html["header"].appendChild( this.html["cancelButton"] );
		this.html["menu"].appendChild( this.html["newButton"] );
		this.html["menu"].appendChild( this.html["newDirButton"] );
		this.html["menu"].appendChild( this.html["upButton"] );
		this.html["menu"].appendChild( this.html["renameButton"] );
		this.html["menu"].appendChild( this.html["deleteButton"] );
		document.getElementsByTagName("body")[0].appendChild( this.html["main"] );
		
		this.show = function(){
			this.html["main"].style.display = "block";
		}
		this.hide = function(){
			this.html["main"].style.display = "none";
		}
		this.up = function(){
			if ( 1 <= this.currentDir.length ){
				this.currentDir = this.currentDir.slice( 0, this.currentDir.length-1 );
				this.select( this.currentDir );
			}
		}
		this.new = function(){
			var name = prompt( "Input name for new file.", ".txt" );
			if ( !name ){	stdio.notify("canceled.");return;	}
			stdio.save( this.currentDir.join("/")+"/"+name, "", function(){
				fileManager.select( fileManager.currentDir );
			} );
			console.log( "saved; "+this.currentDir.join("/")+"/"+name );
			stdio.notify( "saved; "+name );
		}
		this.newDir = function(){
			var name = prompt( "Input name for new directory.", "" );
			if ( !name ){	stdio.notify("canceled.");return;	}
			var dir = fileManager.currentDir.concat( name );
			
			for ( var i in fileManager.unitList ){
				console.log(fileManager.unitList[i].path);
				if ( 0 == fileManager.unitList[i].path.indexOf( dir.join("/") ) ){
						stdio.notify("Already exist.");return;
				}
			}
			console.log( fileManager.currentDir.concat(name).join("/") );
			stdio.notify( "created directory;"+dir );
		}
		this.rename = function(){
			if ( !fileManager.activated ){	alert("select file.");return;	}
			if ( !fileManager.activated.type ){	alert("Its not file.");return;	}
			var name = prompt( "Input filename for rename "+fileManager.activated.name+".", fileManager.activated.name );
			stdio.rename( fileManager.activated.path, fileManager.activated.dir.concat( name ).join("/"), function(){
				fileManager.select( fileManager.currentDir );
			} );
			stdio.notify( "renamed." )
		}
		this.delete = function(){
			if ( !fileManager.activated ){	alert("select file.");return;	}
			if ( -1 != fileManager.activated.dir.indexOf("System Volume Information") ){
				alert("[WARNING!] It is in SYSTEM!");
			}
			if ( -1 != fileManager.activated.dir.indexOf("DCIM") ){
				alert("[WARNING!] It is in SYSTEM!");
			}
			if ( -1 != fileManager.activated.dir.indexOf(".gallery") ){
				alert("[WARNING!] It is in SYSTEM!");
			}
			if ( fileManager.activated.type ){
				if ( !confirm( "Do you want to DELETE " + fileManager.activated.name + "?" ) ){	return;	}
			} else {
				if ( !confirm( "Do you want to DELETE " + fileManager.activated.path+" and ALL FILE in this?" ) ){	return;	}
			}
			stdio.remove( fileManager.activated.path );
			stdio.notify( "deleted; "+fileManager.activated.path );
			this.select( this.currentDir );
		}
		this.open = function( callBack ){
			fileManager.callBack = callBack;
			this.select();
		}
		this.select = function( dir = ["","sdcard"] ){
			//	Initial
			var validDir = [];
			fileManager.activated = undefined;
			this.currentDir = dir || this.currentDir;
			console.log( fileManager.html["address"] );
			fileManager.html["address"].innerHTML = fileManager.currentDir.join("/");
			this.html["body"].innerHTML = "";
			this.html["footer"].innerHTML = "";
			this.show();
			fileManager.html["main"].style.display = "block";
			
			this.searchAll( function(){
				console.log( "All Files;", fileManager.unitList );
				fileManager.unitList.forEach( function( unit ){
					if ( dir.slice( 0 ).toString != unit.dir.slice( 0, dir.length ).toString ) {	return;	}
					if ( dir.length == unit.dir.length ) {
						fileManager.html["body"].appendChild( unit.html["main"] );
					} else if ( dir.length < unit.dir.length ) {
						if( -1 != validDir.indexOf( unit.dir[dir.length] ) ){	return;	}
						validDir.push( unit.dir[dir.length] );
					}
				} );
				console.log( "Searched Directory;", validDir );
				validDir.forEach( function( currentDir ){
					var object = new fileManager.Dir( dir.concat( currentDir ) );
					fileManager.html["body"].appendChild( object.html["main"] );
				} );
			} );
		};
		this.searchAll = function( callBack ){
			var cursor = stdio.sdcard.enumerateEditable();
			fileManager.unitList = [];
			cursor.onsuccess = function () {
				if( !this.result ){	callBack();return;	}
				fileManager.unitList.push( new fileManager.File( this.result ) );
				if ( !this.done ) {		this.continue();	}else{	console.log( "finished" );	}
			}
		};
		// FileManager.File
		this.File = function( blob ){
			var file = this;this.unit = this;
			console.log( blob );
			this.blob = blob;
			this.type = blob.type;//	"text/plain" "image/jpeg"
			this.size = blob.size;
			this.path = blob.name;
			this.path2 = [];
			this.path2 = this.path.split( "/" );
			this.name = this.path2[this.path2.length-1];
			this.dir = this.path2.slice( 0, this.path2.length-1 );
			
			this.html = {};
			this.init( this.name, function(){
				fileManager.callBack( file.blob );
				fileManager.hide();
			} );
			this.html["main"].classList.add("file");
		}
		// FileManager.Dir
		this.Dir = function( directory ){
			var dir = this;this.unit = this;
			this.html = {};
			this.path = directory.join("/");
			this.dir = directory;
			this.init(
				directory[directory.length-1],
				function(){	fileManager.select( directory );
			} );
			this.html["main"].classList.add("directory");
		};
		this.File.prototype = this.Dir.prototype = {
			unit:undefined,
			callBack:function(){},
			init:function( name, callBack ){
				var unit = this;
				this.callBack = callBack;
				this.html["main"] = document.createElement("div");
				this.html["main"].classList.add("unit");
				this.html["main"].innerHTML = name;
				this.html["main"].addEventListener( "click", function(){	unit.activate();	} );
			},
			activate:function(){
				var unit = this;
				if ( fileManager.activated != unit ){
					if ( fileManager.activated ){
						fileManager.activated.html["main"].classList.remove("activated");
					}
					fileManager.activated = unit;
					fileManager.activated.html["main"].classList.add("activated");
					if ( unit.blob ){
						fileManager.html["footer"].innerHTML = [unit.blob.name,"size:"+unit.blob.size,"Path;"+unit.blob.name].join("<br>");
					} else {
						fileManager.html["footer"].innerHTML = unit.path;
					}
					console.log( "activated;", unit );
				} else {
					unit.callBack();
				}
			}
		};

	};
	//	Notify
	this.html["notify"] = stdio.elm( "div", "#notify" );
	document.getElementsByTagName("body")[0].appendChild( this.html["notify"] );
	
	this.notify = function( mes ){
		var notify = this;
		var html = stdio.elm( "div", ".notify", mes );
		stdio.html["notify"].appendChild( html );
		// destruct
		window.setTimeout( function(){
			stdio.html["notify"].removeChild( html );
			html = undefined;
		}, 5000 );
	}
	
	//	Tab
	this.tabList = new function(){
		var tabList = this;
		this.list = [];
		this.activated = undefined;
		this.html = {};
		this.html["main"] = stdio.elm( "div", "#tabBox" );
			this.html["mainNav"] = stdio.elm( "nav", "#tabNav" );
				this.html["openTab"] = stdio.elm( "button", "#openTab", "FileManager" );
				this.html["openTab"].addEventListener( "click", function(){	tabList.open();	} );
				this.html["saveTab"] = stdio.elm( "button", "#saveTab", "SaveAll" );
				this.html["saveTab"].addEventListener( "click", function(){	tabList.save();	} );
				this.html["cancel"] = stdio.elm( "button", "#cancelTab", "×" );
				this.html["cancel"].addEventListener( "click", function(){	tabList.hide();	} );
				this.html["mainNav"].appendChild( this.html["openTab"] );
				this.html["mainNav"].appendChild( this.html["saveTab"] );
				this.html["mainNav"].appendChild( this.html["cancel"] );
			this.html["bottomNav"] = stdio.elm( "nav", "#bottomTabNav","bottom" );

			this.html["list"] = stdio.elm( "div", "#tabList" );
			this.html["main"].appendChild( this.html["mainNav"] );
			this.html["main"].appendChild( this.html["list"] );
		document.getElementsByTagName("body")[0].appendChild( this.html["main"] );

		this.html["subNav"] = stdio.dom("tabnav")[0];
			this.html["selected"] = stdio.elm( "input", "#tabSelected", "not selected" );
			this.html["selected"].setAttribute("readonly", "readonly" );
			this.html["openList"] = stdio.elm( "button", "#tabOpen", "0" );
			this.html["openList"].addEventListener( "click", function(){	tabList.show();	} );
		this.html["subNav"].appendChild( this.html["selected"] );
		this.html["subNav"].appendChild( this.html["openList"] );

		this.html["content"] = stdio.dom("#tabContent");
		this.html["content"].value = "";
		this.html["content"].addEventListener( "change", function(){
			tabList.update();
		} );

		// Public Function
		this.show = function( tab ){
			tabList.html["main"].style.display = "block";
		}
		this.hide = function(){
			if ( !tabList.list ){	self.list = [];	}
			tabList.html["openList"].innerHTML = tabList.list.length;
			tabList.html["main"].style.display = "none";
		}

		// Internal Function
		this.open = function(){
			tabList.hide();
			stdio.fileManager.open( function( file ){
				tabList.show();
				//	Assertion
				if ( !file ){	return;	}
				//	duplication check
				for ( var i in tabList.list ){
					if ( file.name == tabList.list[i].address ){
						stdio.notify("Already opened;", file.name );
						return;
					}
				}
				var tab = new Tab( file.name );
				tabList.list.push( tab );
				tabList.html["list"].appendChild( tab.html["main"] );

				stdio.notify( 'opened; "' + file.name + '"' );
			} );
			return;
		};
		this.save = function(){
			if( !tabList.list ){	alert("Nothing to save!");return;	}

			tabList.list.forEach( function( tab ){
				tab.save();
			} );
			stdio.notify( "All files is saved." );
			return;
		}

		//	Reactive Function
		this.update = function(){
			if( !tabList.activated ){	return;	}
			tabList.activated.content = tabList.html["content"].value;
			console.log( tabList.html["content"].value );
		}
		this.focus = function( tab ){
			console.log("tabList.focus");
			if( tabList.activated != tab ){
				if( tabList.activated ){
					tabList.activated.html["main"].classList.remove( "activated" );
				}
				tabList.activated = tab;
				tabList.activated.html["main"].classList.add( "activated" );
				tabList.html["selected"].value = tab.address;

			} else {
				tabList.html["selected"].value = tab.address;
				tabList.html["content"].value = tab.content;
				tabList.hide();

			}
		}
		this.close = function( tab ){
			tabList.html["list"].removeChild( tab.html["main"] );
			tabList.list.forEach( function( t, i ){
				if( t == tab ){
					delete tabList.list[i];
					t = undefined;
				}
			} );
			if( !tabList.list ){	tabList.list = [];	}

			console.log( "The file closed." );
			stdio.notify( "The file closed." );
		}

		// Tab Class
		var Tab = function( address ){
			var tab = this;
			
			this.address = address || "";
			this.content = "";
			if ( address ){
				stdio.read( address, function( result ){
					tab.content = result;
				} );
			}
			// Initial
			this.html = {};
			this.html["open"] = stdio.elm( "button", ".title", this.address );
			this.html["open"].addEventListener( "click", function(){	tabList.focus( tab );	} );
			this.html["close"] = stdio.elm( "button", ".close", "×" );
			this.html["close"].addEventListener( "click", function(){	tabList.close( tab );	} );
			this.html["main"] = stdio.elm( "tab" );
			this.html["main"].appendChild( this.html["open"] );
			this.html["main"].appendChild( this.html["close"] );
		};
		Tab.prototype = {
			save:function(){
				stdio.save( this.address, this.content );
			}
		};
	};
}
/*Stdio.prototype = {
	dom:function( keyword ){
		switch( keyword[0] ){
			case "#":return document.getElementById( keyword.slice( 1, keyword.length ) );
			case ".":return Document.getElementsByClassName( keyword.slice( 1, keyword.length ) );
			default :return document.getElementsByTagName( keyword.slice( 0, keyword.length ) );
		}
	},
	elm:function( tagName, tagOption, text ){
		var elm;
		elm = document.createElement( tagName );
		if ( tagOption ) {
			tagOption.split(" ").forEach( function( opt ){
				switch( opt[0] ){
					case "#":elm.id = opt.slice( 1, opt.length );break;
					case ".":elm.classList.add( opt.slice( 1, opt.length ) );break;
				}
			} );
		}
		if ( text ) {
			elm.innerHTML = text;
		}
		return elm;
	}
};*/
