﻿/// <reference path="Jyo-min0.1.js" />
var game;

window.onload = function () {
    //Jyo.init("scripts/Jyo.js", function () {

    //new iScroll('paihangFrame', { hScrollbar: false, vScrollbar: false });

    // 实例化一个游戏对象
    game = new Jyo.Game("game", "Canvas");

    // 运行游戏
    game.run(24);

    // 设置资源根目录
    game.content.rootDirectory = "content";

    // 设置画布为同比缩放模式
    game.renderer.enableAutoSize("ratio");

    // 加载游戏屏幕
    Jyo.importScript("scripts/status/playing.js");

    //Jyo.importScript("scripts/status/ranklist.js");
    //});
};

// 微信分享的数据  
var wxData = {
    appId: "", // 服务号可以填写appId  
    imgUrl: "http://bcs.duapp.com/teastudio/face.jpg",
    link: "http://game.hdc.h5stars.com/201411453d4e9d59172f~",
    desc: "经典中国龙-源自中国最难的消除类游戏。你行你来，No zuo no die！",
    title: "传统的玩法不一样的新意,国粹对对碰!"
};

WeixinApi.ready(function (Api) {

    // 分享的回调  
    var wxCallbacks = {
        // 分享操作开始之前  
        ready: function () {
            // 你可以在这里对分享的数据进行重组  
            hiddenMe();
            game.isPause = true;
            pauseGame();
        },
        // 分享被用户自动取消  
        cancel: function (resp) {
            // 你可以在你的页面上给用户一个小Tip，为什么要取消呢？  
            game.isPause = false;
            continueGame();
            location.reload();
        },
        // 分享失败了  
        fail: function (resp) {
            // 分享失败了，是不是可以告诉用户：不要紧，可能是网络问题，一会儿再试试？  
            game.isPause = false;
            continueGame();
            location.reload();
        },
        // 分享成功  
        confirm: function (resp) {
            // 分享成功了，我们是不是可以做一些分享统计呢？  
            game.isPause = false;
            continueGame();
            location.reload();
        },
        // 整个分享过程结束  
        all: function (resp) {
            // 如果你做的是一个鼓励用户进行分享的产品，在这里是不是可以给用户一些反馈了？  
            game.isPause = false;
            location.reload();
        }
    };

    // 用户点开右上角popup菜单后，点击分享给好友，会执行下面这个代码  
    Api.shareToFriend(wxData, wxCallbacks);

    // 点击分享到朋友圈，会执行下面这个代码  
    Api.shareToTimeline(wxData, wxCallbacks);

    // 点击分享到腾讯微博，会执行下面这个代码  
    Api.shareToWeibo(wxData, wxCallbacks);

    document.querySelector(".btnShare").style.display = "block";
    canShare = true;
});

var isShareing = false;

function share(m, n) {
    if (m == 0) {
        wxData.desc = "经典中国龙-源自中国最难的消除类游戏。你行你来，No zuo no die！"
    }
    if (m == 1) {
        var time = n.split(":");
        time[0] = parseInt(time[0]);
        time[1] = parseInt(time[1]);
        wxData.desc = "啊哈！我花了" + time[0] + "分" + time[1] + "秒消除了所有牌，我不信你比我快？"
    }
    if (m == 2) {
        wxData.desc = "我走投无路了，你确定你行？"
    }

    pauseGame();
    document.getElementById("pauseScreen").style.display = "none";
    isShareing = true;
    window.setTimeout(hiddenMe, 5000);
}

function hiddenMe() {
    if (!isShareing) return;
    isShareing = false;
    wxData.desc = "经典中国龙-源自中国最难的消除类游戏。你行你来，No zuo no die！"
    continueGame();
}

var canShare = false;