﻿/// <reference path="../Jyo-min0.1.js" />
void function again() {
    game.exit();

    var content = game.content,
        renderer = game.renderer,
        touch = game.touch,
        mouse = game.mouse;

    var status1 = new Jyo.Status();

    // 顶边栏
    var topBar = new Jyo.Texture();

    // 头像
    var face = new Jyo.Texture();

    // 选择效果
    var selectEffect = new Jyo.Texture();

    // 赢了的界面
    var win = new Jyo.Texture();

    // 输了的界面
    var lost = new Jyo.Texture();

    // 系统按钮
    var btns1 = new Jyo.Texture();

    // 游戏按钮
    var btns2 = new Jyo.Texture();

    // 微信分享提示
    var arron = new Jyo.Texture();

    // 再来一局按钮矩形
    var rectWinRetry = new Jyo.Rectangle(200, 630, 236, 78);
    var rectLostRetry = new Jyo.Rectangle(200, 482, 236, 78);

    var rectWinShare = new Jyo.Rectangle(200, 730, 236, 78);
    var rectLostShare = new Jyo.Rectangle(200, 570, 236, 78);

    // 暂停按钮矩形
    var rectPause = new Jyo.Rectangle(554, 180, 67, 67);

    // 提示按钮矩形
    var rectTips = new Jyo.Rectangle(554, 750, 67, 67);

    // 洗牌按钮矩形
    var rectShuffle = new Jyo.Rectangle(554, 850, 67, 67);

    // 排列
    var stone = [];

    // 层级
    var levels = [36, 16, 4];

    // 元素尺寸
    var elementSize = { width: 85, height: 114 };

    // 元素列表
    var elements = [];

    // 提示元素
    var tipsElement1,
        tipsElement2;

    // 元素图像
    var elImages = {};

    // 开始游戏时间
    var beginTime = 0;

    // 时间字符串
    var timeStr = "";

    // 是否赢了
    var isWin = false;

    // 是否输了
    var isLost = false;

    // 是否暂停
    var isPause = false;

    // 暂停游戏开始时间
    var pauseBeginTime = 0;

    // 暂停所用的时间
    var pauseTime = 0;

    // 已消除牌数
    var clearNum = 0;

    // 当前选中的元素
    var selectElement = null;

    // 道具
    var props = {
        tips: 3,
        shuffle: 1
    }

    status1.load = function () {
        // 加载顶边栏
        content.load(topBar, "images/topBar.png");

        // 加载头像
        content.load(face, "images/face.jpg");

        // 加载选择效果
        content.load(selectEffect, "images/mahjong/mahjongClick.png");

        // 加载赢了的界面
        content.load(win, "images/win.png");

        // 加载输了的界面
        content.load(lost, "images/lost.png");

        // 加载系统按钮
        content.load(btns1, "images/btns1.png");

        // 加载游戏按钮
        content.load(btns2, "images/btns2.png");

        // 加载微信分享提示
        content.load(arron, "images/arron.png");

        touch.ontouchstart = function (list) {
        };

        touch.ontouchend = function (list) {
            /// <summary>触摸结束事件处理函数</summary>
            /// <param name="list" type="Array">触摸列表</param>

            tipsElement1 = tipsElement2 = null;

            for (var i = 0; i < list.length; i++) {
                if (isShareing) return;

                if (isPause) {
                    if (rectPause.intersects(list[i].x, list[i].y, 1, 1)) {
                        // 继续按钮
                        continueGame();
                    }
                    return;
                }

                if (isWin) {
                    if (rectWinRetry.intersects(list[i].x, list[i].y, 1, 1)) {
                        again();
                        //Jyo.importScript("scripts/status/playing.js");
                    }

                    if (canShare && rectWinShare.intersects(list[i].x, list[i].y, 1, 1)) {
                        share(1, timeStr);
                    }

                    continue;
                }

                if (isLost) {
                    if (rectLostRetry.intersects(list[i].x, list[i].y, 1, 1)) {
                        again();
                        Jyo.importScript("scripts/status/playing.js");
                    }

                    if (canShare && rectLostShare.intersects(list[i].x, list[i].y, 1, 1)) {
                        share(2);
                    }
                    continue;
                }

                if (rectPause.intersects(list[i].x, list[i].y, 1, 1)) {
                    // 暂停按钮

                    pauseGame();
                    return;
                }

                if (rectShuffle.intersects(list[i].x, list[i].y, 1, 1)) {
                    // 洗牌按钮

                    if (props.shuffle == 0) {
                        return;
                    }

                    props.shuffle--;

                    var els = [];
                    for (var i = 0; i < elements.length; i++) {
                        !elements[i].isClear && els.push(elements[i]);
                    }
                    els = function (els) {
                        for (var i = els.length - 1; i > 0; i--) {
                            var j = Math.floor(Math.random() * (i + 1));
                            var temp = els[i].value;
                            els[i].value = els[j].value;
                            els[j].value = temp;
                        }
                        return this;
                    }(els);
                    for (var n = 0; n < elements.length; n++) {
                        for (var i = 0; i < els.length; i++) {
                            if (elements[n].x == els[i].x && elements[n].y == els[i].y) {
                                elements[n].value == els[i].value;
                            }
                        }
                    }
                    selectElement = null;
                    return;
                }

                if (rectTips.intersects(list[i].x, list[i].y, 1, 1)) {
                    // 提示按钮

                    if (props.tips == 0) {
                        return;
                    }

                    props.tips--;

                    tips();
                    return;
                }

                for (var n = elements.length; n--;) {
                    if (!elements[n].isClear && elements[n].rect.intersects(list[i].x, list[i].y, 1, 1)) {
                        var el = elements[n];
                        var els = getElements(el.x, el.y);

                        if (!els.length) continue;

                        var oldSelect = selectElement;

                        var leftEls = getElements(el.x - 1, el.y),
                            rightEls = getElements(el.x + 1, el.y);
                        if (leftEls.length == 0 ||
                            leftEls[0].level > els[0].level ||
                            rightEls.length == 0 ||
                            rightEls[0].level > els[0].level) {
                            selectElement = els[0];
                        }

                        if (selectElement == oldSelect) {
                            // 点击了无法点击的元素则取消点击状态

                            selectElement = null;
                        } else if (oldSelect && selectElement && oldSelect.value == selectElement.value) {
                            // 可以消除

                            oldSelect.isClear = selectElement.isClear = true;
                            selectElement = null;
                            clearNum += 2;

                            if (elements.length == clearNum) {
                                isWin = true;
                                break;
                            } else if (elements.length - clearNum == 2) {
                                for (var m = 0; m < elements.length; m++) {
                                    if (!elements[m].isClear) {
                                        if (getElements(elements[m].x, elements[m].y).length == 2) {
                                            isLost = true;
                                        }
                                        break;
                                    }
                                }
                            } else if (!tips(true) && props.shuffle == 0) {
                                isLost = true;
                            }
                        }

                        return;
                    }
                }
            }
        };

        document.querySelector(".btnAgain").addEventListener("mouseup", again);

        initGame();

        game.run(24);
    };

    status1.update = function () {

        if (mouse.leftButton) {
            mouse.click = true;
        } else if (mouse.click) {
            touch.ontouchend([mouse]);
            mouse.click = false;
        }

        if (isWin || isLost || isPause || isShareing) return;

        var time = (((Date.now() - beginTime) / 1000) | 0) - pauseTime,
            m = (time / 60) | 0,
            s = time % 60;

        if (m < 10) m = "0" + m;
        if (s < 10) s = "0" + s;
        timeStr = m + ":" + s;
        if (m > 99) isLost = true;
    };

    status1.draw = function (gameTime) {
        renderer.clear();

        renderer.begin();

        // 绘制游戏背景框
        renderer.fillRect(19, 254, 512, 690, "#ac6a5e");
        renderer.drawRect(19, 254, 512, 690, "#21120f", 5);

        // 绘制UI
        renderer.drawImage(topBar, 0, 0);
        renderer.drawImage(face, 90, 23, 106, 107);
        renderer.drawText("游客", 390, 60, "#ffffff", "Bold 42px SimHei");
        renderer.drawText(timeStr, 65, 196, "#ffffff", "Bold 36px SimHei");
        renderer.drawRect(0, 0, 640, 960, "#2c1c14", 10);

        if (!isPause && !isShareing) {
            for (var i = 0; i < elements.length; i++) {
                // 循环绘制元素

                if (elements[i].isClear) continue;

                renderer.drawImage(elImages[elements[i].value], elements[i].rect);
                if (selectElement == elements[i] || elements[i] == tipsElement1 || elements[i] == tipsElement2) {
                    renderer.drawImage(selectEffect, elements[i].rect);
                }
            }

            // 绘制暂停按钮
            renderer.drawImage(btns1,
                               rectPause.x, rectPause.y, rectPause.width, rectPause.height,
                               0, 0, 67, 67);

            // 绘制洗牌道具按钮
            renderer.drawImage(btns1,
                               rectShuffle.x, rectShuffle.y, rectShuffle.width, rectShuffle.height,
                               props.shuffle == 0 ? 67 : 0, 218, 67, 67);

            renderer.fillRoundRect(rectShuffle.x + 45, rectShuffle.y - 10, 30, 30, 19, props.shuffle == 0 ? "#222" : "#255218");
            renderer.drawRoundRect(rectShuffle.x + 45, rectShuffle.y - 10, 30, 30, 19, "#fff", 3);
            renderer.drawText(props.shuffle.toString(), rectShuffle.x + 54, rectShuffle.y - 8, "#fff", "20px 微软雅黑");

            // 绘制提示道具按钮
            renderer.drawImage(btns1,
                               rectTips.x, rectTips.y, rectTips.width, rectTips.height,
                               props.tips == 0 ? 67 : 0, 144, 67, 67);

            renderer.fillRoundRect(rectTips.x + 45, rectTips.y - 10, 30, 30, 19, props.tips == 0 ? "#222" : "#255218");
            renderer.drawRoundRect(rectTips.x + 45, rectTips.y - 10, 30, 30, 19, "#fff", 3);
            renderer.drawText(props.tips.toString(), rectTips.x + 54, rectTips.y - 8, "#fff", "20px 微软雅黑");
        }

        if (isWin || isLost) {
            // 绘制蒙板
            renderer.fillRect(0, 0, 640, 960, "rgba(0,0,0,0.5)");

            if (isWin) {
                renderer.drawImage(win, 105, 350, 429, 328);
                renderer.drawText(timeStr, 250, 520, "#ffaa00", "Bold 54px SimHei");
                renderer.drawImage(btns2,
                                   rectWinRetry.x, rectWinRetry.y, rectWinRetry.width, rectWinRetry.height,
                                   0, 0, 236, 78);
                canShare && renderer.drawImage(btns2,
                                   rectWinShare.x, rectWinShare.y, rectWinShare.width, rectWinShare.height,
                                   0, 175, 236, 78);
            }

            if (isLost) {
                renderer.drawImage(lost, 165, 400, 306, 82);
                renderer.drawImage(btns2,
                                   rectLostRetry.x, rectLostRetry.y, rectLostRetry.width, rectLostRetry.height,
                                   0, 0, 236, 78);
                canShare && renderer.drawImage(btns2,
                                   rectLostShare.x, rectLostShare.y, rectLostShare.width, rectLostShare.height,
                                   0, 175, 236, 78);
            }
        }

        if (isPause) {
            renderer.fillRect(0, 0, 640, 960, "rgba(0,0,0,0.5)");
        }

        if (isShareing) {
            renderer.fillRect(0, 0, 640, 960, "rgba(0,0,0,0.5)");
            renderer.drawText("     请点击右上角\t\n\r\n" +
                              " 点击【分享到朋友圈】\t\n\r\n" +
                              "告诉他们，中国有句古话：\t\n\r\n" +
                              "    No zuo no die,\t\n\r\n" +
                              "   You can you try!", 100, 280, "#fff", "30px 黑体");
            renderer.drawImage(arron, 640 - arron.width, 0);
        }

        renderer.end();
    };

    status1.unload = function () {
        topBar.destroy();
        face.destroy();
        selectEffect.destroy();
        win.destroy();
        lost.destroy();
        btns1.destroy();
        btns2.destroy();
        arron.destroy();
        document.querySelector(".btnAgain").removeEventListener("mouseup", again);
    };

    game.useStatus(status1);

    function initGame() {
        /// <summary>初始化游戏</summary>

        // 所使用到的牌列表
        stone = "112233445566778899ddbbnnxx112233445566778899ddbbnnxx1122".split('').shuffle();
        var k = 0;
        for (var i = 0; i < levels.length; i++) {
            for (var n = 0; n < levels[i]; n++) {
                var obj = {
                    y: ((n / Math.sqrt(levels[i])) | 0) + i,
                    x: (n % Math.sqrt(levels[i])) + i,
                    value: stone[k],
                    level: 3 - i,
                    isClear: false
                };

                if (!elImages[stone[k]]) {
                    elImages[stone[k]] = new Jyo.Texture();
                    content.load(elImages[stone[k]], "images/mahjong/" + stone[k] + ".png");
                }

                obj.rect = new Jyo.Rectangle(38 + obj.x * elementSize.width - obj.x * 7 + (3 - obj.level) * -10,
                                             280 + obj.y * elementSize.height - obj.y * 9 + (3 - obj.level) * -13,
                                             elementSize.width,
                                             elementSize.height);

                elements.push(obj);
                k++;
            }
        }

        beginTime = Date.now();
    }

    function getElements(x, y) {
        /// <summary>获取元素列表</summary>
        /// <param name="x" type="Number">X坐标</param>
        /// <param name="y" type="Number">Y坐标</param>

        var list = [];
        for (var i = 0; i < elements.length; i++) {
            if (elements[i].x === x && elements[i].y === y && !elements[i].isClear) {
                list.push(elements[i]);
            }
        }

        list.sort(function (a, b) {
            if (a.level < b.level) return -1;
            else if (a.level > b.level) return 1;
            else return 0;
        });

        return list;
    }

    function tips(isReturn) {
        /// <summary>提示可消除的牌</summary>

        var elementList = null,
            elementList1 = null;

        var leftEls = null,
            rightEls = null;

        for (var y = 0; y < 6; y++) {
            for (var x = 0; x < 6; x++) {
                elementList = getElements(x, y);
                if (elementList.length == 0) continue;

                leftEls = getElements(elementList[0].x - 1, elementList[0].y),
                rightEls = getElements(elementList[0].x + 1, elementList[0].y);
                if (!(leftEls.length == 0 ||
                    leftEls[0].level > elementList[0].level ||
                    rightEls.length == 0 ||
                    rightEls[0].level > elementList[0].level)) {
                    continue;
                }

                for (var ny = 0; ny < 6; ny++) {
                    for (var nx = 0; nx < 6; nx++) {
                        elementList1 = getElements(nx, ny);
                        if (elementList1.length == 0 || elementList1[0] == elementList[0]) continue;

                        leftEls = getElements(elementList1[0].x - 1, elementList1[0].y),
                        rightEls = getElements(elementList1[0].x + 1, elementList1[0].y);
                        if (!(leftEls.length == 0 ||
                            leftEls[0].level > elementList1[0].level ||
                            rightEls.length == 0 ||
                            rightEls[0].level > elementList1[0].level)) {
                            continue;
                        }

                        if (elementList[0].value == elementList1[0].value) {
                            if (isReturn) {
                                return {
                                    element1: elementList[0],
                                    element2: elementList1[0]
                                }
                            } else {
                                tipsElement1 = elementList[0];
                                tipsElement2 = elementList1[0];
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    function pauseGame(e) {
        /// <summary>暂停游戏</summary>

        pauseBeginTime = Date.now();
        isPause = true;
        document.getElementById("pauseScreen").style.display = "block";
    }
    window.pauseGame = pauseGame;

    function continueGame(e) {
        /// <summary>继续游戏</summary>

        pauseTime += ((Date.now() - pauseBeginTime) / 1000) | 0;
        isPause = false;
        document.getElementById("pauseScreen").style.display = "none";
    }
    window.continueGame = continueGame;

    function againGame(e) {
        /// <summary>重新开始游戏</summary>

        setTimeout(function () {
            document.getElementById("pauseScreen").style.display = "none";
            again();
            //Jyo.importScript("scripts/status/playing.js");
        }, 100);
    }
    window.againGame = againGame;
}();