var _PAGE_TRANSITION = 'none',
    _KEYWORD = '',
    _TYPE = '',
    _PID = '',
    _CID = '',
    _QUERY_RESULT = [],
    _COMPANYS = {},
    _ORIGINAL_QUERY_RESULT = [],
    _ROW_INDEX = 0,
    _PAGE_SIZE = 10;

var playSoundAndVibration = function(pageid){
	var oggUrl = 'data/scream5.ogg';
	if(pageid === 'index'){
		oggUrl = 'data/scream5.ogg';
	}else if(pageid === 'tag'){
		oggUrl = 'data/scream4.ogg';
	}else if(pageid === 'about'){
		oggUrl = 'data/scream3.ogg';
	}
	var mySound = new Audio(oggUrl);
	mySound.play();
	window.navigator.vibrate(500);
};

var changePage = function(pageid){
	playSoundAndVibration(pageid);
	$.mobile.changePage('#'+pageid, {
		transition: _PAGE_TRANSITION
	});
};

var setupQuery = function(){
	var keyword = $('#keyword').val(),
	    type = $('#productType option:selected').val();
	_KEYWORD= keyword;
	_TYPE = type;
	$.mobile.changePage('#resultList', {
		transition: _PAGE_TRANSITION
	});
};

var getMoreResult = function(rowindex){
	var result = [];
	if(rowindex > (_QUERY_RESULT.length - 1)){
		return result;
	}
	for(var i = 0;i < _PAGE_SIZE;i++){
		if((rowindex + i) <= (_QUERY_RESULT.length - 1)){
			result.push(_QUERY_RESULT[rowindex + i]);
		}else{
			_ROW_INDEX = _QUERY_RESULT.length;
			return result;
		}
	}
	_ROW_INDEX = _ROW_INDEX + _PAGE_SIZE;
	return result;
};

var generateListItem = function(obj){
	var name = obj.name,
		company = obj.companyName,
		code = obj.code;
	return '<li><a href="#" onclick="javascript: toItemDetail(\'' + obj.id + '\')"><h3 class="ui-li-heading">' + name + '</h3><p class="ui-li-desc"><strong>' + company + '</strong></p><p class="ui-li-desc">產品編號：' + code + '</p></a></li>';
};

var toCompanyDetail = function(cid){
	_CID = cid;
	$.mobile.changePage('#companyDetail', {
		transition: _PAGE_TRANSITION
	});
};

var toItemDetail = function(pid){
	_PID = pid;
	$.mobile.changePage('#resultItem', {
		transition: _PAGE_TRANSITION
	});
};

var getNextPageItems = function(){
	$.mobile.loading('show');
	var page = getMoreResult(_ROW_INDEX);
	for(var i = 0;i < page.length;i++){
		$(generateListItem(page[i])).insertBefore('.last-row');
	}
	$('#itemList').listview('refresh');
	$.mobile.loading('hide');
};

var createTypeList = function(types){
	$('#typeList').empty();
	$('#typeList').append('<li data-role="list-divider">類別</li>');
	if(_TYPE === ''){
		var typeMap = {};
		$.each(_QUERY_RESULT, function(index, obj){
			if(typeof typeMap[obj.type] === 'undefined'){
				typeMap[obj.type] = {
					value: obj.type,
					name: types[obj.type].name
				};
			}
		});
		$('#typeList').append('<li id="tListItem" class="t-list-check" data-icon="check"><a href="#" onclick="javascript: filterResultByType(\'\');"><h3 class="ui-li-heading">全部</h3></a></li>');
		$.each(typeMap, function(key, obj){
			var type = obj.value,
				name = obj.name;
			$('#typeList').append('<li id="tListItem' + obj.value + '" data-icon="false"><a href="#" onclick="javascript: filterResultByType(\'' + obj.value + '\');"><h3 class="ui-li-heading">' + name + '</h3></a></li>');
		});
	}else{
		var type = types[_TYPE].value,
			name = types[_TYPE].name;
		$('#typeList').append('<li id="tListItem' + types[_TYPE].value + '" data-icon="check"><a href="#" onclick="javascript: filterResultByType(\'' + types[_TYPE].value + '\');"><h3 class="ui-li-heading">' + name + '</h3></a></li>');
	}
	$('#typeList').listview('refresh');
	$('#typePanel').trigger('updatelayout');
};

var createCompanyList = function(){
	$('#companyList').empty();
	var companyMap = {};
	$.each(_QUERY_RESULT, function(index, obj){
		if(typeof companyMap[obj.cid] === 'undefined'){
			companyMap[obj.cid] = {
				value: obj.cid,
				name: obj.companyName
			};
		}
	});
	$('#companyList').append('<li data-role="list-divider">廠商</li>');
	$('#companyList').append('<li id="cListItem" class="c-list-check" data-icon="check"><a href="#" onclick="javascript: filterResultByCompany(\'\');"><h3 class="ui-li-heading">全部</h3></a></li>');
	$.each(companyMap, function(key, obj){
		var type = obj.value,
			name = obj.name;
		$('#companyList').append('<li id="cListItem' + obj.value + '" data-icon="false"><a href="#" onclick="javascript: filterResultByCompany(\'' + obj.value + '\');"><h3 class="ui-li-heading">' + name + '</h3></a></li>');
	});
	$('#companyList').listview('refresh');
	$('#companyPanel').trigger('updatelayout');
};

var filterResultByCompany = function(cid){
	$('.c-list-check').attr('data-icon','false').removeClass('c-list-check').children('.ui-btn-inner.ui-li').eq(0).children('span').eq(0).remove();
	if(cid === ''){
		$('#cListItem').attr('data-icon', 'check').addClass('c-list-check').children('.ui-btn-inner.ui-li').eq(0).append('<span class="ui-icon ui-icon-check ui-icon-shadow"></span>');
	}else{
		$('#cListItem' + cid).attr('data-icon', 'check').addClass('c-list-check').children('.ui-btn-inner.ui-li').eq(0).append('<span class="ui-icon ui-icon-check ui-icon-shadow"></span>');
	}
	$.mobile.loading('show');
	$('#itemList').empty();
	_ROW_INDEX = 0;
	_QUERY_RESULT = [];
	$.each(_ORIGINAL_QUERY_RESULT, function(index, obj){
		if(cid === '' || obj.cid === cid){
			_QUERY_RESULT.push(obj);
		}
	});
	var page = getMoreResult(_ROW_INDEX);
	if(page.length !== 0){
		$('#itemList').append('<li class="last-row" data-icon="false"><a href="#" onclick="javascript: getNextPageItems();"><h3 class="ui-li-heading">載入更多資料...</h3></a></li>');
		for(var i = 0;i < page.length;i++){
			$(generateListItem(page[i])).insertBefore('.last-row');
		}
	}else{
		$('#itemList').append('<li>查無資料</li>');
	}
	$('#itemList').listview('refresh');
	$('#companyPanel').panel('close');
	$.mobile.loading('hide');
};

var filterResultByType = function(tid){
	$('.t-list-check').attr('data-icon','false').removeClass('t-list-check').children('.ui-btn-inner.ui-li').eq(0).children('span').eq(0).remove();
	if(tid === ''){
		$('#tListItem').attr('data-icon', 'check').addClass('t-list-check').children('.ui-btn-inner.ui-li').eq(0).append('<span class="ui-icon ui-icon-check ui-icon-shadow"></span>');
	}else{
		$('#tListItem' + tid).attr('data-icon', 'check').addClass('t-list-check').children('.ui-btn-inner.ui-li').eq(0).append('<span class="ui-icon ui-icon-check ui-icon-shadow"></span>');
	}
	$.mobile.loading('show');
	$('#itemList').empty();
	_ROW_INDEX = 0;
	_QUERY_RESULT = [];
	$.each(_ORIGINAL_QUERY_RESULT, function(index, obj){
		if(tid === '' || obj.type === tid){
			_QUERY_RESULT.push(obj);
		}
	});
	var page = getMoreResult(_ROW_INDEX);
	if(page.length !== 0){
		$('#itemList').append('<li class="last-row" data-icon="false"><a href="#" onclick="javascript: getNextPageItems();"><h3 class="ui-li-heading">載入更多資料...</h3></a></li>');
		for(var i = 0;i < page.length;i++){
			$(generateListItem(page[i])).insertBefore('.last-row');
		}
	}else{
		$('#itemList').append('<li>查無資料</li>');
	}
	$('#itemList').listview('refresh');
	$('#typePanel').panel('close');
	$.mobile.loading('hide');
};

var toCompanyWebSite = function(url){
	window.open(url, '_blank', 'location=yes');
};

$('#companyDetail').on('pageshow', function(event, ui){
	if(ui.prevPage.attr('id') !== 'resultItem'){
		return;
	}
	$.mobile.loading('show');
	$('.product-item-field').empty();
	var company = null;
	$.each(_COMPANYS, function(key, obj){
		if(obj.id === _CID){
			company = obj;
			return false;
		}
	});
	var cUrl = (typeof company.companyUrl !== 'undefined')?'<a href="#" onclick="javascript: toCompanyWebSite(\'' + $.trim(company.companyUrl) + '\');">' + $.trim(company.companyUrl) + '</a>':'無';
	$('#companyName').text($.trim(company.name));
	$('#companyAddress').text($.trim(company.address));
	$('#factoryAddress').text($.trim(company.faddress));
	$('#companyBoss').text($.trim(company.boss));
	$('#companyPhone').text($.trim(company.phone));
	$('#contactName').text($.trim(company.contactName));
	$('#contactPhone').text($.trim(company.contactPhone));
	$('#contactFax').text($.trim(company.contactFax));
	$('#companyUrl').html(cUrl);
	$('#companyTable').listview('refresh');
	$.mobile.loading('hide');
});

$('#resultItem').on('pageshow', function(event, ui){
	if(ui.prevPage.attr('id') !== 'resultList' && ui.prevPage.attr('id') !== 'companyDetail'){
		return;
	}
	$.mobile.loading('show');
	$('.product-item-field').empty();
	$('#productImage').empty();
	var product = null;
	$.each(_QUERY_RESULT, function(index, obj){
		if(obj.id === _PID){
			product = obj;
			return false;
		}
	});
	$('#productName').text($.trim(product.name));
	$('#productCode').text($.trim(product.code));
	$('#productCompany').html('<a href="#" onclick="javascript: toCompanyDetail(\'' + product.cid + '\');">' + $.trim(product.companyName) + '</a>');
	$('#productSpec').html($.trim(product.spec));
	$('#productFeatures').html($.trim(product.features));
	$('#productPrice').text($.trim(product.price));
	$('#productApproveId').text($.trim(product.approveId));
	$('#productApproveDate').text($.trim(product.approveDate));
	$('#productImage').append('<img class="product-image" src="' + product.picture + '" />');
	$('#detailTable').listview('refresh');
	$.mobile.loading('hide');
});

$('#resultList').on('pageshow', function(event, ui){
	if(ui.prevPage.attr('id') !== 'index'){
		return;
	}
	$.mobile.loading('show'); 
	$('#itemList').empty();
	_ORIGINAL_QUERY_RESULT = [];
	_QUERY_RESULT = [];
	_ROW_INDEX = 0;
	$.ajax({
		url: 'data/data.json',
		type: 'GET',
		dataType: 'json',
		success: function(data){
			_COMPANYS = data.companys;
			$.each(data.products, function(key, obj){
				if(_TYPE === '' || obj.type === _TYPE){
					if(_KEYWORD === '' || obj.name.indexOf(_KEYWORD) !== -1 || obj.companyName.indexOf(_KEYWORD) !== -1 || obj.code.indexOf(_KEYWORD) !== -1){
						_QUERY_RESULT.push(obj);
						_ORIGINAL_QUERY_RESULT.push(obj);
					}
				}
			});
			createTypeList(data.productTypes);
			createCompanyList();
			var page = getMoreResult(_ROW_INDEX);
			if(page.length !== 0){
				$('#itemList').append('<li class="last-row" data-icon="false"><a href="#" onclick="javascript: getNextPageItems();"><h3 class="ui-li-heading">載入更多資料...</h3></a></li>');
				for(var i = 0;i < page.length;i++){
					$(generateListItem(page[i])).insertBefore('.last-row');
				}
			}else{
				$('#itemList').append('<li>查無資料</li>');
			}
			$('#itemList').listview('refresh');
			$.mobile.loading('hide');
		},
		error: function(){
			$.mobile.loading('hide');
			console.log('Anonymous ERROR occurs.');
		}
	});
});

$('#splash').on('pageshow', function(event, ui){
    window.setTimeout(function(){
	$.mobile.changePage('#index', {
	    transition: _PAGE_TRANSITION
	});
    }, 3000);
    var mySound = new Audio('data/brucelee.ogg');
    mySound.play();
});