// ########  ######## ######## #### ##    ## ######## 
// ##     ## ##       ##        ##  ###   ## ##       
// ##     ## ##       ##        ##  ####  ## ##       
// ##     ## ######   ######    ##  ## ## ## ######   
// ##     ## ##       ##        ##  ##  #### ##       
// ##     ## ##       ##        ##  ##   ### ##       
// ########  ######## ##       #### ##    ## ######## 

var pushNotification;
var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicitly call 'app.receivedEvent(...);'
    onDeviceReady: function() {
		localStorage['device'] = JSON.stringify(device);
		pushNotification = window.plugins.pushNotification;
		pushserver.register();
		if(navigator.connection.type==Connection.NONE){
			$("#swip").addClass('no_network');
		}
		sys.geobg();
		sys.calDistance();
    },
};

app.initialize();
var pushserver = {
	register: function(){
		$("#app-status-ul").append('<li>registering ' + device.platform + '</li>');
		if ( device.platform == 'android' || device.platform == 'Android' || device.platform == "amazon-fireos" ){
		    pushNotification.register(
		    this.successHandler,
		    this.errorHandler,
		    {
		        "senderID":"1070130160728",
		        "ecb":"pushserver.onNotification"
		    });
		} else {
		    pushNotification.register(
		    this.tokenHandler,
		    this.errorHandler,
		    {
		        "badge":"true",
		        "sound":"true",
		        "alert":"true",
		        "ecb":"pushserver.onNotificationAPN"
		    });
		}
	},
	successHandler: function(result){
		// result contains any message sent from the plugin call
	},
	errorHandler: function(error){
		// result contains any error description text returned from the plugin call
	},
	tokenHandler: function(result) {
	    // Your iOS push server needs to know the token before it can push to this device
	    // here is where you might want to send it the token for later use.
		$.ajax({
			url: server.list[server.set] + "v1/member/account/push_register/",
			data:{
				'account' : auth.account,
				'token' : auth.token,
				'gcm_id':result+"",
				'device':localStorage['device']
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				sys.success({
					'from':'account.gcm_register'
				});
			},
			error : function(data){
				sys.error({
					'from':'account.gcm_register',
					'data':data
				});
			}
		});
	},
	onNotification: function(e) {
		// Android and Amazon Fire OS
	    $("#app-status-ul").append('<li>EVENT -> RECEIVED:' + e.event + '</li>');
		//alert('RECEIVED:' + e.event );
	    switch( e.event )
	    {
	    case 'registered':
	        if ( e.regid.length > 0 )
	        {
	            // Your GCM push server needs to know the regID before it can push to this device
	            // here is where you might want$("#app-status-ul").append(to send it the regID for later use.
				$.ajax({
					url: server.list[server.set] + "v1/member/account/push_register/",
					data:{
						'account' : auth.account,
						'token' : auth.token,
						'gcm_id' : e.regid,
						'device' : localStorage['device']
					},
					type:"POST",
					dataType:"json",
					success: function(data){
						sys.success({
							'from':'account.gcm_register'
						});
					},
					error : function(data){
						sys.error({
							'from':'account.gcm_register',
							'data':data
						});
					}
				});
	        }
	    break;

	    case 'message':
	       var data = '<div id="bg2"></div>';
	       data += '<div id="Notification">';
	       data += '	<div class="title">'+e.payload.title2+'<button class="close" onClick="pushserver.Notification();">X</button></div>';
	       data += '	<div class="description">'+e.payload.description+'</div>';
	       data += '</div>';
	       $("body").append(data);
	    break;

	    case 'error':
	        $("#app-status-ul").append('<li>ERROR -> MSG:' + e.msg + '</li>');
	    break;

	    default:
	        $("#app-status-ul").append('<li>EVENT -> Unknown, an event was received and we do not know what it is</li>');
	    break;
	  }
	},
	onNotificationAPN:function(event) {
		var data = '<div id="bg2"></div>';
		data += '<div id="Notification">';
		data += '	<div class="title">'+event.title2+'<button class="close" onClick="pushserver.Notification();">X</button></div>';
		data += '	<div class="description">'+event.description+'</div>';
		data += '</div>';
		$("body").append(data);
		// iOS
	    if ( event.alert )
	    {
	        navigator.notification.alert(event.alert);
	    }

	    if ( event.sound )
	    {
	        var snd = new Media(event.sound);
	        snd.play();
	    }

	    if ( event.badge )
	    {
	        pushNotification.setApplicationIconBadgeNumber(successHandler, errorHandler, event.badge);
	    }
	},
	Notification:function(){
		$("#Notification").remove();
		$("#bg2").remove();
	}
};

//       ##       ## ########  ######## ######## #### ##    ## ########     ######  ##     ##  #######  ########   ######  
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##          ##    ## ##     ## ##     ## ##     ## ##    ## 
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##          ##       ##     ## ##     ## ##     ## ##       
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######       ######  ######### ##     ## ########   ######  
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##                ## ##     ## ##     ## ##              ## 
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##          ##    ## ##     ## ##     ## ##        ##    ## 
// ##       ##       ########  ######## ##       #### ##    ## ########     ######  ##     ##  #######  ##         ######  
var shops = {
	'now_id':0,
	sort:function(key){
		var distance = JSON.parse(localStorage['distance']);
		var s = [];
		for(var _item in shops.list){
			s.push({
				'index':_item*1,
				'distance': distance[_item]*1,
				'price': shops.list[_item].meal_price_avg*1,
				'rank': 5-shops.list[_item].rank*1
			});
		}
		return sys.sortByKey(s,key);
	},
	show_love:function(search){
		var distance = JSON.parse(localStorage['distance']);
		localStorage['search'] = search;
		$('#shoplist_list').html('');
		localStorage['list_type'] = 1;
		var echolovecount = 0;
		if(love.list.length>0){
			$("#nolove").css('display','none');
			var sort_type = 'price';
			if(localStorage['sort_type']!==undefined){
				sort_type = localStorage['sort_type'];
			}
			var _sort = shops.sort(sort_type);
			for(var sort_item in _sort){
				_item = _sort[sort_item].index;
				//for(var _item in shops.list){
				if(jQuery.inArray( shops.list[_item].shop_id, love.list ) == -1 || !filter.check(_item)  || shops.list[_item].name.search(search)<0){
					continue;
				}
				echolovecount++;
				var img = shops.list[_item].representative_img.position !== '' ? 'background-position: -'+ (shops.list[_item].representative_img.position%10)*100 +'px -'+ Math.floor(shops.list[_item].representative_img.position/10)*100 +'px;background-image:url(' + shops.default_img.url +');':'background-image: url(' + shops.no_image.representative + ');background-size: 100%;';
				var data="";
				var _distance = distance[_item]<1?Math.floor(distance[_item]*1000)+"M":Math.floor(distance[_item]*10)/10+"KM";
				var price = '';
				for(var i=0;i<shops.list[_item].meal_price_avg;i++){
					price += '$';
				}
				price = "<li class="+'"priceTag"'+">"+price+"<\/li>";
				var kind = '';
				var kind_count =0;
				if(shops.list[_item].shop_kind>0){
					for(var _kind in shops.kind){
						if((shops.list[_item].shop_kind & (1<<(shops.kind[_kind].index-1)))>0){
							if(kind_count>2){
								kind += "<li>...<\/li>";
								break;
							}
							else{
								kind += "<li>"+shops.kind[_kind].data+"<\/li>";
								kind_count++;
							}
						}
					}
				}
				var rank='';
				for(var i=0;i<5;i++){
					if(shops.list[_item].rank>i){
						rank += "		<li class=\"like\"><\/li>";	
					}
					else{
						rank += "		<li class=\"\"><\/li>";	
					}
				}
				var shop_name_length = sys.chineseCount(shops.list[_item].name);
				var shop_name = (shop_name_length.chinese + shop_name_length.english/2)>8?shops.list[_item].name.substr(0,(shop_name_length.chinese + shop_name_length.english))+'...':shops.list[_item].name;
				var discount_info = shops.list[_item].discount_info.length>20?shops.list[_item].discount_info.substr(0,20)+'...':shops.list[_item].discount_info;
				var data="";
				data += "<li href=\"#\" onClick=\"shops.show(" + _item + ");\">";
				data += "    	<i style=\"" + img + "\"></i>";
				data += "	<div class=\"info\">";
				data += "		<h2>"+ shop_name + "<\/h2>";
				data += "		<ul class=\"rank\">";
				data += rank;
				data += "		<\/ul>";
				if(auth.check_permission()>0){
					data += "		<p class=\"address\">"+discount_info+"<\/p>";
				}
				else{
					data += "		<p class=\"address\">"+shops.list[_item].address+"<\/p>";
				}
				data += "		<ul class=\"tag\">";
				data += kind;
				data += price;
				data += "		<\/ul>";
				data += "		<div class=\"distance\">"+_distance+"<\/div>";
				data += "		<div class=\"love light\"><\/div>";
				data += "	<\/div>";
				data += "<\/li>";
				$('#shoplist_list').append(data);
			}
		}else{
			$("#nolove").css('display','block');
		}
		if(echolovecount==0){
			$("#nolove").css('display','block');
		}
	},
	feature_save : function(){
		localStorage['shops'] = JSON.stringify({
			default_img: shops.default_img,
			list: shops.list,
			no_image: shops.no_image,
			kind: shops.kind,
			version: shops.version
		});
		localStorage['feature'] = JSON.stringify({
			version: feature.version,
			user_likes : feature.user_likes
		});
	},
	show_shoplist:function(search, page){
		var distance = JSON.parse(localStorage['distance']);
		localStorage['search'] = search;
		localStorage['list_type'] = 0;
		$('#shoplist_list').html('');
		var sort_type = 'price';
		if(localStorage['sort_type']!==undefined){
			sort_type = localStorage['sort_type'];
		}
		var _sort = shops.sort(sort_type);
		for(var sort_item in _sort){
			if(page==-1){
				//不做分頁動作
			}
			else if(sort_item<page*50){
				continue;
			}
			else if(sort_item>=(page+1)*50){
				break;
			}

			_item = _sort[sort_item].index;
			if(!filter.check(_item) || shops.list[_item].name.search(search)<0){
				continue;
			}
			var img = shops.list[_item].representative_img.position !== '' ? 'background-position: -'+ (shops.list[_item].representative_img.position%10)*100 +'px -'+ Math.floor(shops.list[_item].representative_img.position/10)*100 +'px;background-image:url(' + shops.default_img.url +');':'background-image: url(' + shops.no_image.representative + ');background-size: 100%;';
			var is_love = $.inArray(shops.list[_item].shop_id, love.list)>0?' light':'';
			var shop_name_length = sys.chineseCount(shops.list[_item].name);
			var shop_name = (shop_name_length.chinese + shop_name_length.english/2)>8?shops.list[_item].name.substr(0,(shop_name_length.chinese + shop_name_length.english))+'...':shops.list[_item].name;
				//var shop_name = shops.list[_item].name.length>8?shops.list[_item].name.substr(0,8)+'...':shops.list[_item].name;
			var _distance = distance[_item]<1?Math.floor(distance[_item]*1000)+"M":Math.floor(distance[_item]*10)/10+"KM";
			var price = '';
			for(var i=0;i<shops.list[_item].meal_price_avg;i++){
				price += '$';
			}
			price = "<li class="+'"priceTag"'+">"+price+"<\/li>";
			var kind = '',kind_count=0;
			if(shops.list[_item].shop_kind>0){
				for(var _kind in shops.kind){
					if((shops.list[_item].shop_kind & (1<<(shops.kind[_kind].index-1)))>0){
						if(kind_count>2){
							kind += "<li>...<\/li>";
							break;
						}
						else{
							kind += "<li>"+shops.kind[_kind].data+"<\/li>";
							kind_count++;
						}
					}
				}
			}
			var rank='';
			for(var i=0;i<5;i++){
				if(shops.list[_item].rank>i){
					rank += "		<li class=\"like\"><\/li>";	
				}
				else{
					rank += "		<li class=\"\"><\/li>";	
				}
			}
			var discount_info = shops.list[_item].discount_info.length>20?shops.list[_item].discount_info.substr(0,20)+'...':shops.list[_item].discount_info;
			var data="";
			data += "<li href=\"#\" onClick=\"shops.show(" + _item + ");\">";
			data += "    	<i style=\"" + img + "\"></i>";
			data += "	<div class=\"info\">";
			data += "		<h2>"+ shop_name + "<\/h2>";
			data += "		<ul class=\"rank\">";
			data += rank;
			data += "		<\/ul>";
			if(auth.check_permission()>0){
				data += "		<p class=\"address\">"+discount_info+"<\/p>";
			}
			else{
				data += "		<p class=\"address\">"+shops.list[_item].address+"<\/p>";
			}
			data += "		<ul class=\"tag\">";
			data += kind;
			data += price;
			data += "		<\/ul>";
			data += "		<div class=\"distance\">"+_distance+"<\/div>";
			data += "		<div class=\"love"+is_love+"\"><\/div>";
			data += "	<\/div>";
			data += "<\/li>";
			$('#shoplist_list').append(data);
		}
	},
	update : function(){
		$.ajax({
			url: server.list[server.set] + "v1/catch/shop/",
			data:{
				'version':shops.version
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				localStorage['shops'] = JSON.stringify(data);
				shops.load();
				sys.success({
					'from':'shops.update'
				});
				feature.update();
			},
			error : function(data){
				sys.error({
					'from':'shops.update',
					'data':data
				});
			}
		});	
	},
	load : function(){
		if(localStorage['shops']!==undefined){
			var _shops = $.parseJSON(localStorage['shops']);
			shops.list = _shops.list;
			shops.version = _shops.version;
			shops.no_image.representative = _shops.no_image.representative;
			shops.default_img.url = _shops.default_img.url;
			shops.default_img.file = _shops.default_img.file;
			shops.kind = _shops.kind;
		}
		if(localStorage['feature']!==undefined){
			var _feature = $.parseJSON(localStorage['feature']);
			feature.version = _feature.version;
			feature.user_likes = _feature.user_likes;
		}
		if(localStorage['user_likes']!==undefined){
			var _user_likes = $.parseJSON(localStorage['user_likes']);
			feature.user_likes = _user_likes;
		}
		shops.now_id = localStorage['shop_show_index']*1;
	},
	version : 0,
	no_image:{
		"representative":"images/logo.png"
	},
	default_img : {
		"url" : 'http://i.imgur.com/Lowb4NK.jpg',
		"file" : 'default.jpg'
	},
	list:[
		{
		    "id": 123,
		    "name": "特約店",
		    "address": "臺中市xxx路xx號",
		    "tel": "0976543211",
		    "description": "<p>簡短介紹</p>",
		    "location": [
		        "123.12345689",
		        "23.123467"
		    ],
		    "img_count": "10",
		    "meal_price_avg": "50.2",
		    "feature_count": "2",
		    "representative_img": {
		        "url": "http: //imgur.com/xxxxx",
		        "upload_date": "2014/7/7",
		        "img_id": "1",
		        "position":null
		    },
		    "preview_img": {
		        "url": "http: //imgur.com/xxxxx",
		        "upload_date": "2014/7/7"
		    },
		    "imgs": [],
		    "goods": [],
		    "features":[]
		}
	],
	kind:[
		'分類'
	],
	show:function(id) {
		localStorage['shop_show_index'] = id;
		location = 'shop_index.html';
	},
	next_shop:function(type){
		var id = localStorage['shop_show_index'];
		var search = localStorage['search'];
		var list_type = localStorage['list_type'];
		var distance = JSON.parse(localStorage['distance']);
		var sort_type = 'price';
		if(localStorage['sort_type']!==undefined){
			sort_type = localStorage['sort_type'];
		}
		var _sort = shops.sort(sort_type);
		var pre=0, show=0;
		for(var sort_item in _sort){
			_item = _sort[sort_item].index;
			if(!filter.check(_item) || shops.list[_item].name.search(search)<0){
				continue;
			}
			if(jQuery.inArray( shops.list[_item].shop_id, love.list ) == -1 && list_type==1){
				continue;
			}
			if(show==1 && type==1){
				shops.show(_item);
				console.log('next');
				return 0;
			}
			else if(_item==id){
				show=1;
				console.log('set');
			}
			else{
				pre = _item;
				console.log('else');
			}
			if(show==1 && type==-1){
				if(pre==0) break;
				shops.show(pre);
				console.log('pre');
				return 0;
			}
		}
		alert('已經到底囉！');
		return 0;
	}
};
var myScroll;
//       ##       ## ########  ######## ######## #### ##    ## ########    ######## ########    ###    ######## ##     ## ########  ######## 
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##          ##       ##         ## ##      ##    ##     ## ##     ## ##       
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##          ##       ##        ##   ##     ##    ##     ## ##     ## ##       
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######      ######   ######   ##     ##    ##    ##     ## ########  ######   
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##          ##       ##       #########    ##    ##     ## ##   ##   ##       
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##          ##       ##       ##     ##    ##    ##     ## ##    ##  ##       
// ##       ##       ########  ######## ##       #### ##    ## ########    ##       ######## ##     ##    ##     #######  ##     ## ######## 
var feature = {
	version:0,
	user_likes : [],
	like : function(id,type){
		sys.feet({
			'page':document.URL,
			'type':'function_call',
			'funcion':'feature.like',
			'data':id
		});
		if(type==0){
			feature.user_likes.push(id);
		}else{
			sys.removeA(feature.user_likes,id);
		}
		localStorage['feature'] = JSON.stringify({
			version: feature.version,
			user_likes : feature.user_likes
		});
		$.ajax({
			url: server.list[server.set] + "v1/feature/like/",
			data:{
				'account' : auth.account,
				'token' : auth.token,
				'feature':id,
				'type':type
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				feature.update();
				sys.success({
					'from':'feature.like'
				});
				feature.load(shops.now_id);
			},
			error : function(data){
				sys.error({
					'from':'feature.like',
					'data':data
				});
			}
		});
	},
	add : function(title,data,rank,shop_id){
		$.ajax({
			url: server.list[server.set] + "v1/feature/create/",
			data:{
				'account' : auth.account,
				'token' : auth.token,
				'title':title,
				'data':data,
				'rank':rank,
				'shop_id':shop_id
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				feature.user_likes.push(data.feature_id*1);
				localStorage['feature'] = JSON.stringify({
					version: feature.version,
					user_likes : feature.user_likes
				});
				feature.load_shop();
				sys.success({
					'from':'feature.add'
				});
				alert('評論成功!');
			},
			error : function(data){
				sys.error({
					'from':'feature.add',
					'data':data
				});
			}
		});
	},
	load : function(s_id){
		var shop_data = shops.list[s_id];
		if(shop_data.features.length>0){
			$("#commit ul").html('');
			for(var _features in shop_data.features){
				var img = shop_data.features[_features].img==''?'':shop_data.features[_features].img;
				var like_button = $.inArray(shop_data.features[_features].feature_id, feature.user_likes)<0?'<button class="like_btn" onclick="feature.like('+shop_data.features[_features].feature_id+','+'0);">('+shop_data.features[_features].like+')</button>':'<button class="like_btn active" onclick="feature.like('+shop_data.features[_features].feature_id+','+'1);">('+shop_data.features[_features].like+')</button>';
				var data="";
				data += "<li>";
				data += "	<img src=\"\" alt=\"\">";
				data += "	<div class=\"message\">";
				data += "		<div class=\"title\">"+shop_data.features[_features].title+"<\/div>";
				data += "		<p>"+shop_data.features[_features].data+"<\/p>";
				data += "	<\/div>";
				data += like_button;
				data += "	<ul class=\"rank\">";
				for(var i=1;i<6;i++){
					if(shop_data.features[_features].rank>=i){
						data += "		<li class=\"like\"><\/li>";	
					}
					else{
						data += "		<li class=\"\"><\/li>";	
					}
				}
				data += "	<\/ul>";
				data += "	<div class=\"date\">"+shop_data.features[_features].date.substring(0,10)+"<\/div>";
				data += "<\/li>";
				$("#commit>ul").append(data);
			}
		}
		else{
			//無評論
			$("#commit ul").html('<li>無評論</li>');
		}
	},
	load_shop : function(){
		var shop_tmp = shops.list[shops.now_id].shop_id;
		$.ajax({
			url: server.list[server.set] + "v1/feature/info/",
			data:{
				'account' : auth.account,
				'token' : auth.token,
				'shop_id':shop_tmp
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				var i = sys.arrayObjectIndexOf(shops.list,shop_tmp,'shop_id');
				if(i>=0){
					shops.list[i].features = data.features;	
					var rank =0;
					for(var _i in data.features){
						rank += data.features[_i].rank;
					}
					shops.list[i].rank = rank/data.features.length;
				}
				shops.feature_save();
				feature.load(shops.now_id);
				sys.success({
					'from':'feature.load_shop'
				});
			},
			error : function(data){
				sys.error({
					'from':'feature.load_shop',
					'data':data
				});
			}
		});
	},
	update:function(){
		$.ajax({
			url: server.list[server.set] + "v1/catch/feature/",
			data:{
				'version':feature.version
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				for(item in data.shops){
					var i = sys.arrayObjectIndexOf(shops.list,data.shops[item].shop_id,'shop_id');
					if(i>=0){
						shops.list[i].features = data.shops[item].features;	
						var rank =0;
						for(var _i in data.shops[item].features){
							rank += data.shops[item].features[_i].rank;
						}
						shops.list[i].rank = rank/data.shops[item].features.length;
					}
				}
				feature.version = data.version;
				shops.feature_save();
				sys.success({
					'from':'feature.update'
				});
			},
			error : function(data){
				sys.error({
					'from':'feature.update',
					'data':data
				});
			}
		});

		$.ajax({
			url: server.list[server.set] + "v1/feature/user_likes/",
			data:{
				'account' : auth.account,
				'token' : auth.token
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				feature.user_likes = data.features;
				localStorage['feature'] = JSON.stringify({
					version: feature.version,
					user_likes : feature.user_likes
				});
				feature.load(shops.now_id);
				sys.success({
					'from':'feature.update-user_likes'
				});
			},
			error : function(data){
				sys.error({
					'from':'feature.update-user_likes',
					'data':data
				});
			}
		});	
	}
};
// ########  ######## ######## #### ##    ## ########     ######   #######  ##     ## ########   #######  ##    ## 
// ##     ## ##       ##        ##  ###   ## ##          ##    ## ##     ## ##     ## ##     ## ##     ## ###   ## 
// ##     ## ##       ##        ##  ####  ## ##          ##       ##     ## ##     ## ##     ## ##     ## ####  ## 
// ##     ## ######   ######    ##  ## ## ## ######      ##       ##     ## ##     ## ########  ##     ## ## ## ## 
// ##     ## ##       ##        ##  ##  #### ##          ##       ##     ## ##     ## ##        ##     ## ##  #### 
// ##     ## ##       ##        ##  ##   ### ##          ##    ## ##     ## ##     ## ##        ##     ## ##   ### 
// ########  ######## ##       #### ##    ## ########     ######   #######   #######  ##         #######  ##    ## 
var coupon = {
	list:[],
	version:0,
	my:{
		list:[],
		last_update :0
	},
	show_detail:function(id){
		localStorage['coupon_show_detail'] = id;
		location = "coupon_detail.html";
	},
	show_mydetail:function(id){
		localStorage['coupon_show_mydetail'] = id;
		location = "mycoupon_detail.html";
	},
	show_mylist:function(){
		$("#mycoupon .coupon_list").html('');
		var distance = JSON.parse(localStorage['distance']);
		for(var i in coupon.my.list){
			shop_id = sys.arrayObjectIndexOf(shops.list,coupon.my.list[i].shop_id,'shop_id');
			if(shop_id == -1){
				continue;
			}
			var kind = '';
			var kind_count =0;
			if(shops.list[shop_id].shop_kind>0){
				for(var _kind in shops.kind){
					if((shops.list[shop_id].shop_kind & (1<<(shops.kind[_kind].index-1)))>0){
						if(kind_count>2){
							kind += "<li>...<\/li>";
							break;
						}
						else{
							kind += "<li>"+shops.kind[_kind].data+"<\/li>";
							kind_count++;
						}
					}
				}
			}
			
			var _distance = distance[shop_id]<1?Math.floor(distance[shop_id]*1000)+"M":Math.floor(distance[shop_id]*10)/10+"KM";
			var data="";
			data += "<li href=\"#\" onclick=\"coupon.show_mydetail("+coupon.my.list[i].coupon_id+");\">";
			data += "	<div class=\"img\"><img src=\""+coupon.my.list[i].small_img+"\"></div>";
			data += "	<div class=\"info\">";
			data += "		<h2>"+shops.list[shop_id].name+"<\/h2>";
			data += "		<p class=\"date\">期限:"+coupon.my.list[i].start_time+"~"+coupon.list[i].end_time+"<\/p>";
			data += "		<p class=\"coupon_info\">"+coupon.my.list[i].coupon_name+"<\/p>";
			data += "		<ul class=\"tag\">";
			data += kind;
			data += "		<\/ul>";
			data += "		<div class=\"distance\">"+_distance+"<\/div>";
			data += "		<div class=\"expired_date\">距離到期<span>"+(coupon.my.list[i].total-coupon.my.list[i].used)+"天<\/span><\/div>";
			data += "	<\/div>";
			data += "<\/li>";
			$("#mycoupon .coupon_list").append(data);
		}
	},
	show_list:function(){
		$("#coupon .coupon_list").html('');
		var distance = JSON.parse(localStorage['distance']);
		for(var i in coupon.list){
			shop_id = sys.arrayObjectIndexOf(shops.list,coupon.list[i].shop_id,'shop_id');
			if(shop_id == -1){
				continue;
			}
			var kind = '';
			var kind_count =0;
			if(shops.list[shop_id].shop_kind>0){
				for(var _kind in shops.kind){
					if((shops.list[shop_id].shop_kind & (1<<(shops.kind[_kind].index-1)))>0){
						if(kind_count>2){
							kind += "<li>...<\/li>";
							break;
						}
						else{
							kind += "<li>"+shops.kind[_kind].data+"<\/li>";
							kind_count++;
						}
					}
				}
			}
			
			var _distance = distance[shop_id]<1?Math.floor(distance[shop_id]*1000)+"M":Math.floor(distance[shop_id]*10)/10+"KM";
			var data="";
			data += "<li href=\"#\" onclick=\"coupon.show_detail("+coupon.list[i].coupon_id+");\">";
			data += "	<div class=\"img\"><img src=\""+coupon.list[i].small_img+"\"></div>";
			data += "	<div class=\"info\">";
			data += "		<h2>"+shops.list[shop_id].name+"<\/h2>";
			data += "		<p class=\"date\">期限:"+coupon.list[i].start_time+"~"+coupon.list[i].end_time+"<\/p>";
			data += "		<p class=\"coupon_info\">"+coupon.list[i].coupon_name+"<\/p>";
			data += "		<ul class=\"tag\">";
			data += kind;
			data += "		<\/ul>";
			data += "		<div class=\"distance\">"+_distance+"<\/div>";
			data += "		<div class=\"count\">剩餘數量<span>"+(coupon.list[i].total-coupon.list[i].used)+"張<\/span><\/div>";
			data += "	<\/div>";
			data += "<\/li>";
			$("#coupon .coupon_list").append(data);
		}
	},
	show_mycoupon:function(){

	},
	load:function(){
		if(localStorage['coupon']===undefined){
			localStorage['coupon'] = JSON.stringify({
				version: 0,
				list : []
			});
		}
		else{
			var _coupon = $.parseJSON(localStorage['coupon']);
			coupon.list = _coupon.list;
			coupon.version = _coupon.version;
		}
		if(localStorage['mycoupon']===undefined){
			localStorage['mycoupon'] = JSON.stringify({
				last_update: 0,
				list : []
			});
		}
		else{
			var _mycoupon = $.parseJSON(localStorage['mycoupon']);
			coupon.my.list = _mycoupon.list;
			coupon.my.last_update = _mycoupon.last_update;
		}
	},
	update_my:function(){
		$.ajax({
			url: server.list[server.set] + "v1/coupon/mycoupon/",
			data:{
				'version':feature.version
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				if(data.code==0){
					localStorage['mycoupon'] = JSON.stringify({
						last_update: Date.now(),
						list : data.list
					});
					coupon.load();
					sys.success({
						'from':'mycoupon.update'
					});
				}
				else{
					sys.error({
						'from':'mycoupon.update.server-error',
						'data':data
					});
				}
			},
			error : function(data){
				sys.error({
					'from':'mycoupon.update',
					'data':data
				});
			}
		});
	},
	update:function(){
		$.ajax({
			url: server.list[server.set] + "v1/coupon/list/",
			data:{
				'version':feature.version
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				if(data.code==0){
					localStorage['coupon'] = JSON.stringify({
						version: data.version,
						list : data.list
					});
					coupon.load();
					sys.success({
						'from':'coupon.update'
					});
				}
				else{
					sys.error({
						'from':'coupon.update.server-error',
						'data':data
					});
				}
			},
			error : function(data){
				sys.error({
					'from':'coupon.update',
					'data':data
				});
			}
		});
	}
};

//       ##       ## ########  ######## ######## #### ##    ## ########    ##        #######  ##     ## ######## 
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##          ##       ##     ## ##     ## ##       
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##          ##       ##     ## ##     ## ##       
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######      ##       ##     ## ##     ## ######   
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##          ##       ##     ##  ##   ##  ##       
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##          ##       ##     ##   ## ##   ##       
// ##       ##       ########  ######## ##       #### ##    ## ########    ########  #######     ###    ######## 
var love = {
	"last_change":"2014/05/06",
	"list":[],
	load:function(){
		if(localStorage['love']!==undefined){
			var _love = $.parseJSON(localStorage['love']);
			love.list = _love.list;
			love.last_change = _love.last_change;
		}else{
			localStorage['love'] = JSON.stringify({"last_change":"2014/05/06","list":[123]});
		}
	},
	add:function(id){
		love.list.push(id);
		love.last_change = new Date().getTime();
		localStorage['love'] = JSON.stringify({"last_change":love.last_change,"list":love.list});
		sys.feet({
			'page':document.URL,
			'type':'function_call',
			'funcion':'love.add',
			'data':id
		});
	},
	remove:function(id){
		sys.removeA(love.list,id);
		love.last_change = new Date().getTime();
		localStorage['love'] = JSON.stringify({"last_change":love.last_change,"list":love.list});
		sys.feet({
			'page':document.URL,
			'type':'function_call',
			'funcion':'love.remove',
			'data':id
		});
	}
};

//       ##       ## ########  ######## ######## #### ##    ## ########       ###    ########   ######  
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##            ## ##   ##     ## ##    ## 
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##           ##   ##  ##     ## ##       
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######      ##     ## ##     ##  ######  
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##          ######### ##     ##       ## 
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##          ##     ## ##     ## ##    ## 
// ##       ##       ########  ######## ##       #### ##    ## ########    ##     ## ########   ######  
var mySwiper;
var ads = {
	list : ['<img src="swiper/images/1.jpg">','<img src="swiper/images/2.jpg">'],
	version : 0,
	update : function(){
		$.ajax({
			url: server.list[server.set] + "v1/ads/get/",
			data:{
				'version':ads.version
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				localStorage['ads'] = JSON.stringify(data);
				ads.load();
				sys.success({
					'from':'ads.update'
				});
			},
			error : function(data){
				sys.error({
					'from':'ads.update',
					'data':data
				});
			}
		});
	},
	load : function(){
		if(localStorage['ads']!==undefined){
			var _ads = $.parseJSON(localStorage['ads']);
			ads.list = _ads.list;
			ads.version = _ads.version;
		}
	},
	show : function(){
		var _ads = ads.list;
		$('.swiper-container .swiper-wrapper').html('');
		for(var _item in _ads){
			$('.swiper-container .swiper-wrapper').append('<div class="swiper-slide"> ' + _ads[_item] + ' </div>');
		}
		mySwiper.reInit();
	}
};

//       ##       ## ########  ######## ######## #### ##    ## ########       ###    ##     ## ######## ##     ## 
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##            ## ##   ##     ##    ##    ##     ## 
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##           ##   ##  ##     ##    ##    ##     ## 
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######      ##     ## ##     ##    ##    ######### 
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##          ######### ##     ##    ##    ##     ## 
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##          ##     ## ##     ##    ##    ##     ## 
// ##       ##       ########  ######## ##       #### ##    ## ########    ##     ##  #######     ##    ##     ## 
var auth = {
	'account':0,
	'token':0,
	load : function(){
		if(localStorage['registration']!==undefined){
			var tmp = $.parseJSON(localStorage['registration']);
			auth.account = tmp.account;
			auth.token = tmp.token;
			if(tmp.student_id !== undefined){
				auth.student_id = tmp.student_id;
			}
			if(tmp.shop_id !== undefined){
				auth.shop_id = tmp.shop_id;
			}	
			try{
				auth.permission = tmp.permission;
				auth.permission_name = tmp.permission_name;
				auth.percent = tmp.percent;
			}
			catch(e){

			}
		}
	},
	school_auth : function(school_id,password){
		var encrypt;
		try {
			encrypt = new JSEncrypt();
			encrypt.setPublicKey('-----BEGIN PUBLIC KEY-----\
			MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDUvGTKzzVvfeEQkc7hFb/qWJHq\
			AauJ1Xjg7x6LIoUVdS9vE93XtyGRHho+eCaoC6OAnhtwe277DQK9Wi9dERZSs32z\
			bONPtxb72N5z+8Bj/ZEpFqqo1ukznGP41hrpg2BO3GbVmCgoSb7fr+1HEH8ttsn6\
			/izRZg5+9qkhGwaDhwIDAQAB\
			-----END PUBLIC KEY-----');
		}
		catch(err) {
		    
		}
		$.ajax({
			url: server.list[server.set] + "v1/member/auth/school/",
			dataType: 'json',
			type:"POST",
			data:{
				'action':'check_school_auth',
				'student_id':school_id,
				'password':encrypt.encrypt(password),
				'account' : auth.account,
				'token' : auth.token,
				'hash' : 'true'
			},
			success: function (data) {
				$("#registration_submit").removeAttr('disabled','disabled');
				sys.feet({
					'page':document.URL,
					'type':'function_call',
					'funcion':'check_auth2',
					'data':data
				});
				if(data.code == 0 ){
					registration_info = {
						'account':data.account,
						'token' : data.token,
						'student_id':data.student_id,
						'permission' : data.permission,
						'permission_name' : data.permission_name,
						'percent' : data.percent
					};
					localStorage['registration'] = JSON.stringify(registration_info);
					alert('驗證成功，APP即將重新載入！');
					window.location = "index.html";
				}
				else if(data.code == 2){
					registration_info = {
						'account':data.account,
						'token' : data.token,
						'shop_id':data.shop_id,
						'permission' : data.permission,
						'permission_name' : data.permission_name
					};
					localStorage['registration'] = JSON.stringify(registration_info);
					alert('店家驗證成功，APP即將重新載入！');
					window.location = "index.html";
				}
				else{
					alert('驗證失敗，帳號密碼有誤？');
				}
			},error:function(){
				$("#registration_submit").removeAttr('disabled','disabled');
				alert('錯誤!無法向伺服器註冊!請連上網路!');
			}
		});
	},
	registration : function(t){
		var device = '{}';
		if(localStorage['device'] !== undefined){
			device = localStorage['device'];
		}
		$.ajax({
			url: server.list[server.set] + "v1/member/account/add/",
			dataType: 'json',
			type:"POST",
			data:{
				'action':'registration',
				'device':device
			},
			success: function (data) {
				registration_info = {
					'account':data.account,
					'token' : data.token
				};
				localStorage['registration'] = JSON.stringify(registration_info);
				location.reload();
			},error:function(){
				sys.error('錯誤!無法向伺服器註冊!請連上網路!');
				setTimeout(function(){
					auth.registration(t++);
				},30 * 1000);
			}
		});
	},
	check_permission : function(){
		if(auth.student_id !== undefined){
			if(auth.permission>0){
				return 2;
			}else{
				return 1;
			}
		}
		else if(auth.shop_id !== undefined){
			return 3;
		}
		else{
			return 0;
		}
	},
	check_auth : function(){
		switch(auth.check_permission()){
			case 2:
			case 1:
				location = 'auth_success.html';
				break;

			case 3:
				sys.loadURL('http://siwahochi-app.yo-mi.com/system/tokenlogin/'+auth.token);
				//sys.loadURL('http://jackai.dev.yo-mi.com/system/tokenlogin/'+auth.token);
				break;

			default:
				location = 'registration.html';
		}
		sys.feet({
			'page':document.URL,
			'type':'function_call',
			'funcion':'auth.check_auth',
			'data':auth.check_permission()
		});
	}
};
//       ##       ## ########  ######## ######## #### ##    ## ########       ######## #### ##       ######## ######## ########  
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##             ##        ##  ##          ##    ##       ##     ## 
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##             ##        ##  ##          ##    ##       ##     ## 
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######         ######    ##  ##          ##    ######   ########  
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##             ##        ##  ##          ##    ##       ##   ##   
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##             ##        ##  ##          ##    ##       ##    ##  
// ##       ##       ########  ######## ##       #### ##    ## ########       ##       #### ########    ##    ######## ##     ## 
var filter = {
	start : function(backurl){
		localStorage['filter_backurl'] = backurl;
		location = 'filter.html';
	},
	finish : function(){
		location = localStorage['filter_backurl'];
	},
	set : function(type,value){
		if(localStorage['filter']===undefined){
			localStorage['filter'] = JSON.stringify([]);
		}
		var setting = $.parseJSON(localStorage['filter']);
		var i = sys.arrayObjectIndexOf(setting,type,'type');
		while(~i){
			setting.splice(i,1);
			i = sys.arrayObjectIndexOf(setting,type,'type');
		}
		setting.push({
			'type' : type,
			'value' : value
		});
		localStorage['filter'] = JSON.stringify(setting);
	},
	get_data : function(type){
		if(localStorage['filter']===undefined){
			localStorage['filter'] = JSON.stringify([]);
		}
		var setting = $.parseJSON(localStorage['filter']);
		var i = sys.arrayObjectIndexOf(setting,type,'type');
		return i>=0?setting[i].value:0;
	},
	check : function(shop_index){
		//console.log(shop_index);
		var setting = $.parseJSON(localStorage['filter']);
		var distance = JSON.parse(localStorage['distance']);
		var dis = [1000000,500,1000,2000,5000];
		for(var i in setting){
			switch(setting[i].type){
				case 'dis':
					//console.log('--'+setting[i].type+'#'+!((distance[shop_index]*1000)>dis[setting[i].value])+':'+dis[setting[i].value*1]+'--'+(distance[shop_index]*1000));
					if((distance[shop_index]*1000)>dis[setting[i].value]){
						return false;
					}
					break;
				case 'types':
					console.log('--'+setting[i].type+'#'+!((shops.list[shop_index].shop_kind&setting[i].value)==0)+':'+setting[i].value+'--'+(shops.list[shop_index].shop_kind&setting[i].value));
					if((shops.list[shop_index].shop_kind&setting[i].value)==0){
						return false;
					}
					break;
				case 'money':
					//console.log('--'+setting[i].type+'#'+!(shops.list[shop_index].meal_price_avg*1!=setting[i].value*1&&setting[i].value!=0)+':'+setting[i].value+'--'+shops.list[shop_index].meal_price_avg);
					if(shops.list[shop_index].meal_price_avg*1!=setting[i].value*1&&setting[i].value!=0){
						return false;
					}
					break;
			}
		}
		return true;
	}
};
//       ##       ## ########  ######## ######## #### ##    ## ########     ######  ######## ########  ##     ## ######## ########  
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##          ##    ## ##       ##     ## ##     ## ##       ##     ## 
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##          ##       ##       ##     ## ##     ## ##       ##     ## 
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######       ######  ######   ########  ##     ## ######   ########  
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##                ## ##       ##   ##    ##   ##  ##       ##   ##   
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##          ##    ## ##       ##    ##    ## ##   ##       ##    ##  
// ##       ##       ########  ######## ##       #### ##    ## ########     ######  ######## ##     ##    ###    ######## ##     ## 
var server = {
	set : 0, //set server id
	list : ['http://siwahochi-app.yo-mi.com/apis/','http://jackai.dev.yo-mi.com/apis/','http://echo-server.nutc-life.com/','http://exo-card.nutc-life.com/www_exo/']
};
//       ##       ## ########  ######## ######## #### ##    ## ########     ######  ##    ##  ######  ######## ######## ##     ## 
//      ##       ##  ##     ## ##       ##        ##  ###   ## ##          ##    ##  ##  ##  ##    ##    ##    ##       ###   ### 
//     ##       ##   ##     ## ##       ##        ##  ####  ## ##          ##         ####   ##          ##    ##       #### #### 
//    ##       ##    ##     ## ######   ######    ##  ## ## ## ######       ######     ##     ######     ##    ######   ## ### ## 
//   ##       ##     ##     ## ##       ##        ##  ##  #### ##                ##    ##          ##    ##    ##       ##     ## 
//  ##       ##      ##     ## ##       ##        ##  ##   ### ##          ##    ##    ##    ##    ##    ##    ##       ##     ## 
// ##       ##       ########  ######## ##       #### ##    ## ########     ######     ##     ######     ##    ######## ##     ## 
var sys = {
	version:4,
	debug:0,
	gps_error:1,
	error : function(data){
		sys.log(data);
	},
	success : function(data){
		sys.log(data);
	},
	loadURL : function(url){
		window.open(url, '_system');
	    return false;
	},
	log:function(obj){
		if(sys.debug==1){
			console.log(obj);
		}
	},
	check_version : function(){
		$.ajax({
			url: server.list[server.set] + "v1/catch/system/",
			data:{
				'version':ads.version
			},
			type:"POST",
			dataType:"json",
			success: function(data){
				sys.log(data);
				if(data.ads > ads.version){
					ads.update();
				}
				if(data.shops > shops.version){
					shops.update();
				}
				if(data.feature > feature.version){
					feature.update();
				}
				if(data.coupon > coupon.version){
					coupon.update();
				}

			if(sys.version < data.app['version']){
				if(confirm('已有更新版！是否去google play更新？ \n ' + data.app['info'] )){
					sys.loadURL(data.app['url']);
				}else{
					//取消
				}
			}
			},
			error : function(data){
				sys.error({
					'from':'sys.check_version',
					'data':data
				});
			}
		});		
	},
	feet : function(feet){
		if(localStorage['feet']===undefined){
			localStorage['feet'] = JSON.stringify([]);
		}
		var _feet = $.parseJSON(localStorage['feet']);
		_feet.push({
			'feet':feet,
			't':new Date().getTime()
		});
		localStorage['feet'] = JSON.stringify(_feet);
	},
	sync : function(){
		if(localStorage['feet']===undefined){
			localStorage['feet'] = JSON.stringify([]);
		}
		var _feet = $.parseJSON(localStorage['feet']);
		$.ajax({
			url: server.list[server.set] + "v1/member/log/user/",
			dataType: 'json',
			type:"POST",
			data:{
				'action':'check_auth',
				'account' : auth.account,
				'token' : auth.token,
				'data':JSON.stringify(_feet)
			},
			success: function (data) {
				if(data.code==0){
					if(auth.student_id !== undefined){
						if((data.student_id == 0 || data.student_id == null )&& data.student_id != auth.student_id){
							registration_info = {
								'account':auth.account,
								'token' : auth.token
							};
							localStorage['registration'] = JSON.stringify(registration_info);
							alert('已從其他裝置登入！');
							sys.feet({
								'page':document.URL,
								'type':'function_call',
								'funcion':'sys.sync',
								'data':'logout'
							});
							location = 'index.html';
						}else{
							//記錄
							registration_info = {
								'account':auth.account,
								'token' : auth.token,
								'student_id':data.student_id,
								'permission' : data.permission,
								'permission_name' : data.permission_name,
								'percent' : data.percent
							};
							localStorage['registration'] = JSON.stringify(registration_info);
						}
					}
					else if(auth.shop_id !== undefined){
						if((data.shop_id == 0 || data.shop_id == null )&& data.shop_id != auth.shop_id){
							registration_info = {
								'account':auth.account,
								'token' : auth.token
							};
							localStorage['registration'] = JSON.stringify(registration_info);
							alert('已從其他裝置登入！');
							sys.feet({
								'page':document.URL,
								'type':'function_call',
								'funcion':'sys.sync',
								'data':'logout'
							});
							location = 'index.html';
						}else{
							//記錄
							registration_info = {
								'account':auth.account,
								'token' : data.token,
								'shop_id':data.shop_id,
								'permission' : data.permission,
								'permission_name' : data.permission_name
							};
							localStorage['registration'] = JSON.stringify(registration_info);
						}
					}
					var feet = $.parseJSON(localStorage['feet']);
					for(var i=0;i<_feet.length;i++){
						feet.shift();
					}
					localStorage['feet'] = JSON.stringify(feet);
				}
			},
			error:function(){
				$("#check_auth").removeAttr('disabled','disabled');
			}
		});
	},
	/**
	 * loadScript
	 * @param  {String}   url
	 * @param  {Function} callback
	 * @author http://stackoverflow.com/questions/950087/how-to-include-a-javascript-file-in-another-javascript-file
	 * @example
		$.getScript("my_lovely_script.js", function(){
		
		   alert("Script loaded and executed.");
		   // Here you can use anything you defined in the loaded script
		});
	 */
	loadScript : function(url, callback)
	{
	    // Adding the script tag to the head as suggested before
	    var head = document.getElementsByTagName('head')[0];
	    var script = document.createElement('script');
	    script.type = 'text/javascript';
	    script.src = url;

	    if(callback==''){
		    // Then bind the event to the callback function.
		    // There are several events for cross browser compatibility.
		    script.onreadystatechange = callback;
		    script.onload = callback;	
	    }

	    // Fire the loading
	    head.appendChild(script);
	},
	/**
	 * convertImgToBase64
	 * @param  {String}   url
	 * @param  {Function} callback
	 * @param  {String}   [outputFormat='image/png']
	 * @author HaNdTriX
	 * @example
		convertImgToBase64('http://goo.gl/AOxHAL', function(base64Img){
			sys.log('IMAGE:',base64Img);
		})
	 */
	convertImgToBase64 : function(url, callback, outputFormat){
		var canvas = document.createElement('CANVAS');
		var ctx = canvas.getContext('2d');
		var img = new Image;
		img.crossOrigin = 'Anonymous';
		img.onload = function(){
			canvas.height = img.height;
			canvas.width = img.width;
		  	ctx.drawImage(img,0,0);
		  	var dataURL = canvas.toDataURL(outputFormat || 'image/png');
		  	callback.call(this, dataURL);
	        // Clean up
		  	canvas = null; 
		};
		img.src = url;
	},
	arrayObjectIndexOf:function(myArray, searchTerm, property) {
	    for(var i = 0, len = myArray.length; i < len; i++) {
	        if (myArray[i][property] === searchTerm) return i;
	    }
	    return -1;
	},
	removeA:function(arr) {
	    var what, a = arguments, L = a.length, ax;
	    while (L > 1 && arr.length) {
	        what = a[--L];
	        while ((ax= arr.indexOf(what)) !== -1) {
	            arr.splice(ax, 1);
	        }
	    }
	    return arr;
	},
	ajax_test:function(){
		$.ajax({
			url:"http://echo-server.nutc-life.com/a",
			type:"POST",
			dataType:"json",
			success: function(data){
				$("#main_123").prepend(JSON.stringify(data));
			},
			error : function(){
				alert('error');
			}
		});
	},
	geobg:function(){
		navigator.geolocation.getCurrentPosition(function(position) {
			localStorage['position'] = JSON.stringify(position);
			sys.gps_error=0;
			sys.calDistance();
			//alert('geobg');
			//console.log(position);
		}, 
		function(){
			sys.gps_error=1;
			if(document.URL=='shoplist'){
				$("#gps_error").css({
					display: 'block'
				});
			}
		});
	},
	calDistance:function(){
		var position = JSON.parse(localStorage['position']);
		if(position===undefined){
			var	position = {
					coords:{
						latitude : 24.1468688,
						longitude : 120.68260420000001
					}
			};	
		}
		var distance = [];
		for(var _item in shops.list){
			try{
				distance.push(sys.getFlatternDistance(shops.list[_item].location[0]*1,shops.list[_item].location[1]*1,position.coords.latitude,position.coords.longitude));
			}
			catch(e){

			}
		}
		localStorage['distance'] = JSON.stringify(distance);
	},
	getFlatternDistance:function(lat1, lon1, lat2, lon2){
      var R = 6378.1370; // km
      var dLat = sys.toRad(lat2-lat1);
      var dLon = sys.toRad(lon2-lon1);
      var lat1 = sys.toRad(lat1);
      var lat2 = sys.toRad(lat2);

      var a = Math.sin(dLat/2) * Math.sin(dLat/2) +
        Math.sin(dLon/2) * Math.sin(dLon/2) * Math.cos(lat1) * Math.cos(lat2); 
      var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a)); 
      var d = R * c;
      return d;
    },
    // Converts numeric degrees to radians
    toRad:function (Value){
        return Value * Math.PI / 180;
    },
	getFlatternDistance2:function(lat1,lng1,lat2,lng2){
		/*
		var EARTH_RADIUS = 6378137.0;
		var PI = Math.PI; 
		var f = ((lat1*1 + lat2*1)/2)*PI/180.0; 
		var g = ((lat1*1 - lat2*1)/2)*PI/180.0; 
		var l = ((lng1*1 - lng2*1)/2)*PI/180.0; 

		var sg = Math.sin(g); 
		var sl = Math.sin(l); 
		var sf = Math.sin(f); 

		var s,c,w,r,d,h1,h2; 
		var a = EARTH_RADIUS; 
		var fl = 1/298.257; 

		sg = sg*sg; 
		sl = sl*sl; 
		sf = sf*sf; 

		s = sg*(1-sl) + (1-sf)*sl; 
		c = (1-sg)*(1-sl) + sf*sl; 

		w = Math.atan(Math.sqrt(s/c)); 
		r = Math.sqrt(s*c)/w; 
		d = 2*w*a; 
		h1 = (3*r -1)/2/c; 
		h2 = (3*r +1)/2/s; 
		distance = d*(1 + fl*(h1*sf*(1-sg) - h2*(1-sf)*sg));
		if(distance<1000){
			distance = '距離 ' + Math.floor(distance) + ' 公尺';
		}else{
			distance = '距離 ' + Math.floor(distance/100)/10 + ' 公里';
		}
		return distance; 
		/*/
		//var R = 6371; // km (change this constant to get miles)
		dLat = (lat2-lat1) * Math.PI / 180;
		dLon = (lng2-lng1) * Math.PI / 180;
		da = Math.sin(dLat/2) * Math.sin(dLat/2) +
		Math.cos(lat1 * Math.PI / 180 ) * Math.cos(lat2 * Math.PI / 180 ) *
		Math.sin(dLon/2) * Math.sin(dLon/2);
		//var c = 2 * Math.atan2(Math.sqrt(da), Math.sqrt(1-da));
		dd = 6371 * 2 * Math.atan2(Math.sqrt(da), Math.sqrt(1-da));;
		//if (dd>1) return  '距離 ' + Math.round(dd)+" 公里";
		//else if (dd<=1) return  '距離 ' + Math.round(dd*1000)+" 公尺";
		return dd;
	},
	loadZoom:function(src){
		localStorage['load_img'] = src;
		$.mobile.changePage("#zoom_imgae", {
	        transition: "slide",
	        reverse: false
		});
	},
	sortByKey:function(array, key) {
	    return array.sort(function(a, b) {
	        var x = a[key]; var y = b[key];
	        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
	    });
	},
	lastPage:function(){
		//retrieve the previous page
		var previousPage = window.sessionStorage.getItem("page");
		// if thee is no previous page you are on the first page
		if (previousPage === undefined){
			//do something if you want, this means it's the first page the user is seeing
		}
		//get current page address
		var currentPage = window.location.href;
		//store it
		window.sessionStorage.setItem("page",currentPage); 
		//check if the previous page is the one you wanted.
		return previousPage;
	},
	chineseCount:function(word){
		return {
			'chinese':word.split(/[\u4e00-\u9a05]/).length -1,
			'english':word.length - (word.split(/[\u4e00-\u9a05]/).length -1)
		};
	}
};
var dLat,dLon,da,dd;


$(document).ready(function() {
	/*載入資料*/
	ads.load();
	shops.load();
	love.load();
	coupon.load();
	var lastPage = sys.lastPage();
	/*確定註冊資訊*/
	if(localStorage['registration']===undefined){
		auth.registration(0);
	}
	auth.load();
	/*檢查更新*/
	sys.check_version();
	sys.sync();
	coupon.update_my();
	var sync_timer = setInterval(function(){
		sys.check_version();
		sys.sync();
		coupon.update_my();
	},300 * 1000);

	/*載入GPS位置*/
	if(localStorage['position']===undefined){
		localStorage['position'] = JSON.stringify({
			coords:{
				latitude : 24.1468688,
				longitude : 120.68260420000001
			}
		});
		sys.calDistance();
	}
	sys.geobg();
	sys.calDistance();
	setInterval(function(){ 
		sys.geobg();
	}, 60 * 1000);

	$(".home_btn").on('click', function(event) {
		location = 'index.html';
		event.preventDefault();
		/* Act on the event */
	});
	$(".back_btn").on('click', function(event) {
		if(lastPage.search("random.html")>0){
			location = 'index.html';
		}
		else{
			window.history.back();
		}
		event.preventDefault();
		/* Act on the event */
	});
	switch(auth.check_permission()){
		case 3:
			$(".check_auth").html('登入後台');
			break;

		case 2:
			$(".check_auth").html('顯示特約卡');
			break;

		case 1:
			$(".check_auth").html('請連絡系會');
			break;

		default:
			$(".check_auth").html('請登入');
	}
	$(".check_auth").on('click', function(event) {
		auth.check_auth();
		event.preventDefault();
		/* Act on the event */
	});
	$("#infoImg").on('click', function(event) {
		sys.loadURL('https://www.facebook.com/siwahochi');
		event.preventDefault();
		/* Act on the event */
	});
	sys.loadScript("cordova.js",'');
});