$(document).ready(function($) {
	shops.load();
	setTimeout(function() {
		sys.loadScript('https://maps.googleapis.com/maps/api/js?key=AIzaSyASf6gMw3baIn51bnDHtkNtUyatnsTvRoE&sensor=true&callback=drawMap',function(){});
	}, 300);
	$("#shop_list").on('click', function(event) {
		location = 'shop_list.html';
		event.preventDefault();
		/* Act on the event */
	});
	$("#filter").on('click', function(event) {
		filter.start('location.html');
		event.preventDefault();
		/* Act on the event */
	});
});

var map,infowindow,latlng;

var show_info = function(marker,_item){ 
	var shop_data = shops.list[_item];
	var position = JSON.parse(localStorage['position']);
	var img = shops.list[_item].representative_img.position !== '' ? 'background-position: -'+ Math.floor(shops.list[_item].representative_img.position%10)*50 +'px  -'+ Math.floor(shops.list[_item].representative_img.position/10)*50 +'px;background-image:url(' + shops.default_img.url +')' : 'background-image: url(' + shops.no_image.representative + ');background-size: 100%;';
	console.log(_item);
	var rank = "";
	for(var i=0;i<5;i++){
		if(shop_data.rank>=i){
			rank += "		<li class=\"like\"><\/li>";	
		}
		else{
			rank += "		<li class=\"\"><\/li>";	
		}
	}
	var contentString = '';
	contentString += '<div class="content" onClick="shops.show(' + _item + ');">';
	contentString += "    	<i style=\"" + img + "\"></i>";
	contentString += "		<h2>"+ shop_data.name + "<\/h2>";
	contentString += "		<ul class=\"rank\">"+ rank + "<\/ul>";
	contentString += "		<p class=\"address\">"+ shop_data.address +"<\/p>";
	contentString += '</div>';
	infowindow.setContent(contentString );
	infowindow.open(map,marker);
}
var drawMap = function() {
	// Create an array of styles.

	infowindow = new google.maps.InfoWindow({
		content: '<div id="content">loading...</div>'
	})
	var styles = [
	{
		"featureType": "landscape.natural",
		"elementType": "geometry.fill",
		"stylers": [
		{
			"visibility": "on"
		},
		{
			"color": "#e0efef"
		}
		]
	},
	{
		"featureType": "poi",
		"elementType": "all",
		"stylers": [
		{
			"visibility": "off"
		},
		{
			"hue": "#1900ff"
		},
		{
			"color": "#c0e8e8"
		}
		]
	},
	{
		"featureType": "road",
		"elementType": "geometry",
		"stylers": [
		{
			"lightness": 100
		},
		{
			"visibility": "simplified"
		}
		]
	},
	{
		"featureType": "road",
		"elementType": "labels",
		"stylers": [
		{
			"visibility": "on"
		}
		]
	},
	{
		"featureType": "transit.line",
		"elementType": "geometry",
		"stylers": [
		{
			"visibility": "on"
		},
		{
			"lightness": 700
		}
		]
	},
	{
		"featureType": "water",
		"elementType": "all",
		"stylers": [
		{
			"color": "#7dcdcd"
		}
		]
	}
	];
	var styledMap = new google.maps.StyledMapType(styles,{name: "Styled Map"});
    var defaultLatLng = new google.maps.LatLng(24.1493310, 120.6845234);  // Default to Hollywood, CA when no geolocation support
    latlng = defaultLatLng;
    // Try HTML5 geolocation
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			latlng = new google.maps.LatLng(position.coords.latitude,position.coords.longitude);
			map.setCenter(latlng);
			var marker= new google.maps.Marker({
				position:latlng,
				map:map,
				icon: 'http://icons.iconarchive.com/icons/icons8/windows-8/24/Maps-Define-Location-icon.png'
			});
		}, function() {
			handleNoGeolocation(true);
		});
	}
    var myOptions = {
        zoom: 19,
        center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    map = new google.maps.Map(document.getElementById("map-canvas"), myOptions);
    map.mapTypes.set('map_style', styledMap);
    map.setMapTypeId('map_style');
    // Add an overlay to the map of current lat/lng
	for(var _item=0;_item<shops.list.length;_item++){
		if(filter.check(_item)==false){
			continue;
		}
	    var marker= new google.maps.Marker({
	    	position:new google.maps.LatLng(shops.list[_item].location[0],shops.list[_item].location[1]),
	    	map:map
	    });
		google.maps.event.addListener(marker, 'click', (function(marker, _item) {
	        return function() {
				sys.log(_item);
				show_info(this,_item);//shops.show(_item);
	        };
	    })(marker, _item));
    }

}
