$(document).ready(function($) {
	mySwiper = new Swiper('.swiper-container',{
	    paginationClickable: true,
	    loop: true
	});
	setTimeout(function() {
		console.log(shops.list[localStorage['shop_show_index']]);
		var shop_data = shops.list[localStorage['shop_show_index']];
		/* 載入圖片 */
		var _imgs = shops.list[localStorage['shop_show_index']].imgs;
		$('.swiper-container .swiper-wrapper').html('');
		for(var _item in _imgs){
			$('.swiper-container .swiper-wrapper').append('<div class="swiper-slide"><img src="' + shops.list[localStorage['shop_show_index']].imgs[_item].url_400px + '" url="' + shops.list[localStorage['shop_show_index']].imgs[_item].url + '"></div>');
		}
		if (_imgs.length == 0){
			$('.swiper-container .swiper-wrapper').append('<div class="swiper-slide"><img src="css/icons/shop_'+Math.floor((Math.random() * 6))+'.png"></div>');
		}
		mySwiper.reInit();
		/*載入標題*/
		$("#shop_name").html(shop_data.name);
		do{
			fix_width = ($("#shop_name").width()>(window.innerWidth-155));
			if(fix_width==true){
				$("#shop_name").css('font-size',$("#shop_name").css('font-size').substr(0,2)-1+'px');
			}
			else{
				break;
			}
		}while(true);

		var rank='';
		for(var i=0;i<5;i++){
			if(shop_data.rank>i){
				rank += "		<li class=\"like\"><\/li>";	
			}
			else{
				rank += "		<li class=\"\"><\/li>";	
			}
		}
		$("#shop_rank").html(rank);
		var position = JSON.parse(localStorage['position']);
		var _distance = sys.getFlatternDistance(shop_data.location[0]*1,shop_data.location[1]*1,position.coords.latitude,position.coords.longitude);
		$("#shop_distance").html(_distance<1?(Math.floor(_distance*1000) + 'm'):(Math.floor(_distance*10)/10 + 'KM'));
		/*載入基本資訊*/
		var kind = '';
		if(shops.list[localStorage['shop_show_index']].shop_kind>0){
			for(var _kind in shops.kind){
				if((shops.list[localStorage['shop_show_index']].shop_kind & (1<<(shops.kind[_kind].index-1)))>0){
					kind += shops.kind[_kind].data+" ";
				}
			}
		}
		var native_map = ['geo:0,0?','comgooglemaps://?','https://maps.google.com/maps?'];
		var device_set = window.navigator.standalone==true?1:0;
		$("#address_data").html(shop_data.address);
		$("#address_data").attr('href' , native_map[device_set] + 'q=' + encodeURI(shop_data.address != '' ? shop_data.address : shop_data.name ));
		$("#address_data").on('click', function(event) {
			sys.loadURL(this.href);
			event.preventDefault();
			/* Act on the event */
		});
		$("#type_data").html(kind==""?'無資料':kind);
		$("#tel_data").html(shop_data.tel==""?'無資料':shop_data.tel);
		$("#tel_data").attr('href',shop_data.tel != '' ? 'tel:' + shop_data.tel : '#');
		if(shop_data.tel != '' ){
			$("#tel_data").on('click', function(event) {
				sys.loadURL(this.href);
				event.preventDefault();
				/* Act on the event */
			});
		}
		var business_hour = '詳細資料';
		week_day_data = ['星期日','星期一','星期二','星期三','星期四','星期五','星期六'];
		if(shops.list[localStorage['shop_show_index']].business_hour.length>0){
			var day = new Date().getDay();
			$("#business_hour table tbody").html('');
			for(var _business_hour in shops.list[localStorage['shop_show_index']].business_hour){
				if(shops.list[localStorage['shop_show_index']].business_hour[_business_hour].week_day==day){
					business_hour = shops.list[localStorage['shop_show_index']].business_hour[_business_hour].start.substring(0,5) + '~' + shops.list[localStorage['shop_show_index']].business_hour[_business_hour].end.substring(0,5) + '|' + business_hour;
				}
				$("#business_hour table tbody").append('<tr><td>'+week_day_data[shops.list[localStorage['shop_show_index']].business_hour[_business_hour].week_day]+'</td><td>'+shops.list[localStorage['shop_show_index']].business_hour[_business_hour].start.substring(0,5) + '~' + shops.list[localStorage['shop_show_index']].business_hour[_business_hour].end.substring(0,5)+'</td></tr>');
			}
		}
		$("#time_data").html(business_hour);
			
		$("#description_data").html(shop_data.description===null||shop_data.description==""?'無資料':shop_data.description);
		/*載入評論*/
		$("#commit h2").html('店家評論<span>('+shop_data.features.length+')</span>');
		feature.load(localStorage['shop_show_index']);
		/*載入商品*/
		if(shop_data.goods.length>0){
			$("#goods table tbody").html('');
			for(var _goods in shop_data.goods){
				$("#goods table tbody").append('<tr><td>'+shop_data.goods[_goods].name+'</td><td>'+shop_data.goods[_goods].price+'</td></tr>');
			}
		}
		else{
			//無商品
			$("#goods table tfoot").html('<tr><td>目前尚無資料</td></tr>');
			$("#goods table tbody").html('');
		}
		if(auth.check_permission()>0){
			$("#siwahochi_data").html(shop_data.discount_info);
		}
		else{
			$("#siwahochi_data").html('請先登入食萬伙集!');
		}
		
		$('.swiper-container img').on('click', function(event) {
			localStorage['zoom_img'] = $(this).attr('url');
			location = 'zoom.html';
			event.preventDefault();
			/* Act on the event */
		});
	}, 300);

	$(".tab_container").css('height',window.innerHeight-320+'px');
	/*Tabs*/
	$("#menu a").on('click', function(event) {
		$(this).parent().parent().children('li').removeClass('active');
		$(this).parent().addClass('active');
		$(".tab_content").removeClass('active');
		$($(this).attr('href')).addClass('active');
		event.preventDefault();
		/* Act on the event */
	});
	/*加到最愛*/
	if(jQuery.inArray( shops.list[localStorage['shop_show_index']*1].shop_id, love.list ) != -1 ){
		$("#love_icon").addClass('active');
	}
	$("#love_icon").on('click', function(event) {
		if(jQuery.inArray( shops.list[localStorage['shop_show_index']*1].shop_id, love.list ) == -1 ){
			love.add(shops.list[localStorage['shop_show_index']*1].shop_id);
			$("#love_icon").addClass('active');
			alert('已加入我的最愛');
		}
		else{
			love.remove(shops.list[localStorage['shop_show_index']*1].shop_id);
			$("#love_icon").removeClass('active');
			alert('從我的最愛中移除');
		}
		event.preventDefault();
		/* Act on the event */
	});
	/*新增評論功能*/
	$("#add_commit_submit").on('click', function(event) {
		feature.add($("#add_commit_title").val(),$("#add_commit_data").val(),$("#add_commit_rank").val(),shops.list[localStorage['shop_show_index']*1].shop_id);
		$("#add_commit").css('display', 'none');
		$("#bg").css('display', 'none');
		event.preventDefault();
		/* Act on the event */
	});
	$("#add_commit_cancel").on('click', function(event) {
		$("#add_commit").css('display', 'none');
		$("#bg").css('display', 'none');
		event.preventDefault();
		/* Act on the event */
	});
	$("#add_commit_btn,#shop_rank").on('click', function(event) {
		$("#add_commit").css('display', 'block');
		$("#bg").css('display', 'block');
		event.preventDefault();
		/* Act on the event */
	});
	$("#time_data").on('click', function(event) {
		$("#business_hour").css('display', 'block');
		$("#bg").css('display', 'block');
		event.preventDefault();
		/* Act on the event */
	});
	$("#business_hour_cancel").on('click', function(event) {
		$("#business_hour").css('display', 'none');
		$("#bg").css('display', 'none');
		event.preventDefault();
		/* Act on the event */
	});
	$(".tab_container").swipe({
        //Generic swipe handler for all directions
        swipe:function(event, direction, distance, duration, fingerCount, fingerData) {
        },
        swipeStatus:function(event, phase, direction, distance, duration, fingers){
			if(distance>90 && distance<180){
				if(direction=="left"){
					$("#right").css('right', distance-90-180+'px');
					$("#left").css('left', -180+'px');
				}
				else{
					$("#left").css('left', distance-90-180+'px');
					$("#right").css('right', -180+'px');
				}
			}

        	if(phase=="cancel" || phase=="end"){
				if(distance>180){
					if(direction=="left"){
						shops.next_shop(1);
					}
					else{
						shops.next_shop(-1);
					}
				}
				$("#right").css('right', -180+'px');
				$("#left").css('left', -180+'px');
        	}
        },
        allowPageScroll:"vertical"
    });
});