$(document).ready(function($) {
	shops.load();
	love.load();
	setTimeout(function() {
		/* 排序方式 */
		if(localStorage['sort_type'] !== undefined){
			$("#sort").val(localStorage['sort_type']);
		}
		else{
			localStorage['sort_type'] = "distance";
		}
		/* 頁面切換 */
		if(localStorage['page'] === undefined){
			localStorage['page'] = 0;
		}
		shops.show_shoplist('',localStorage['page']*1);
		$("#shop_list_loading").css('display', 'none');

		/* 卷軸位置修正 */
		if(localStorage['scroll'] !== undefined){
			$(document).scrollTop(localStorage['scroll']);
		}
		else{
			localStorage['scroll'] = 0;
		}
		$(document).scroll(function() {
			localStorage['scroll'] = $(document).scrollTop();
		});

		/* 按紐事件 */
		$("#map").on('click', function(event) {
			location = 'location.html';
			event.preventDefault();
			/* Act on the event */
		});
		$("#filter").on('click', function(event) {
			filter.start('shop_list.html');
			event.preventDefault();
			/* Act on the event */
		});
		$("#sort").on('change', function(event) {
			var data = "";
			data+='<li>';
			data+='	<img src="css/icons/loading.gif" />';
			data+='	<div class="info">';
			data+='		<h2>載入店家資訊中....</h2>';
			data+='	</div>';
			data+='</li>';
			$('#shoplist_list').html(data);
			localStorage['sort_type'] = $(this).val();
			shops.show_shoplist('',0);
			localStorage['page'] = 0;
			$(document).scrollTop(0);
			event.preventDefault();
			/* Act on the event */
		});
		$(".search_btn").on('click', function(event) {
			var re = prompt('請輸入要尋找店名','');
			if(re!==null && re!==''){
				shops.show_shoplist(re,-1);
				$(document).scrollTop(0);
			}
			event.preventDefault();
			/* Act on the event */
		});
		$("#left").on('click', function(event) {
			var page = localStorage['page']*1;
			if((page-1)<0){
				alert('已經是第一頁了！');
			}
			else{
				localStorage['page'] = page-1;
				shops.show_shoplist('',page-1);
				$(document).scrollTop(0);
			}
			event.preventDefault();
			/* Act on the event */
		});
		$("#right").on('click', function(event) {
			var page = localStorage['page']*1;
			if((page+1)>=Math.ceil(shops.list.length/50)){
				alert('已經是最後一頁了！');
			}
			else{
				localStorage['page'] = page+1;
				shops.show_shoplist('',page+1);
				$(document).scrollTop(0);
			}
			event.preventDefault();
			/* Act on the event */
		});
	}, 300);
});
