// onCreateに相当
window.onload = function() {
	// findViewByIdに相当
	var btn1 = document.getElementById('btn1');
}

// setOnClickListnerに相当
var onButtonClick = function() {
    document.getElementById('div1').innerHTML = 'Hello World';
}

var horizontalNumbers = new Array(10);
var verticalNumbers = new Array(10);
var cursorX = 0;
var cursorY = 0;
var isStart = false;
var time = 0;
var passageID;

function start100masu() {
	writeNumbers();
	paintMasu();
	document.getElementById('p_time').innerHTML = '　0秒経過';
	passageID = setInterval("writeTime();",1000);
	document.getElementById("start_button").disabled = true; // スタートボタンの無効化
	document.getElementById("stop_button").disabled = false; // ストップボタンの有効化
	isStart = true;
}

function stop100masu() {
	document.getElementById("start_button").disabled = false; // スタートボタンの有効化
	document.getElementById("stop_button").disabled = true; // ストップボタンの無効化
	clearInterval(passageID);
	isStart = false;
	cursorX = 0;
	cursorY = 0;
	time = 0;
}

function writeNumbers() {
	initNumbers();

	for(i = 0; i < 10; i++){
		getHorizontalMasuElement(i).textContent = horizontalNumbers[i];
		getVerticalMasuElement(i).textContent = horizontalNumbers[i];
	}
	for(x = 0; x < 10; x++){
		for(y = 0; y < 10; y++){
			getMainMasuElement(x, y).textContent = "";
		}
	}
}

function writeTime()
{
	time++;
	document.getElementById('p_time').innerHTML = getTime();
}

function getTime() {
	sec = time % 60;
	min = (time - sec) / 60;
	if (min < 1) {
		return '　' + time + '秒経過';
	} else {
		return '　' + min + '分' + sec + '秒経過';
	}
}

function paintMasu() {
	// 全マスを白く塗る
	for(x = 0; x < 10; x++) {
		for(y = 0; y < 10; y++) {
			var mainMasu = document.getElementById('masu' + x + '-' + y);
			mainMasu.style.backgroundColor = "#FFFFFF";
			mainMasu.style.fontWeight = "normal";
		}
	}
	for(i = 0; i < 10; i++) {
		var selectedVerticalMasu = document.getElementById('horizontal' + i);
		selectedVerticalMasu.style.backgroundColor = "#FFFFFF";
		selectedVerticalMasu.style.fontWeight = "normal";
		var selectedVerticalMasu = document.getElementById('vertical' + i);
		selectedVerticalMasu.style.backgroundColor = "#FFFFFF";
		selectedVerticalMasu.style.fontWeight = "normal";
	}

	// カーソル位置を塗る
	getSelectedMainMasuElement().style.backgroundColor = "#FFCCCC";
	getSelectedHorizontalMasuElement().style.backgroundColor = "#FFCCCC";
	getSelectedVerticalMasuElement().style.backgroundColor = "#FFCCCC";
	getSelectedMainMasuElement().style.fontWeight = "bold";
	getSelectedHorizontalMasuElement().style.fontWeight = "bold";
	getSelectedVerticalMasuElement().style.fontWeight = "bold";
}

function writeMasu() {
	var html = "";

	html += '<p>上マスと左マスを足し算した値を入力してください。</p>';

	html += '<p>';

	html += '<table "masu_table">';
	html += '	<tr>';
	html += '		<td id = "sisoku">';
	html += '			＋';
	html += '		</td>';
	html += '	<td>';

	html = getHorizontalTableHtml(html); // 横マス

	html += '	</td>';
	html += '	</tr>';
	html += '	<tr>';
	html += '		<td>';

	html = getVerticalTableHtml(html); // 縦マス

	html += '		</td>';
	html += '		<td>';

	html = getMainTableHtml(html); //メインマス

	html += '		</td>';
	html += '	</tr>';
	html += '</table>';

	html += '</p>';
	
	html += '<table id="input_table">';
	html += '	<tr>';
	html += '		<td>';
	html += '			<input type="button" value="1" onclick="input(1);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="2" onclick="input(2);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="3" onclick="input(3);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="4" onclick="input(4);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="5" onclick="input(5);">';
	html += '		</td>';
	html += '		<td rowspan="2">';
	html += '			<input type="button" value="クリア" onclick="input_clear();">';
	html += '		</td>';
	html += '	</tr>';
	html += '	<tr>';
	html += '		<td>';
	html += '			<input type="button" value="6" onclick="input(6);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="7" onclick="input(7);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="8" onclick="input(8);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="9" onclick="input(9);">';
	html += '		</td>';
	html += '		<td>';
	html += '			<input type="button" value="0" onclick="input(0);">';
	html += '		</td>';
	html += '	</tr>';
	html += '</table>';


	document.getElementById('p_100masu').innerHTML = html;
}

function initNumbers() {
	for(i = 0; i < 10; i++) {
		horizontalNumbers[i] = getRandomNumber(2, 9);
	}
	for(i = 0; i < 10; i++) {
		verticalNumbers[i] = getRandomNumber(2, 9);
	}
}

function getHorizontalTableHtml(html) {
	// 横マス
	html += '<table id="horizontal_table" class = "masu_table">';
	html += '<tr>';
	for(i = 0; i < 10; i++){
		html += '<td id="horizontal' + i + '" >';
		html += '</td>';
	}
	html += '</tr>';
	html += '</table>';
	
	return html;
}

function getVerticalTableHtml(html) {
	// 縦マス
	html += '<table id="vertical_table" class = "masu_table">';
	for(i = 0; i < 10; i++){
		html += '<tr>';
		html += '<td id="vertical' + i + '" >';
		html += '</td>';
		html += '</tr>';
	}
	html += '</table>';

	return html;
}

function getMainTableHtml(html) {
	// メインマス
	html += '<table id="main_table" class = "masu_table">';
	for(i = 0; i < 10; i++) {
		html += '<tr>';
		for(j = 0; j < 10; j++){
			html += '<td id="masu' + j + '-' + i + '"' + '></td>';
		}
		html += '</tr>';
	}
	html += '</table>';
	
	return html;
}

function getRandomNumber(min, max) {
	return Math.floor(Math.random()*(max + 1 - min) + min);
}

function inputNumberMainMasu(number) {
	var selectedMainMasu = getSelectedMainMasuElement();
	if(number == "B") {
//		selectedMainMasu.textContent = selectedMainMasu.textContent.substr(0, selectedMainMasu.textContent.length - 1);
		selectedMainMasu.textContent = "";
		return;
	} 
	
	if(selectedMainMasu.textContent.length == 0) {
		selectedMainMasu.textContent = number;
	} else if (selectedMainMasu.textContent.length == 1){
		selectedMainMasu.textContent = selectedMainMasu.textContent + number;
	} else if (selectedMainMasu.textContent.length == 2){
		selectedMainMasu.textContent = number;
	}
	
	x = getSelectedHorizontalMasuElement().textContent;
	y = getSelectedVerticalMasuElement().textContent;
	if(selectedMainMasu.textContent == (Number(x) + Number(y))) {
		cursorPlus(); 
	} else {
		selectedMainMasu.style.backgroundColor = "#FFFF8F";
	}
}

function getSelectedMainMasuElement() {
	return document.getElementById('masu' + cursorX + '-' + cursorY);
}

function getSelectedHorizontalMasuElement() {
	return document.getElementById('horizontal' + cursorX);
}

function getSelectedVerticalMasuElement() {
	return document.getElementById('vertical' + cursorY);
}

function getMainMasuElement(x, y) {
	return document.getElementById('masu' + x + '-' + y);
}

function getHorizontalMasuElement(x) {
	return document.getElementById('horizontal' + x);
}

function getVerticalMasuElement(y) {
	return document.getElementById('vertical' + y);
}

function cursorPlus() {
	if(cursorX < 9) {
		cursorX++;
		paintMasu();
		return;
	} else {
		if(cursorY < 9) {
			cursorX = 0;
			cursorY++;
			paintMasu();
			return;
		} else {
			isStart = false;
			clearInterval(passageID);
			
			var result = "";
			sec = time % 60;
			min = (time - sec) / 60;
			if (min < 1) {
				result = '　' + time + '秒';
			} else {
				result = '　' + min + '分' + sec + '秒';
			}
			alert("結果：　" + result + "　でした");

			// カーソル位置を白く塗る
			getSelectedMainMasuElement().style.backgroundColor = "#FFFFFF";
			getSelectedHorizontalMasuElement().style.backgroundColor = "#FFFFFF";
			getSelectedVerticalMasuElement().style.backgroundColor = "#FFFFFF";

			document.getElementById("start_button").disabled = false; // スタートボタンの有効化
			document.getElementById("stop_button").disabled = true; // ストップボタンの無効化
			time = 0;
		}
	}
}

function input(i) {
	if(isStart == false) {
		return;
	}
	inputNumberMainMasu(i);
}

function input_clear() {
	if(isStart == false) {
		return;
	}
	inputNumberMainMasu("B");
}