var basicInfoCanvas = document.createElement('canvas');
var basicInfoContext = basicInfoCanvas.getContext("2d");

var topShadeImage = new Image();
var bottomShadeImage = new Image();

var questionButton = null;
var leftBasicButton = null;

var telenorNetworkInfo = false;

function loadBasicInfoImages() {
    topShadeImage.src = "images/top_shade.png";
    bottomShadeImage.src = "images/bottom_shade.png";
    
    topShadeImage.onload = loading;
    bottomShadeImage.onload = loading;
}

function initializeBasicInfo(size) {
    basicInfoCanvas.width = screenWidth;
    basicInfoCanvas.height = size;
}

function predrawBasicInfo() {
    basicInfoContext.clearRect(0, 0, basicInfoCanvas.width, basicInfoCanvas.height);
    var height = screenWidth * topShadeImage.height / topShadeImage.width;
    basicInfoContext.drawImage(topShadeImage, 0, 0, screenWidth, height);
    basicInfoContext.drawImage(bottomShadeImage, 0, basicInfoCanvas.height - height, screenWidth, height);    
    
    if (userAccount != null) {        
        if (userAccount.accountType == "prepaid" || userAccount.accountType == "hybrid") {
            for (i = 0; i < userAccount.params.length; i++) {
                var param = userAccount.params[i];
                if (param.key == "balance") {
                    drawText(basicInfoContext, param.name.toUpperCase(), screenWidth / 2 - dh10, basicInfoCanvas.height / 2 - d10, "MyLight", d14, textGrayColor, "right");
                    drawText(basicInfoContext, param.value.toUpperCase(), screenWidth / 2 - dh10, basicInfoCanvas.height / 2 + d10, "MyBold", d18, tab1Color, "right");
                }
                else if (param.key == "airtimeExpiry") {
                    drawText(basicInfoContext, param.name.toUpperCase(), screenWidth / 2 + dh10, d25, "MyLight", d14, textGrayColor, "left");
                    drawText(basicInfoContext, param.value.toUpperCase(), screenWidth / 2 + dh10, d39, "MyBold", d14, tab1Color, "left");
                }
                else if (param.key == "serviceExpiry") {
                    drawText(basicInfoContext, param.name.toUpperCase(), screenWidth / 2 + dh10, d51, "MyLight", d14, textGrayColor, "left");
                    drawText(basicInfoContext, param.value.toUpperCase(), screenWidth / 2 + dh10, d65, "MyBold", d14, tab1Color, "left");
                }
            }
        }
        else if(userAccount.accountType == "postpaid") {
            for (i = 0; i < userAccount.params.length; i++) {
                var param = userAccount.params[i];
                if (param.key == "balance") {
                    drawText(basicInfoContext, param.name.toUpperCase(), screenWidth / 2 - dh10, basicInfoCanvas.height / 2 - d10, "MyLight", d14, textGrayColor, "right");
                    drawText(basicInfoContext, param.value.toUpperCase(), screenWidth / 2 - dh10, basicInfoCanvas.height / 2 + d10, "MyBold", 18, tab1Color, "right");
                }
                else if (param.key == "lastBill") {
                    drawText(basicInfoContext, param.name.toUpperCase(), screenWidth / 2 + dh10, basicInfoCanvas.height / 2 - d10, "MyLight", d14, textGrayColor, "left");
                    drawText(basicInfoContext, param.value.toUpperCase(), screenWidth / 2 + dh10, basicInfoCanvas.height / 2 + d10, "MyBold", 18, tab1Color, "left");
                }
            }
            leftBasicButton = new BUTTON(0, iconSize, screenWidth / 2, iconSize, "?", executeLeftBasicButton);
            questionButton = new BUTTON(screenWidth / 2, iconSize, screenWidth / 2, iconSize, "?", executeQuestionButton);
            drawText(basicInfoContext, "?", screenWidth - dh15, iconSize - d15, "MyBold", d18, textGrayColor, "center");
        }        
    }
    if(telenorNetworkInfo){
        drawText(basicInfoContext, "Potrebno je povezati aplikaciju sa brojem telefona", screenWidth / 2, iconSize / 2 + d7, "MyLight", d14, tab1Color, "center");
    }
    else {
        drawVLine(basicInfoContext, screenWidth / 2, iconSize / 6, screenWidth / 2, 5 * iconSize / 6);
    }
}

function drawBasicInfo(context) {
    context.drawImage(basicInfoCanvas, 0, iconSize);
}

function executeQuestionButton(){
    prepareBasciInfoDialog();
    drawScreen();
}

function executeLeftBasicButton(){
    prepareLeftBasciInfoDialog();
    drawScreen();
}

function clickBasicInfo(x, y){
    if(questionButton != null){
        if(insideButton(questionButton, x, y)){
            questionButton.action();
        }
        else if(insideButton(leftBasicButton, x, y)){
            leftBasicButton.action();
        }
    }
}