var basicInfoTabCanvas = document.createElement('canvas');
var basicInfoTabContext = basicInfoTabCanvas.getContext("2d");

var barBlueImage = new Image();
var barGreenImage = new Image();
var barOrangeImage = new Image();
var barPurpleImage = new Image();

var gaugeFullImage = new Image();
var gaugeEmptyImage = new Image();

var barBlueCanvas = document.createElement('canvas');
var barGreenCanvas = document.createElement('canvas');
var barOrangeCanvas = document.createElement('canvas');
var barPurpleCanvas = document.createElement('canvas');

var barWidth = 0;
var barHeight = 0;

var barX = 0;

var animationWidth = 0;

var scrollYBasicInfoTab = 0;

var lastBasicInfoTabScroll = 0;

var maxBasicInfoHeight = 0;

var gaugeVoiceX = 0;
var gaugeSmsX = 0;

var gaugeHeight = 0;
var gaugesEnabled = "true";

function loadBasicInfoTabImages(){
    barBlueImage.src = "images/bar_full_blue.png";
    barGreenImage.src = "images/bar_full_green.png";
    barOrangeImage.src = "images/bar_full_orange.png";
    barPurpleImage.src = "images/bar_full_purple.png";     
    
    gaugeEmptyImage.src = "images/gauge_empty.png";
    gaugeFullImage.src = "images/gauge_full.png";
    
    barBlueImage.onload = loading;
    barGreenImage.onload = loading;
    barOrangeImage.onload = loading;
    barPurpleImage.onload = loading;
}

function predrawBasicInfoTab(){
    basicInfoTabContext.clearRect(0, 0, basicInfoTabCanvas.width, basicInfoTabCanvas.height);

    maxBasicInfoHeight = d20;
    if(userAccount != null){                
        drawText(basicInfoTabContext, userAccount.accountClass.name, screenWidth - dh10, d16, "MyBold", d14, textDarkColor, "right");
        for(var i = 0; i < userAccount.addons.length; i++){            
            drawBar(basicInfoTabContext, i, userAccount.addons[i]);
            drawAddon(basicInfoTabContext, i);
            maxBasicInfoHeight += 3 * barHeight;
        }
        gaugesEnabled = localStorage.getItem("111meniFFG");
        if(gaugesEnabled == "true"){
            drawGauges(basicInfoTabContext);
        }
    }        
}

function drawAddon(context, index){
    drawHLine(context, 0, (index + 1) * 3 * barHeight + d20, screenWidth, (index + 1) * 3 * barHeight + d20);
    drawRect(context, barX, index * 3 * barHeight + barHeight + d20, barWidth, barHeight);
}

function drawBar(context, index, addon){
    var v = 0;
    var mv = 0;    
    try {
        v = parseInt(addon.value);
        mv = parseInt(addon.maxValue);
    } catch(ex){
        console.log("GRESKA U STRINGETIMA");
    }    
    if(mv == 0){
        if(v == 0) width = 0;
        else width = 100;
    }
    else 
        width = v * 100 / mv;
    var w = barBlueCanvas.width * width / 100;
    if(animationWidth < width) {
        w = barBlueCanvas.width * animationWidth / 100;
    }    
    drawText(context, addon.name, screenWidth - dh10, index * 3 * barHeight + d20 + d16, "MyLight", d14, textGrayColor, "right");
    drawText(context, addon.value, screenWidth - dh10, index * 3 * barHeight + 2 * barHeight + d20 + d16, "MyBold", d14, textDarkColor, "right");
    if(w != 0) {    
        if(addon.color == "blue"){
            context.drawImage(barBlueCanvas, 0, 0, w, barBlueCanvas.height, barX, index * 3 * barHeight + barHeight + d20, w, barHeight);
        }
        if(addon.color == "green"){
            context.drawImage(barGreenCanvas, 0, 0, w, barBlueCanvas.height, barX, index * 3 * barHeight + barHeight + d20, w, barHeight);
        }
        else if(addon.color == "orange"){
            context.drawImage(barOrangeCanvas, 0, 0, w, barBlueCanvas.height, barX, index * 3 * barHeight + barHeight + d20, w, barHeight);
        }
        else if(addon.color == "purple"){
            context.drawImage(barPurpleCanvas, 0, 0, w, barBlueCanvas.height, barX, index * 3 * barHeight + barHeight + d20, w, barHeight);
        }       
        else {
            context.drawImage(barBlueCanvas, 0, 0, w, barBlueCanvas.height, barX, index * 3 * barHeight + barHeight + d20, w, barHeight);
        }
    }
}

function drawGauges(context){
    var w = screenWidth * 2 / 5;
    var h = w * gaugeEmptyImage.height / gaugeEmptyImage.width;    
    gaugeHeight = h;
    var r = w / 2;
    if(userAccount.specRecap.voice.number != ""){
        var v = 0;
        var mv = 0;
        try {
            v = parseInt(userAccount.specRecap.voice.sum);
            mv = parseInt(userAccount.specRecap.voice.total);
        } catch(ex){
            console.log("GRESKA U STRINGETIMA");
        }                
        if(mv > 0){
            var y = maxBasicInfoHeight + d20;
            var width = v * 100 / mv;
            if(animationWidth < width) {
                width = animationWidth;                
            }   
            var da = Math.PI * width / 100;               
            var dx = r - r * Math.cos(da);
            var dy = h - r * Math.sin(da);
            context.drawImage(gaugeEmptyImage, 0, 0, gaugeEmptyImage.width, gaugeEmptyImage.height, gaugeVoiceX, y, w, h);
            context.save();
            context.beginPath();        
            context.moveTo(gaugeVoiceX + r, y + h);
            context.lineTo(gaugeVoiceX + dx, y + dy)
            context.lineTo(gaugeVoiceX + dx, y);
            context.lineTo(gaugeVoiceX, y);
            context.lineTo(gaugeVoiceX, y + h);
            context.lineTo(gaugeVoiceX + r, y + h);
            context.clip();
            context.drawImage(gaugeFullImage, 0, 0, gaugeFullImage.width, gaugeEmptyImage.height, gaugeVoiceX, y, w, h)
            context.restore();
            drawText(context, userAccount.specRecap.voice.sum, gaugeVoiceX + r, y + h - d25, "MyBold", d12, textDarkColor, "center");
            drawText(context, "MIN", gaugeVoiceX + r, y + h - dh10, "MyLight", d12, textGrayColor, "center");
        }
    }
    if(userAccount.specRecap.sms.number != ""){
        var v = 0;
        var mv = 0;
        try {
            v = parseInt(userAccount.specRecap.sms.sum);
            mv = parseInt(userAccount.specRecap.sms.total);
        } catch(ex){
            console.log("GRESKA U STRINGETIMA");
        }                
        if(mv > 0){
            var y = maxBasicInfoHeight + d20;
            var width = v * 100 / mv;
            if(animationWidth < width) {
                width = animationWidth;                
            }   
            var da = Math.PI * width / 100;               
            var dx = r - r * Math.cos(da);
            var dy = h - r * Math.sin(da);
            context.drawImage(gaugeEmptyImage, 0, 0, gaugeEmptyImage.width, gaugeEmptyImage.height, gaugeSmsX, y, w, h);
            context.save();
            context.beginPath();        
            context.moveTo(gaugeSmsX + r, y + h);
            context.lineTo(gaugeSmsX + dx, y + dy)
            context.lineTo(gaugeSmsX + dx, y);
            context.lineTo(gaugeSmsX, y);
            context.lineTo(gaugeSmsX, y + h);
            context.lineTo(gaugeSmsX + r, y + h);
            context.clip();
            context.drawImage(gaugeFullImage, 0, 0, gaugeFullImage.width, gaugeEmptyImage.height, gaugeSmsX, y, w, h)
            context.restore();
            drawText(context, userAccount.specRecap.sms.sum, gaugeSmsX + r, y + h - d25, "MyBold", d12, textDarkColor, "center");
            drawText(context, "SMS", gaugeSmsX + r, y + h - dh10, "MyLight", d12, textGrayColor, "center");
        }
    }
    if(userAccount.specRecap.voice.number != "" || userAccount.specRecap.sms.number != "")
        drawText(context, "Najviše komuniciram", screenWidth / 2, y + h + d14, "MyLight", d14, textGrayColor, "center");
    maxBasicInfoHeight = y + h + d28;
}

function animateBasicInfo(redraw){
    if(currentTab == 1){
        requestAnimFrame(function() {
            animationWidth += 1.5;
            if(animationWidth > 100) {
                animationWidth = 100;
                predrawBasicInfoTab();
                redraw();
            }
            else {
                predrawBasicInfoTab(); 
                redraw();
                animateBasicInfo(redraw);
            }
        });
    }
}

function initializeBasicInfoTab(){        
    barWidth = screenWidth * 0.8;
    barHeight = barBlueCanvas.width * barBlueImage.height / barBlueImage.width; 
    
    basicInfoTabCanvas.width = screenWidth;    
    basicInfoTabCanvas.height = barHeight * 3 * 9;
    
    barX = Math.floor((screenWidth - barWidth) / 2);
    
    initializeBarImage(barBlueCanvas, barBlueImage);
    initializeBarImage(barGreenCanvas, barGreenImage);
    initializeBarImage(barOrangeCanvas, barOrangeImage);
    initializeBarImage(barPurpleCanvas, barPurpleImage);
    
    gaugeVoiceX = Math.floor(0.05 * screenWidth);
    gaugeSmsX = Math.floor(0.55 * screenWidth);
}

function initializeBarImage(canvas, image){
    canvas.width = barWidth;
    canvas.height = barHeight;
    
    var tmpContext = canvas.getContext("2d");
    tmpContext.drawImage(image, 0, 0, image.width, image.height, 0, 0, barWidth, barHeight);
}

function drawBasicInfoTab(context, index){
    context.drawImage(basicInfoTabCanvas, 0, scrollYBasicInfoTab, basicInfoTabCanvas.width, basicInfoTabCanvas.height - scrollYBasicInfoTab, 
        index * screenWidth, 0, basicInfoTabCanvas.width, basicInfoTabCanvas.height - scrollYBasicInfoTab);
}

function scrollBasicInfoTab(scrollY) {
    scrollYBasicInfoTab -= scrollY - lastBasicInfoTabScroll;    
    lastBasicInfoTabScroll = scrollY;
    if (maxBasicInfoHeight - scrollYBasicInfoTab < screenHeight - (2 * iconSize)) {
        scrollYBasicInfoTab = maxBasicInfoHeight - screenHeight + (2 * iconSize);
    }    
    if (scrollYBasicInfoTab < 0)
        scrollYBasicInfoTab = 0;    
}

function startBasicInfoTabScroll() {
    lastBasicInfoTabScroll = 0;    
}

function loadBasicInfoTab(){
    scrollYBasicInfoTab = 0;
    lastBasicInfoTabScroll = 0;
    animationWidth = 0;
    animateBasicInfo(drawScreen);    
}

function clickBasicInfoTab(x, y){     
    var dy = scrollYBasicInfoTab + y - 2 * iconSize;
    if(dy > maxBasicInfoHeight - gaugeHeight - scrollYBasicInfoTab - d40) {
        if(x > screenWidth / 2) prepareGaugeDialog(userAccount.specRecap.sms.number, "Broj telefona");
        else prepareGaugeDialog(userAccount.specRecap.voice.number, "Broj telefona");
    }
}