var currentDialog = 0;

var dialogCanvas = document.createElement('canvas');
var dialogContext = dialogCanvas.getContext("2d");

var buttonHeight = d40;

var buttons = [];

var dialogWidth = 0;
var dialogHeight = 0;

var dialogX = 0;
var dialogY = 0;

var buttonHeight = 0;
var buttonFontSize = 0;

var dialogColor = 0;

function initializeDialogs() {
    dialogCanvas.width = screenWidth;
    dialogCanvas.height = screenHeight;

    dialogWidth = screenWidth * 5 / 6;
}

function drawDialog(context) {
    if (currentDialog == 1) {
        showServiceUnavailableDialog(context, getTabColor(currentTab));
    }
    else if (currentDialog == 2) {
        showInternetDialog(context, dialogColor);
    }
    else if (currentDialog == 3) {
        showAboutDialog(context, textDarkColor);
    }
    else if (currentDialog == 4) {
        showGaugeDialog(context, tab2Color);
    }
    else if (currentDialog == 5) {
        showAPIDialog(context, getTabColor(currentTab));
    }
    else if (currentDialog == 6) {
        if(currentTab == 3)
            showBasicInfoDialog(context, textDarkColor);
        else 
            showBasicInfoDialog(context, getTabColor(currentTab));
    }
    else if (currentDialog == 7) {        
        if(currentTab == 3) 
            showLeftBasicInfoDialog(context, textDarkColor);
        else
            showLeftBasicInfoDialog(context, getTabColor(currentTab));
    }
    else if(currentDialog == 8){
        showRegisterInfoDialog(context, getTabColor(currentTab));
    }
    else if(currentDialog == 9){
        showConfirmDialog(context, getTabColor(currentTab));
    }
}

function prepareAPIDialog(head, content, color) {
    dialogColor = color;
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    drawText(dialogContext, head, 0, d15, "MyLight", d14, 'white', 'left');
    dialogHeight = drawTextWrap(dialogContext, content, 0, d35, dialogWidth, "MyLight", d14, 'white', "left");
    dialogHeight += d60;

    var bw = dialogWidth / 6;
    var bx1 = (screenWidth - bw) / 2;
    var by = (screenHeight - dialogHeight - d20) / 2 + dialogHeight - d40;

    buttons.push(new BUTTON(bx1, by, bw, d40, "OK", cancelAPIDialog));

    currentDialog = 5;
}

function showAPIDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
}

function showInfoDialog(context, color) {
    var w = screenWidth * 2 / 3;
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    var h = drawTextWrap(dialogContext, "Nema interneta", 0, d20, w, "MyBold", d20, 'white', "left");
    fillRect(context, (screenWidth - w - dh20) / 2, (screenHeight - h - d) / 2, w + dh20, h + d20, tab1Color);
    context.drawImage(dialogCanvas, 0, 0, w, h, (screenWidth - w) / 2, (screenHeight - h) / 2, w, h);
}

function showInfoFailDialog(context, color) {
    var w = screenWidth * 2 / 3;
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    var h = drawTextWrap(dialogContext, "Servis nije dostupan", 0, d20, w, "MyBold", d20, 'white', "left");
    fillRect(context, (screenWidth - w - dh20) / 2, (screenHeight - h - d20) / 2, w + dh20, h + d20, tab1Color);
    context.drawImage(dialogCanvas, 0, 0, w, h, (screenWidth - w) / 2, (screenHeight - h) / 2, w, h);
}

function prepareInternetDialog(confirmAction, color) {
    dialogColor = color;
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    dialogHeight = drawTextWrap(dialogContext, "Ova akcija će pokrenuti Internet pretraživač", 0, d20, dialogWidth, "MyLight", d20, 'white', "left");
    dialogHeight += d60;

    var bw = 3 * dialogWidth / 8;
    var bx1 = screenWidth / 2 - dh10 - bw;
    var bx2 = screenWidth / 2 + 10;
    var by = (screenHeight - dialogHeight - d20) / 2 + dialogHeight - d40;

    buttons.push(new BUTTON(bx1, by, bw, d40, "Prihvati", confirmAction));
    buttons.push(new BUTTON(bx2, by, bw, d40, "Odustani", cancelDialog));

    currentDialog = 2;
}

function showInternetDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
    drawButton(context, buttons[1], 'white', color);
}

function prepareServiceUnavailableDialog() {
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    dialogHeight = drawTextWrap(dialogContext, "Servis trenutno nije dosupan. Provjerite internet konekciju.", 0, d20, dialogWidth, "MyLight", d20, 'white', "left");
    dialogHeight += d60;

    var bw = dialogWidth / 6;
    var bx1 = (screenWidth - bw) / 2;
    var by = (screenHeight - dialogHeight - d20) / 2 + dialogHeight - d40;

    buttons.push(new BUTTON(bx1, by, bw, d40, "OK", cancelDialog));

    currentDialog = 1;
}

function showServiceUnavailableDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
}

function prepareAboutDialog() {
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    dialogHeight = drawTextWrap(dialogContext, "Copyright by Telenor doo 2014\nDeveloped by panRobotics doo, Beograd.\nVersion 3.1", 0, d20, dialogWidth, "MyLight", d20, 'white', "left");
    dialogHeight += d60;

    var bw = dialogWidth / 6;
    var bx1 = (screenWidth - bw) / 2;
    var by = (screenHeight - dialogHeight - d20) / 2 + dialogHeight - d40;

    buttons.push(new BUTTON(bx1, by, bw, d40, "OK", cancelDialog));

    currentDialog = 3;
}

function prepareGaugeDialog(number, title) {
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    dialogHeight = drawTextWrap(dialogContext, title, dialogWidth / 2, d20, dialogWidth, "MyLight", d14, 'white', "center");
    dialogHeight += drawTextWrap(dialogContext, number, dialogWidth / 2, dialogHeight + d20, dialogWidth, "MyLight", d18, 'white', "center");
    dialogHeight += d60;

    var bw = dialogWidth / 6;
    var bx1 = (screenWidth - bw) / 2;
    var by = (screenHeight - dialogHeight - d20) / 2 + dialogHeight - d40;

    buttons.push(new BUTTON(bx1, by, bw, d40, "OK", cancelDialog));

    currentDialog = 4;
}

function showGaugeDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
}

function showAboutDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
}

function dialogClick(x, y) {
    if (currentDialog == 1) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
    }
    else if (currentDialog == 2) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
        else if (insideButton(buttons[1], x, y))
            buttons[1].action();
    }
    else if (currentDialog == 3) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
    }
    else if (currentDialog == 4) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
    }
    else if (currentDialog == 5) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
    }
    else if (currentDialog == 6) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
    }
    else if (currentDialog == 7) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
    }
    else if (currentDialog == 8) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
    }
    else if (currentDialog == 9) {
        if (insideButton(buttons[0], x, y))
            buttons[0].action();
        else if (insideButton(buttons[1], x, y))
            buttons[1].action();
    }
}

function cancelAPIDialog() {
    currentDialog = 0;
    refreshApp();
    drawScreen();
}

function cancelDialog() {
    currentDialog = 0;
    drawScreen();
}

function prepareInputDialog(option) {
    document.getElementById('inputDialog').style.display = 'block';
    var str = "";
    for (var i = 0; i < option.inputs.length; i++) {
        str += "<p id=\"inputDialogContent\">";
        str += option.inputs[i].name;
        str += "</p>";
        str += "<input class=\"input\" type=\"text\" id=\"myInput" + i + "\" value=\"" + option.inputs[i].value + "\">";
    }
    str += "<br><table width=\"100%\"><tr>";
    str += "<td width=\"50%\"><button id=\"inputDialogButton\" onclick=\"inputDialogAction()\">" + option.name + "</button></td>";
    str += "<td width=\"50%\"><button id=\"cancelInputButton\" onclick=\"cancelInputDialogAction()\">Odustani</button></td>";
    str += "</tr></table>";
    document.getElementById('inputDialog').innerHTML = str;

    currentDialog = 99;
}

function cancelInputDialogAction(){
    document.getElementById('inputDialog').style.display = 'none';
    currentDialog = 0;
}

function inputDialogAction() {
    document.getElementById('inputDialog').style.display = 'none';
    var inputStr = executeOption.action + "?";
    for (var i = 0; i < executeOption.inputs.length; i++) {
        executeOption.inputs[i].value = document.getElementById('myInput' + i).value;
        if (i > 0)
            inputStr += "&";
        inputStr += executeOption.inputs[i].id + "=" + executeOption.inputs[i].value;
    }    
    executeFunction(inputStr);
    currentDialog = 0;
}

function prepareBasciInfoDialog() {
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    var str = "";
    for (i = 0; i < userAccount.params.length; i++) {
        var param = userAccount.params[i];
        if (param.key == "telenorAccountNumber") {
            drawText(dialogContext, param.name, 0, d25, "MyLight", d14, 'white', 'left');
            drawText(dialogContext, param.value, 0, d40, "MyLight", d14, 'white', 'left');
        }
    }
    for (i = 0; i < userAccount.params.length; i++) {
        var param = userAccount.params[i];
        if (param.key == "lastBill") {
            drawText(dialogContext, param.name, 0, d40 + d15, "MyLight", d14, 'white', 'left');
            drawText(dialogContext, param.value, 0, d70, "MyLight", d14, 'white', 'left');
        }
    }
    for (i = 0; i < userAccount.params.length; i++) {
        var param = userAccount.params[i];
        if (param.key == "billingNumber") {
            drawText(dialogContext, param.name, 0, d70 + d15, "MyLight", d14, 'white', 'left');
            drawText(dialogContext, param.value, 0, d100, "MyLight", d14, 'white', 'left');
        }
    }
    for (i = 0; i < userAccount.params.length; i++) {
        var param = userAccount.params[i];
        if (param.key == "lastBill-1") {
            drawText(dialogContext, param.name, 0, d100 + d15, "MyLight", d14, 'white', 'left');
            drawText(dialogContext, param.value, 0, d100 + 2 * d15, "MyLight", d14, 'white', 'left');
        }
    }
    for (i = 0; i < userAccount.params.length; i++) {
        var param = userAccount.params[i];
        if (param.key == "billingNumber-1") {
            drawText(dialogContext, param.name, 0, d100 + 3 * d15, "MyLight", d14, 'white', 'left');
            drawText(dialogContext, param.value, 0, d100 + 4 * d15, "MyLight", d14, 'white', 'left');
        }
    }
    for (i = 0; i < userAccount.params.length; i++) {
        var param = userAccount.params[i];
        if (param.key == "lastBill-2") {
            drawText(dialogContext, param.name, 0, d100 + 5 * d15, "MyLight", d14, 'white', 'left');
            drawText(dialogContext, param.value, 0, d100 + 6 * d15, "MyLight", d14, 'white', 'left');
        }
    }
    for (i = 0; i < userAccount.params.length; i++) {
        var param = userAccount.params[i];
        if (param.key == "billingNumber-2") {
            drawText(dialogContext, param.name, 0, d100 + 7 * d15, "MyLight", d14, 'white', 'left');
            drawText(dialogContext, param.value, 0, d100 + 8 * d15, "MyLight", d14, 'white', 'left');
        }
    }
    dialogHeight = d160 * 2;

    var bw = dialogWidth / 6;
    var bx1 = (screenWidth - bw) / 2;
    var by = (screenHeight - dialogHeight - d20) / 2 + dialogHeight - d40;

    buttons.push(new BUTTON(bx1, by, bw, d40, "OK", cancelDialog));

    currentDialog = 6;
}

function showBasicInfoDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
}

function prepareLeftBasciInfoDialog() {
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    drawText(dialogContext, "Trenutno zaduženje", 0, d25, "MyLight", d18, 'white', 'left');
    drawText(dialogContext, "Trenutno zaduženje je bez pretplate i PDV-a", 0, d50, "MyLight", d18, 'white', 'left');        
    dialogHeight = d120;

    var bw = dialogWidth / 6;
    var bx1 = (screenWidth - bw) / 2;
    var by = (screenHeight - dialogHeight - 20) / 2 + dialogHeight - 40;

    buttons.push(new BUTTON(bx1, by, bw, 40, "OK", cancelDialog));

    currentDialog = 7;
}

function showLeftBasicInfoDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - 20) / 2, (screenHeight - dialogHeight - 20) / 2, dialogWidth + 20, dialogHeight + 20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
}

function prepareRegisterDialog(){
    document.getElementById('registerDialog').style.display = 'block';
    var str = "";

    str += "<br><table width=\"100%\">";
    str += "<tr><td><p id=\"registerDialogContent\">Unesite vaš broj</p></td></tr>";
    str += "<tr><td width=\"70%\">";    
    str += "<input class=\"registerInput\" type=\"text\" id=\"phoneInput\" value=\"06\">";
    str += "</p></td>";     
    str += "<td width=\"30%\"><button id=\"registerDialogButton\" onclick=\"sendPhoneAction()\">Potvrdite</button></td></tr>";    
    str += "<tr><td><p id=\"registerDialogContent\">Unesite dobijeni kod</p></td></tr>";
    str += "<tr><td width=\"70%\">";    
    str += "<input class=\"registerInput\" type=\"text\" id=\"codeInput\" value=\"\">";
    str += "</p></td>";     
    str += "<td width=\"30%\"><button id=\"registerDialogButton\" onclick=\"sendCodeAction()\">Potvrdite</button></td>";    
    str += "</tr></table>";
    document.getElementById('registerDialog').innerHTML = str;

    currentDialog = 66;
}

function sendPhoneAction(){
    loadRegPhone(document.getElementById('phoneInput').value);        
}

function handleRegResponse(){    
    if(userReg.token != null && userReg.token != ""){
        saveToken(userReg.token);
        register = false;
        refreshApp();
    }
    else {
        prepareRegisterInfoDialog();
        drawScreen();   
    }
}

function sendCodeAction(){
    loadRegCode(document.getElementById('codeInput').value);
}

function prepareRegisterInfoDialog() {    
    document.getElementById('registerDialog').style.display = 'none';
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    drawText(dialogContext, userReg.head, 0, d25, "MyLight", d18, 'white', 'left');
    drawText(dialogContext, userReg.content, 0, d50, "MyLight", d18, 'white', 'left');        
    dialogHeight = d120;

    var bw = dialogWidth / 6;
    var bx1 = (screenWidth - bw) / 2;
    var by = (screenHeight - dialogHeight - 20) / 2 + dialogHeight - 40;

    buttons.push(new BUTTON(bx1, by, bw, 40, "OK", cancelRegisterDialog));

    currentDialog = 8;
} 

function cancelRegisterDialog(){
    document.getElementById('registerDialog').style.display = 'block';
    currentDialog = 66;
    drawScreen();
}

function showRegisterInfoDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
}

function showRegisterDialog(show){
    if(show) {        
        if(register) {
            currentDialog = 66;
            document.getElementById('registerDialog').style.display = 'block';
        }
        else {
            if(currentDialog == 66) currentDialog = 0;
            document.getElementById('registerDialog').style.display = 'none';
        }
    }
    else {
        if(currentDialog == 66) currentDialog = 0;
        document.getElementById('registerDialog').style.display = 'none';
    }
}

function prepareConfirmDialog(message, bt1, bt2, confirmAction) {    
    buttons = [];
    dialogContext.clearRect(0, 0, screenWidth, screenHeight);
    dialogHeight = drawTextWrap(dialogContext, message, 0, d20, dialogWidth, "MyLight", d20, 'white', "left");
    dialogHeight += d60;

    var bw = 3 * dialogWidth / 8;
    var bx1 = screenWidth / 2 - dh10 - bw;
    var bx2 = screenWidth / 2 + 10;
    var by = (screenHeight - dialogHeight - d20) / 2 + dialogHeight - d40;

    buttons.push(new BUTTON(bx1, by, bw, d40, bt1, confirmAction));
    buttons.push(new BUTTON(bx2, by, bw, d40, bt2, cancelDialog));

    currentDialog = 9;
}

function showConfirmDialog(context, color) {
    fillRect(context, (screenWidth - dialogWidth - dh20) / 2, (screenHeight - dialogHeight - d20) / 2, dialogWidth + dh20, dialogHeight + d20, color);
    context.drawImage(dialogCanvas, 0, 0, dialogWidth, dialogHeight, (screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2, dialogWidth, dialogHeight);

    drawButton(context, buttons[0], 'white', color);
    drawButton(context, buttons[1], 'white', color);
}