var extrasTabCanvas = document.createElement('canvas');
var extrasTabContext = extrasTabCanvas.getContext("2d");

var arrowRightWhiteImage = new Image();
var infoImage = new Image();
var settingsImage = new Image();
var helpImage = new Image();

var scrollYExtrasTab = 0;
var lastExtrasTabScroll = 0;

var maxExtrasHeight = 0;

var currentExtrasPage = 0;

var pages = [];

var extrasButtons = [];

var extrasTabLoaded = false;

var extrasBackButton;

var extrasStartY = 0;

var executeOption;
var executeFunction;

function loadExtrasTabImages() {
    arrowRightWhiteImage.src = "images/arrow_right_white.png";
    infoImage.src = "images/info.png";
    settingsImage.src = "images/settings.png";
    helpImage.src = "images/help.png";
}

function initializeExtrasTab() {
    extrasTabCanvas.width = screenWidth;
    extrasTabCanvas.height = screenHeight * 3;

    maxExtrasHeight = extrasTabCanvas.height;
}

function predrawExtrasTab() {
    extrasTabContext.clearRect(0, 0, extrasTabCanvas.width, extrasTabCanvas.height);
    
    extrasButtons = [];
    extrasBackButton = null;
    if(pages.length > 0){
        extrasStartY = d70;
        if(currentExtrasPage != 0){            
            drawText(extrasTabContext, pages[currentExtrasPage].head, dh20, d25, "MyBold", d14, textDarkColor, "left");
            extrasBackButton = new BUTTON(dh20, d30, dh60, d30, "< Nazad", executeExtrasBackAction);
            drawButton(extrasTabContext, extrasBackButton, tab4Color, "white");
            if(pages[currentExtrasPage].content != ""){
                extrasStartY = drawTextWrap(extrasTabContext, pages[currentExtrasPage].content, dh20, extrasStartY + d10, screenWidth - dh40, "MyLight", d14, textGrayColor, "left");
                extrasStartY += d10;
            }
        }
        else {
            extrasStartY = d30;
        }
        maxExtrasHeight = extrasStartY;
        for (var i = 0; i < pages[currentExtrasPage].options.length; i++) {
            drawExtras(pages[currentExtrasPage].options[i], i);
        }        
        if(currentExtrasPage == 0){
            drawExtrasFirstPage(extrasTabContext);            
        }
    }                    
}

function drawExtras(option, index){
    if(option.type == "MAPS"){
        var bx = dh20;
        var bw = screenWidth - 2 * dh20;
        var by = maxExtrasHeight;    
        var h = 2 * d100;
        for (var i = 0; i < option.maps.results; i++){            
            var by = maxExtrasHeight + d4; 
            var mapsOption = option.maps.options[i];     
            var res = mapsOption.map.content.split("\n");
            drawText(extrasTabContext, mapsOption.name, dh20, by, "MyBold", d14, textDarkColor, "left");
            maxExtrasHeight = by + d14;
            for (var j = 0; j < res.length; j++){
                drawText(extrasTabContext, res[j], dh20, maxExtrasHeight, "MyLight", d14, textDarkColor, "left");
                maxExtrasHeight = maxExtrasHeight + d4 + d14;
            }
            //extrasTabContext.drawImage(mapsOption.picture, 0, 0, mapsOption.picture.width, mapsOption.picture.height, dh20, maxExtrasHeight, bw, h);                                                
            //maxExtrasHeight = maxExtrasHeight + h;            
        }
        var button = new BUTTON(0, 0, 0, 0, "", executeExtrasAction);
        extrasButtons.push(button);
    }
    else if(option.type == "MAP"){
        var by = maxExtrasHeight + d4;     
        var res = option.map.content.split("\n");
        drawText(extrasTabContext, option.name, dh20, by, "MyBold", d14, textDarkColor, "left");
        maxExtrasHeight = by + d14;
        for (var j = 0; j < res.length; j++){
            drawText(extrasTabContext, res[j], dh20, maxExtrasHeight, "MyLight", d14, textDarkColor, "left");
            maxExtrasHeight = maxExtrasHeight + d4 + d14;
        }
    }
    else {
        var h = iconSize / 2;
        var bx = dh20;
        var bw = screenWidth - 2 * dh20;
        var by = maxExtrasHeight;    

        var button = new BUTTON(dh20, by, screenWidth - dh40, h, option.name, executeExtrasAction);
        extrasButtons.push(button);
        drawExtrasButton(extrasTabContext, button, tab4Color, "white");
        extrasTabContext.drawImage(arrowRightWhiteImage, 0, 0, arrowRightWhiteImage.width, arrowRightWhiteImage.height, screenWidth - dh40, by + (h - d20) / 2, dh10, d20);
        maxExtrasHeight = by + h + d4;
    }
}

function drawExtrasFirstPage(context){    
    context.drawImage(infoImage, 0, 0, infoImage.width, infoImage.height, dh20, maxExtrasHeight + d20, dh40, d40);
    context.drawImage(settingsImage, 0, 0, settingsImage.width, settingsImage.height, screenWidth / 2 - dh20, maxExtrasHeight + d20, dh40, d40);
    context.drawImage(helpImage, 0, 0, helpImage.width, helpImage.height, screenWidth - dh60, maxExtrasHeight + d20, dh40, d40);
    maxExtrasHeight += d20 + helpImage.height + d20;
}

function drawExtrasTab(context, index) {        
    context.drawImage(extrasTabCanvas, 0, scrollYExtrasTab, extrasTabCanvas.width, extrasTabCanvas.height - scrollYExtrasTab,
            index * screenWidth, 0, extrasTabCanvas.width, extrasTabCanvas.height - scrollYExtrasTab);                
}

function scrollExtrasTab(scrollY) {
    scrollYExtrasTab -= scrollY - lastExtrasTabScroll;
    lastExtrasTabScroll = scrollY;    
    if (maxExtrasHeight - scrollYExtrasTab < screenHeight - (2 * iconSize)) {
        scrollYExtrasTab = maxExtrasHeight - screenHeight + (2 * iconSize);
    }
    if (scrollYExtrasTab < 0)
        scrollYExtrasTab = 0;
}

function startExtrasTabScroll() {
    lastExtrasTabScroll = 0;
}

function clickExtrasTab(x, y) { 
    var dy = scrollYExtrasTab + y - 2 * iconSize; 
    if(currentExtrasPage == 0){
        if(insideRect(dh20, screenHeight - d60, dh40, d40, x, y)){                    
            prepareAboutDialog();
            return;
        }
        else if(insideRect(screenWidth / 2 - dh20, screenHeight - d60, dh40, d40, x, y)){            
            window.location.replace("settings.html");
            return;
        }                
        else if(insideRect(screenWidth - dh60, screenHeight - d60, dh40, d40, x, y)){            
            prepareInternetDialog(gotoHelp, textDarkColor);
            return;
        }                
    }
    else {
        if(insideButton(extrasBackButton, x, dy)){
            extrasBackButton.action();
            return;
        }
    }        
    for(var i = 0; i < extrasButtons.length; i++){
        if(insideButton(extrasButtons[i], x, dy)){    
            extrasButtons[i].action(i);
            break;
        }
    }    
}

function executeExtrasBackAction(){                
    if(pages.length > 1) pages.pop();
    currentExtrasPage = pages.length - 1;   
    scrollYExtrasTab = 0;
    predrawExtrasTab();
    drawScreen();
}

function executeExtrasAction(index) {        
    var tmpPage = pages[currentExtrasPage];
    executeOption = tmpPage.options[index];
    console.log(executeOption.name);
    if(executeOption.type == "PAGE"){        
        pages.push(tmpPage.options[index].page);
        currentExtrasPage += 1;
        scrollYExtrasTab = 0;
        predrawExtrasTab();
        drawScreen();
    }
    else if(executeOption.type == "URL"){        
        prepareInternetDialog(executeExtrasURL, textDarkColor);
    }
    else if(executeOption.type == "API"){
        executeExtrasAPI();
    }
}

function loadExtrasTab(){
    lastExtrasTabScroll = 0;
    scrollYExtrasTab = 0;
    currentExtrasPage = 0;
    pages = [];    
    if(userExtras != null){
        pages.push(userExtras.page);        
    }
    predrawExtrasTab();
    drawScreen();
}

function drawExtrasButton(context, button, backColor, frontColor){
    fillRect(context, button.x, button.y, button.width, button.height, backColor);
    drawText(context, button.text, button.x + dh20, button.y + button.height / 2 + d8, "MyBold", d16, frontColor, "left");
}

function gotoHelp(){    
    openNewWindow("https://api.telenor.rs/mymenu/pages/o-aplikaciji.php");
    currentDialog = 0;
    drawScreen();
}

function executeExtrasURL(){    
    openNewWindow(executeOption.action);
    currentDialog = 0;
    drawScreen();
}

function executeExtrasAPI(){
    if(executeOption.inputs.length > 0){
        prepareInputDialog(executeOption);
        executeFunction = loadExtrasAPI;
        console.log("INPUTS " + executeOption.inputs.length)
    }
    else {
        loadExtrasAPI(executeOption.action);
    }
}

function handleExtrasAPI(){
    stopExtrasWait();
    if(userExtrasAPI.template == "TAB"){
        //if(userExtrasAPI.page.options[0].maps != null){
        //    for(var i = 0; i < userExtrasAPI.page.options[0].maps.results; i++){                 
        //        userExtrasAPI.page.options[0].maps.options[i].picture.src = "http://api.telenor.rs" + userExtrasAPI.page.options[0].maps.options[i].image;
        //        userExtrasAPI.page.options[0].maps.options[i].picture.onload = new onMapLoad();
        //    }
        //}
        pages.push(userExtrasAPI.page);
        currentExtrasPage += 1;
        scrollYExtrasTab = 0;
        predrawExtrasTab();
        drawScreen();
    }
    else if(userExtrasAPI.template == "ERROR" || userExtrasAPI.template == "INFO"){
        prepareAPIDialog(userExtrasAPI.page.head, userExtrasAPI.page.content, textDarkColor);
        drawScreen();
    }
}

function onMapLoad(){
    predrawExtrasTab();
    drawScreen();
}