var tab1Color = "#08aae8";
var tab2Color = "#ed008c";
var tab3Color = "#f4781e";
var tab4Color = "#94a83d";
var lineGray = "#BABABA";
var textGrayColor = "#989898";
var textDarkColor = "#000000";

var currentTab = 2;
var register = false;
var nextTab = 2;
var tongueX = 0;
var previousTab = -1;

var contentCanvas;

function getTabColor(tabIndex) {
    var c = tab1Color;
    switch (tabIndex) {
        case 0:
            c = tab1Color;
            break;
        case 1:
            c = tab2Color;
            break;
        case 2:
            c = tab3Color;
            break;
        case 3:
            c = tab4Color;
            break;
    }
    return c;
}

function drawText(context, message, x, y, font, size, color, align) {    
    context.fillStyle = color;
    context.textAlign = align;
    context.font = size + "px " + font;    
    context.fillText(message, x, y);
}

function drawHLine(context, x1, y1, x2, y2) {
    y1 = Math.floor(y1) + 0.5;
    y2 = Math.floor(y2) + 0.5;
    x1 = Math.floor(x1);
    x2 = Math.floor(x2);
    drawLine(context, x1, y1, x2, y2);
}

function drawVLine(context, x1, y1, x2, y2) {
    x1 = Math.floor(x1) + 0.5;
    x2 = Math.floor(x2) + 0.5;
    y1 = Math.floor(y1);
    y2 = Math.floor(y2);
    drawLine(context, x1, y1, x2, y2);
}

function drawLine(context, x1, y1, x2, y2) {
    context.beginPath();
    context.moveTo(x1, y1);
    context.lineTo(x2, y2);
    context.strokeStyle = lineGray;
    context.stroke();
}

function drawRect(context, x, y, width, height) {
    context.beginPath();
    x = Math.floor(x) + 0.5;
    y = Math.floor(y) + 0.5;
    width = Math.floor(width);
    height = Math.floor(height);
    context.rect(x, y, width, height);
    context.lineWidth = 1;
    context.strokeStyle = lineGray;
    context.stroke();
}

function fillRect(context, x, y, width, height, color) {        
    context.fillStyle = color;
    context.fillRect(x, y, width, height);
}

function drawTextWrap(context, message, x, y, maxWidth, font, size, color, align) {
    var tmpY = y;
    context.fillStyle = color;
    context.textAlign = align;
    context.font = size + "px " + font
    lineHeight = 5 * size / 4;
    
    if(message == null) message = '';
    var words = message.split(' ');
    var line = '';

    for (var n = 0; n < words.length; n++) {
        var testLine = line + words[n] + ' ';
        var metrics = context.measureText(testLine);
        var testWidth = metrics.width;
        if (testWidth > maxWidth && n > 0) {
            context.fillText(line, x, tmpY);
            line = words[n] + ' ';
            tmpY += lineHeight;
        }
        else { 
            line = testLine;
        }
    }
    context.fillText(line, x, tmpY);
    return tmpY;
}

window.requestAnimFrame = (function(callback) {
    return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame ||
            function(callback) {
                window.setTimeout(callback, 1000 / 60);
            };
})();

function getNodeValue(xmlData, name) {
    var value = "";
    if (xmlData != null) {
        var tmpXML = xmlData.getElementsByTagName(name) [0];
        if (tmpXML != null) {
            var tmpNode = tmpXML.childNodes[0];
            if (tmpNode != null) {
                value = tmpNode.nodeValue;
            }
        }
    }
    return value;
}

function getNodeArray(xmlData, name, arrayToFill, elementParser) {
    if (xmlData != null) {
        var nodes = xmlData.childNodes;
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].nodeName == name) {
                var element = new elementParser(nodes[i]);
                arrayToFill.push(element);
            }
        }
    }
}

function getChildNode(xmlData, name) {
    if (xmlData != null) {
        var nodes = xmlData.childNodes;
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].nodeName == name) {
                return nodes[i];
            }
        }
    }
    return null;
}

function printXML(xmlData) {
    if (xmlData != null) {
        var xml_serializer = new XMLSerializer();
        var txt = xml_serializer.serializeToString(xmlData);
        console.log("-----------------------------------------------");
        console.log(txt);
        console.log("-----------------------------------------------");
    }
    else {
        console.log("NULL");
    }
}

function openNewWindow(link) {
    window.open(link);
}

function drawButton(context, button, backColor, frontColor){
    fillRect(context, button.x, button.y, button.width, button.height, backColor);
    drawText(context, button.text, button.x + button.width / 2, button.y + button.height / 2 + d8, "MyBold", d16, frontColor, "center");
}

function insideButton(button, cx, cy){
    if(cx < button.x) return false;
    if(cx > button.x + button.width) return false;
    if(cy < button.y) return false;
    if(cy > button.y + button.height) return false;    
    return true;
}

function insideRect(x, y, w, h, cx, cy){
    if(cx < x) return false;
    if(cx > x + w) return false;
    if(cy < y) return false;
    if(cy > y + h) return false;
    return true;
}

function BUTTON(x, y, width, height, text, action){
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
    this.text = text;
    this.action = action;
}