var zeroTabCanvas = document.createElement('canvas');
var zeroTabContext = zeroTabCanvas.getContext("2d");

var tmpFeedCanvas = document.createElement('canvas');
var tmpFeedContext = tmpFeedCanvas.getContext("2d");

var bannerImage = new Image();

var isBannerLoaded = false;

var y = 0;

var scrollYZeroTab = 0;
var lastZeroTabScroll = 0;

var maxZeroHeight = 0;

var rssHeights = [];

var selectedFeed = 0;

var bannerHeight = 0;

var animationZeroWidth = 0;

var isFeedDrawn = false;

function initializeZeroTab(){        
    zeroTabCanvas.width = screenWidth;    
    zeroTabCanvas.height = screenHeight * 5;                
    
    tmpFeedCanvas.width = screenWidth;
    tmpFeedCanvas.height = screenHeight - 2 * iconSize;        
}

function loadedBanner(){
    bannerHeight = screenWidth * bannerImage.height / bannerImage.width;
    isBannerLoaded = true;
    stopBannerWait();
    animateZero(drawScreen);
}

function loadBanner(){
    if(userHome != null){
        if(userHome.info != null){
            if(userHome.info.options[0] != null){
                if(userHome.info.options[0].name != null){
                    bannerImage.src = userHome.info.options[0].name;                    
                    bannerImage.onload = loadedBanner;
                }
            }
        }
    }
}

function animateZero(redraw){
    if(currentTab == 2){
        requestAnimFrame(function() {
            animationZeroWidth += 3;
            if(animationZeroWidth > 100) {
                animationZeroWidth = 100;
                predrawZeroTab();
                redraw();
            }
            else {
                predrawZeroTab(); 
                redraw();
                animateZero(redraw);
            }
        });
    }
}

function predrawZeroTab(){        
    if(isBannerLoaded){
        zeroTabContext.clearRect(0, 0, zeroTabCanvas.width, bannerHeight);
        var dx = 50 - 50 * animationZeroWidth / 100;
        var dy = 30 - 30 * animationZeroWidth / 100;
        
        var dw = 0.7 * bannerImage.width + 0.3 * bannerImage.width * animationZeroWidth / 100;
        var dh = 0.7 * bannerImage.height + 0.3 * bannerImage.height * animationZeroWidth / 100;
        
        zeroTabContext.drawImage(bannerImage, dx, dy, dw, dh, 0, 0, screenWidth, bannerHeight);            
    }
    
    if(!isFeedDrawn){
        zeroTabContext.clearRect(0, bannerHeight, zeroTabCanvas.width, zeroTabCanvas.height - bannerHeight);
        if(thefeeds != null){
            y = bannerHeight;
            rssHeights = [];
            for(var i = 0; i < thefeeds.length; i++){
                drawFeed(thefeeds[i].title, thefeeds[i].contentSnippet);
                drawHLine(zeroTabContext, 0, y, screenWidth, y);
            }
            maxZeroHeight = y;
            isFeedDrawn = true;
        }        
    }
}

function drawFeed(title, content){    
    tmpFeedContext.clearRect(0, 0, screenWidth, screenHeight);   
    var h = drawTextWrap(tmpFeedContext, title, dh10, d20, screenWidth - dh20, "MyBold", d14, tab3Color, "left");
    h = drawTextWrap(tmpFeedContext, content, dh10, h + d20, screenWidth - dh20, "MyLight", d14, textGrayColor, "left");    
    h += d10;    
    zeroTabContext.drawImage(tmpFeedCanvas, 0, 0, screenWidth, h, 0, y, screenWidth, h);
    y += h;    
    rssHeights.push(h);
}

function drawZeroTab(context, index){
    context.drawImage(zeroTabCanvas, 0, scrollYZeroTab, zeroTabCanvas.width, zeroTabCanvas.height - scrollYZeroTab,
            index * screenWidth, 0, zeroTabCanvas.width, zeroTabCanvas.height - scrollYZeroTab);
}

function scrollZeroTab(scrollY) {
    scrollYZeroTab -= scrollY - lastZeroTabScroll;
    lastZeroTabScroll = scrollY;
    if (scrollYZeroTab < 0)
        scrollYZeroTab = 0;
    if (maxZeroHeight - scrollYZeroTab < screenHeight - (2 * iconSize)) {
        scrollYZeroTab = maxZeroHeight - screenHeight + (2 * iconSize);
    }
}

function startZeroTabScroll() {
    lastZeroTabScroll = 0;
}

function clickZeroTab(x, y){    
    if (y > 2 * iconSize) {        
        var dy = scrollYZeroTab + y - 2 * iconSize - d20;
        selectedFeed = -1;
        if(dy < bannerHeight){
            prepareInternetDialog(executeBanner, tab3Color);            
        }        
        else {
            var h = bannerHeight;                
            for(var i = 0; i < rssHeights.length; i++){
                h += rssHeights[i];
                if(dy < h) {
                    selectedFeed = i;
                    break;
                }
            }             
            if(selectedFeed >= 0){
                prepareInternetDialog(executeFeed, tab3Color);            
            }
        }
    }    
}

function executeBanner(){    
    openNewWindow(userHome.info.options[0].action);
    currentDialog = 0;
    drawScreen();
}

function executeFeed(){    
    openNewWindow(thefeeds[selectedFeed].link);
    currentDialog = 0;
    drawScreen();
}

function loadScreenZeroTab(){
    lastZeroTabScroll = 0;
    scrollYZeroTab = 0;
    animationZeroWidth = 0;
    animateZero(drawScreen);
}