var userHome = null;
var userAccount = null;
var userOffers = null;
var userSlots = null;
var userExtras = null;

var userExtrasAPI = null;
var userOffersAPI = null;

var userInit = null;

var userReg = null;

var homeClient = new XMLHttpRequest();
var accountClient = new XMLHttpRequest();
var offersClient = new XMLHttpRequest();
var extrasClient = new XMLHttpRequest();

var extrasAPIClient = new XMLHttpRequest();
var offersAPIClient = new XMLHttpRequest();

var proxy = {
    host: '192.168.246.005',
    port: 8080
}
var initClient = new XMLHttpRequest(proxy);

var regClient = new XMLHttpRequest();

var token = "";

function INIT(xmlInit) {
    if (xmlInit != null) {
        this.initToken = getNodeValue(xmlInit, "token");
    }
}

function HOME(xmlHome) {
    if (xmlHome != null) {
        this.accountType = getNodeValue(xmlHome, "accountType");

        this.info = new INFO(getChildNode(xmlHome, "info"));
    }
}

function INFO(xmlInfo) {
    if (xmlInfo != null) {
        this.head = getNodeValue(xmlInfo, "head");
        this.content = getNodeValue(xmlInfo, "content");

        this.options = [];

        var xmlOptions = getChildNode(xmlInfo, "options");
        getNodeArray(xmlOptions, "option", this.options, OPTION);
    }
}

function OPTION(xmlOption) {
    if (xmlOption != null) {
        this.type = getNodeValue(xmlOption, "type");
        this.name = getNodeValue(xmlOption, "name");
        this.action = getNodeValue(xmlOption, "action");
        this.image = getNodeValue(xmlOption, "image");
        if(this.image != ""){
            this.picture = new Image();
            this.picture.src = this.image;
        }

        var xmlConfirm = getChildNode(xmlOption, "confirm");
        this.confirm = new CONFIRM(xmlConfirm);

        var xmlPage = getChildNode(xmlOption, "page");
        this.page = new PAGE(xmlPage);

        this.inputs = [];
        var xmlInputs = getChildNode(xmlOption, "inputs");
        getNodeArray(xmlInputs, "input", this.inputs, INPUT);
    }
}

function CONFIRM(xmlConfirm) {
    if (xmlConfirm != null) {
        this.message = getNodeValue(xmlConfirm, "message");
        this.yes = getNodeValue(xmlConfirm, "yes");
        this.no = getNodeValue(xmlConfirm, "no");
    }
}

function PAGE(xmlPage) {
    if (xmlPage != null) {
        this.head = getNodeValue(xmlPage, "head");
        this.content = getNodeValue(xmlPage, "content");

        this.options = [];

        var xmlOptions = getChildNode(xmlPage, "options");
        getNodeArray(xmlOptions, "option", this.options, OPTION);
    }
}

function INPUT(xmlInput) {
    this.id = getNodeValue(xmlInput, "id");
    this.type = getNodeValue(xmlInput, "type");
    this.name = getNodeValue(xmlInput, "name");
    this.value = getNodeValue(xmlInput, "value");
}

function ACCOUNT(xmlAccount) {
    this.accountType = getNodeValue(xmlAccount, "type");
    this.largeAccount = getNodeValue(xmlAccount, "largeAccount");

    this.accountClass = new ACCOUNTCLASS(getChildNode(xmlAccount, "class"));

    this.params = [];

    var xmlParams = getChildNode(xmlAccount, "params");
    getNodeArray(xmlParams, "param", this.params, PARAM);

    this.addons = [];

    var xmlAddons = getChildNode(xmlAccount, "addons");
    getNodeArray(xmlAddons, "addon", this.addons, ADDON);

    this.specRecap = new SEPCRECAP(getChildNode(xmlAccount, "specRecap"));
}

function ACCOUNTCLASS(xmlClass) {
    this.id = getNodeValue(xmlClass, "id");
    this.name = getNodeValue(xmlClass, "name");
}

function PARAM(xmlParam) {
    this.key = getNodeValue(xmlParam, "key");
    this.name = getNodeValue(xmlParam, "name");
    this.value = getNodeValue(xmlParam, "value");
}

function ADDON(xmlAddon) {
    this.id = getNodeValue(xmlAddon, "id");
    this.name = getNodeValue(xmlAddon, "name");
    this.value = getNodeValue(xmlAddon, "value");
    this.maxValue = getNodeValue(xmlAddon, "maxValue");
    this.unit = getNodeValue(xmlAddon, "unit");
    this.description = getNodeValue(xmlAddon, "description");
    this.color = getNodeValue(xmlAddon, "color");
}

function SEPCRECAP(xmlSpecRecap) {
    this.date = getNodeValue(xmlSpecRecap, "date");
    this.voice = new VOICE(getChildNode(xmlSpecRecap, "voice"));
    this.sms = new SMS(getChildNode(xmlSpecRecap, "sms"));
}

function VOICE(xmlVoice) {
    this.number = getNodeValue(xmlVoice, "number");
    this.sum = getNodeValue(xmlVoice, "sum");
    this.total = getNodeValue(xmlVoice, "total");
}

function SMS(xmlSms) {
    this.number = getNodeValue(xmlSms, "number");
    this.sum = getNodeValue(xmlSms, "sum");
    this.total = getNodeValue(xmlSms, "total");
}

function MENU(xmlMenu) {
    this.template = getNodeValue(xmlMenu, "template");
    var xmlPage = getChildNode(xmlMenu, "page");
    this.page = new PAGE(xmlPage);
}

function REG(xmlDoc){
    var xmlReg = getChildNode(getChildNode(xmlDoc, "response"), "menu");
    var xmlPage = getChildNode(xmlReg, "page");    
    this.template = getNodeValue(xmlReg, "template");
    this.head = getNodeValue(xmlPage, "head");
    this.content = getNodeValue(xmlPage, "content");
    var xmlInit = getChildNode(getChildNode(xmlDoc, "response"), "init");
    this.token = getNodeValue(xmlInit, "token");    
}

function SLOTS(xmlDoc){
    this.totalSlots = getNodeValue(xmlDoc, "totalSlots");
    this.freeSlots = getNodeValue(xmlDoc, "freeSlots");
    
    var xmlFreeSlotOption = getChildNode(xmlDoc, "freeSlotOption")
    this.freeSlotOption = new OPTION(xmlFreeSlotOption);
    this.takenSlotsOptions = [];

    var xmlOptions = getChildNode(xmlDoc, "takenSlotsOptions");
    getNodeArray(xmlOptions, "option", this.takenSlotsOptions, OPTION);
    
    console.log(this.takenSlotsOptions.length);    
}

function parseHomeListener() {
    var xmlDoc = getResponse(homeClient);
    var xmlHome = getChildNode(getChildNode(xmlDoc, "response"), "home");
    userHome = new HOME(xmlHome);
    finishHome();
}

function parseAccountListener() {
    var xmlDoc = getResponse(accountClient);
    if(xmlDoc != null){
        var xmlAccount = getChildNode(getChildNode(xmlDoc, "response"), "account");    
        userAccount = new ACCOUNT(xmlAccount);
    }
    else register = true;    
    predrawBasicInfo();
    predrawBasicInfoTab();
    if(register) {        
        currentTab = 0;
        nextTab = 0;
        predrawBasicInfo();
        predrawBasicInfoTab();
        loadCurrentTab();        
    }
    drawScreen();
}

function parseOffersListener() {
    var xmlDoc = getResponse(offersClient);
    userOffers = null;
    if (xmlDoc != null) {
        var xmlMenu = getChildNode(getChildNode(xmlDoc, "response"), "menu");
        userOffers = new MENU(xmlMenu);
        var xmlSlots = getChildNode(getChildNode(xmlDoc, "response"), "slots");
        userSlots = new SLOTS(xmlSlots);
    }
    stopOffersWait();
    loadOffersTab();
}

function parseExtrasListener() {
    var xmlDoc = getResponse(extrasClient);
    userExtras = null;
    if (xmlDoc != null) {
        var xmlMenu = getChildNode(getChildNode(xmlDoc, "response"), "menu");
        userExtras = new MENU(xmlMenu);
    }
    stopExtrasWait();
    loadExtrasTab();
}

function parseExtrasAPIListener() {
    var xmlDoc = getResponse(extrasAPIClient);
    userExtrasAPI = null;
    if (xmlDoc != null) {
        var xmlMenu = getChildNode(getChildNode(xmlDoc, "response"), "menu");
        userExtrasAPI = new MENU(xmlMenu);
    }

    handleExtrasAPI();
}

function parseOffersAPIListener() {
    var xmlDoc = getResponse(offersAPIClient);
    userOffersAPI = null;
    if (xmlDoc != null) {
        var xmlMenu = getChildNode(getChildNode(xmlDoc, "response"), "menu");
        userOffersAPI = new MENU(xmlMenu);
    }

    handleOffersAPI();
}

function parseInitListener() {
    var xmlDoc = getResponse(initClient);
    userinit = null;
    if (xmlDoc != null) {
        var xmlInit = getChildNode(getChildNode(xmlDoc, "response"), "init");
        userInit = new INIT(xmlInit);
        if (userInit.initToken != null) {
            if (userInit.initToken != "") {
                saveToken(userInit.initToken);
            }
        }
    }
    finishInit();
}

function parseRegListener(){
    var xmlDoc = getResponse(regClient);    
    if (xmlDoc != null){                
        userReg = new REG(xmlDoc);
        handleRegResponse();
    }
}

function loadRegPhone(msisdn){    
    loadRegisterXMLDoc(parseRegListener, errorHomeListener, "https://api.telenor.me/mymenu/init/msisdn/?msisdn=" + msisdn, regClient);
}

function loadRegCode(code){    
    loadRegisterXMLDoc(parseRegListener, errorHomeListener, "https://api.telenor.me/mymenu/init/sms/?code=" + code, regClient);
}

function loadInit() {
    loadInitXMLDoc(parseInitListener, errorHomeListener, "http://api.telenor.me/mymenu/init/", initClient);
}

function loadHome() {
    loadXMLDoc(parseHomeListener, errorHomeListener, "https://api.telenor.me/mymenu/home/", homeClient);
}

function loadAccount() {
    loadXMLDoc(parseAccountListener, errorAccountListener, "https://api.telenor.me/mymenu/account/", accountClient);
}

function loadOffers() {
    loadXMLDoc(parseOffersListener, errorOffersListener, "https://api.telenor.me/mymenu/offers/", offersClient);
}

function loadExtras() {
    loadXMLDoc(parseExtrasListener, errorExtrasListener, "https://api.telenor.me/mymenu/services/", extrasClient);
}

function loadExtrasAPI(url) {
    startExtrasWait();
    loadXMLDoc(parseExtrasAPIListener, errorExtrasListener, url, extrasAPIClient);
}

function loadOffersAPI(url) {
    startOffersWait();
    loadXMLDoc(parseOffersAPIListener, errorOffersListener, url, offersAPIClient);
}

function getResponse(webClient) {
    if (webClient.status == 200) {
        token = webClient.getResponseHeader("X-TELENOR-API-TOKEN");
        if (token != null)
            saveToken(token);
        if (webClient.responseText != null) {
            var xmlParser = new DOMParser();
            var xmlDoc = xmlParser.parseFromString(webClient.responseText, "text/xml");

            var xmlStatus = xmlDoc.getElementsByTagName("status") [0];

            var code = xmlStatus.getElementsByTagName("code") [0].childNodes[0].nodeValue;
            var message = xmlStatus.getElementsByTagName("message") [0].childNodes[0].nodeValue;

            telenorNetworkInfo = false;
            if (code != "0") {
                var n = parseInt(code);
                if (n > -100)
                    telenorNetworkInfo = true;
                else
                    prepareServiceUnavailableDialog();
                return null;
            }
            else
                return xmlDoc;
        }
        else {
            prepareServiceUnavailableDialog();
            return null;
        }
    }
    else {
        prepareServiceUnavailableDialog();
    }
    return null;
}

function errorInitListener() {
    finishInit();
}

function errorHomeListener() {
    stopBasicInfoWait();
    prepareServiceUnavailableDialog();
    drawScreen();
}

function errorExtrasListener() {
    stopExtrasWait();
    prepareServiceUnavailableDialog();
    drawScreen();
}

function errorOffersListener() {
    stopOffersWait();
    prepareServiceUnavailableDialog();
    drawScreen();
}

function errorAccountListener() {
    prepareServiceUnavailableDialog();
    drawScreen();
}

function loadXMLDoc(listener, errorListener, urlPath, webClient) {
    try {
        webClient.onload = listener;
        webClient.onerror = errorListener;
        webClient.open("GET", urlPath, true);
        token = loadToken();
        //token = "";
        //token = "9c6a2ca296df552c9cf94ec816ea4f67b2a6a43f80a61660826923660ae3f26c52bdd1ea09f4eff7643314de369668a5729f11fd1cac0c6d6b332f76b8945838";
        webClient.setRequestHeader("X-Telenor-API-Version", "2.1", false);
        webClient.setRequestHeader("X-Telenor-API-ID", "ca5a151fcf5a6af2669c5eaca84d5877", false);
        webClient.setRequestHeader("X-TELENOR-API-TOKEN", token, false);
        webClient.send();
    }
    catch (ex) {
        console.log("ERROR");
        prepareServiceUnavailableDialog();
    }
}

function loadInitXMLDoc(listener, errorListener, urlPath, webClient) {
    try {
        webClient.onload = listener;
        webClient.onerror = errorListener;
        webClient.open("GET", urlPath, true);
        webClient.setRequestHeader("X-Telenor-API-Version", "2.1", false);
        webClient.setRequestHeader("X-Telenor-API-ID", "ca5a151fcf5a6af2669c5eaca84d5877", false);
        webClient.setRequestHeader("X-TELENOR-API-TOKEN", token, false);
        webClient.send();
    }
    catch (ex) {
        console.log("ERROR");
        prepareServiceUnavailableDialog();
    }
}

function saveToken(token) {
    localStorage.setItem("123meniFFT", token);
}

function loadToken() {
    return localStorage.getItem("123meniFFT");
}

function loadRegisterXMLDoc(listener, errorListener, urlPath, webClient) {
    try {
        webClient.onload = listener;
        webClient.onerror = errorListener;
        webClient.open("GET", urlPath, true);        
        webClient.setRequestHeader("X-Telenor-API-Version", "2.1", false);
        webClient.setRequestHeader("X-Telenor-API-ID", "ca5a151fcf5a6af2669c5eaca84d5877", false);
        webClient.send();
    }
    catch (ex) {
        console.log("ERROR");
        prepareServiceUnavailableDialog();
    }
}