var iconSize = 0;

var icon1Image = new Image();
var icon2Image = new Image();
var icon3Image = new Image();
var icon4Image = new Image();

var icon1FImage = new Image();
var icon2FImage = new Image();
var icon3FImage = new Image();
var icon4FImage = new Image();

var tmpIconCanvas = document.createElement('canvas');
var tmpIconContext = tmpIconCanvas.getContext("2d");

function loadIconImages() {
    icon1Image.src = "images/ic_tab_offers_default.png"
    icon2Image.src = "images/ic_tab_basicinfo_default.png";
    icon3Image.src = "images/ic_tab_screenzero_default.png";
    icon4Image.src = "images/ic_tab_extras_default.png";

    icon1FImage.src = "images/ic_tab_offers_selected.png"
    icon2FImage.src = "images/ic_tab_basicinfo_selected.png";
    icon3FImage.src = "images/ic_tab_screenzero_selected.png";
    icon4FImage.src = "images/ic_tab_extras_selected.png";
    
    icon1Image.onload = loading;
    icon2Image.onload = loading;
    icon3Image.onload = loading;
    icon4Image.onload = loading;
    
    icon1FImage.onload = loading;
    icon2FImage.onload = loading;
    icon3FImage.onload = loading;
    icon4FImage.onload = loading;
}

function initializeIcons(size) {
    iconSize = size;
}

function drawBackIcons(context) {
    context.drawImage(icon1Image, 0, 0, iconSize, iconSize);
    context.drawImage(icon2Image, iconSize, 0, iconSize, iconSize);
    context.drawImage(icon3Image, 2 * iconSize, 0, iconSize, iconSize);
    context.drawImage(icon4Image, 3 * iconSize, 0, iconSize, iconSize);
}

function getFrontIconImage(index) {
    switch (index) {
        case 0:
            return icon1FImage;
        case 1:
            return icon2FImage;
        case 2:
            return icon3FImage;
        case 3:
            return icon4FImage;
    }
}

function drawFrontIcons(context, tongueX) {
    if (tongueX > 0) {
        drawFrontIcon(context, getFrontIconImage(currentTab), currentTab, false);
        drawFrontIcon(context, getFrontIconImage(currentTab + 1), currentTab + 1, true);
    }
    else if (tongueX < 0) {
        drawFrontIcon(context, getFrontIconImage(currentTab), currentTab, true);
        drawFrontIcon(context, getFrontIconImage(currentTab - 1), currentTab - 1, false);
    }
    else {
        context.drawImage(getFrontIconImage(currentTab), currentTab * iconSize, 0, iconSize, iconSize);
    }
}

function drawFrontIcon(context, iconImage, index, leftToRight) {
    tmpIconContext.clearRect(0, 0, iconSize, iconSize);
    tmpIconContext.drawImage(iconImage, 0, 0, iconSize, iconSize);
    var width = tongueX;
    if (tongueX < 0)
        width = iconSize + tongueX;
    if (leftToRight) {
        context.drawImage(tmpIconCanvas, 0, 0, width, iconSize, index * iconSize, 0, width, iconSize);
    }
    else {
        context.drawImage(tmpIconCanvas, width, 0, iconSize - width, iconSize, index * iconSize + width, 0, iconSize - width, iconSize);
    }
}

function drawTongue(context, moveX) {
    context.beginPath();
    tongueX = (-moveX) / 4;
    if (tongueX < 0 && currentTab == 0)
        tongueX = 0;
    if (tongueX > 0 && currentTab == 3)
        tongueX = 0;
    context.rect(currentTab * iconSize + tongueX, 0, iconSize, iconSize);
    var c = getTabColor(currentTab);
    if (nextTab != currentTab)
        c = getTabColor(nextTab);
    context.fillStyle = c;
    context.fill();
}

function drawTongueEnd(context, moveX) {
    context.beginPath();
    var dy = iconSize / 3;
    var radius = iconSize / 6 * Math.sqrt(13);
    var da = Math.asin(iconSize / 3 / radius);
    context.arc(currentTab * iconSize + tongueX + iconSize / 2, 2 * iconSize - dy, radius, da, Math.PI - da, false);    
    var c = getTabColor(currentTab);
    if (nextTab != currentTab)
        c = getTabColor(nextTab);
    context.fillStyle = c;
    context.fill();
}