var canvas = null;
var context = null;

var screenWidth = 0;
var screenHeight = 0;

var startTouchX = 0;
var startTouchY = 0;

var endTouchX = 0;
var endTouchY = 0;

var moveTouchX = 0;
var moveTouchY = 0;

var scrolling = false;
var scrollDirection = 0;

var loadedResources = 0;

function initializeCanvas() {
    canvas = window.document.getElementById('myCanvas');

    canvas.width = screenWidth;
    canvas.height = screenHeight;    

    contentCanvas = document.createElement('canvas');
    contentContext = contentCanvas.getContext("2d");

    contentCanvas.width = 4 * screenWidth;
    contentCanvas.height = screenHeight - screenWidth / 21;

    context = canvas.getContext("2d");

    context.font = '10px MyBold';
    context.fillText('', 20, 10);
    context.font = '10px MyLight';
    context.fillText('', 20, 10);
}

function drawScreen() {
    context.clearRect(0, 0, screenWidth, screenHeight);

    drawBackIcons(context);
    drawTongue(context, moveTouchX);
    drawFrontIcons(context, tongueX);
    drawBasicInfo(context);
    contentContext.clearRect(0, 0, contentCanvas.width, contentCanvas.height);
    drawOffersTab(contentContext, 0);
    drawBasicInfoTab(contentContext, 1);
    drawZeroTab(contentContext, 2);
    drawExtrasTab(contentContext, 3);
    drawContent(context);
    drawTongueEnd(context);
    drawDialog(context);
    
    displayWait(context);
}

function drawContent(context) {
    var dx = -moveTouchX;
    if (currentTab == 0 && dx < 0)
        dx = 0;
    if (currentTab == 3 && dx > 0)
        dx = 0;
    context.drawImage(contentCanvas, currentTab * screenWidth + dx, 0, screenWidth, contentCanvas.height, 0, iconSize * 2, screenWidth, contentCanvas.height);
}

function endSwipe(moveX) {
    nextTab = currentTab;    
    if (Math.abs(moveX) > screenWidth / 2) {
        if (moveX > 0)
            nextTab--;
        else
            nextTab++;
        if (nextTab > 3)
            nextTab = 3;
        else if (nextTab < 0)
            nextTab = 0;
    }
}

function addTouchStart(canvas) {
    canvas.addEventListener("touchstart", function(evt) {
        touches = evt.touches;
        touch = touches[0];

        startTouchX = touch.pageX;
        startTouchY = touch.pageY;

        endTouchX = startTouchX;
        endTouchY = startTouchY;

        moveTouchX = 0;
        moveTouchY = 0;

        if (startTouchY > 2 * iconSize) {
            if (currentTab == 0) {
                startOffersTabScroll();
            }
            else if (currentTab == 1) {
                startBasicInfoTabScroll();
            }
            else if (currentTab == 2) {
                startZeroTabScroll();
            }
            else if (currentTab == 3) {
                startExtrasTabScroll();
            }
        }

    }, false);
}

function addTouchEnd(canvas) {
    canvas.addEventListener("touchend", function(evt) {
        if (currentDialog != 0 && currentDialog != 66) {
            if (startTouchX == endTouchX && startTouchY == endTouchY) {
                dialogClick(startTouchX, startTouchY);
            }
        }
        else {
            if (startTouchY < iconSize) {
                if (startTouchX == endTouchX && startTouchY == endTouchY) {
                    nextTab = (startTouchX - (startTouchX % iconSize)) / iconSize;
                    if (nextTab != currentTab) {
                        currentTab = nextTab;
                        loadCurrentTab();
                        drawScreen();
                    }
                }
            }
            else if(startTouchY < 2 * iconSize){
                clickBasicInfo(startTouchX, startTouchY);
            }
            else {
                if (startTouchX == endTouchX && startTouchY == endTouchY) {
                    if (currentTab == 0) {
                        clickOffersTab(startTouchX, startTouchY);
                    }
                    else if (currentTab == 1) {
                        clickBasicInfoTab(startTouchX, startTouchY);
                    }
                    else if (currentTab == 2) {
                        clickZeroTab(startTouchX, startTouchY);
                    }
                    else if (currentTab == 3) {
                        clickExtrasTab(startTouchX, startTouchY);
                    }
                }
                else {
                    if (scrollDirection == 2) {
                        endSwipe(moveTouchX);
                        moveTouchX = 0;
                        currentTab = nextTab;
                        loadCurrentTab();
                    }
                }
                drawScreen();
            }
            scrolling = false;
        }
    }, false);
}

function addTouchMove(canvas) {
    canvas.addEventListener("touchmove", function(evt) {
        touches = evt.touches;
        touch = touches[0];

        endTouchX = touch.pageX;
        endTouchX = touch.pageY;

        moveTouchX = 1.4 * (touch.pageX - startTouchX);
        if(moveTouchX <= -screenWidth) moveTouchX = -screenWidth + 1;
        if(moveTouchX >= screenWidth) moveTouchX = screenWidth - 1;
        moveTouchY = touch.pageY - startTouchY;

        if (currentDialog != 0 && currentDialog != 66) {
            //console.log("DIALOG");
        }
        else {
            if (startTouchY > 2 * iconSize) {
                if (!scrolling) {
                    if (Math.abs(moveTouchY) > Math.abs(moveTouchX))
                        scrollDirection = 1;
                    else
                        scrollDirection = 2;
                    scrolling = true;
                }
                if (scrollDirection == 1) {
                    if (currentTab == 0) {
                        scrollOffersTab(moveTouchY);
                    }
                    else if (currentTab == 1) {
                        scrollBasicInfoTab(moveTouchY);
                    }
                    else if (currentTab == 2) {
                        scrollZeroTab(moveTouchY);
                    }
                    else if (currentTab == 3) {
                        scrollExtrasTab(moveTouchY);
                    }
                    moveTouchX = 0;
                }
                else {
                    endSwipe(moveTouchX);
                }
                drawScreen();
            }
        }
    }, false);
}

loadGoogle();

loadWait();
loadIconImages();
loadBasicInfoImages();
loadBasicInfoTabImages();
loadOffersTabImages();
loadExtrasTabImages();

window.onload = function() {
    var pin = localStorage.getItem("123meniFFP");
    var checkPin = localStorage.getItem("123meniFFC");  
    if(checkPin != "true"){
        if(pin != null && pin.length > 0){
            window.location.replace("checkpin.html");
        }
    }
    else {
        localStorage.setItem("123meniFFC", "false");  
    }
    
    screenWidth = window.innerWidth;
    screenHeight = window.innerHeight - 10;

    calculateDimensions();

    initializeCanvas();

    initializeIcons(screenWidth / 4);

    initializeBasicInfo(iconSize);

    initializeDialogs();

    initializeOffersTab();
    initializeBasicInfoTab();
    initializeZeroTab();
    initializeExtrasTab();

    addTouchStart(canvas);
    addTouchEnd(canvas);
    addTouchMove(canvas);

    setTimeout(finishLoading, 1000);
    
    prepareRegisterDialog();
    showRegisterDialog(false);
}

function startApp() {
    startBasicInfoWait();
    loadInit();     
}

function finishInit(){
    loadHome();        
}

function finishHome() {
    stopBasicInfoWait();
    loadAccount();

    startBannerWait();
    startRssWait();
    loadBanner();
    setTimeout(rssFeedSetup, 1000);

    loadCurrentTab();

    drawScreen();    
}

function loadCurrentTab() {
    if (previousTab != currentTab) {
        if (currentTab == 0) {
            if (!offersTabLoaded) {
                startOffersWait();
                loadOffers();
                offersTabLoaded = true;
            }
            loadOffersTab();
            showRegisterDialog(true);
        }
        if (currentTab == 1) {
            loadBasicInfoTab();
            showRegisterDialog(false);
        }
        if (currentTab == 2) {
            loadScreenZeroTab();
            showRegisterDialog(false);
        }
        else if (currentTab == 3) {
            if (!extrasTabLoaded) {
                startExtrasWait();
                loadExtras();
                extrasTabLoaded = true;
            }
            else
                loadExtrasTab();
            showRegisterDialog(false);
        }
    }
    previousTab = currentTab;
}

function finishLoading() {
    startApp();

    predrawBasicInfo();
    predrawOffersTab();
    predrawZeroTab();
    predrawExtrasTab();

    drawScreen();
    
    setTimeout(refreshApp, 900000);
}

function loading() {
    loadedResources += 1;
}

function refreshApp(){
    window.location.reload();   
    localStorage.setItem("123meniFFC", "true"); 
}