var offersTabCanvas = document.createElement('canvas');
var offersTabContext = offersTabCanvas.getContext("2d");

var tmpOfferCanvas = document.createElement('canvas');
var tmpOfferContext = tmpOfferCanvas.getContext("2d");

var arrowDownImage = new Image();
var arrowUpImage = new Image();
var arrowRightImage = new Image();

var joy1Image = new Image();
var joy2Image = new Image();
var joy3Image = new Image();

var joy1Option = null;
var joy2Option = null;
var joy3Option = null;

var maskImage = new Image();

var scrollYOffersTab = 0;
var lastOffersTabScroll = 0;

var maxOffersHeight = 0;

var currentVisibleItem = -1;
var visibleItemHeight = 0;

var currentOffersPage = 0;
var offersPages = [];

var offersStartY = 0;

var offersTabLoaded = false;

var offerButtons = [];
var offerOptions = [];

var offersBackButton = null;

var offersCopyButton = null;
var offersCopyOption = null;

function loadOffersTabImages() {
    arrowDownImage.src = "images/arrow_down.png";
    arrowUpImage.src = "images/arrow_up.png";
    arrowRightImage.src = "images/arrow_right.png";
    maskImage.src = "images/maskjoy.png";

    arrowDownImage.onload = loading;
    arrowUpImage.onload = loading;
    
    joy1Image.onload = drawJoy1;
    joy2Image.onload = drawJoy2;
    joy3Image.onload = drawJoy3;
}

function initializeOffersTab() {
    offersTabCanvas.width = screenWidth;
    offersTabCanvas.height = screenHeight * 3;

    tmpOfferCanvas.width = screenWidth;
    tmpOfferCanvas.height = screenHeight - 2 * iconSize;

    maxOffersHeight = offersTabCanvas.height;
}

function drawJoy1(){
    offersTabContext.drawImage(joy1Image, 0, 0, joy1Image.width, joy1Image.height, dh10, d25, d100, d100);
    offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10, d25, d100, d100);
    drawScreen();
}

function drawJoy2(){
    offersTabContext.drawImage(joy2Image, 0, 0, joy1Image.width, joy1Image.height, dh10 + d100, d25, d100, d100);
    offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10 + d100, d25, d100, d100);
    drawScreen();
}

function drawJoy3(){
    offersTabContext.drawImage(joy3Image, 0, 0, joy1Image.width, joy1Image.height, dh10 + d100 + d100, d25, d100, d100);
    offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10 + d100 + d100, d25, d100, d100);
    drawScreen();
}

function predrawOffersTab() {
    offersTabContext.clearRect(0, 0, offersTabCanvas.width, offersTabCanvas.height);

    offersBackButton = null;
    offerButtons = [];
    if (offersPages.length > 0) {
        if(currentOffersPage == 0 && userSlots.totalSlots > 0){
            maxOffersHeight = d160;
            offersStartY = d160;
                        
            for (var i = 0; i < userSlots.totalSlots; i++) {
                if(i < userSlots.takenSlotsOptions.length){
                    if(i == 0) {
                        joy1Image.src = userSlots.takenSlotsOptions[0].image;
                        offersTabContext.drawImage(joy1Image, 0, 0, joy1Image.width, joy1Image.height, dh10, d25, d100, d100);
                        offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10, d25, d100, d100);
                        joy1Option = userSlots.takenSlotsOptions[0];
                    }
                    if(i == 1) {
                        joy2Image.src = userSlots.takenSlotsOptions[1].image;
                        offersTabContext.drawImage(joy2Image, 0, 0, joy1Image.width, joy1Image.height, dh10 + d100, d25, d100, d100);
                        offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10 + d100, d25, d100, d100);
                        joy2Option = userSlots.takenSlotsOptions[1];
                    }
                    if(i == 2) {
                        joy3Image.src = userSlots.takenSlotsOptions[2].image;
                        offersTabContext.drawImage(joy3Image, 0, 0, joy1Image.width, joy1Image.height, dh10 + d100 + d100, d25, d100, d100);
                        offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10 + d100 + d100, d25, d100, d100);
                        joy3Option = userSlots.takenSlotsOptions[2];
                    }
                }
                else {
                    if(i == 0) {
                        joy1Image.src = userSlots.freeSlotOption.image;
                        offersTabContext.drawImage(joy1Image, 0, 0, joy1Image.width, joy1Image.height, dh10, d25, d100, d100);
                        offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10, d25, d100, d100);
                        joy1Option = userSlots.freeSlotOption;
                    }
                    if(i == 1) {
                        joy2Image.src = userSlots.freeSlotOption.image;
                        offersTabContext.drawImage(joy2Image, 0, 0, joy1Image.width, joy1Image.height, dh10 + d100, d25, d100, d100);
                        offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10 + d100, d25, d100, d100);
                        joy2Option = userSlots.freeSlotOption;
                    }
                    if(i == 2) {
                        joy3Image.src = userSlots.freeSlotOption.image;
                        offersTabContext.drawImage(joy3Image, 0, 0, joy1Image.width, joy1Image.height, dh10 + d100 + d100, d25, d100, d100);
                        offersTabContext.drawImage(maskImage, 0, 0, maskImage.width, maskImage.height, dh10 + d100 + d100, d25, d100, d100);
                        joy3Option = userSlots.freeSlotOption;
                    }
                }
            }                        
                        
            drawText(offersTabContext, "Telenor Play", screenWidth - dh10, d20, "MyBold", d14, textGrayColor, "right");
            drawText(offersTabContext, offersPages[currentOffersPage].head, screenWidth - dh10, d160, "MyBold", d14, textGrayColor, "right");
        }
        else {
            maxOffersHeight = d20;                            
            offersStartY = d20;
            drawText(offersTabContext, offersPages[currentOffersPage].head, screenWidth - dh10, d20, "MyBold", d14, textGrayColor, "right");
        }
        offerOptions = [];        
        if(currentOffersPage > 0){  
            offersStartY = d70;
            offersBackButton = new BUTTON(dh20, d30, dh60, d30, "< Nazad", executeOffersBackAction);
            drawButton(offersTabContext, offersBackButton, tab1Color, "white");
            if(offersPages[currentOffersPage].content != ""){
                offersStartY = drawTextWrap(offersTabContext, offersPages[currentOffersPage].content, dh20, offersStartY + d10, screenWidth - dh40, "MyLight", d14, textGrayColor, "left");
                offersStartY += d10;
            }
            maxOffersHeight = offersStartY;
        }
        visibleItemHeight = 0;
        for (var i = 0; i < offersPages[currentOffersPage].options.length; i++) {
            drawOffer(offersPages[currentOffersPage].options[i], i);
        }
        maxOffersHeight += visibleItemHeight;
    }
}

function drawOffer(option, index) {
    var h = iconSize * 2 / 3;
    var y = index * h + offersStartY;
    var w = screenWidth * 0.5;
    var bw = screenWidth * 0.45;
    
    if (index > currentVisibleItem)
        y += visibleItemHeight;
            
    if(option.image != ""){
        offersTabContext.drawImage(option.picture, 0, 0, option.picture.width, option.picture.height, dh5, y + d5, h - dh10, h - d10);        
        drawText(offersTabContext, option.name, dh10 + h + dh5, y + h / 2 + d8, "MyLight", d16, tab1Color, "left");        
    }
    else {        
        if(option.type == "code"){
            console.log("code");
            offersCopyButton = new BUTTON(screenWidth - dh10 - bw, y + d14, bw, d30, option.name, executeCopy);
            offersCopyOption = option;
            drawButton(offersTabContext, offersCopyButton, tab1Color, "white");    
            drawText(offersTabContext, option.action, dh10, y + h / 2 + d8, "MyLight", d16, tab1Color, "left"); 
        }
        else {
            drawText(offersTabContext, option.name, dh10, y + h / 2 + d8, "MyLight", d16, tab1Color, "left");  
        }
    }
    offerButtons.push(new OFFERRECT(0, y, screenWidth, h));
    drawHLine(offersTabContext, 0, y + h, screenWidth, y + h);

    if (currentVisibleItem == index) {
        offersTabContext.drawImage(arrowUpImage, 0, 0, arrowUpImage.width, arrowUpImage.height, screenWidth - dh30, y + h / 2 - 5, dh20, d10);

        tmpOfferContext.clearRect(0, 0, tmpOfferCanvas.width, tmpOfferCanvas.height);        

        if (option.type == "PAGE") {
            var tmpH = d5 + drawTextWrap(tmpOfferContext, option.page.content, dh5, d22, w, "MyLight", d14, textGrayColor, "left");
            var tmpH2 = option.page.options.length * d35;
            var dty = 0;
            var dby = 0;

            if (tmpH > tmpH2 + d20) {
                visibleItemHeight = tmpH;
                dby = (tmpH - tmpH2) / 2;
            }
            else {
                visibleItemHeight = tmpH2 + d20;
                dty = (tmpH2 - tmpH) / 2;
                dby = d10;
            }
            for (var i = 0; i < option.page.options.length; i++) {
                fillRect(offersTabContext, screenWidth - bw - dh10, y + h + d35 * i + dby, bw, d30, tab1Color);
                offerOptions.push(new OFFERRECT(screenWidth - bw - dh10, y + h + d35 * i + dby, bw, d30));
                drawText(offersTabContext, option.page.options[i].name, screenWidth - bw - dh10 + bw / 2, y + h + d15 + d6 + d35 * i + dby, "MyLight", d14, "white", "center");
            }
            offersTabContext.drawImage(tmpOfferCanvas, 0, 0, w, tmpH, 0, y + h + dty, w, tmpH);
        }
        else {
            fillRect(offersTabContext, screenWidth - bw - dh10, y + h + d10, bw, d30, tab1Color);
            offerOptions.push(new OFFERRECT(screenWidth - bw - dh10, y + h + d10, bw, d30));
            drawText(offersTabContext, "Dalje", screenWidth - bw - dh10 + bw / 2, y + h + d10 + d15 + d6, "MyLight", d14, "white", "center");
            drawTextWrap(offersTabContext, "Pogledajte ponuđene opcije", dh10, y + h + d25 + d7, w, "MyLight", d14, textGrayColor, "left");
            visibleItemHeight = dh50;
        }
        drawHLine(offersTabContext, 0, y + h + visibleItemHeight, screenWidth, y + h + visibleItemHeight);
    }
    else {
        if(currentOffersPage > 0){
            if(option.type != "code")
                offersTabContext.drawImage(arrowRightImage, 0, 0, arrowRightImage.width, arrowRightImage.height, screenWidth - dh30, y + h / 2 - d5, dh10, d20);
        }
        else{
            if(option.type != "code")
                offersTabContext.drawImage(arrowDownImage, 0, 0, arrowDownImage.width, arrowDownImage.height, screenWidth - dh30, y + h / 2 - d5, dh20, d10);
        }
    }

    maxOffersHeight += h + 1;
}

function executeCopy(){
    
}

function drawOffersTab(context, index) {
    context.drawImage(offersTabCanvas, 0, scrollYOffersTab, offersTabCanvas.width, offersTabCanvas.height - scrollYOffersTab,
            index * screenWidth, 0, offersTabCanvas.width, offersTabCanvas.height - scrollYOffersTab);
}

function scrollOffersTab(scrollY) {
    scrollYOffersTab -= scrollY - lastOffersTabScroll;
    lastOffersTabScroll = scrollY;
    if (maxOffersHeight - scrollYOffersTab < screenHeight - (2 * iconSize)) {
        scrollYOffersTab = maxOffersHeight - screenHeight + (2 * iconSize);
    }
    if (scrollYOffersTab < 0)
        scrollYOffersTab = 0;
}

function startOffersTabScroll() {
    lastOffersTabScroll = 0;
}

function clickOffersTab(x, y) {
    var h = iconSize * 2 / 3;
    if (y > 2 * iconSize) {
        var dy = scrollYOffersTab + y - 2 * iconSize;
        if(dy < offersStartY && currentOffersPage == 0){
            if(x > d10 && x < d100 + d10){
                if(joy1Option != null)
                    executeJoystickOption(joy1Option);
            }
            else if(x > d100 + d10 && x < d10 + d100 + d100){
                if(joy2Option != null)
                    executeJoystickOption(joy2Option);
            }
            else if(x > d10 + d100 + d100 && x < d10 + d100 + d100 + d100){
                if(joy3Option != null)
                    executeJoystickOption(joy3Option);
            }            
        }
        else {
            if(insideButton(offersCopyButton, x, dy)){
                offersCopyButton.action();
                return;
            } 
            for (var i = 0; i < offerButtons.length; i++) {
                if (insideRect(offerButtons[i].x, offerButtons[i].y, offerButtons[i].width, offerButtons[i].height, x, dy)) {
                    executeOfferAction(i);
                    return;
                }
            }
            for (var i = 0; i < offerOptions.length; i++) {
                if (insideRect(offerOptions[i].x, offerOptions[i].y, offerOptions[i].width, offerOptions[i].height, x, dy)) {                
                    executeSubAction(i);
                    return;
                }
            }        
            if(insideButton(offersBackButton, x, dy)){
                offersBackButton.action();
                return;
            }                
        }
    }
}

function executeJoystickOption(option){
    if(option.type == "PAGE"){
        offersPages.push(option.page);
        currentOffersPage += 1;
        scrollYOffersTab = 0;
        predrawOffersTab();
    }
    else if(option.type == "API"){
        loadOffersAPI(option.action);
    }
}

function executeSubAction(index) {     
    if(userOffers.page.options[currentVisibleItem].type == "PAGE"){
        if(userOffers.page.options[currentVisibleItem].page.options[index].type == "URL"){
            executeOption = userOffers.page.options[currentVisibleItem].page.options[index];
            prepareInternetDialog(executeOffersURL, tab1Color);
        }
        else if(userOffers.page.options[currentVisibleItem].page.options[index].type == "PAGE"){        
            offersPages.push(userOffers.page.options[currentVisibleItem].page);
            currentOffersPage += 1;
            scrollYOffersTab = 0;
        }
        else if(userOffers.page.options[currentVisibleItem].page.options[index].type == "API"){
            executeOption = userOffers.page.options[currentVisibleItem].page.options[index];
            executeOffersAPI();
        }
    }
    else {
        if(userOffers.page.options[currentVisibleItem].type == "API"){
            executeOption = userOffers.page.options[currentVisibleItem];
            executeOffersAPI();
        }
    }
    
    currentVisibleItem = -1;    
    
    predrawOffersTab();
    drawScreen();
}

function executeOffersURL(){    
    openNewWindow(executeOption.action);
    currentDialog = 0;
    drawScreen();
}

function executeOfferAction(index) {
    if (currentOffersPage == 0) {
        if (currentVisibleItem == index)
            currentVisibleItem = -1;
        else
            currentVisibleItem = index;
    }
    else {
        if(offersPages[currentOffersPage].options[index].type == "PAGE"){            
            offersPages.push(offersPages[currentOffersPage].options[index].page);
            currentOffersPage += 1;
            scrollYOffersTab = 0;
        }
        else if(offersPages[currentOffersPage].options[index].type == "URL"){
            executeOption = offersPages[currentOffersPage].options[index];
            prepareInternetDialog(executeOffersURL, tab1Color);
        }
        else if(offersPages[currentOffersPage].options[index].type == "API"){
            executeOption = offersPages[currentOffersPage].options[index];
            executeOffersAPI();
        }
    }
    predrawOffersTab();
}

function loadOffersTab() {    
    lastOffersTabScroll = 0;
    scrollYOffersTab = 0;
    currentOffersPage = 0;
    offersPages = [];       
    if (userOffers != null) {        
        offersPages.push(userOffers.page);
    }
    predrawOffersTab();
    drawScreen();
}

function OFFERRECT(x, y, width, height) {
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
}

function executeOffersBackAction() {    
    if (offersPages.length > 1)
        offersPages.pop();
    currentOffersPage = offersPages.length - 1;
    predrawOffersTab();
    drawScreen();
}

function executeOffersAPI(){    
    prepareConfirmDialog(executeOption.confirm.message, executeOption.confirm.yes, executeOption.confirm.no, confirmExecute);
}

function confirmExecute(){
    if(executeOption.inputs.length > 0){
        prepareInputDialog(executeOption);
        executeFunction = loadOffersAPI;
    }
    else {
        loadOffersAPI(executeOption.action);
    }
}

function handleOffersAPI(){
    stopOffersWait();
    if(userOffersAPI.template == "TAB"){
        scrollYOffersTab = 0;
        offersPages.push(userOffersAPI.page);
        currentOffersPage += 1;
        predrawOffersTab();
        drawScreen();
    }
    else if(userOffersAPI.template == "ERROR" || userOffersAPI.template == "INFO"){
        prepareAPIDialog(userOffersAPI.page.head, userOffersAPI.page.content, textDarkColor);
        drawScreen();
    }
}