var config = {
	//ゲーム画面の設定
	game:{
		width: 740,
		height: 1280
	},
	//ブロックの設定
	block: {
		width: 130,
		height: 40,
		margin: {
			top: 5,
			left: 5,
			right: 5,
			bottom: 5
		}
	},
	//ブロック表示領域全体の設定
	blocks: {
		margin: {
			top: 100,
			left: 20,
			right: 10,
			bottom: 0
		}
	},
	//ボールの設定
	ball: {
		R: 60,
		bottom: 300,
		maxSpeed: 40,
		minSpeed: 25
	},
	//パドルの設定
	paddle: {
		width: 200,
		height: 20,
		bottom: 100
	},
	label: {
		color: "#f7931e",
		font: "36px monospace",
		textAlign: "center",
		score: "Your score is ",
		highscore: "HIGH SCORE"
	},
	//画像の設定
	assets: [
		"img/block00.png",
		"img/ball.png",
		"img/paddle.png",
		"img/splash.png",
		"img/countdown.png",
		"img/gameover.png",
		"sounds/se0.mp3"
	],
	//イベントの設定
	events:{
		load: "load",
		scenesReady: "scnensready",
		splashEnd: "splashend",
		gameOver: "gameover",
		restart: "restart",
		blockCrash: "blockcrash",
		nextLevel: "nextlevel"
	},
	//ブロック座標の設定
	stages: [
		[
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0]
		],
		[
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0]
		],
		[
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0]
		],
		[
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0]
		]
	],
	score: {
		base: 10,
		bonus: 5,
		stageClear: 100
	},
	storageKeys: {
		highscore: "highscore"
	},
	feedback:{
		brockCrashed: "sounds/se0.mp3",
		vibrationDuration: 100
	}
};

window.addEventListener("load", initApp);

function initApp(){
	enchant();
	var game = new Core(config.game.width, config.game.height);
	console.log("アプリの初期化開始");
	initGame(game);
}

function initGame(game){
	console.log("ゲームの初期化開始");

	//configデータをgameオブジェクトに取り込む
	game.config = config;
	game.events = config.events;
	game.stages = config.stages;
	
	//サウンドはenchant.DOMSoundを使用
	enchant.Sound = enchant.DOMSound;
	
	game.preload(game.config.assets);
		
	//画像ファイルのロード終了時に実行
	game.addEventListener(game.events.load, function(){
		console.log("ゲームの初期化終了");
		initScenes(game);
	});

	//各シーンの初期化が終了した際に実行
	game.addEventListener(game.events.scenesReady, function(){
		console.log("scnensreadyイベント発生");
		startGame(game);
	});
	
	//スプラッシュシーン終了時に実行
	game.addEventListener(game.events.splashEnd, function(){
		console.log("ゲーム画面へ遷移");
		game.dispatchEvent(new Event(game.events.ready));
	});

	//ブロックが壊れた際に実行
	game.addEventListener(game.events.blockCrash, function(event){
		game.score += game.config.score.base + game.config.score.bonus * event.value;
		playSound(game, config.feedback.brockCrashed);
		navigator.vibrate(config.feedback.vibrationDuration);
	});
	
	//全てのブロックが壊れた際に実行
	game.addEventListener(game.events.nextLevel, function(event){
		game.score += game.config.score.stageClear;
		game.scenes.main.dispatchEvent(new Event(game.events.nextLevel));
	});

	//ゲームオーバー時に実行
	game.addEventListener(game.events.gameOver, function(event){
		console.log("ゲームオーバー");
		var highscore = loadHighscore();
		game.highscore = game.score > highscore;
		if(game.highscore){
			saveHighscore(game.score);
		}
		game.popScene();
		game.pushScene(game.scenes.gameOver);
	});

	//リスタート時に実行
	game.addEventListener(game.events.restart, function(event){
		console.log("リスタート");
		game.scenes.main.dispatchEvent(new Event(game.events.restart));
	});

	//メインシーンでプレイ可能になった時に実行
	game.addEventListener(game.events.ready, function(events){
		console.log("readyイベント発生");
		game.score = 0;
		game.popScene();
		game.pushScene(game.scenes.main);
	});

	game.start();
}

function initScenes(game){
	console.log("シーンの初期化開始");
	
	//gameのscenesプロパティを作り、「名前:値」の形式でオブジェクトを作成
	game.scenes = {
		splash:initSplash(game),
		main:initMain(game),
		gameOver:initGameover(game)
	};
	
	console.log("シーンの初期化終了");
	game.dispatchEvent(new Event(game.events.scenesReady));
}

function startGame(game){
	startSplash(game);
}

function saveHighscore(score){
	//sessionStorageにハイスコアを記録
	sessionStorage.setItem(config.storageKeys.highscore, score);
}

function loadHighscore(){
	//sessionStorageからデータ取得
	return Number(sessionStorage.getItem(config.storageKeys.highscore) || 0);
}

function playSound(game, file){
	var sound = game.assets[file].clone();
	sound.play();
}
