function initBall(game){
	var sprite = new Sprite(game.config.ball.R, game.config.ball.R);
	sprite.image = game.assets["img/ball.png"];

	sprite.r = game.config.ball.R / 2;
	sprite.R = game.config.ball.R;

	resetBall(sprite, game);

	return sprite;
}

function resetBall(ball, game){
	ball.y = game.height - game.config.ball.bottom - game.config.ball.R / 2;
	ball.x = (game.width - game.config.ball.R) / 2;
	
	//Xs[h͈
	var range = game.config.ball.maxSpeed - game.config.ball.minSpeed;

	//01
	var sign = Math.floor(Math.random() - 0.5);

	//ŒXs[hȉŉE֐iẍړ
	ball.dx = sign * Math.floor(Math.random() * range) + game.config.ball.minSpeed;

	//ŒXs[hȏŉɐiÿړ
	ball.dy = Math.floor(Math.random() * range) + game.config.ball.minSpeed;
}

function reboundBallByWall(ball, scene){
	if(ball.x < 0){
		ball.x = 0;
		ball.dx = ball.dx * -1;
	}
	if(ball.y < 0){
		ball.y = 0;
		ball.dy = ball.dy * -1;
	}
	if(ball.x > scene.width - ball.R){
		ball.x = scene.width - ball.R;
		ball.dx = ball.dx * -1;
	}
}

function reboundBallByPaddle(ball, paddle){
	if(paddle != null && ball.intersect(paddle)){
		ball.dy = ball.dy * -1;
	}
}
