function initGameover(game){
	var scene = new Scene();
	var image = game.assets["img/gameover.png"];
	var sprite = new Sprite(image.width, image.height);

	//ʒɔzu
	sprite.x = (game.width - image.width) / 2;
	sprite.y = (game.height - image.height) / 2;
	sprite.image = image;

	//XRApx
	var score = createLabel(game, "");
	var highscore = createLabel(game, game.config.label.highscore);
	score.y = sprite.y + sprite.height * 2;

	scene.addEventListener(Event.TOUCH_END, function(event){
		game.dispatchEvent(new Event(game.events.restart));
	});

	scene.addEventListener(Event.ENTER, function(event){
		scene.removeChild(highscore);
		if(game.highscore){
			highscore.y = score.y;
			score.y = highscore.y + 50;
			scene.addChild(highscore);
		}
		score.text = game.config.label.score + game.score;
	});

	scene.addChild(sprite);
	scene.addChild(score);
	scene.addChild(highscore);
	return scene;
}

function createLabel(game, text){
	var label = new Label();
	label.color = game.config.label.color;
	label.font = game.config.label.font;
	label.textAlign = game.config.label.textAlign;
	label.width = game.width;
	label.text = text;
	label.x = 0
	return label;
}
