var memoText;
var memoList;
var currentKey;

window.onload = function() {
  memoText = document.getElementById("memoText");
  memoList = document.getElementById("memoList");
  currentKey = newKeyName();

  memoText.onkeypress = function(e) {
    // enter key
    if ( e.charCode === 13 || e.keyCode === 13) {
      writeData(currentKey);
      currentKey = newKeyName(); // create new memo
      memoText.value = "";
    }
  };
  forFirstUse();
  redrawMemoList();
  autoSave();

};

function autoSave() {
  writeData(currentKey);
  setTimeout(autoSave, 1000); // 1sec
  redrawMemoList();
}

function readData(key) {
  if (localStorage.getItem(key)) {
    memoText.value = localStorage.getItem(key);
    currentKey = key; // set currentKey
  }
  redrawMemoList();
}

function writeData(key) {
  var tmp = memoText.value.replace(/^[ 　]+|[ 　]+$/g, '');
  if ( tmp !== "") {
    localStorage.setItem(key, tmp);
  }else{
    deleteData(key); // if no data delete.
  }
  redrawMemoList();
}

function deleteData(key) {
  localStorage.removeItem(key);
  redrawMemoList();
}

function redrawMemoList() {
  var memolistHtml = "";
  for(var aKey in localStorage) {
    if ( localStorage.hasOwnProperty(aKey) ) {

      var tmp = "";
      if (aKey!==currentKey) {
        tmp = "<a href='#' onclick='deleteData(\"" + aKey + "\");'>Del</a>　";
      } else {
        tmp = "***　";
      }
      memolistHtml = tmp + 
        "<a href='#'onclick='readData(\"" + aKey + "\");'>" + 
        getMemoHead(localStorage.getItem(aKey))+ "</a><br />" + memolistHtml;
    }
  }
  memoList.innerHTML = memolistHtml;
  memoText.focus();
}

function getMemoHead(memo) {
  if ( memo.length>15 ) {
    return memo.substr(0,15) + "...";
  } else {
    return memo;
  }
}

function newKeyName() {
  return new Date().toLocaleString();
}

function forFirstUse() {
  if (localStorage.length === 0) {
    localStorage.setItem("1", "Very Simple!!!");
    localStorage.setItem("2", "Tap here: EDIT");
    localStorage.setItem("3", "<-- DELETE");
    localStorage.setItem("4", "Enter: NEW MEMO");
  }
}
