//Variable global del juego
var global_game = null;
var gravityForce = -3;
//Imagenes
var imgFondo;
var tileImages = {};
var lastInput = 40;
var maxTiles = 16;
var ticksToNextMove = 40;
var currentGravity = "DOWN";
var fichaRadius = 1.16;
var maxSearchSiteTries = 10000;

//CONFIG
var b2DebugDrawEnable = false;
var imageTilesCanRotate = true;

//Se ejecuta cuando la página está lista
function main() {
	if(!localStorage.bestScore) localStorage.bestScore = 0;
	else
	{
		$( "#best-score" ).text(localStorage.bestScore);
	}

	$( ".restart-button" ).bind( "click", reset_game );
	$( ".retry-button" ).bind( "click", reset_game );

	start_game();

}

function reset_game()
{
	location.reload();

}

//Crea juego, imagen y evento resize dependiente de la ventana
function start_game()
{
	$( "#score" ).text(0);

	var g = new game();
	
	//lo almacenamos en la variable global
	global_game = g;
	
	$(window).resize(function() {
		g.resize();
	});
	
	
	imgFondo = new Image();
	imgFondo.src= 'images/background.png';

	for(var i = 2; i <= 2048; i*=2)
	{
		tileImages['tile' + i] = new Image();
		tileImages['tile' + i].src = 'images/tile' + i + '.png';
	}

	imgFondo.onload = g.start();
}

//atributos del juego
function game()
{
	this.fps = 60;
	this.scale = 50;
	this.tileCount = 0;
	this.score = 0;

	this.MoveEnabled = true;
	this.tickCountDown = ticksToNextMove;
	
	//almacenamos los objetos del juego (para luego recorrerlos para poder pintarlos, destruirlos...)
	this.game_objects = [];
	
	this.to_destroy = [];

	this.to_add = [];
}

game.prototype.resize = function()
{
	var canvas = this.canvas;
	
	//Conversión de las dimensiones del canvas a las de la ventana
	//outerWidth incluye padding y border
	/*
	var w = $(window).outerWidth() - 20;
	var h = $(window).outerHeight() - 20;

	var squaredSize = w > h ? h : w;
	
	canvas.width(squaredSize);
	canvas.height(squaredSize);
	
	canvas.attr('width' , squaredSize * 0.75);
	canvas.attr('height' , squaredSize * 0.75);
	*/
	
	this.canvas_width = canvas.attr('width');
	this.canvas_height = canvas.attr('height');
	
	this.screen_height = 10;
	this.scale = this.canvas_height / this.screen_height;
	this.screen_width = this.canvas_width / this.scale;
}

game.prototype.setup = function()
{
	this.ctx = ctx = $('#canvas').get(0).getContext('2d');
	var canvas = $('#canvas');
	this.canvas = canvas;
	
	//redimensionar
	this.resize();
	
	//dimensiones en metros (box2D)
	var w = this.screen_width;
	var h = this.screen_height;
		
	//crear el mundo Box2D
	this.create_box2d_world();

	//Primera ficha
	this.addRandomFicha();

	//Paredes
	this.game_objects.push(new wall({x : w/2, y: 0,height: 0.4,width: 10,game: this}));
	this.game_objects.push(new wall({x : w/2, y: h,height: 0.4,width: 10,game: this}));
	this.game_objects.push(new wall({x : 0, y: h/2,height: 10,width: 0.4,game: this}));
	this.game_objects.push(new wall({x : w, y: h/2,height: 10,width: 0.4,game: this}));
	

	//linkar los eventos de teclado
	this.start_handling();
	
	//linkar las colisiones
	this.setup_collision_handler();
	
}

game.prototype.create_box2d_world = function()
{
	//gravedad
	var gravity = new b2Vec2(0, -gravityForce);
	
	//Se pone a falso para evitar que los cuerpos dinámicos que se mueven por los estáticos no se desactiven
	var doSleep = false;
	var world = new b2World(gravity , doSleep);
	
	if(b2DebugDrawEnable)
	{
		var debugDraw = new b2DebugDraw();
		debugDraw.SetSprite(this.ctx); 
		debugDraw.SetDrawScale(this.scale); 
		//debugDraw.SetDrawScale(20); 
		debugDraw.SetFillAlpha(0.5); 
		debugDraw.SetLineThickness(1.0); 
		debugDraw.SetFlags(b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit); 

		world.SetDebugDraw(debugDraw); 
	}

	//grabar en la varibale global
	this.box2d_world = world;

}

//Comienzo del juego
game.prototype.start = function()
{
	this.on = true;
	
	this.setup();
	this.is_paused = false;
	
	//Empezar el loop del juego
	this.tick();
}

game.prototype.redraw_world = function()
{
	//Limpiar el canvas
	this.ctx.clearRect(0 , 0 , this.canvas_width , this.canvas_height);
	
	//dimensiones en metros
	var w = this.screen_width;
	var h = this.screen_height;

	this.ctx.drawImage(imgFondo, 0 , 0 , this.canvas_width, this.canvas_height);
	
	//Dibujar todos los objetos

	for(var i in this.game_objects)
	{
		this.game_objects[i].draw();
	}

	//Dibujamos debug
    this.box2d_world.DrawDebugData();
}

game.prototype.tick = function(cnt)
{
	if(!this.is_paused && this.on)
	{
	
		//ejecutar el tick de cada objeto, y si están en estado 'dead', eliminarlos
		for(var i in this.game_objects)
			this.game_objects[i].tick();
		
		//Destruir
		this.perform_destroy();

		this.perform_addFichas();

		//Dar un paso en el Box2D
		this.box2d_world.Step(1/20 , 8 , 3);
		
		//Limpiar las fuerzas
		this.box2d_world.ClearForces();
		
		//Redibujar el mundo
		this.redraw_world();
		
		if(!this.is_paused && this.on)
		{
			var that = this;
			this.timer = setTimeout( function() { that.tick(); }  , 1000/this.fps);
		}

		if(!this.MoveEnabled)
		{
			if(this.tickCountDown > 0)
			{
				this.tickCountDown--;
			}
			else
			{
				this.MoveEnabled = true;
				this.tickCountDown = ticksToNextMove;
			}
		}
	}
}

game.prototype.get_offset = function(vector)
{
	return new b2Vec2(vector.x - 0, Math.abs(vector.y - this.screen_height));
}

//controla los eventos de teclado
game.prototype.start_handling = function()
{
	var that = this;
	
	$(document).on('keydown' , function(e)
	{
		that.key_down(e);
		return false;
	});
	
	$(document).on('keyup' ,function(e)
	{
		that.key_up(e);
		return false;
	});
}

//evento keydown
game.prototype.key_down = function(e)
{
	if(!this.MoveEnabled) return;

	var code = e.keyCode;
	
	//izquierda
	if(code == 37 && lastInput != 37)
	{
		this.addRandomFicha();
		this.box2d_world.SetGravity(new b2Vec2(gravityForce, 0));
		currentGravity = "LEFT";
		lastInput = code;
		this.MoveEnabled = false;
	}
	//arriba
	else if(code == 38 && lastInput != 38)
	{
		this.addRandomFicha();
		this.box2d_world.SetGravity(new b2Vec2(0, gravityForce));
		currentGravity = "UP";
		lastInput = code;
		this.MoveEnabled = false;
	}
	//derecha
	else if(code == 39 && lastInput != 39)
	{
		this.addRandomFicha();
		this.box2d_world.SetGravity(new b2Vec2(-gravityForce, 0));
		currentGravity = "RIGHT";
		lastInput = code;
		this.MoveEnabled = false;
	}
	//abajo
	else if(code == 40 && lastInput != 40)
	{
		this.addRandomFicha();
		this.box2d_world.SetGravity(new b2Vec2(0, -gravityForce));
		currentGravity = "DOWN";
		lastInput = code;
		this.MoveEnabled = false;
	}

}

//evento keyup
game.prototype.key_up = function(e)
{
	/*
	var code = e.keyCode;
	
	//arriba
	if(code == 38)
	{
		this.player.do_move_up = false;
		this.player.can_move_up = true;
	}
	//izquierda
	else if(code == 37)
	{
		this.player.do_move_left = false;
	}
	//derecha
	else if(code == 39)
	{
		this.player.do_move_right = false;
	}
	*/
}
	


function ficha(options)
{
	this.x = options.x;
	this.y = options.y;
	this.value = options.value;
	this.radius = fichaRadius;

	this.game = options.game;

	var info = {
		'density' : 2,
		'linearDamping' : 0,
		'fixedRotation' : false,
		'restitution' : 0.3,
		'friction' : 0.1,
		'userData' : this,
		'type' : b2Body.b2_dynamicBody
	};

	var body = create_circle(this.game.box2d_world, this.x, this.y, this.radius, info);
	this.body = body;
}

ficha.prototype.draw = function()
{
	if(this.body == null)
	{
		return false;
	}

	draw_body(this.body, this.game.ctx);
	
	var c = this.body.GetPosition();
	var r = this.body.GetAngle();
	
	var scale = this.game.scale;
	
	var sx = c.x * scale;
	var sy = c.y * scale;
	
	var width = this.width * scale;
	var height = this.height * scale;
	var radius = this.radius * scale;
	
	var ctx = this.game.ctx;
	ctx.save();
	ctx.beginPath();
	ctx.arc(sx, sy, radius, 0, 2 * Math.PI, false);
	ctx.clip();
	if(imageTilesCanRotate)
	{
		ctx.translate(sx,sy);
		ctx.rotate(r);
		ctx.drawImage(tileImages['tile' + this.value], -radius, -radius, radius * 2, radius * 2);
		ctx.rotate(-r);
		ctx.translate(-sx,-sy);
	}
	else
	{
		ctx.drawImage(tileImages['tile' + this.value], sx - radius, sy - radius, radius * 2, radius * 2);
	}
	

	/*
	ctx.fillStyle = 'green';
	ctx.fill();
	ctx.fillStyle = 'black';
	ctx.font="30px Verdana";
	ctx.fillText(this.value,sx,sy);
	*/
	ctx.restore();
}

ficha.prototype.tick = function()
{
	this.age++;
	
}

game.prototype.addRandomFicha = function ()
{
		var x, y;
		var siteFound = false;
		var tries = 0;

		while(!siteFound && tries < maxSearchSiteTries)
		{
			tries++;
			var fichaCounts = 0;

			x = (Math.random() * (this.screen_width - fichaRadius * 2)) + fichaRadius;
			y = (Math.random() * (this.screen_height - fichaRadius * 2)) + fichaRadius;

			for(var i = 4; i < this.game_objects.length; i++)
			{
				fichaCounts++;

				var ficha = this.game_objects[i];
				

				
				var f = ficha.body.GetPosition();
				var fx = f.x * this.scale;
				var fy = f.y * this.scale;
				var fr = fichaRadius * this.scale * 0.9;
				var sx = x * this.scale;
				var sy = y * this.scale;

				/*
				var ctx = this.ctx;
				ctx.save();
				ctx.beginPath();
				ctx.arc(sx, sy, fichaRadius * this.scale, 0, 2 * Math.PI, false);
				ctx.fill();
				ctx.beginPath();
				ctx.moveTo(sx, sy);
				ctx.lineTo(fx, fy);
				ctx.stroke();
				ctx.restore();
				*/

				var dist = Math.sqrt( Math.pow(fx - sx, 2) + Math.pow(fy - sy, 2)) - (fr * 2);

				if(  dist > 0 )
				{
					siteFound = true;
				}
				else
				{
					siteFound = false;
					break;
				}
				
				
				//this.game_objects[i];
				
			}
			
			if(fichaCounts == 0)
			{
				siteFound = true;
			}
		}
		
		//console.log("Num tries: " + tries);

	    if(tries >= maxSearchSiteTries)
	    {
	    	this.is_paused = true;
			this.messagefunction(false);
			return;
	    }

    	//this.game_objects.push(new ficha({x : x, y: y,value : 2,game: this}));
		var ficha = {
			x: x,
			y: y,
			value: Math.random() > 0.5 ? 2 : 4,
		};
		this.to_add.push(ficha);
		
}

game.prototype.addFicha = function (x, y, value)
{
		//this.game_objects.push(new ficha({x : x, y: y,value : value,game: this}));
		var ficha = {
			x: x,
			y: y,
			value: value
		};
		this.to_add.push(ficha);
}

//Objeto muro
function wall(options)
{
	this.height = options.height;
	this.width = options.width;
	this.x = options.x;
	this.y = options.y;
	
	this.game = options.game;
	
	var linear_damping = 8;
	
	var info = { 
		'density' : 10 ,
		'fixedRotation' : true ,
		'userData' : this ,
		'type' : b2Body.b2_staticBody ,
	};
	
	var body = create_box(this.game.box2d_world , this.x, this.y, this.width, this.height, info);
	this.body = body;

}

wall.prototype.tick = function()
{
	this.age++;
}

//Dibujar el suelo
wall.prototype.draw = function()
{
	if(this.body == null)
	{
		return false;
	}
	//draw_body(this.body, this.game.ctx);
	
	var c = this.body.GetPosition();
	
	var scale = this.game.scale;
	
	var sx = c.x * scale;
	var sy = c.y * scale;
	
	var width = this.width * scale;
	var height = this.height * scale;
	
	/*
	this.game.ctx.fillStyle = "green";
    this.game.ctx.fillRect (sx - width / 2,sy - height / 2,width,height);
    */
}


//Colisiones
game.prototype.setup_collision_handler = function()
{
	var that = this;
	
	//b2ContactListener
	b2ContactListener.prototype.BeginContact = function (contact) 
	{
		
		var a = contact.GetFixtureA().GetUserData();
		var b = contact.GetFixtureB().GetUserData();
		
		if(a instanceof ficha && b instanceof ficha && a.value == b.value)
		{
			var posA = a.body.GetPosition();
			var posB = b.body.GetPosition();
			var contactPointX = posA.x + (posB.x - posA.x) / 2;
			var contactPointY = posA.y + (posB.y - posA.y) / 2;
			var valueResult = a.value + b.value;

			that.destroy_object(a);
			that.destroy_object(b);

			that.addFicha(contactPointX, contactPointY, valueResult);
			that.score += valueResult;
			//console.log("Current Score: " + that.score);
			$( "#score" ).text(that.score);
			$( "#scoreAdd" ).append('<div class="score-addition">+' + valueResult + '</div>');
			if(localStorage.bestScore < that.score)
			{
				localStorage.bestScore = that.score;
				$( "#best-score" ).text(that.score);
			}

			
		}
		
		
	}
}

//Agregar a objetos a destruir
game.prototype.destroy_object = function(obj)
{
	this.to_destroy.push(obj);
}


//Destruir
game.prototype.perform_destroy = function()
{
	for(var i in this.to_destroy)
	{
		if(this.to_destroy[i].body != null)
		{
			var index = this.game_objects.indexOf(this.to_destroy[i]);
			if( index > -1)
			{
				this.game_objects.splice(index, 1);
			}

			this.to_destroy[i].destroy();
			this.tileCount--;
		}
		
	}

	this.to_destroy = [];
}

game.prototype.perform_addFichas = function()
{
	for(var i in this.to_add)
	{
		if(value >= 2048)
		{
			this.is_paused = true;
			this.messagefunction(true);
			return;
		}

		var x = this.to_add[i].x;
		var y = this.to_add[i].y;
		var value = this.to_add[i].value;
		this.game_objects.push(new ficha({x : x, y: y,value : value,game: this}));

		this.tileCount++;

		if(this.tileCount >= maxTiles)
		{
			this.is_paused = true;
			this.messagefunction(false);
			return;
		}
	}
	
	this.to_add = [];
	
}

ficha.prototype.destroy = function()
{
	if(this.body == null)
	{
		return;
	}
	this.body.GetWorld().DestroyBody( this.body );
	this.body = null;
	this.dead = true;
}

game.prototype.messagefunction = function (won)
{

  var type    = won ? "game-won" : "game-over";
  var message = won ? "You win!" : "Game over!";

  $(".game-message").addClass(type);
  $(".game-message .msg").text(message);
  

  //Twitter
  var tweet = document.createElement("a");
  tweet.classList.add("twitter-share-button");
  tweet.setAttribute("href", "https://twitter.com/share");
  tweet.setAttribute("data-via", "AlexSanchezCdz");
  tweet.setAttribute("data-url", "http://2048physics.gamer-on.com");
  tweet.setAttribute("data-counturl", "http://2048physics.gamer-on.com");
  tweet.textContent = "Tweet";

  var text =  "I scored " + this.score + " points at 2048physics, the new 2048 game version using physics! ";
  tweet.setAttribute("data-text", text);

  $("#shareScoreButton").append(tweet);
  twttr.widgets.load();
}