"use strict";

// Achievements manager -- responsible for loading and granting achievements

var AchievementManager = AchievementManager || {};

AchievementManager.achievements = {};
AchievementManager.preloaded = false;


// We actually need to make two calls to load achievements.
// One of which loads up the achievement definitions, and the second
// loads up which achievements the player actually earned
AchievementManager.loadData = function() {
    var request = gapi.client.games.achievementDefinitions.list();
    request.execute(function(response) {
        console.log('Achievement definitions', response);
        if(response.kind === 'games#achievementDefinitionsListResponse' && response.hasOwnProperty('items')) {
            for(var i = 0; i < response.items.length; i++) {
                AchievementManager.achievements[response.items[i].id] = response.items[i];                
                // Will be overwritten later if we have achievement data
                AchievementManager.achievements[response.items[i].id].achievementState = response.items[i].initialState;
            }        
            AchievementManager.loadAchievementsEarnedByPlayer();
        }
    });
};

AchievementManager.clearData = function() {
    AchievementManager.achievements = {};
    AchievementManager.preloaded = false;
};

AchievementManager.loadAchievementsEarnedByPlayer = function() {
    var request = gapi.client.games.achievements.list({playerId: 'me'});
    request.execute(function(response) {
        console.log('Your achievement data: ', response);
        if(response.kind == 'games#playerAchievementListResponse' && response.hasOwnProperty('items')) {
            for (var i=0; i<response.items.length; i++) {
                var nextAch = response.items[i];
                AchievementManager.achievements[nextAch.id].achievementState = nextAch.achievementState;
                if(nextAch.hasOwnProperty('formattedCurrentStepsString'))
                    AchievementManager.achievements[nextAch.id].formattedCurrentStepsString = nextAch.formattedCurrentStepsString;        
            }
        } 
        else
            console.log("**Unexpected response **", response);    
    });

    AchievementManager.preloaded = true;
};

AchievementManager.getNameForId = function(achId){
    return AchievementManager.achievements[achId].name;
};

AchievementManager.submitProgress = function(achId, amount, callback){
    var request = gapi.client.games.achievements.increment(
        {achievementId: achId,
        stepsToIncrement: amount}
    );
    
    request.execute(function(response) {
        console.log('Data from incrementing achievement is ', response);
        // Let's updated our locally cached version
        AchievementManager.achievements[achId].currentSteps = response.currentSteps;
        AchievementManager.achievements[achId].formattedCurrentStepsString = String(response.currentSteps);
        if(response.newlyUnlocked ){
            if(callback != null)
                callback(achId, true);
        } else{
            console.log('You either haven\'t unlocked ' + AchievementManager.achievements[achId].name
                    + ' yet, or you unlocked it already.');    
            if(callback != null)
                callback(achId, false);
        }
  });
};


AchievementManager.unlockAchievement = function(achId, callback){
    var request = gapi.client.games.achievements.unlock(
        {achievementId: achId}
    );
  
    request.execute(function(response) {
        console.log('Data from earning achievement is ', response);
        if(response.newlyUnlocked){
            if(callback != null)
                callback(achId, true);
            AchievementManager.loadAchievementsEarnedByPlayer();
        } 
        else {
            console.log('You unlocked ' + AchievementManager.achievements[achId].name + ' but you already unlocked it earlier.');
            if(callback != null)
                callback(achId, false);
        }
    });
};

