function AvatarView(){
    var mContext;
    
    var mSize = 0;
    
    var mX = 0;
    var mY = 0;
    
    var mImageSrc = '';
    var mImage;
        
    var mBorderColor;
    var mBorderWidth;
    
    var onClickListener;
    
    var mImageLoaded = false;
    
    var mNeedRender = true;
    
    this.setImage = function(imageSrc){
        if(mImageSrc == imageSrc)
            return;
        
        mImageSrc = imageSrc;
        
        if(mImage == null)
            mImage = new Image();
            
        mImageLoaded = false;
        mImage.src = imageSrc;
        mImage.onload = function() {
            mImageLoaded = true;
            mImage.onload = null;
            mNeedRender = true;
        };
    };
    
    this.setProperties = function(context, size, x, y, imageSrc, borderColor, borderWidth){
        mContext = context;
        mSize = size;
        mX = x;
        mY = y;        
        mBorderColor = borderColor;
        mBorderWidth = borderWidth;
        this.setImage(imageSrc);
    };
    
    this.setOnClickListener = function(listener){
        onClickListener = listener;
    };
        
    function isHit(x, y){
        return x > mX && x < mX + mSize && y > mY && y < mY + mSize;
    }
    
    this.onTouchEvent = function(action, event) {
        switch (action){
            case MOUSE_ACTION_DOWN:
                if(isHit(event.x, event.y))
                    return true;
                break;
            case MOUSE_ACTION_UP:
                if(isHit(event.x, event.y)){
                    if(onClickListener != null)
                        onClickListener();
                    
                    return true;
                }
                break;
        }
        return false;
    },
    
    this.update = function(next){
        return mNeedRender;
    };
    
    this.render = function(){        
        mContext.save();
        
        if(mImageLoaded){
            mContext.save();
             
            mContext.beginPath();
            mContext.arc(mX + mSize / 2, mY + mSize / 2, mSize / 2, 0, Math.PI * 2, true);
            mContext.closePath();
            mContext.clip();
            mContext.drawImage(mImage, mX, mY, mSize, mSize);
            
            mContext.restore();
        }
        else{
            mContext.beginPath();
            mContext.arc(mX + mSize / 2, mY + mSize / 2, mSize / 2, 0, Math.PI * 2, true);
            mContext.closePath();            
            mContext.fillStyle = '#FFFFFF';
            mContext.fill();
        }
        
        if(mBorderWidth > 0){
            mContext.beginPath();
            mContext.arc(mX + mSize / 2, mY + mSize / 2, (mSize - mBorderWidth + 2)/ 2, 0, Math.PI * 2, true);
            mContext.closePath();
            mContext.lineWidth = mBorderWidth;
            mContext.strokeStyle = mBorderColor;
            mContext.stroke();
        }
        
        mContext.restore();
        
        if(mNeedRender)
            mNeedRender = false;
    };
}
