function Button(){
    var mContext;
    
    var mWidth = 0;
    var mHeight = 0;
    
    var mX = 0;
    var mY = 0;
    
    var mImageSrc;
    var mImage;
    
    var mTextColor;
    var mText;
    var mTextSize;
    
    var mImageLoaded = false;
    var mNeedRender = true;
    
    var onClickListener;
    
    var mVisible = true;
    var mClicking = false;
    
    this.setImage = function(imageSrc){
        if(mImageSrc !== imageSrc){
            mImageSrc = imageSrc; 
            if(mImage == null)
                mImage = new Image();


            mImageLoaded = false;
            mImage.src = imageSrc;
            mImage.onload = function() {
                mImageLoaded = true;
                mImage.onload = null;
                mNeedRender = true;
            };
        }
    };
    
    this.setProperties = function(context, width, height, x, y, imageSrc, textColor, textSize){
        mContext = context;
        mWidth = width;
        mHeight = height;
        mX = x;
        mY = y;        
        mTextColor = textColor;
        mTextSize = textSize;
        this.setImage(imageSrc);        
    };
    
    this.setOnClickListener = function(listener){
        onClickListener = listener;
    };
    
    this.setText = function(text){
        mText = text;             
        mNeedRender = true;
    };
    
    this.setVisible = function(visible){
        if(mVisible !== visible){
            mVisible = visible;
            mNeedRender = true;
        }
    };
    
    function isHit(x, y){
        return x > mX && x < mX + mWidth && y > mY && y < mY + mHeight;
    }
    
    this.onTouchEvent = function(action, event) {
        if(!mVisible)
            return false;
        
        switch (action){
            case MOUSE_ACTION_DOWN:
                if(isHit(event.x, event.y)){
                    mClicking = true;
                    mNeedRender = true;
                    return true;
                }
                break;
            case MOUSE_ACTION_UP:
                if(mClicking){
                    if(onClickListener != null)
                        onClickListener();
                    
                    mClicking = false;
                    needRender = true;
                    return true;
                }
                break;
        }
        return false;
    },
    
    this.update = function(next){
        return mNeedRender;
    };
    
    this.render = function(){
        if(!mVisible)
            return;
        
        mContext.save();
        
        if(mImageLoaded){
            mContext.drawImage(mImage, mX, mY + (mClicking ? 4 : 0), mWidth, mHeight);
            
            if(mText != null){
                mContext.font = mTextSize + 'pt ' + Config.TEXT_FONT;
                mContext.textAlign = 'center';
                mContext.textBaseline = 'middle';
                mContext.fillStyle = mTextColor;
                mContext.fillText(mText, mX + mWidth / 2, mY + mHeight / 2 + (mClicking ? 4 : 0));
            }
        }
        
        mContext.restore();
        
        if(mNeedRender)
            mNeedRender = false;
    };
}
