var Config = Config || {};

Config.CELL_COLORS = [  '#CCCCCC', '#FF66FF', '#EC118E', '#DC053C',
                        '#A0D305', '#0ACF2D', '#41AF12', '#18CDCD',
                        '#129C9C', '#187D9A', '#F1761B', '#DB500D',
                        '#E24A0' ];
                    
Config.CELL_COLOR_BG = '#282825';
	
Config.CELL_COLOR_TEXT = [  '#000000', '#FFFFFF', '#FFFFFF', '#FFFFFF',
                            '#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF',
                            '#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF',
                            '#FFFFFF'];
	
Config.CELL_BLOCK_COLOR_BG = '#999999';
Config.CELL_BLOCK_COLOR_TEXT = '#282825';
		
Config.BG_CANVAS = '#302F2C';
        
Config.ANIM_DURATION = 200;

Config.ANIM_DURATION_LONG = 400;
	
Config.ANIM_IN_START_SCALE = 0.0;
Config.ANIM_MOVE_MAX_SCALE = 1.1;
	
Config.LEVEL_BLOCK_MIN = 3;
Config.LEVEL_BLOCK_MAX = 9;
Config.LEVEL_BLOCK_START = 6;
	
Config.BASE_VALUE = 2;
	
Config.BLOCK_STEP = 11;
	
Config.LEVEL_WIN = 12;

Config.TEXT_FONT = 'Roboto-Bold';

Config.BG_SCORE = '#07B9ED';
Config.TEXT_SCORE = '#FFFFFF';

Config.BG_WIN = '#00CA00';
Config.BG_OVER = '#E60000';

Config.OVERSHOOT_TENSION = 2.0;
Config.DECECLERATE_FACTOR = 2.0;
Config.ANTICIPATE_TENSION = 2.0;

Config.MAX_UNDO = 2;

Config.CLIENT_ID = '790537987337-m0veq7r27v19ghmiqrigoq5fd2knekao.apps.googleusercontent.com';

Config.ACH_FIRST_256_TILE = 'CgkIicrx_YAXEAIQAQ';
Config.ACH_FIRST_512_TILE = 'CgkIicrx_YAXEAIQAg';
Config.ACH_FIRST_1024_TILE = 'CgkIicrx_YAXEAIQAw';
Config.ACH_FIRST_2048_TILE = 'CgkIicrx_YAXEAIQBA';
Config.ACH_FIRST_4096_TILE = 'CgkIicrx_YAXEAIQBQ';
Config.ACH_FIRST_8192_TILE = 'CgkIicrx_YAXEAIQBg';
Config.ACH_FIRST_16384_TILE = 'CgkIicrx_YAXEAIQBw';
Config.ACH_500TH_256_TILE = 'CgkIicrx_YAXEAIQCA';
Config.ACH_500TH_512_TILE = 'CgkIicrx_YAXEAIQCQ';
Config.ACH_500TH_1024_TILE = 'CgkIicrx_YAXEAIQCg';
Config.ACH_500TH_2048_TILE = 'CgkIicrx_YAXEAIQCw';
Config.ACH_500TH_4096_TILE = 'CgkIicrx_YAXEAIQDA';
Config.ACH_1000TH_256_TILE = 'CgkIicrx_YAXEAIQDQ';
Config.ACH_1000TH_512_TILE = 'CgkIicrx_YAXEAIQDg';
Config.ACH_1000TH_1024_TILE = 'CgkIicrx_YAXEAIQDw';
Config.ACH_1000TH_2048_TILE = 'CgkIicrx_YAXEAIQEA';
Config.ACH_1000TH_4096_TILE = 'CgkIicrx_YAXEAIQEQ';

Config.LEAD_SINGLEPLAY = 'CgkIicrx_YAXEAIQEg';

Config.getCellColor = function(level){
    if(level >= Config.CELL_COLORS.length)
	return Config.CELL_COLORS[Config.CELL_COLORS.length - 1];
		
    return Config.CELL_COLORS[level];
};
	
Config.getCellTextColor = function(level){
    if(level >= Config.CELL_COLOR_TEXT.length)
	return Config.CELL_COLOR_TEXT[Config.CELL_COLOR_TEXT.length - 1];
		
    return Config.CELL_COLOR_TEXT[level];
};

Config.getOvershootInterpolation = function(t){
    t -= 1.0;
    return t * t * ((Config.OVERSHOOT_TENSION + 1) * t + Config.OVERSHOOT_TENSION) + 1.0;
};
    
Config.getDecelerateInterpolation = function(t){
    if (Config.DECECLERATE_FACTOR === 1.0)
        return (1.0 - (1.0 - t) * (1.0 - t));
    else
        return (1.0 - Math.pow((1.0 - t), 2 * Config.DECECLERATE_FACTOR));        
};

Config.getAnticipateInterpolation = function(t){
    return t * t * ((Config.ANTICIPATE_TENSION + 1) * t - Config.ANTICIPATE_TENSION);
}
