function ConfirmView(){}

function Option(){
    var mText = '';
        
    var mX = 0;
    var mY = 0;
    var mWidth = 0;
    var mHeight = 0;
    
    var mOffset = 0;
        
    var mVisible = true;
        
    this.setText = function(text){
        mText = text;    
    };
    
    this.isHit = function(x, y){
        return x > mX && x < mX + mWidth && y > mY && y < mY + mHeight;
    };
    
    this.isVisible = function(){
        return mVisible;
    };
    
    this.setVisible = function(visible){
        mVisible = visible;
    };
    
    this.setRegion = function(x, y, width, height){
        mX = x;
        mY = y;
        mWidth = width;
        mHeight = height;
    };
    
    this.getX = function(){
        return mX;
    };
    
    this.getWidth = function(){
        return mWidth;
    };
    
    this.setOffset = function(offset){
        mOffset = offset;
    }
    
    this.render = function(context, bgColor, textColor, textSize){
        if(!mVisible)
            return;
        
        var shift = Math.abs(mHeight / Math.tan(1.0471976));
        
        context.beginPath();
        context.moveTo(mX + mOffset, mY + mHeight);
        context.lineTo(mX + shift + mOffset, mY);
        context.lineTo(mX + mWidth + mOffset, mY);
        context.lineTo(mX + mWidth - shift + mOffset, mY + mHeight);
        context.closePath();
        context.fillStyle = bgColor;
        context.fill();
        
        context.font = textSize + 'pt ' + Config.TEXT_FONT;
        context.textAlign = 'center';
        context.textBaseline = 'middle';
        context.fillStyle = textColor;        
        context.fillText(mText, mX + mWidth / 2 + mOffset, mY + mHeight / 2);
    };
}

function Message(){
    var mText;
        
    var mX = 0;
    var mY = 0;
    var mWidth = 0;
    var mHeight = 0;
    var mLineHeight = 0;
    
    var mPercent = 0;
        
    this.setText = function(text){
        mText = text;    
    };
    
    this.getText = function(){
        return mText;    
    };
        
    this.setRegion = function(x, y, width, height, lineHeight){
        mX = x;
        mY = y;
        mWidth = width;
        mHeight = height;
        mLineHeight = lineHeight;
    };
    
    this.setPercent = function(percent){
        mPercent = percent;        
    };
    
    this.render = function(context, bgColor, textColor, textSize){
        var shift = Math.abs(mHeight / Math.tan(1.0471976));
                
        if(mPercent === 1){            
            context.beginPath();
            context.moveTo(mX, mY + mHeight);
            context.lineTo(mX + shift, mY);
            context.lineTo(mX + mWidth, mY);
            context.lineTo(mX + mWidth - shift, mY + mHeight);
            context.closePath();
            context.fillStyle = bgColor;
            context.fill();
        
            context.font = textSize + 'pt ' + Config.TEXT_FONT;
            context.textAlign = 'center';
            context.textBaseline = 'middle';
            context.fillStyle = textColor;

            var x = mX + mWidth / 2;
            var y  = mY + (mHeight - mText.length * mLineHeight) / 2 + mLineHeight / 2;
            for(var i = 0; i < mText.length; i++){
                context.fillText(mText[i], x, y);
                y += mLineHeight;
            }  
        }
        else{
            var offset = mWidth * (1 - mPercent) / 2;
            
            context.beginPath();
            context.moveTo(mX + offset, mY + mHeight);
            context.lineTo(Math.min(mX + offset + shift, mX + mWidth / 2), mY);
            context.lineTo(mX + mWidth - offset, mY);
            context.lineTo(Math.max(mX + mWidth - offset - shift, mX + mWidth / 2), mY + mHeight);
            context.closePath();
            context.fillStyle = bgColor;
            context.fill();
        }
    };
}

ConfirmView.SELECT_OPT1 = 1;
ConfirmView.SELECT_OPT2 = 2;
ConfirmView.SELECT_NONE = 0;

ConfirmView.TYPE_SHOW = 1;
ConfirmView.TYPE_HIDE = 2;
ConfirmView.TYPE_NONE = 0;

ConfirmView.prototype = (function(){
    var mContext;
    
    var mWidth;
    var mHeight;
    
    var mMessage = new Message();
    var mFirstOption = new Option();
    var mSecondOption = new Option();
    
    var mOptionBgColor;
    var mMessageBgColor;
    
    var mTextColor;
    var mMessageTextSize;
    var mOptionTextSize;
    
    var mPadding;
        
    var mVisible = false;
        
    var mOnSelectListener;
    
    var mNeedRender = true;
    
    var mAnimFactor = 0;
    var mAnimStartTime;
    var mAnimType = ConfirmView.TYPE_NONE;    
    
    var mId;
    
    var mMaxAlpha = 0.4;
    var mAlpha = 0;
        
    function measure(){
        mContext.font = mMessageTextSize + 'pt ' + Config.TEXT_FONT;
        var msgLineHeight = mContext.measureText('M').width + 4;        
        var msgHeight = msgLineHeight * mMessage.getText().length + mPadding * 2; 
        
        var msgWidth = 0;
        for(var i = 0; i < mMessage.getText().length; i++)
            msgWidth = Math.max(msgWidth, mContext.measureText(mMessage.getText()[i]).width);        
        msgWidth += mPadding * 2 + Math.abs(msgHeight / Math.tan(1.0471976)) * 2;
        
        mContext.font = mOptionTextSize + 'pt ' + Config.TEXT_FONT;        
        var optHeight = mContext.measureText('M').width + mPadding * 2;
                
        var x = (mWidth - msgWidth) / 2;
        var y = (mHeight - msgHeight - mPadding * 2 - optHeight) / 2;
        
        mMessage.setRegion(x, y, msgWidth, msgHeight, msgLineHeight);
        
        var optWidth = (mWidth * 0.75) / 2;
        x = mWidth * 0.125;
        y += msgHeight + mPadding * 2;
        mFirstOption.setRegion(x, y, optWidth, optHeight);
        
        x+= optWidth;
        mSecondOption.setRegion(x, y, optWidth, optHeight);         
    }
        
    return{
        setProperties: function(context, width, height, messageTextSize, optionTextSize, optionBgColor, textColor, padding){
            mContext = context;
            mWidth = width;
            mHeight = height;
            mMessageTextSize = messageTextSize;
            mOptionTextSize = optionTextSize;
            mOptionBgColor = optionBgColor;
            mTextColor = textColor;
            mPadding = padding;
        },
                
        getId : function(){
            return mId;
        },
                
        show: function(id, message, messageBgColor, opt1, opt2, listener){
            mId = id;
            mMessage.setText(message);
            mFirstOption.setText(opt1);
            mFirstOption.setVisible(opt1 != null);
            mSecondOption.setText(opt2);
            mSecondOption.setVisible(opt2 != null);
            mMessageBgColor = messageBgColor;
            mOnSelectListener = listener;
            
            measure();
            
            mVisible = true;
            mNeedRender = true;
            
            mAnimType = ConfirmView.TYPE_SHOW;
            mAnimStartTime = Date.now();
            mAnimFactor = 0;
        },
                
        hide: function(){
            mVisible = false;
            mNeedRender = true;
            
            mAnimType = ConfirmView.TYPE_HIDE;
            mAnimStartTime = Date.now();
            mAnimFactor = 0;
        },
        
        onTouchEvent: function(action, event) {
            if(!mVisible)
                return false;
           
            switch (action){
                 case MOUSE_ACTION_DOWN:
                    return true;
                case MOUSE_ACTION_UP:
                    if(mFirstOption.isHit(event.x, event.y)){
                        if(mOnSelectListener != null)
                            mOnSelectListener(mId, ConfirmView.SELECT_OPT1);
                    }
                    else if(mSecondOption.isHit(event.x, event.y)){
                        if(mOnSelectListener != null)
                            mOnSelectListener(mId, ConfirmView.SELECT_OPT2);
                    }
                    else{
                        if(mOnSelectListener != null)
                            mOnSelectListener(mId, ConfirmView.SELECT_NONE);
                        this.hide();
                    }                    
                    return true;
            }

            return false;
        },
        
        update: function(next){
            switch (mAnimType){
                case ConfirmView.TYPE_SHOW:
                    mAnimFactor = Math.min(1, (next - mAnimStartTime) / Config.ANIM_DURATION_LONG);
                    mAlpha = mMaxAlpha * mAnimFactor;
                    mMessage.setPercent(mAnimFactor);
                    var factor = Config.getOvershootInterpolation(mAnimFactor);
                    mFirstOption.setOffset((-mFirstOption.getWidth() - mFirstOption.getX()) * (1 - factor));
                    mSecondOption.setOffset((mWidth - mSecondOption.getX()) * (1 - factor));
                    return true;
                case ConfirmView.TYPE_HIDE:
                    mAnimFactor = Math.min(1, (next - mAnimStartTime) / Config.ANIM_DURATION_LONG);
                    mAlpha = mMaxAlpha * (1 - mAnimFactor);
                    mMessage.setPercent(1 - mAnimFactor);
                    var factor = Config.getAnticipateInterpolation(mAnimFactor);
                    mFirstOption.setOffset((-mFirstOption.getWidth() - mFirstOption.getX()) * factor);
                    mSecondOption.setOffset((mWidth - mSecondOption.getX()) * factor);
                    return true;
            }
            return mNeedRender;
        },

        render: function(){
            if(mAnimType === ConfirmView.TYPE_NONE){
                if(mNeedRender)
                    mNeedRender = false;
            
                if(!mVisible)
                    return;
                
                mAlpha = mMaxAlpha;
                mMessage.setPercent(1);
            }
            else if(mAnimFactor >= 1)
                mAnimType = ConfirmView.TYPE_NONE;             
                        
            mContext.save();
            
            mContext.beginPath();
            mContext.rect(0, 0, mWidth, mHeight);
            mContext.closePath();
            mContext.fillStyle = 'rgba(0, 0, 0, ' + mAlpha + ')';
            mContext.fill();
            
            mMessage.render(mContext, mMessageBgColor, mTextColor, mMessageTextSize);
            mFirstOption.render(mContext, mOptionBgColor, mTextColor, mOptionTextSize);
            mSecondOption.render(mContext, mOptionBgColor, mTextColor, mOptionTextSize);
            
            mContext.restore();
        }
    };
    
})();
