function Rect(){
    this.left = 0.0;
    this.top = 0.0;
    this.right = 0.0;
    this.bottom = 0.0;    
    
    this.width = function(){
        return this.right - this.left;
    };
    
    this.height = function() {
        return this.bottom - this.top;
    };

    this.centerX = function() {
        return (this.left + this.right) * 0.5;
    };

    this.centerY = function() {
        return (this.top + this.bottom) * 0.5;
    };

    this.set = function(left, top, right, bottom) {
        this.left   = left;
        this.top    = top;
        this.right  = right;
        this.bottom = bottom;
    };
}

function HexaDrawable(){
    var mContext;
    
    var mColor = '#FF0000';
    
    var mBaseEdge = 0.0;
    var mBaseWidth = 0.0;
    var mBaseHeight = 0.0;
    
    var mTextLevel = -1;
    var mTextColor = '#786F66';
    var mTextSizes = [];
    for(var i = 0; i < 20; i++)
        mTextSizes[i] = 0;    
    var mTexts = [];
    
    var DEFAULT_TEXTSIZE = 48;
    var MULTIPLIER = Math.sqrt(3);
    var ROUND_PERCENT = 0.2;
    
    var mRotateAngle = 0.0;
    var mPostScale = 1.0;
    
    var mScale = 1.0;
    var mTranslateX = 0.0;
    var mTranslateY = 0.0;
    
    var mRect = new Rect();
    
    var mPointX = [];
    var mPointY = [];
    
    function onBoundChanged(bounds){		
        mScale = Math.min(bounds.width() / mBaseWidth, bounds.height() / mBaseHeight) * mPostScale;
        mTranslateX = bounds.left + (bounds.width() - mBaseWidth * mScale) / 2;
        mTranslateY = bounds.top + + (bounds.height() - mBaseHeight * mScale) / 2;        
    }
            
    function measureText(){
        if(mTextLevel <= 0 || mTextSizes[mTextLevel] !== 0)
            return;
        
        if(mTexts[mTextLevel] == null)
            mTexts[mTextLevel] = Cell.getValue(mTextLevel);
        
        var text = mTexts[mTextLevel];	
	var textBoundWidth = mBaseWidth * 2 / 3;
        var textBoundHeight = mBaseHeight / 2;
        
        var fontStyle = DEFAULT_TEXTSIZE + 'pt ' + Config.TEXT_FONT;
        mContext.font = fontStyle;
        var width = mContext.measureText(text).width;
        var height = mContext.measureText('M').width;
        
        var scale = Math.min(textBoundWidth / width, textBoundHeight / height);
                
        mTextSizes[mTextLevel] = Math.floor(DEFAULT_TEXTSIZE * scale);
    }
        
    function getTransfromX(x){
        return x * mScale + mTranslateX;
    }
    
    function getTransfromY(y){
        return y * mScale + mTranslateY;
    }
    
    this.setContext = function(context){
        mContext = context;
    };

    this.setFloatBounds = function(left, top, right, bottom) {		
        mRect.set(left, top, right, bottom);
        onBoundChanged(mRect);
    };

    this.setPosition = function(x, y){
        this.setFloatBounds(x, y, x + mBaseWidth, y + mBaseHeight);
    };

    this.setRotateAngle = function(angle){
        if(mRotateAngle !== angle){
            mRotateAngle = angle;			
            onBoundChanged(mRect);
        }
    };

    this.setPostScale = function(scale){
        if(mPostScale !== scale){
            mPostScale = scale;			
            onBoundChanged(mRect);
        }
    };

    this.setTextLevel = function(level){
        if(mTextLevel !== level){
            mTextLevel = level;
            measureText();
        }
    };

    this.setTextColor = function(color){
        mTextColor = color;
    };

    this.setTextSize = function(size){
        if(mTextSize !== size){
            mTextSize = size;
            measureText();
        }
    };

    this.setProperties = function(color, textLevel, textColor, rotateAngle, postScale, x, y){
        this.setColor(color);
        this.setTextLevel(textLevel);
        this.setTextColor(textColor);
        mRotateAngle = rotateAngle;	
        mPostScale = postScale;	
        this.setPosition(x, y);

        return this;
    };

    this.setColor = function(color){
        mColor = color;	        
    };

    this.getBaseEdge = function(){
        return mBaseEdge;
    };

    this.getBaseWidth = function(){
        return mBaseWidth;
    };

    this.getBaseHeight = function(){
        return mBaseHeight;
    };

    this.setBaseEdge = function(l){
        if(mBaseEdge !== l){
            var half_percent = ROUND_PERCENT / 2;

            mBaseEdge = l;
            mBaseWidth = mBaseEdge * MULTIPLIER;
            mBaseHeight = mBaseEdge * 2;

            mPointX[0] = mBaseWidth * (0.5 - half_percent);
            mPointY[0] = mBaseEdge * half_percent;

            mPointX[1] = mBaseWidth * 0.5;
            mPointY[1] = 0;

            mPointX[2] = mBaseWidth * (0.5 + half_percent);
            mPointY[2] = mBaseEdge * half_percent;

            mPointX[3] = mBaseWidth * (1 - half_percent);
            mPointY[3] = mBaseEdge * (0.5 - half_percent);

            mPointX[4] = mBaseWidth;
            mPointY[4] = mBaseEdge * 0.5;

            mPointX[5] = mBaseWidth;
            mPointY[5] = mBaseEdge * (0.5 + ROUND_PERCENT);

            mPointX[6] = mBaseWidth;
            mPointY[6] = mBaseEdge * (1.5 - ROUND_PERCENT);

            mPointX[7] = mBaseWidth;
            mPointY[7] = mBaseEdge * 1.5;

            mPointX[8] = mBaseWidth * (1 - half_percent);
            mPointY[8] = mBaseEdge * (1.5 + half_percent);

            mPointX[9] = mBaseWidth * (0.5 + half_percent);
            mPointY[9] = mBaseEdge * (2 - half_percent);

            mPointX[10] = mBaseWidth * 0.5;
            mPointY[10] = mBaseEdge * 2;

            mPointX[11] = mBaseWidth * (0.5 - half_percent);
            mPointY[11] = mBaseEdge * (2 - half_percent);

            mPointX[12] = mBaseWidth * half_percent;
            mPointY[12] = mBaseEdge * (1.5 + half_percent);

            mPointX[13] = 0;
            mPointY[13] = mBaseEdge * 1.5;

            mPointX[14] = 0;
            mPointY[14] = mBaseEdge *(1.5 - ROUND_PERCENT);

            mPointX[15] = 0;
            mPointY[15] = mBaseEdge * (0.5 + ROUND_PERCENT);

            mPointX[16] = 0;
            mPointY[16] = mBaseEdge * 0.5;

            mPointX[17] = mBaseWidth * half_percent;
            mPointY[17] = mBaseEdge * (0.5 - half_percent);

            measureText();

            onBoundChanged(mRect);
        }
    };

    this.draw = function(context) {        
        context.beginPath();
        for(var i = 0; i < mPointX.length; i += 3){
            if(i === 0)
                context.moveTo(getTransfromX(mPointX[i]), getTransfromY(mPointY[i]));
            else
                context.lineTo(getTransfromX(mPointX[i]), getTransfromY(mPointY[i]));

            context.quadraticCurveTo(getTransfromX(mPointX[i + 1]), getTransfromY(mPointY[i + 1]), getTransfromX(mPointX[i + 2]), getTransfromY(mPointY[i + 2]));                
        }			
        context.closePath();

        context.fillStyle = mColor;        
        context.fill();

        if(mTextLevel > 0){
            context.font = Math.floor(mTextSizes[mTextLevel] * mScale) + 'pt ' + Config.TEXT_FONT;
            context.textAlign = 'center';
            context.textBaseline = 'middle';
            context.fillStyle = mTextColor;
            context.fillText(mTexts[mTextLevel], getTransfromX(mBaseWidth / 2), getTransfromY(mBaseHeight / 2));
        }
    };    
        
}

HexaDrawable.DEFAULT_EDGE = 300;