"use strict";

var LeaderboardManager = LeaderboardManager || {};
LeaderboardManager.preloaded = false;
LeaderboardManager.leaderboards = {};

LeaderboardManager.TIME_DAILY = 'DAILY';
LeaderboardManager.TIME_WEEKLY = 'WEEKLY';
LeaderboardManager.TIME_ALL_TIME = 'ALL_TIME';

LeaderboardManager.COL_SOCIAL = 'SOCIAL';
LeaderboardManager.COL_PUBLIC = 'PUBLIC';

/**
 * This really just loads up the leaderboard definitions. Not the scores
 * themselves
 */
LeaderboardManager.preloadData = function() {
    var request = gapi.client.games.leaderboards.list();
    request.execute(function(response) {
        console.log('Leaderboard data', response);
        if(response.kind === 'games#leaderboardListResponse' && response.hasOwnProperty('items')){
            for (var i =0; i<response.items.length; i++)
                LeaderboardManager.leaderboards[response.items[i].id] = response.items[i];       
        }
    
        LeaderboardManager.preloaded = true;    
    });
};

LeaderboardManager.clearData = function(){
    LeaderboardManager.leaderboards = {};
    LeaderboardManager.preloaded = false;
};

LeaderboardManager.getLeaderboardObject = function(leadId){
    return LeaderboardManager.leaderboards[leadId];
};

LeaderboardManager.submitScore = function(receivedScore, leaderboardId, tag, callback){
    var request;
    
    console.log('Submitting score=' + receivedScore + ' id = ' + leaderboardId + ' tag = ' + tag);
    
    if(tag == null)
        request = gapi.client.games.scores.submit(
            {leaderboardId: leaderboardId,
            score: receivedScore}
        );
    else
        request = gapi.client.games.scores.submit(
            {leaderboardId: leaderboardId,
            score: receivedScore,
            scoreTag: tag}
        );
  
    request.execute(function(response) {
        console.log('Data from submitting high score is ', response);
        
        var newDailyHighScore = false;
        var newWeeklyHighScore = false;
        var newAllTimeHighScore = false;
        
        if(response.hasOwnProperty('beatenScoreTimeSpans')){
            for(var i = 0; i < response.beatenScoreTimeSpans.length; i++){
                if(response.beatenScoreTimeSpans[i] === LeaderboardManager.TIME_DAILY){
                    console.log('Hooray! New daily high score!');
                    newDailyHighScore = true;
                }
                else if(response.beatenScoreTimeSpans[i] === LeaderboardManager.TIME_WEEKLY) {
                    console.log('Hooray! New weekly high score!');
                    newWeeklyHighScore = true;
                }
                else if(response.beatenScoreTimeSpans[i] === LeaderboardManager.TIME_ALL_TIME) {
                    console.log('Hooray! New all-time high score!');
                    newAllTimeHighScore = true;
                }
            }
        }
        
        if(callback != null)
            callback(newDailyHighScore, newWeeklyHighScore, newAllTimeHighScore);
    });
};