"use strict";

var LeaderboardTable = LeaderboardTable || {};

LeaderboardTable.modal = document.querySelector('#modal-leaderboard');
LeaderboardTable.nextToken = '';
LeaderboardTable.numScores = 0;
LeaderboardTable.loading = null;
LeaderboardTable.leaderboardId = '';
LeaderboardTable.visible = false;

LeaderboardTable.showLeaderboard = function(leaderboardId){
    console.log("I am going to show leaderboard ", leaderboardId);
    
    var request = gapi.client.games.scores.list(
        {collection: LeaderboardManager.COL_PUBLIC,
            leaderboardId: leaderboardId,
            timeSpan: LeaderboardManager.TIME_ALL_TIME
        }
    );
    
    LeaderboardTable.leaderboardId = leaderboardId;
    LeaderboardTable.nextToken = '';
    LeaderboardTable.numScores = 0;
    LeaderboardTable.loading = true;
    
    request.execute(function(response) {
        console.log('This is your data: ', response);
        LeaderboardTable.nextToken = response.nextPageToken;        
        if(response.hasOwnProperty('items')){
            $('#leaderboard').empty();
            LeaderboardTable.numScores += response.items.length;
            for(var i = 0; i < response.items.length; i++) {    
                var $leaderboardRow = LeaderboardTable.buildTableRowFromData(i + 1, response.items[i]);
                $leaderboardRow.appendTo($('#leaderboard'));
            }
        }
        else{
            $('#leaderboard').empty();
        }
        LeaderboardTable.loading = false;
        LeaderboardTable.showModal();
    });
};

LeaderboardTable.buildTableRowFromData = function(index, rowObj) {
    var scorePlayer = rowObj.player;
    var url = scorePlayer.avatarImageUrl == null ? 'res/avatar_default.png' : (scorePlayer.avatarImageUrl + '?sz=72');    
    var $listRow = $('<li></li>');
    var $container = $('<div></div>')
            .prop('class', 'md_list_row');
    
    var $numCell = $('<p></p>').prop('id', 'row_num').text(index + '');
    var $imgCell = $('<img />').prop('src', url).prop('id', 'row_img');
    
    var $infoCell = $('<div></div>').prop('id', 'row_info');
    var $nameCell = $('<p></p>').prop('id', 'row_name').text(scorePlayer.displayName);
    var $scoreCell = $('<p></p>').prop('id', 'row_score').text(rowObj.formattedScore);
    
    $infoCell.append($nameCell).append($scoreCell);
    $container.append($numCell).append($imgCell).append($infoCell);
    $listRow.append($container);
    
    return $listRow;
};

LeaderboardTable.showModal = function(){ 
    classie.add(LeaderboardTable.modal, 'md-show');
    LeaderboardTable.visible = true;
};

LeaderboardTable.hideModal = function(){
    classie.remove(LeaderboardTable.modal, 'md-show');
    LeaderboardTable.visible = false;
    LeaderboardTable.nextToken = '';
    LeaderboardTable.numScores = 0;
};

LeaderboardTable.loadMore = function(){
    if(!LeaderboardTable.loading && LeaderboardTable.nextToken != null && LeaderboardTable.visible){        
        console.log("load more leaderboard data ", LeaderboardTable.leaderboardId);

        var request = gapi.client.games.scores.list(
            {collection: LeaderboardManager.COL_PUBLIC,
                leaderboardId: LeaderboardTable.leaderboardId ,
                timeSpan: LeaderboardManager.TIME_ALL_TIME,
                pageToken: LeaderboardTable.nextToken
            }
        );

        LeaderboardTable.loading = true;

        request.execute(function(response) {
            console.log('This is your data: ', response);
            LeaderboardTable.nextToken = response.nextPageToken;        
            if(response.hasOwnProperty('items')){                
                for(var i = 0; i < response.items.length; i++) {    
                    var $leaderboardRow = LeaderboardTable.buildTableRowFromData(LeaderboardTable.numScores + i + 1, response.items[i]);
                    $leaderboardRow.appendTo($('#leaderboard'));
                }
                LeaderboardTable.numScores += response.items.length;
            }
            LeaderboardTable.loading = false;
        });
    }
}

var overlay = document.querySelector('.md-overlay');
overlay.addEventListener('click', function(ev){
    ev.stopPropagation();
    LeaderboardTable.hideModal();
});

var close = document.querySelector('.md-close');
close.addEventListener('click', function(ev){
    ev.stopPropagation();
    LeaderboardTable.hideModal();
});

$('#leaderboard').scroll(function(){
    if($('#leaderboard').scrollTop() + $('#leaderboard').innerHeight() >= $('#leaderboard').get(0).scrollHeight && LeaderboardTable.numScores > 0)
        LeaderboardTable.loadMore();  
});