
"use strict";
var Player = Player || {};

Player.loaded = false;
Player.displayName = '';
Player.profileUrl = 'res/avatar_default.png';
Player.userId = '';

Player.loadLocalPlayer = function() {
  var request = gapi.client.games.players.get({playerId: 'me'});
  request.execute(function(response) {
    console.log('This is who you are ', response);
    Player.displayName = response.displayName;
    Player.profileUrl = response.avatarImageUrl;
    Player.userId = response.playerId;
    Player.loaded = true;
    
    showNotif('Welcome back, ' + Player.displayName + '!');
    console.log(Player.profileUrl);
    
    if(mAvatarView != null)
        mAvatarView.setImage(Player.profileUrl);
    
    if(mLoginButton != null)
        mLoginButton.setVisible(false);
  });
};

Player.clearData = function() {
    Player.displayName = '';
    Player.profileUrl = 'res/avatar_default.png';
    Player.userId = '';
    Player.loaded  = false;
  
    if(mAvatarView != null)
        mAvatarView.setImage(Player.profileUrl);
    
    if(mLoginButton != null)
        mLoginButton.setVisible(true);
};
