function ScoreView(){}

ScoreView.prototype = (function(){
    var mContext;
    
    var mWidth = 0;
    var mHeight = 0;
    
    var mX = 0;
    var mY = 0;
    
    var mTextColor;
    var mText;
    var mTextSize;
    
    var mBackgroundColor;
    
    var DEFAULT_TEXTSIZE = 48;
    
    var mNeedRender = true;
    
    function measureText(){
        if(mText == null)
            return;
        
	var textBoundWidth = mWidth * 3 / 4;
        var textBoundHeight = mHeight * 2 / 3;
        
        var fontStyle = DEFAULT_TEXTSIZE + 'pt ' + Config.TEXT_FONT;
        mContext.font = fontStyle;
        var width = mContext.measureText(mText).width;
        var height = mContext.measureText('M').width;
        
        var scale = Math.min(textBoundWidth / width, textBoundHeight / height);
                
        mTextSize = Math.floor(DEFAULT_TEXTSIZE * scale);
    }
    
    return{
        setProperties: function(context, width, height, x, y, textColor, bgColor){
            mContext = context;
            mWidth = width;
            mHeight = height;
            mX = x;
            mY = y;
            mTextColor = textColor;
            mBackgroundColor = bgColor;

            measureText();
        },

        setText: function(text){
            mText = text;          
            measureText();          
            mNeedRender = true;
        },

        onTouchEvent: function(action, event) {
            return false;
        },

        update: function(next){
            return mNeedRender;
        },

        render: function(){
            mContext.save();
            
            mContext.beginPath();
            mContext.moveTo(mX, mY);
            mContext.lineTo(mX + mWidth, mY);
            mContext.lineTo(mX + mWidth, mY + mHeight);
            mContext.lineTo(mX, mY + mHeight);
            mContext.closePath();
            mContext.fillStyle = mBackgroundColor;
            mContext.fill();

            if(mText != null){
                mContext.font = mTextSize + 'pt ' + Config.TEXT_FONT;
                mContext.textAlign = 'center';
                mContext.textBaseline = 'middle';
                mContext.fillStyle = mTextColor;
                mContext.fillText(mText, mX + mWidth / 2, mY + mHeight / 2);
            }

            mContext.restore();

            if(mNeedRender)
                mNeedRender = false;
        }

    };   
    
})();
