"use strict";

var login = login || {};

/**
 * This function allows us to load up the game service via the discovery doc
 * and makes calls directly through the client library instead of needing
 * to specify the REST endpoints.
 */
login.loadClient = function() {

  // Load up /games/v1
  gapi.client.load('games','v1',function(response) {
      if(!Player.loaded)
        Player.loadLocalPlayer();
      if(!LeaderboardManager.preloaded)
        LeaderboardManager.preloadData();
      AchievementManager.loadData();
  });

  // Load up v1management
  gapi.client.load('gamesManagement','v1management', function(response) {
  });

  // Load up /plus/v1
  gapi.client.load('plus','v1', function(response) {
  });

};

login.handleAuthResult = function(auth) {
    console.log('We are in handle auth result', auth);
    if(auth && auth.error == null){
        console.log('Hooray! You\'re logged in! ', auth );
        login.loadClient();
    } else {
        console.log('Login failed because: ', auth.error);
//        if(auth && auth.hasOwnProperty('error'))
//            console.log('Login failed because: ', auth.error);
    }
};


login.showLoginDialog = function() {
    console.log('Trying not-so-silent auth');
    gapi.auth.signIn();
};

login.logout = function() {
    gapi.auth.signOut();
    Player.clearData();
    LeaderboardManager.clearData();
    AchievementManager.clearData();
};

