/* 
 * @file        4dcc.js
 * @version     v1.0.1
 * @createDate  10-May-14
 * @author      Chonchanok MueangRuangWit
 * @copyRight   4DBag Software 2014
 */

var debug_mode = true;
var _4dbag_satatus = {lastUpdate: '', tmp: ''};
var INFO = 'INFO', WARNING = 'WARN', ERROR = 'ERROR';

var _4DCC = function (settings)
{
    // Private variables
    var currencies = new Array();
    var URL_YAHOO_API = 'http://finance.yahoo.com/webservice/v1/symbols/allcurrencies/quote?format=json';
    var URL_BITCOIN_API = "http://blockchain.info/ticker";
    var YAHOO_API = 'yahoo', BITCOIN_API = 'bitcoin';
    var decimals = 2;
    var lastUpdate;
    var errorActionFn;
    
    //Public method
    this.convert = function (from, to, volume)
    {
        if(! (from in currencies) || ! (to in currencies)) return false;
        
        var converted;
        
        if(from === "USD")
            converted = currencies[to].forOneUSD * volume;
        else if( to === "USD")
            converted = ( 1 / currencies[from].forOneUSD ) * volume;
        else
            converted = ( currencies[to].forOneUSD / currencies[from].forOneUSD ) * volume;
        
        var msg = "convert " + from + " to " + to + " by " + volume + ": " + converted + " " + to;
        myLog(INFO, msg);
        
        if(decimals > -1)
            return converted.toFixed(decimals);
        else
            return converted;
    };
    
    this.refreshRate = function ()
    {
        get_exchange_rates();
        get_bitcoin_rate();
    };
    
    this.setDecimal= function (num)
    {
        decimals = num;
    };
    
    this.getLastUpdateDateTime = function()
    {
        return lastUpdate;
    };
    
    this.getCurrenciesList = function ()
    {
        return currencies;
    };
    
    this.setUpdateErrorAction = function(fn)
    {
        errorActionFn = fn;
    };
    
    this.storeCurrencyData = function()
    {
        var sets = {};
        sets = currencies;
        sets.pair = currencyNames;
        sets.lastUpdate = _4dbag_satatus.tmp;
        var str = createJSONString(sets);
        localStorage.setItem('settings', str);
    };
    
    
    // Private method
    var ajaxHelper = function ( url, fn, api)
    {
        var xhr = new XMLHttpRequest({mozSystem: true});
        xhr.open("GET", url, true);
        xhr.responseType = "text";

        xhr.onload = fn;
        xhr.onerror = function () {
            var error_log = '';
            switch (api)
            {
                case YAHOO_API:
                    error_log = 'Could not connect to Yahoo! Currency API';
                    break;
                case BITCOIN_API:
                    error_log = 'Could not connect to Bitcoin API';
                    break;
            }
            myLog(ERROR, error_log);
            errorActionFn();
        };
        xhr.send();
    };
    
    var get_exchange_rates = function()
    {
        ajaxHelper(URL_YAHOO_API, function(){
            try
            {
                var rates = JSON.parse(this.response).list.resources;
                for(var i in rates)
                {
                    var code = rates[i].resource.fields.name.substr(4, 6);

                    if(currenciesList[code] !== undefined)
                    {
                        currencies[code] = new Currency(code, currenciesList[code].name, rates[i].resource.fields.price);
                    }
                }
                _4dbag_satatus.lastUpdate = Date();
                _4dbag_satatus.tmp = Date();
                storeCurrencyData();
            }
            catch (err)
            {
                myLog(ERROR, err.message);
                myLog(ERROR, err.stack);
            }
        }, YAHOO_API);
    };
    
    var get_bitcoin_rate = function()
    {
        ajaxHelper(URL_BITCOIN_API, function(){
            try
            {
                var rate = JSON.parse(this.response);
                currencies['BTC'] = new Currency("BTC", "Bitcoin", 1 / rate.USD.buy);
                _4dbag_satatus.lastUpdate = Date();
                _4dbag_satatus.tmp = Date();
                storeCurrencyData();
            }
            catch (err)
            {
                myLog(ERROR, err.message);
                myLog(ERROR, err.stack);
            }
        }, BITCOIN_API);
    };
    
    var restoreCurrencyData = function()
    {
        var data = localStorage.getItem('settings');
        if(data !== null)
            return JSON.parse(data);
        else
            return null;
    };
    
    //Construction Zone
    //this.refreshRate();
    
    if(settings !== undefined)
    {
        currencies = settings.currencies;
    }
};

function Currency(symbol, name, toUSD)
{
    this.symbol = symbol;
    this.name = name;
    this.forOneUSD = toUSD;
}