/* 
 * @file        init.js
 * @version     v1.0.1
 * @createDate  10-May-14
 * @author      Chonchanok MueangRuangWit
 * @copyRight   4DBag Software 2014
 */

$(document).ready(function(){
//    var settings = getSettings();
//    
//    if(settings !== null)
//    {
//        _4dcc = new _4DCC(settings);
//        currencyNames = settings.pair;
//        _4dbag_satatus.lastUpdate = settings.lastUpdate;
//        _4dbag_satatus.tmp = settings.lastUpdate;
//    }
//    else
        _4dcc = new _4DCC();    
    
    _4dcc.setUpdateErrorAction(updateErrorFn);
    _4dcc.refreshRate();
    createCurrenciesList();
    $("#getJax").click(callAjaxBtnClkListener);
    $("#home input[type=number]").keyup(textChangedListener);
    $('#home input[type=number]').click(function(){$(this).val('');});
    $('#currency_1_name, #currency_2_name').click(moveToCurrenciesListPage);
    $('.currencyItem').click(currencyItemClick);
    // initialize state
    initScreen();    
    setWatching();
    updateCurrencyQuote();
});

function createCurrenciesList() {
    for(var c in currenciesList) {
        $('div#currency_list ul').append(genCurrencyListItem(currenciesList[c]));
    }
}

function genCurrencyListItem(item)
{
    var str = "<li class='currencyItem' alpha3='" + item.alpha3 +"'><span class='flag flag-" + item.alpha2 + "'></span>" + item.name + " (" + item.alpha3 +")</li>";
    return  str;
}

function callAjaxBtnClkListener()
{
    _4dcc.refreshRate();
}

function textChangedListener(event)
{
    var which = $(this).attr('name');
    var val = $(this).val();
    var from, to;
    if(which === 'text_1')
    {
        from = currencyNames[TEXT_1];
        to = currencyNames[TEXT_2];
    }
    else
    {
        from = currencyNames[TEXT_2];
        to = currencyNames[TEXT_1];
    }    
    
    val = numberValidator(val);
    
    var convertedVal = _4dcc.convert(from, to, val);
    
    if(which === 'text_1')
    {
        $('#' + varNames[TEXT_2]).val(convertedVal);
    }
    else
    {
        $('#' + varNames[TEXT_1]).val(convertedVal);
    }
    
    values[TEXT_1] =  $('#' + varNames[TEXT_1]).val();
    values[TEXT_2] =  $('#' + varNames[TEXT_2]).val();
}

function updateInputBox()
{
    $('#from_text').val(fromValue);
    $('#to_text').val(toValue);
}

function numberValidator(str)
{
    if(str == '')
    {
        return '0';
    }
    return str;
}

function loadStoredData()
{
    if(localStorage.getItem('_4dccData') !== null)
    {
        
    }
}

function initScreen()
{
    updateCurrencyQuote();
}

function moveToCurrenciesListPage()
{
    focusedCurrencyName = $(this).attr('id');
    $.mobile.navigate('#currency_list');
}

function currencyItemClick()
{
    var alpha3 = $(this).attr('alpha3');
    var from, to, from_, to_, volume;
    if(focusedCurrencyName === 'currency_1_name')
    {
        from_ = TEXT_1;
        to_ = TEXT_2;
    }
    else
    {
        from_ = TEXT_2;
        to_ = TEXT_1;
    }
    
    currencyNames[from_] = alpha3;
    from = alpha3;
    to = currencyNames[to_];
    volume = values[from_];

    var converted = _4dcc.convert(from, to, volume);
    $('#' + varNames[to_]).val(converted);
    values[to_] = converted;
    
    updateCurrencyQuote();
    $.mobile.navigate('');
}

function updateCurrencyQuote()
{
    var c1class = getNationFlagOfThisElement(CURRENCY_LOGO_1_ID);
    var c2class = getNationFlagOfThisElement(CURRENCY_LOGO_2_ID);
    
    $('#' + CURRENCY_LOGO_1_ID).removeClass(c1class);
    $('#' + CURRENCY_LOGO_2_ID).removeClass(c2class);
    
    c1class = getFlagClassName(currencyNames[TEXT_1]);
    c2class = getFlagClassName(currencyNames[TEXT_2]);
    
    $('#' + CURRENCY_LOGO_1_ID).addClass(c1class);
    $('#' + CURRENCY_LOGO_2_ID).addClass(c2class);
    
    _4dcc.storeCurrencyData();
}

function getNationFlagOfThisElement(id)
{
    var classList = document.getElementById(id).className.split(/\s+/);
    for (var i = 0; i < classList.length; i++)
    {
        if (classList[i].match(/flag-[a-z0-9][a-z0-9]/) !== null)
            return classList[i];
    }
    
    return null;
}

function getFlagClassName(alpha3)
{
    return 'flag-' + currenciesList[alpha3].alpha2;
}

function setWatching()
{
    _4dbag_satatus.watch('lastUpdate',function(id, oldVal, newVal){        
        var msg = 'Currency was updated';
        $('#update_date').html(dateToTime(newVal, 'LLLL'));
        myLog(INFO, msg);
    });
}

function updateErrorFn()
{
    $('#error_msg').popup();
    $('#error_msg').popup('open');
}

function getSettings()
{
    var json = localStorage.getItem('settings');
    //myLog(INFO, 'json: ' + json);
    if(json !== null)
        return JSON.parse(json);
    else 
        return null;
}