var app = {
	"valorPantalla": "0",
	"resultado": 0,
	"operando": 0,
	"operacion": "",
	"digitosEntrada": 0,
	"maxDigitos": 10,
	"existePuntoDecimal": false,
	"valorMayorSinExponente": 0,
	"bloqueo": false,
	"valorPI": "3.141592653",
	"arrayMemoria": [ 0, 0, 0, 0, 0],
	"operacionMemoria": "",
	"editable": true,

		// Estados:
		//	R: resultado
		//	P: introducción primer operando
		//	O: operación
		//	S: introducción segundo operando
	"estado": 'R',

	"MEF": {
		"R": {
			"C": "clear",
			"N": "negativo",
			"R": "raizCuadrada",
			"B": "clear",
			"D0": "clear",
			"D1": "digito",
			"D2": "digito",
			"D3": "digito",
			"D4": "digito",
			"D5": "digito",
			"D6": "digito",
			"D7": "digito",
			"D8": "digito",
			"D9": "digito",
			"P": "puntoDecimal",
			"DIV": "operador",
			"MUL": "operador",
			"RES": "operador",
			"SUM": "operador",
			"PI": "pi",
			"I": "",
			"OB": "obtener",
			"GU": "guardar"
			},
		"P": {
			"C": "clear",
			"N": "negativo",
			"R": "raizCuadrada",
			"B": "borrarDigito",
			"D0": "digito",
			"D1": "digito",
			"D2": "digito",
			"D3": "digito",
			"D4": "digito",
			"D5": "digito",
			"D6": "digito",
			"D7": "digito",
			"D8": "digito",
			"D9": "digito",
			"P": "puntoDecimal",
			"DIV": "operador",
			"MUL": "operador",
			"RES": "operador",
			"SUM": "operador",
			"PI": "pi",
			"I": "",
			"OB": "obtener",
			"GU": "guardar"
			},
		"O": {
			"C": "clear",
			"N": "",
			"R": "",
			"B": "borrarDigito",
			"D0": "digito",
			"D1": "digito",
			"D2": "digito",
			"D3": "digito",
			"D4": "digito",
			"D5": "digito",
			"D6": "digito",
			"D7": "digito",
			"D8": "digito",
			"D9": "digito",
			"P": "puntoDecimal",
			"DIV": "operador",
			"MUL": "operador",
			"RES": "operador",
			"SUM": "operador",
			"PI": "pi",
			"I": "calcular",
			"OB": "obtener"
			},
		"S": {
			"C": "clear",
			"N": "negativo",
			"R": "raizCuadrada",
			"B": "borrarDigito",
			"D0": "digito",
			"D1": "digito",
			"D2": "digito",
			"D3": "digito",
			"D4": "digito",
			"D5": "digito",
			"D6": "digito",
			"D7": "digito",
			"D8": "digito",
			"D9": "digito",
			"P": "puntoDecimal",
			"DIV": "operador",
			"MUL": "operador",
			"RES": "operador",
			"SUM": "operador",
			"PI": "pi",
			"I": "calcular",
			"OB": "obtener",
			"GU": "guardar"
			}
	},

	"inicializar": function() {
		document.getElementById("tecla-C").onclick = function() { app.clic('C'); };
		document.getElementById("tecla-GU").onclick = function() { app.clic('GU'); };
		document.getElementById("tecla-OB").onclick = function() { app.clic('OB'); };
		document.getElementById("tecla-B").onclick = function() { app.clic('B'); };
		document.getElementById("tecla-SUM").onclick = function() { app.clic('SUM'); };
		document.getElementById("tecla-RES").onclick = function() { app.clic('RES'); };
		document.getElementById("tecla-MUL").onclick = function() { app.clic('MUL'); };
		document.getElementById("tecla-DIV").onclick = function() { app.clic('DIV'); };
		document.getElementById("tecla-D7").onclick = function() { app.clic('D7'); };
		document.getElementById("tecla-D8").onclick = function() { app.clic('D8'); };
		document.getElementById("tecla-D9").onclick = function() { app.clic('D9'); };
		document.getElementById("tecla-R").onclick = function() { app.clic('R'); };
		document.getElementById("tecla-D4").onclick = function() { app.clic('D4'); };
		document.getElementById("tecla-D5").onclick = function() { app.clic('D5'); };
		document.getElementById("tecla-D6").onclick = function() { app.clic('D6'); };
		document.getElementById("tecla-N").onclick = function() { app.clic('N'); };
		document.getElementById("tecla-D1").onclick = function() { app.clic('D1'); };
		document.getElementById("tecla-D2").onclick = function() { app.clic('D2'); };
		document.getElementById("tecla-D3").onclick = function() { app.clic('D3'); };
		document.getElementById("tecla-PI").onclick = function() { app.clic('PI'); };
		document.getElementById("tecla-D0").onclick = function() { app.clic('D0'); };
		document.getElementById("tecla-P").onclick = function() { app.clic('P'); };
		document.getElementById("tecla-I").onclick = function() { app.clic('I'); };

		document.getElementById("clic-m0").onclick = function() { app.clicMem(0); };
		document.getElementById("clic-m1").onclick = function() { app.clicMem(1); };
		document.getElementById("clic-m2").onclick = function() { app.clicMem(2); };
		document.getElementById("clic-m3").onclick = function() { app.clicMem(3); };
		document.getElementById("clic-m4").onclick = function() { app.clicMem(4); };

		this.clear();
	},

	"clear": function() {
		var pantalla = document.getElementById("pantalla");
		this.valorPantalla = "0";
		this.resultado = 0;
		this.operando = 0;
		this.operacion = "";
		this.digitosEntrada = 0;
		this.existePuntoDecimal = 0;
		this.estado = "R";
		this.valorMayorSinExponente = ('1e' + this.maxDigitos) - 1;
		this.bloqueo = false;

		this.escribirPantalla();

		window.onresize = app.procesarCambioOrientacion;
	},

	"procesarCambioOrientacion": function() {
		app.escribirPantalla();
	},

	"escribirPantalla": function() {
		var texto;
			// Si es NaN se muestra error
		if (isNaN(this.valorPantalla)) {
			texto = "Error";
			this.bloqueo = true;
		} else {
				// Si es 'Infinito' se muestra el símbolo
			var infinito = new RegExp((1 / 0) + '', 'g');
			texto = this.valorPantalla;
			texto = texto.replace(infinito, '∞');
			this.bloqueo = (texto == '∞');
		}
		
		var pantalla = document.getElementById("pantalla");
		var anchura = pantalla.offsetWidth;
		var altura = pantalla.offsetHeight;
		var pxw = (26 + (9 * (anchura - 300) / 100));
		var pxh = (26 + (9 * (altura - 40) / 19));
		pxw = (pxw * 21) / (1 + texto.length);

		px = (pxw < pxh) ? pxw : pxh;
		pantalla.style.fontSize = px + "px";
		//pantalla.style.fontSize = "120px";

		pantalla.innerHTML = texto;
		
		this.existePuntoDecimal = (texto.indexOf(".") >= 0);
		this.editable = (texto.indexOf("e") == -1);
		if (!this.bloqueo && this.editable) {
			this.digitosEntrada = 0;
			for (var i=0 ; i<texto.length ; i++) {
				if ("0123456789".indexOf(texto.substr(i, 1)) >= 0) {
					++this.digitosEntrada;
				}
			}
		}
	},
	
	"clic": function(tecla) {
		if (!this.bloqueo || tecla == "C") {
			var funcion = this.MEF[this.estado][tecla];
			if ((typeof funcion) != 'undefined' && funcion != "") {
				this[funcion](tecla);
			}
		}
	},

	"borrarDigito": function(tecla) {
		if (!this.editable) {
			return;
		}

		var ultimo = this.valorPantalla.substr(this.valorPantalla.length - 1, 1);
		switch (this.estado) {
			case 'P':
				if (ultimo == ".") {
					this.valorPantalla = this.valorPantalla.substr(0, this.valorPantalla.length - 1);
					this.escribirPantalla();
				} else {
					this.valorPantalla = this.valorPantalla.substr(0, this.valorPantalla.length - 1);
					if (this.valorPantalla == "-" || this.valorPantalla == "") {
						this.clear();
					} else {
						this.escribirPantalla();
					}
				}
				break;
			case 'O':
				this.estado = "P";
				if (ultimo == ".") {
					this.valorPantalla = this.valorPantalla.substr(0, this.valorPantalla.length - 1);
					this.escribirPantalla();
				} else {
					this.valorPantalla = this.valorPantalla.substr(0, this.valorPantalla.length - 1);
					if (this.valorPantalla == "-" || this.valorPantalla == "") {
						this.clear();
					} else {
						this.escribirPantalla();
					}
				}
				break;
			case 'S':
				if (ultimo == ".") {
					this.valorPantalla = this.valorPantalla.substr(0, this.valorPantalla.length - 1);
					this.escribirPantalla();
				} else {
					this.valorPantalla = this.valorPantalla.substr(0, this.valorPantalla.length - 1);
					if (this.valorPantalla == "-" || this.valorPantalla == "") {
							this.valorPantalla = "0";
							this.estado = "O";
					} else {
						this.escribirPantalla();
					}
				}
				break;
		}
	},

	"raizCuadrada": function(tecla) {
		switch (this.estado) {
			case 'R':
				this.resultado = Math.sqrt(this.valorPantalla * 1.0);
				this.prepararResultado();
				this.existePuntoDecimal = (this.valorPantalla.indexOf(".") >= 0);
				break;
			case 'P':
				this.resultado = Math.sqrt(this.valorPantalla * 1.0);
				this.prepararResultado();
				this.existePuntoDecimal = (this.valorPantalla.indexOf(".") >= 0);
				this.estado = "R";
				break;
			case 'S':
				this.resultado = Math.sqrt(this.valorPantalla * 1.0);
				this.prepararResultado();
				this.existePuntoDecimal = (this.valorPantalla.indexOf(".") >= 0);
				break;
		}
	},

	"puntoDecimal": function(tecla) {
		tecla = ".";
		switch (this.estado) {
			case 'R':
				this.valorPantalla = "0.";
				this.digitosEntrada = 1;
				this.estado = 'P';
				this.escribirPantalla();
				break;
			case 'P':
				if (!this.existePuntoDecimal) {
					this.valorPantalla += tecla;
					this.escribirPantalla();
				}
				break;
			case 'O':
				this.valorPantalla = "0.";
				this.digitosEntrada = 1;
				this.estado = 'S';
				this.escribirPantalla();
				break;
			case 'S':
				if (!this.existePuntoDecimal) {
					this.valorPantalla += tecla;
					this.escribirPantalla();
				}
				break;
		}
	},

	"operador": function(tecla) {
		switch (this.estado) {
			case 'R':
				this.operacion = tecla;
				this.operando = this.valorPantalla * 1.0;
				this.estado = "O";
				break;
			case 'P':
				this.operacion = tecla;
				this.operando = this.valorPantalla * 1.0;
				this.estado = "O";
				break;
			case 'O':
				this.operacion = tecla;
				break;
			case 'S':
				this.calcular(tecla);
				this.operacion = tecla;
				this.operando = this.valorPantalla * 1.0;
				this.estado = "O";
				break;
		}
	},

	"negativo": function(tecla) {
		var inicio = this.valorPantalla.substr(0, 1);
		if (inicio == "-") {
			this.valorPantalla = this.valorPantalla.substr(1);
		} else {
			if (this.valorPantalla != "0") {
				this.valorPantalla = "-" + this.valorPantalla;
			}
		}
		this.escribirPantalla();
	},

	"digito": function(tecla) {
		tecla = tecla.substr(1, 1);
		switch (this.estado) {
			case 'R':
				this.valorPantalla = tecla;
				this.digitosEntrada = 1;
				this.estado = 'P';
				this.escribirPantalla();
				break;
			case 'P':
				if (this.editable && this.digitosEntrada < this.maxDigitos) {
					this.valorPantalla += tecla;
					this.digitosEntrada++;
					this.escribirPantalla();
				}
				break;
			case 'O':
				this.valorPantalla = tecla;
				this.digitosEntrada = 1;
				this.estado = 'S';
				this.escribirPantalla();
				break;
			case 'S':
				if (this.editable && this.digitosEntrada < this.maxDigitos) {
					this.valorPantalla += tecla;
					this.digitosEntrada++;
					this.escribirPantalla();
				}
				break;
		}
	},

	"pi": function(tecla) {
		switch (this.estado) {
			case 'R':
				this.valorPantalla = this.valorPI;
				this.digitosEntrada = 10;
				this.estado = 'P';
				this.escribirPantalla();
				break;
			case 'P':
				this.valorPantalla = this.valorPI;
				this.digitosEntrada = 10;
				this.escribirPantalla();
				break;
			case 'O':
				this.valorPantalla = this.valorPI;
				this.digitosEntrada = 10;
				this.estado = 'S';
				this.escribirPantalla();
				break;
			case 'S':
				this.valorPantalla = this.valorPI;
				this.digitosEntrada = 10;
				this.escribirPantalla();
				break;
		}
		//alert(window.innerWidth + " x " + window.innerHeight);
	},

	"calcular": function(tecla) {
		switch (this.estado) {
			case 'O':
				switch (this.operacion) {
					case 'SUM':
						this.resultado = this.operando + this.operando;
						break;
					case 'RES':
						this.resultado = this.operando - this.operando;
						break;
					case 'MUL':
						this.resultado = this.operando * this.operando;
						break;
					case 'DIV':
						this.resultado = this.operando / this.operando;
						break;
				}
				this.prepararResultado();
				this.estado = "R";
				break;
			case 'S':
				switch (this.operacion) {
					case 'SUM':
						this.resultado = this.operando + (this.valorPantalla * 1.0);
						break;
					case 'RES':
						this.resultado = this.operando - (this.valorPantalla * 1.0);
						break;
					case 'MUL':
						this.resultado = this.operando * (this.valorPantalla * 1.0);
						break;
					case 'DIV':
						this.resultado = this.operando / (this.valorPantalla * 1.0);
						break;
				}
				this.prepararResultado();
				this.estado = "R";
				break;
		}
	},

	"prepararResultado": function() {
		this.resultado = parseFloat(this.resultado.toPrecision(this.maxDigitos));
		if (this.resultado > this.valorMayorSinExponente || this.resultado < -this.valorMayorSinExponente) {
			this.resultado = this.resultado.toExponential();
		}
		this.operacion = "";
		this.valorPantalla = this.resultado + '';
		this.escribirPantalla();
	},

	"obtener": function(tecla) {
		this.operacionMemoria = tecla;
		for (var i=0 ; i<5 ; i++) {
			document.getElementById("mem-" + i).innerHTML = this.arrayMemoria[i];
		}
		document.getElementById("fondo-oscuro").style.visibility = "visible";
		document.getElementById("ventana").style.visibility = "visible";
	},

	"guardar": function(tecla) {
		this.operacionMemoria = tecla;
		for (var i=0 ; i<5 ; i++) {
			document.getElementById("mem-" + i).innerHTML = this.arrayMemoria[i];
		}
		document.getElementById("fondo-oscuro").style.visibility = "visible";
		document.getElementById("ventana").style.visibility = "visible";
	},

	"clicMem": function(indice) {
		if (this.operacionMemoria == "OB") {
			this.valorPantalla = this.arrayMemoria[indice] + '';
			this.cerrarVentana();
			this.escribirPantalla();

			switch (this.estado) {
				case 'R':
					if (this.valorPantalla != "0") {
						this.estado = 'P';
					}
					break;
				case 'O':
					if (this.valorPantalla != "0") {
						this.estado = 'S';
					}
					break;
				case 'P':
					if (this.valorPantalla == "0") {
						this.estado = 'R';
					}
					break;
				case 'S':
					if (this.valorPantalla == "0") {
						this.estado = 'O';
					}
					break;
			}
		} else if (this.operacionMemoria == "GU") {
			this.arrayMemoria[indice] = this.valorPantalla;
			this.cerrarVentana();

			switch (this.estado) {
				case 'R':
					break;
				case 'P':
					break;
				case 'S':
					break;
			}
		} 
	},

	"cerrarVentana": function(tecla) {
		document.getElementById("ventana").style.visibility = "hidden";
		document.getElementById("fondo-oscuro").style.visibility = "hidden";
	}


}

app.inicializar();

