angular.module('starter.controllers', [])

.controller('AppCtrl', function($scope, $ionicModal, $timeout, $http, $rootScope, $window) {
    // With the new view caching in Ionic, Controllers are only called
    // when they are recreated or on app start, instead of every page change.
    // To listen for when this page is active (for example, to refresh data),
    // listen for the $ionicView.enter event:
    //$scope.$on('$ionicView.enter', function(e) {
    //});

    if (!$window.localStorage.favourits)
        $window.localStorage.favourits = "[]";
    console.log($window.localStorage.favourits)
    $rootScope.favourits = JSON.parse($window.localStorage.favourits) || [];

    $http.get('http://khrogah-51355.onmodulus.net/categories').success(function(data) {
        $scope.categories = data;
        $scope.$broadcast('scroll.infiniteScrollComplete');
    });
    // Form data for the login modal
    $scope.feedback = {};

    // Create the login modal that we will use later
    $ionicModal.fromTemplateUrl('templates/feedback.html', {
        scope: $scope
    }).then(function(modal) {
        $scope.modal = modal;
    });
    // Create the login modal that we will use later
    $ionicModal.fromTemplateUrl('templates/about.html', {
        scope: $scope
    }).then(function(modal) {
        $scope.about = modal;
    });

    // Triggered in the login modal to close it
    $scope.closeAbout = function() {
        $scope.about.hide();
    };

    // Open the login modal
    $scope.showAbout = function() {
        $scope.about.show();
    };
    // Triggered in the login modal to close it
    $scope.closeFeedback = function() {
        $scope.modal.hide();
    };

    // Open the login modal
    $scope.showFeedback = function() {
        $scope.modal.show();
    };

    // Perform the login action when the user submits the login form
    $scope.doFeedback = function() {
        console.log('Submitting feedback', $scope.feedback);
        $http.get('http://khrogah-51355.onmodulus.net/feedback?username=' + $scope.feedback.username + '&email=' + $scope.feedback.email + '&message=' + $scope.feedback.message)
            // Simulate a login delay. Remove this and replace with your login
            // code if using a login system
        $timeout(function() {
            $scope.closeFeedback();
        }, 1000);
    };

})

.controller('homeCtrl', function($scope, $rootScope, $http, $window) {
    $scope.loadCount = 5,
        $rootScope.places = [];
    $scope.loadMore = function() {
        $scope.loadCount = $scope.loadCount + 5;
        $http.get('http://khrogah-51355.onmodulus.net/home?limit=' + $scope.loadCount).success(function(data) {
            $rootScope.places = $rootScope.places.concat(data);
            $scope.$broadcast('scroll.infiniteScrollComplete');
        });
    }
    $rootScope.isFavourite = function(place, $index) {
        for (var i = 0; i < $rootScope.favourits.length; i++) {
            if ($rootScope.favourits[i]._id == place._id) {
                $rootScope.places[$index].favourite = true;
                return;
            } else
                $rootScope.places[$index].favourite = false
        }
    }
    $rootScope.addFavourite = function(place, $index) {
        place.$$hashKey = undefined;
        $scope.existed = -1;
        $rootScope.places[$index].favourite = !$rootScope.places[$index].favourite;
        if ($rootScope.favourits == []) {
            $rootScope.favourits.push(place);
            $window.localStorage.favourits = JSON.stringify($rootScope.favourits);
        } else{
            for (var i = 0; i < $rootScope.favourits.length; i++) {
                if ($rootScope.favourits[i]._id == place._id) {
                    $scope.existed = i
                    l($rootScope.favourits[i]._id)
                    l(place._id)
                    l('------------- existed ----------------')
                }
            }
            if($scope.existed>-1){
                $rootScope.favourits.splice($scope.existed, 1);
                $window.localStorage.favourits = JSON.stringify($rootScope.favourits);
            }
            else{
                $rootScope.favourits.push(place);
                $window.localStorage.favourits = JSON.stringify($rootScope.favourits);
            }
        }
    }
})

.controller('placeCtrl', function($scope, $rootScope, $stateParams, $http, $ionicSlideBoxDelegate) {
        console.log($stateParams)
        $scope.places = [];
        $scope.showLoading = true;
        $http.get('http://khrogah-51355.onmodulus.net/item?itemId=' + $stateParams.placeId + '&itemType=' + $stateParams.type).success(function(place) {
            $scope.place = place[0];
            console.log(place[0])
            $scope.showLoading = false;
            $ionicSlideBoxDelegate.update();

        })
    })
    .controller('categoryCtrl', function($scope, $rootScope, $stateParams, $http) {
        $scope.loadCount = 5,
            $scope.allowRequest = true,
            $scope.categoryeId = $stateParams.categoryeId,
            $scope.places = [];
        $scope.loadMore = function() {
            $scope.loadCount = $scope.loadCount + 5;
            if ($scope.allowRequest)
                $http.get('http://khrogah-51355.onmodulus.net/category?id=' + $scope.categoryeId.replace(/&/g, '_and_') + '&limit=' + $scope.loadCount).success(function(data) {
                    $scope.places = $scope.places.concat(data);;
                    if (data == [])
                        $scope.allowRequest = false;
                    $scope.$broadcast('scroll.infiniteScrollComplete');
                });
        }
    });

function l(m) {
    console.log(m)
}
